/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.plugins.sgr.SGRPluginImpl;
import edu.ku.brc.specify.plugins.sgr.WorkbenchColorizer;
import edu.ku.brc.specify.tasks.subpane.wb.GridTableHeader;
import edu.ku.brc.specify.tasks.subpane.wb.SgrHeading;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.tmanfe.SpreadSheetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GridTableModel
extends SpreadSheetModel {
    private static final Logger log = Logger.getLogger(GridTableModel.class);
    protected WorkbenchPaneSS workbenchPaneSS;
    protected boolean batchMode = false;
    protected boolean isInImageMode = false;
    protected boolean isUserEdit = true;
    protected ImageIcon blankIcon = IconManager.getIcon("Blank", IconManager.IconSize.Std16);
    protected ImageIcon imageIcon = IconManager.getIcon("CardImage", IconManager.IconSize.Std16);
    protected Vector<GridTableHeader> headers = new Vector();
    protected WorkbenchTemplateMappingItem imageMappingItem = null;
    private GridTableHeader sgrHeading;

    public GridTableHeader getSgrHeading() {
        return this.sgrHeading;
    }

    public GridTableModel(WorkbenchPaneSS workbenchPaneSS) {
        this.workbenchPaneSS = workbenchPaneSS;
        this.setWorkbench(workbenchPaneSS.getWorkbench());
    }

    protected void setWorkbench(Workbench workbench) {
        this.headers.clear();
        this.headers.addAll(workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems());
        Collections.sort(this.headers);
        this.sgrHeading = new SgrHeading((short)this.headers.size());
        this.headers.add(this.sgrHeading);
        if (this.imageMappingItem != null) {
            this.headers.add(this.imageMappingItem);
        }
    }

    protected Workbench getWorkbench() {
        if (this.workbenchPaneSS != null) {
            return this.workbenchPaneSS.getWorkbench();
        }
        return null;
    }

    public void fireDataChanged() {
        this.fireTableDataChanged();
    }

    public boolean isInImageMode() {
        return this.isInImageMode;
    }

    public void setInImageMode(boolean isInImageMode) {
        if (!this.isInImageMode && isInImageMode) {
            if (this.imageMappingItem == null) {
                this.imageMappingItem = new WorkbenchTemplateMappingItem(){

                    @Override
                    public String getFieldName() {
                        return "Image";
                    }
                };
                this.imageMappingItem.initialize();
                this.imageMappingItem.setCaption(UIRegistry.getResourceString("WB_IMAGE"));
                this.imageMappingItem.setViewOrder((short)this.headers.size());
            }
            this.headers.add(this.imageMappingItem);
        } else if (this.isInImageMode && !isInImageMode) {
            this.headers.remove(this.imageMappingItem);
        }
        this.isInImageMode = isInImageMode;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.headers.size();
    }

    @Override
    public String getColumnName(int column) {
        if (this.headers != null) {
            String label = this.headers.get(column).getCaption();
            return label != null ? label : "";
        }
        log.error((Object)"columnList should not be null!");
        return "N/A";
    }

    @Override
    public int getRowCount() {
        return this.getWorkbench() != null ? this.getWorkbench().getWorkbenchRows().size() : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return null;
        }
        if (this.headers.get(column) == this.imageMappingItem) {
            WorkbenchRow rowObj = this.getWorkbench().getRow(row);
            Set<WorkbenchRowImage> images = rowObj.getWorkbenchRowImages();
            if (images != null && images.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (WorkbenchRowImage rowImg : images) {
                    String fullPath = rowImg.getCardImageFullPath();
                    String filename = FilenameUtils.getName((String)fullPath);
                    sb.append(String.valueOf(filename) + "; ");
                }
                sb.delete(sb.length() - 2, sb.length());
                return sb.toString();
            }
            return "";
        }
        if (this.headers.get(column) == this.sgrHeading) {
            SGRPluginImpl sgr = (SGRPluginImpl)this.workbenchPaneSS.getPlugin(SGRPluginImpl.class);
            if (sgr != null) {
                WorkbenchColorizer colorizer = sgr.getColorizer();
                Float score = colorizer.getScoreForRow(this.workbenchPaneSS.getWorkbench().getRow(row));
                return score != null ? String.format("%1$.2f", score) : "";
            }
            return 0;
        }
        if (this.getRowCount() > row) {
            return this.getWorkbench().getWorkbenchRowsAsList().get(row).getData(column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isInImageMode) {
            return column != this.headers.size() - 1;
        }
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, final int row, final int column) {
        if (this.isInImageMode && column == this.headers.size() - 1) {
            return;
        }
        if (this.getRowCount() >= 0) {
            boolean changed;
            String currentValue = this.getWorkbench().getWorkbenchRowsAsList().get(row).getData(column);
            boolean bl = changed = !StringUtils.equals((String)currentValue, (String)value.toString());
            if (changed) {
                this.getWorkbench().getWorkbenchRowsAsList().get(row).setData(value.toString(), (short)column, this.isUserEdit);
                if (!this.batchMode) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GridTableModel.this.fireTableCellUpdated(row, column);
                        }
                    });
                }
            }
        }
    }

    public void setValueAt(Object value, int row, int column, boolean isUserEdit) {
        this.isUserEdit = isUserEdit;
        try {
            this.setValueAt(value, row, column);
        }
        finally {
            this.isUserEdit = true;
        }
    }

    @Override
    public void appendRow() {
        int selInx = this.spreadSheet.getSelectedRow();
        if (selInx == -1) {
            selInx = this.spreadSheet.getEditingRow();
        }
        this.addRowAt(this.getRowCount(), selInx);
    }

    @Override
    public void clearCells(int[] rows, int[] cols) {
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int rowInx = nArray[n2];
            WorkbenchRow wbRow = this.getWorkbench().getRow(rowInx);
            int[] nArray2 = cols;
            int n3 = cols.length;
            int n4 = 0;
            while (n4 < n3) {
                int col = nArray2[n4];
                wbRow.setData("", (short)col, true);
                ++n4;
            }
            ++n2;
        }
        this.workbenchPaneSS.validateRows(rows);
        this.fireDataChanged();
    }

    @Override
    public void deleteRows(int[] rows) {
        Arrays.sort(rows);
        int i = rows.length - 1;
        while (i > -1) {
            log.info((Object)("Deleting Row Index " + rows[i] + " Row Count[" + this.getRowCount() + "]"));
            this.getWorkbench().deleteRow(rows[i]);
            if (this.spreadSheet != null) {
                this.spreadSheet.removeRow(rows[i], rows.length == 1);
            }
            --i;
        }
        this.fireDataChanged();
    }

    @Override
    public void fill(int colInx, int valueRowInx, int[] rowInxs) {
        Object value = this.getValueAt(valueRowInx, colInx);
        try {
            this.setBatchMode(rowInxs.length > 50);
            int[] nArray = rowInxs;
            int n = rowInxs.length;
            int n2 = 0;
            while (n2 < n) {
                int rowInx = nArray[n2];
                this.setValueAt(value, rowInx, colInx);
                ++n2;
            }
            if (!this.workbenchPaneSS.validateRows(rowInxs) && this.isBatchMode()) {
                this.fireDataChanged();
            }
        }
        finally {
            if (this.isBatchMode()) {
                this.setBatchMode(false);
            }
        }
    }

    public void fillAndIncrement(int colInx, int valueRowInx, int[] rowInxs, UIFieldFormatterIFace incrementer) {
        Object value = this.getValueAt(valueRowInx, colInx);
        try {
            this.setBatchMode(rowInxs.length > 50);
            int[] nArray = rowInxs;
            int n = rowInxs.length;
            int n2 = 0;
            while (n2 < n) {
                int rowInx = nArray[n2];
                this.setValueAt(value, rowInx, colInx);
                value = incrementer.formatToUI(incrementer.getNextNumber(incrementer.formatFromUI(value).toString(), true).toString());
                ++n2;
            }
            if (!this.workbenchPaneSS.validateRows(rowInxs) && this.isBatchMode()) {
                this.fireDataChanged();
            }
        }
        finally {
            if (this.isBatchMode()) {
                this.setBatchMode(false);
            }
        }
    }

    @Override
    public void insertRow(int rowInx) {
        int rowIndex;
        int oldRowIndex = rowInx;
        int n = rowIndex = rowInx == -1 ? this.getRowCount() : rowInx;
        if (this.getRowCount() == -1) {
            if (this.getRowCount() > 0) {
                oldRowIndex = this.getRowCount() - 1;
                rowIndex = this.getRowCount();
            } else {
                rowIndex = -1;
            }
        }
        this.addRowAt(rowIndex, oldRowIndex);
    }

    public void insertAfterRow(int rowInx) {
        if (rowInx == -1) {
            throw new RuntimeException("Why is rowInx == -1?");
        }
        int oldRowIndex = rowInx;
        int rowIndex = rowInx + 1;
        if (rowIndex > this.getRowCount()) {
            rowIndex = this.getRowCount();
        }
        this.addRowAt(rowIndex, oldRowIndex);
    }

    protected void addRowAt(int rowIndex, int oldRowIndex) {
        WorkbenchRow wbRow = null;
        if (oldRowIndex > -1 && this.getRowCount() > 0) {
            wbRow = this.getWorkbench().getWorkbenchRowsAsList().get(oldRowIndex);
        }
        WorkbenchRow newRow = rowIndex == -1 || rowIndex == this.getRowCount() ? this.getWorkbench().addRow() : this.getWorkbench().insertRow((short)rowIndex);
        if (wbRow != null) {
            for (WorkbenchTemplateMappingItem wbdmi : this.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateMappingItems()) {
                if (!wbdmi.getCarryForward().booleanValue()) continue;
                newRow.setData(wbRow.getData(wbdmi.getViewOrder().shortValue()), wbdmi.getViewOrder(), true);
            }
        }
        if (this.spreadSheet != null) {
            this.spreadSheet.addRow();
        }
        this.fireDataChanged();
    }

    @Override
    public int getColDataLen(int column) {
        return this.headers.get(column).getDataFieldLength().shortValue();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.headers != null) {
            this.headers.clear();
        }
        this.workbenchPaneSS = null;
        this.headers = null;
        this.imageMappingItem = null;
    }

    public GridTableHeader getColMapping(int column) {
        return this.headers.get(column);
    }

    @Override
    public boolean isBatchMode() {
        return this.batchMode;
    }

    @Override
    public void setBatchMode(boolean value) {
        this.batchMode = value;
    }
}

