/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValTextArea;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.SGRTask;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.CellRenderingAttributes;
import edu.ku.brc.specify.tasks.subpane.wb.EditFormControlDlg;
import edu.ku.brc.specify.tasks.subpane.wb.FormPaneWrapper;
import edu.ku.brc.specify.tasks.subpane.wb.InputPanel;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.ui.LengthInputVerifier;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormPane
extends JPanel
implements FormPaneWrapper {
    private static final Logger log = Logger.getLogger(FormPane.class);
    protected static final short TEXTFIELD_DATA_LEN_MAX = 64;
    protected static final short MAX_COLS = 64;
    protected static final short DEFAULT_TEXTFIELD_COLS = 15;
    protected static final short DEFAULT_TEXTAREA_COLS = 45;
    protected static final short DEFAULT_TEXTFIELD_ROWS = 1;
    protected static final short DEFAULT_TEXTAREA_ROWS = 5;
    protected WorkbenchPaneSS workbenchPane;
    protected Workbench workbench;
    protected boolean hasChanged = false;
    protected Vector<InputPanel> uiComps = new Vector();
    protected boolean isInImageMode = false;
    protected JButton controlPropsBtn = null;
    protected Component firstComp = null;
    protected boolean ignoreChanges = false;
    protected boolean changesInForm = false;
    protected int currentIndex = -1;
    protected DocumentAdaptor docListener;
    protected ChangeListener changeListener = null;
    protected InputPanel selectedInputPanel = null;
    protected Vector<WorkbenchTemplateMappingItem> headers = new Vector();
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected EditFormControlDlg controlPropsDlg = null;
    protected boolean wasShowing = false;
    protected JScrollPane scrollPane;
    protected Dimension initialSize = null;
    protected boolean readOnly;

    public FormPane(WorkbenchPaneSS workbenchPane, Workbench workbench, boolean readOnly) {
        this.setLayout(null);
        this.workbenchPane = workbenchPane;
        this.workbench = workbench;
        this.readOnly = readOnly;
        this.dropFlavors.add(InputPanel.INPUTPANEL_FLAVOR);
        this.docListener = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                FormPane.this.stateChange();
            }
        };
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FormPane.this.stateChange();
            }
        };
        this.buildUI();
        this.scrollPane = new JScrollPane(this, 20, 30);
    }

    protected void buildUI() {
        this.headers.addAll(this.workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems());
        Collections.sort(this.headers);
        MouseAdapter clickable = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FormPane.this.selectControl(e.getSource());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FormPane.this.selectedInputPanel = FormPane.this.getInputPanel(e.getSource());
                FormPane.this.controlPropsBtn.setEnabled(true);
                if (FormPane.this.controlPropsDlg != null) {
                    FormPane.this.controlPropsDlg.setControl(FormPane.this.selectedInputPanel);
                }
                if (!(e.getClickCount() != 2 || FormPane.this.controlPropsDlg != null && FormPane.this.controlPropsDlg.isVisible())) {
                    UsageTracker.incrUsageCount("WB.FormPropsTool");
                    FormPane.this.showControlProps();
                }
            }
        };
        Point topLeftPnt = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int LAYOUT_SPACING = 4;
        int maxY = 0;
        Vector<InputPanel> delayedLayout = new Vector<InputPanel>();
        int maxWidthOffset = 0;
        for (WorkbenchTemplateMappingItem wbtmi : this.headers) {
            InputPanel panel = new InputPanel(wbtmi, wbtmi.getCaption(), this.createUIComp(wbtmi), this, clickable);
            Dimension size = panel.getPreferredSize();
            panel.setSize(size);
            panel.setPreferredSize(size);
            maxWidthOffset = Math.max(panel.getTextFieldOffset(), maxWidthOffset);
            short x = wbtmi.getXCoord();
            short y = wbtmi.getYCoord();
            if (y < topLeftPnt.y || y == topLeftPnt.y && x < topLeftPnt.x) {
                this.firstComp = panel.getComp();
                topLeftPnt.setLocation(x, y);
            }
            this.uiComps.add(panel);
            this.add(panel);
            if (wbtmi.getXCoord() == null || wbtmi.getYCoord() == null || wbtmi.getXCoord() == -1 || wbtmi.getYCoord() == -1) {
                delayedLayout.add(panel);
                continue;
            }
            maxY = (short)Math.max(wbtmi.getYCoord() + size.height, maxY);
        }
        int inx = 0;
        int maxX = 0;
        int y = maxY + 4;
        for (InputPanel panel : this.uiComps) {
            WorkbenchTemplateMappingItem wbtmi = this.headers.get(inx);
            if (delayedLayout.contains(panel)) {
                int x = maxWidthOffset - panel.getTextFieldOffset();
                panel.setLocation(x, y);
                wbtmi.setXCoord((short)x);
                wbtmi.setYCoord((short)y);
                Dimension size = panel.getPreferredSize();
                y += size.height + 4;
            }
            Rectangle r = panel.getBounds();
            maxX = Math.max(maxX, r.x + r.width);
            ++inx;
        }
        this.initialSize = new Dimension(maxX, y);
        this.controlPropsBtn = UIHelper.createIconBtn("ControlEdit", IconManager.IconSize.NonStd, "WB_EDIT_CONTROL", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UsageTracker.getUsageCount("WBFormPropsTool");
                FormPane.this.showControlProps();
            }
        });
        this.addArrowTraversalKeys();
    }

    protected void addArrowTraversalKeys() {
        Set<AWTKeyStroke> set = this.getFocusTraversalKeys(0);
        KeyStroke forward = KeyStroke.getKeyStroke("DOWN");
        set = new HashSet<AWTKeyStroke>(set);
        set.add(forward);
        this.setFocusTraversalKeys(0, set);
        set = this.getFocusTraversalKeys(1);
        KeyStroke backward = KeyStroke.getKeyStroke("UP");
        set = new HashSet<AWTKeyStroke>(set);
        set.add(backward);
        this.setFocusTraversalKeys(1, set);
    }

    protected InputPanel getInputPanel(Object obj) {
        InputPanel inputPanel;
        Container comp = ((Component)obj).getParent();
        while (comp != null && !(comp instanceof InputPanel)) {
            comp = comp.getParent();
        }
        InputPanel inputPanel2 = inputPanel = comp instanceof InputPanel ? (InputPanel)comp : null;
        if (inputPanel != null && obj instanceof JLabel) {
            inputPanel.getComp().requestFocus();
        }
        return inputPanel;
    }

    protected void selectControl(Object uiObj) {
        this.selectedInputPanel = this.getInputPanel(uiObj);
        this.controlPropsBtn.setEnabled(true);
        if (this.controlPropsDlg != null) {
            this.controlPropsDlg.setControl(this.selectedInputPanel);
        }
    }

    @Override
    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
        this.headers.clear();
        this.headers.addAll(workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems());
        Collections.sort(this.headers);
        Vector<InputPanel> oldItems = new Vector<InputPanel>(this.uiComps);
        for (WorkbenchTemplateMappingItem newItem : this.headers) {
            InputPanel fndItem = null;
            for (InputPanel panel : oldItems) {
                if (newItem.getId().intValue() != panel.getWbtmi().getId().intValue()) continue;
                fndItem = panel;
                break;
            }
            if (fndItem != null) {
                oldItems.remove(fndItem);
                fndItem.setWbtmi(newItem);
                continue;
            }
            log.error((Object)("Couldn't find panel by ID [" + newItem.getId() + "]"));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.initialSize;
    }

    @Override
    public JScrollPane getPane() {
        return this.scrollPane;
    }

    @Override
    public WorkbenchPaneSS getWorkbenchPane() {
        return this.workbenchPane;
    }

    @Override
    public JButton getControlPropsBtn() {
        return this.controlPropsBtn;
    }

    @Override
    public void cleanup() {
        this.removeAll();
        this.scrollPane.removeAll();
        for (InputPanel panel : this.uiComps) {
            Component comp = panel.getComp();
            if (comp instanceof ValTextField) {
                ((ValTextField)comp).getDocument().removeDocumentListener(this.docListener);
            } else if (comp instanceof ValTextArea) {
                ((ValTextArea)comp).getDocument().removeDocumentListener(this.docListener);
            } else if (comp instanceof ValCheckBox) {
                ((ValCheckBox)comp).removeChangeListener(this.changeListener);
            }
            panel.cleanUp();
        }
        this.uiComps.clear();
        this.headers.clear();
        this.dropFlavors.clear();
        this.workbenchPane = null;
        this.workbench = null;
        this.controlPropsBtn = null;
        this.firstComp = null;
        this.selectedInputPanel = null;
        this.controlPropsDlg = null;
        this.scrollPane = null;
        this.initialSize = null;
        this.uiComps = null;
        this.headers = null;
        this.dropFlavors = null;
        this.docListener = null;
        this.changeListener = null;
    }

    protected JScrollPane createTextArea(short len, short rows) {
        ValTextArea textArea = new ValTextArea("", rows, len);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.getDocument().addDocumentListener(this.docListener);
        JScrollPane taScrollPane = new JScrollPane(textArea);
        taScrollPane.setHorizontalScrollBarPolicy(32);
        taScrollPane.setVerticalScrollBarPolicy(22);
        return taScrollPane;
    }

    protected JComponent createUIComp(WorkbenchTemplateMappingItem wbtmi) {
        return this.createUIComp(WorkbenchTask.getDataType(wbtmi), wbtmi.getCaption(), wbtmi.getFieldName(), wbtmi.getFieldType(), wbtmi.getDataFieldLength(), FormPane.getColumns(wbtmi), FormPane.getRows(wbtmi), wbtmi);
    }

    protected static boolean useTextField(String fieldName, Short fieldType, Short fieldLen) {
        if (fieldType != null) {
            return fieldType == 1 || fieldType == 4 || fieldType == 3;
        }
        if (fieldLen > 64) {
            return fieldName.toLowerCase().indexOf("remarks") == -1;
        }
        return true;
    }

    protected static boolean useTextField(WorkbenchTemplateMappingItem wbtmi) {
        return FormPane.useTextField(wbtmi.getFieldName(), wbtmi.getFieldType(), wbtmi.getDataFieldLength());
    }

    public static short getColumns(WorkbenchTemplateMappingItem wbtmi) {
        Properties props;
        short columns = FormPane.useTextField(wbtmi) ? (short)15 : 45;
        String metaData = wbtmi.getMetaData();
        if (StringUtils.isNotEmpty((String)metaData) && (props = UIHelper.parseProperties(metaData)) != null) {
            columns = (short)UIHelper.getProperty(props, "columns", FormPane.useTextField(wbtmi) ? 15 : 45);
        }
        return columns;
    }

    public static short getRows(WorkbenchTemplateMappingItem wbtmi) {
        Properties props;
        short rows = FormPane.useTextField(wbtmi) ? (short)1 : 5;
        String metaData = wbtmi.getMetaData();
        if (StringUtils.isNotEmpty((String)metaData) && (props = UIHelper.parseProperties(metaData)) != null) {
            rows = (short)UIHelper.getProperty(props, "rows", FormPane.useTextField(wbtmi) ? 1 : 5);
        }
        return rows;
    }

    protected JComponent createUIComp(Class<?> dbFieldTypeArg, String caption, String fieldName, Short fieldType, Short fieldLength, short columns, short rows, WorkbenchTemplateMappingItem wbtmi) {
        Component focusComp;
        JComponent comp;
        int uiType = 0;
        Class<Object> dbFieldType = dbFieldTypeArg;
        if (dbFieldType == null) {
            dbFieldType = String.class;
        }
        if (dbFieldType.equals(Calendar.class) || dbFieldType.equals(Date.class)) {
            ValTextField txt = new ValTextField(columns);
            txt.getDocument().addDocumentListener(this.docListener);
            comp = txt;
            focusComp = comp;
            uiType = 4;
        } else if (this.useComboBox(wbtmi)) {
            final JComboBox<Object> comboBox = new JComboBox<Object>(this.getValues(wbtmi));
            comboBox.setName("Form Combo");
            comboBox.setEditable(true);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource() == comboBox) {
                        FormPane.this.stateChange();
                    }
                }
            });
            comp = comboBox;
            focusComp = comp;
            uiType = 5;
        } else if (FormPane.useTextField(fieldName, fieldType, fieldLength)) {
            ValTextField txt = new ValTextField(columns);
            txt.getDocument().addDocumentListener(this.docListener);
            txt.setInputVerifier(new LengthInputVerifier(caption, fieldLength.shortValue()));
            comp = txt;
            focusComp = comp;
            uiType = 1;
        } else {
            JScrollPane taScrollPane = this.createTextArea(columns, rows);
            ((JTextArea)taScrollPane.getViewport().getView()).setInputVerifier(new LengthInputVerifier(caption, fieldLength.shortValue()));
            comp = taScrollPane;
            focusComp = taScrollPane.getViewport().getView();
            uiType = 2;
        }
        wbtmi.setFieldType((short)uiType);
        focusComp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FormPane.this.selectControl(e.getSource());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        comp.setEnabled(!this.readOnly);
        ((Component)focusComp).setEnabled(!this.readOnly);
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!FormPane.this.readOnly && (e.isControlDown() || e.isMetaDown()) && e.getKeyCode() == 78) {
                    FormPane.this.workbenchPane.addRowAfter();
                }
                super.keyTyped(e);
            }
        });
        return comp;
    }

    protected Vector<Object> getValues(WorkbenchTemplateMappingItem wbtmi) {
        Vector<WorkbenchTemplateMappingItem> wbtmis = new Vector<WorkbenchTemplateMappingItem>();
        wbtmis.addAll(this.workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems());
        Collections.sort(wbtmis);
        int wbCol = -1;
        int c = 0;
        while (c < wbtmis.size()) {
            if (wbtmis.get(c) == wbtmi) {
                wbCol = c;
                break;
            }
            ++c;
        }
        if (wbCol != -1 && this.workbenchPane.getSpreadSheet().getColumnModel().getColumn(wbCol).getCellEditor() instanceof WorkbenchPaneSS.GridCellListEditor) {
            ComboBoxModel model = ((WorkbenchPaneSS.GridCellListEditor)this.workbenchPane.getSpreadSheet().getColumnModel().getColumn(wbCol).getCellEditor()).getList();
            Vector<Object> result = new Vector<Object>();
            int i = 0;
            while (i < model.getSize()) {
                result.add(model.getElementAt(i));
                ++i;
            }
            return result;
        }
        return null;
    }

    protected boolean useComboBox(WorkbenchTemplateMappingItem wbtmi) {
        return this.getValues(wbtmi) != null;
    }

    @Override
    public void swapTextFieldType(InputPanel inputPanel, short fieldLen) {
        short rows;
        JTextComponent oldComp;
        short fieldType;
        if (inputPanel.getComp() instanceof JTextField) {
            JTextField tf = (JTextField)inputPanel.getComp();
            tf.getDocument().removeDocumentListener(this.docListener);
            fieldType = 2;
            oldComp = tf;
            rows = 5;
        } else {
            JTextArea ta = (JTextArea)inputPanel.getComp();
            ta.getDocument().removeDocumentListener(this.docListener);
            fieldType = 1;
            oldComp = ta;
            rows = 1;
        }
        WorkbenchTemplateMappingItem wbtmi = inputPanel.getWbtmi();
        inputPanel.setComp(this.createUIComp(WorkbenchTask.getDataType(wbtmi), wbtmi.getCaption(), wbtmi.getFieldName(), fieldType, wbtmi.getDataFieldLength(), fieldLen, rows, wbtmi));
        this.ignoreChanges = true;
        ((JTextComponent)inputPanel.getComp()).setText(oldComp.getText());
        this.ignoreChanges = false;
        this.hasChanged = true;
        this.workbenchPane.setChanged(true);
    }

    protected void showControlProps() {
        if (this.selectedInputPanel != null) {
            if (this.controlPropsDlg == null) {
                this.controlPropsDlg = new EditFormControlDlg((Frame)UIRegistry.get("frame"), "", this.selectedInputPanel, this);
            }
            this.controlPropsDlg.setTitle(String.format(UIRegistry.getResourceString("WB_EDIT_DLG_TITLE"), this.selectedInputPanel.getControlTitle()));
            this.controlPropsDlg.setVisible(true);
            if (!this.controlPropsDlg.isCancelled()) {
                this.workbenchPane.gridColumnsUpdated();
                this.adjustPanelSize();
            }
            this.controlPropsDlg.dispose();
            this.controlPropsDlg = null;
        }
    }

    protected void adjustPanelSize() {
        int maxX = 0;
        int maxY = 0;
        for (InputPanel panel : this.uiComps) {
            Rectangle r = panel.getBounds();
            maxX = Math.max(r.x + r.width, maxX);
            maxY = Math.max(r.y + r.height, maxY);
        }
        Dimension size = this.getSize();
        if (maxX != size.width || maxY != size.height) {
            this.initialSize.width = maxX;
            this.initialSize.height = maxY;
            this.scrollPane.validate();
            this.scrollPane.repaint();
        }
    }

    @Override
    public void aboutToShowHide(boolean show) {
        if (!show) {
            if (this.currentIndex > -1 && this.changesInForm) {
                this.copyDataFromForm(this.currentIndex);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FormPane.this.firstComp != null) {
                        FormPane.this.firstComp.requestFocus();
                    }
                }
            });
        }
    }

    @Override
    public void showingPane(boolean show) {
        if (show) {
            if (this.wasShowing) {
                this.controlPropsDlg.setVisible(true);
            }
        } else if (this.controlPropsDlg != null) {
            this.controlPropsDlg.setVisible(false);
            this.wasShowing = true;
        } else {
            this.wasShowing = false;
        }
    }

    @Override
    public void copyDataFromForm() {
        this.copyDataFromForm(this.currentIndex);
    }

    protected void copyDataFromForm(InputPanel p, WorkbenchRow wbRow) {
        short col = p.getWbtmi().getViewOrder();
        WorkbenchDataItem result = null;
        if (p.getComp() instanceof JTextComponent) {
            String data = ((JTextComponent)p.getComp()).getText();
            String cellData = wbRow.getData(col);
            if (StringUtils.isNotEmpty((String)cellData) || data != null) {
                result = wbRow.setData(data == null ? "" : data, col, true);
            }
        } else if (p.getComp() instanceof GetSetValueIFace) {
            Object data = ((GetSetValueIFace)((Object)p.getComp())).getValue();
            String cellData = wbRow.getData(col);
            if (StringUtils.isNotEmpty((String)cellData) || data != null) {
                result = wbRow.setData(data == null ? "" : data.toString(), col, true);
            }
        } else if (p.getComp() instanceof JScrollPane) {
            JScrollPane sc = (JScrollPane)p.getComp();
            Component comp = sc.getViewport().getView();
            if (comp instanceof JTextArea) {
                result = wbRow.setData(((JTextArea)comp).getText(), col, true);
            }
        } else if (p.getComp() instanceof JComboBox) {
            JComboBox cb = (JComboBox)p.getComp();
            result = wbRow.setData(cb.getSelectedItem().toString(), col, true);
        } else {
            log.error((Object)("Can't get data from control[" + p.getLabelText() + "]"));
        }
        if (result != null && this.workbenchPane.getTask() instanceof SGRTask) {
            wbRow.setSgrStatus((byte)1);
        }
    }

    protected void copyDataFromForm(int index) {
        if (!this.changesInForm) {
            return;
        }
        this.ignoreChanges = true;
        this.changesInForm = false;
        int modelIndex = this.workbenchPane.getSpreadSheet().convertRowIndexToModel(index);
        WorkbenchRow wbRow = this.workbench.getWorkbenchRowsAsList().get(modelIndex);
        for (InputPanel p : this.uiComps) {
            this.copyDataFromForm(p, wbRow);
        }
        this.ignoreChanges = false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (!aFlag && this.controlPropsDlg != null) {
            this.controlPropsDlg.setVisible(false);
        }
        super.setVisible(aFlag);
    }

    protected void setDataIntoForm(int index) {
        if (index < 0) {
            this.ignoreChanges = true;
            for (InputPanel panel : this.uiComps) {
                panel.getLabel().setEnabled(false);
                Component comp = panel.getComp();
                comp.setEnabled(false);
                if (comp instanceof JTextComponent) {
                    ((JTextComponent)comp).setText("");
                    continue;
                }
                if (!(comp instanceof JCheckBox)) continue;
                ((JCheckBox)comp).setSelected(false);
            }
            this.ignoreChanges = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormPane.this.workbenchPane.getResultSetController().getNewRecBtn().requestFocus();
                }
            });
            return;
        }
        if (index == 0 && this.workbench.getWorkbenchRowsAsList().size() == 1) {
            for (InputPanel panel : this.uiComps) {
                panel.getLabel().setEnabled(true);
                panel.getComp().setEnabled(true);
            }
        }
        this.ignoreChanges = true;
        int modelIndex = this.workbenchPane.getSpreadSheet().convertRowIndexToModel(index);
        WorkbenchRow wbRow = this.workbench.getWorkbenchRowsAsList().get(modelIndex);
        for (InputPanel p : this.uiComps) {
            short col = p.getWbtmi().getViewOrder();
            if (p.getComp() instanceof GetSetValueIFace) {
                ((GetSetValueIFace)((Object)p.getComp())).setValue(wbRow.getData(col), wbRow.getData(col));
                continue;
            }
            if (p.getComp() instanceof JComboBox) {
                ((JComboBox)p.getComp()).setSelectedItem(wbRow.getData(col));
                continue;
            }
            if (p.getComp() instanceof JScrollPane) {
                JScrollPane sc = (JScrollPane)p.getComp();
                Component comp = sc.getViewport().getView();
                if (!(comp instanceof JTextArea)) continue;
                ((JTextArea)comp).setText(wbRow.getData(col));
                continue;
            }
            ((JTextComponent)p.getComp()).setText(wbRow.getData(col));
        }
        this.ignoreChanges = false;
    }

    @Override
    public boolean indexAboutToChange(int oldIndex, int newIndex) {
        if (newIndex != this.currentIndex && this.currentIndex > -1 && this.scrollPane.isVisible()) {
            this.copyDataFromForm(this.currentIndex);
            this.currentIndex = newIndex;
        }
        return true;
    }

    @Override
    public void indexChanged(int newIndex) {
        if (this.scrollPane.isVisible()) {
            this.currentIndex = newIndex;
            this.setDataIntoForm(this.currentIndex);
            if (this.workbenchPane.isDoIncremental()) {
                this.updateValidationUI();
            } else {
                for (InputPanel ip : this.uiComps) {
                    ip.getLabel().setToolTipText(null);
                    ip.getLabel().setBorder(null);
                }
            }
            if (this.firstComp != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormPane.this.firstComp.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public void newRecordAdded() {
        if (this.currentIndex > -1) {
            this.copyDataFromForm(this.currentIndex);
        }
        this.workbenchPane.addRowAfter();
    }

    @Override
    public void doAction(GhostActionable src) {
        if (src instanceof InputPanel) {
            InputPanel inputPanel = (InputPanel)src;
            Point offSet = src.getMouseInputAdapter().getOffsetFromStartPnt();
            Point location = inputPanel.getLocation();
            Point offset = ((GhostGlassPane)UIRegistry.get("glasspane")).getOffset();
            location.translate(offSet.x - offset.x, offSet.y - offset.y);
            location.x = Math.max(0, location.x);
            location.y = Math.max(0, location.y);
            inputPanel.setLocation(location);
            this.remove(inputPanel);
            this.add(inputPanel);
            this.repaint();
            this.validate();
            this.doLayout();
            this.adjustPanelSize();
            WorkbenchTemplateMappingItem wbtmi = inputPanel.getWbtmi();
            wbtmi.setXCoord((short)location.x);
            wbtmi.setYCoord((short)location.y);
            this.workbenchPane.setChanged(true);
            UsageTracker.getUsageCount("WBLayoutFormDrop");
        }
    }

    @Override
    public void setData(Object data) {
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(this, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
    }

    @Override
    public void setActive(boolean isActive) {
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return null;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return null;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return null;
    }

    protected void stateChange() {
        if (!this.ignoreChanges) {
            this.changesInForm = true;
            this.workbenchPane.setChanged(true);
            if (this.workbenchPane.isDoIncremental()) {
                this.ignoreChanges = true;
                WorkbenchRow wbRow = this.workbench.getWorkbenchRowsAsList().get(this.currentIndex);
                this.copyDataFromForm();
                this.workbenchPane.updateRowValidationStatus(this.currentIndex, -1, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormPane.this.workbenchPane.updateBtnUI();
                    }
                });
                this.updateValidationUI(wbRow);
                this.ignoreChanges = false;
            }
        }
    }

    @Override
    public void updateValidationUI() {
        this.updateValidationUI(this.workbench.getWorkbenchRowsAsList().get(this.currentIndex));
    }

    protected void updateValidationUI(WorkbenchRow wbRow) {
        for (InputPanel ip : this.uiComps) {
            this.updateValidationUI(ip, wbRow);
        }
    }

    protected void updateValidationUI(InputPanel ip, WorkbenchRow wbRow) {
        String toolTip = null;
        LineBorder border = null;
        WorkbenchDataItem wbCell = wbRow.getItems().get(ip.getWbtmi().getViewOrder());
        if (wbCell != null) {
            toolTip = wbCell.getStatusText();
            if (wbCell.getEditorValidationStatus() == 2 && this.workbenchPane.isDoIncrementalValidation()) {
                this.workbenchPane.getCellDecorator();
                border = new LineBorder(CellRenderingAttributes.errorBorder);
            } else if (wbCell.getEditorValidationStatus() == 4 && this.workbenchPane.isDoIncrementalMatching()) {
                this.workbenchPane.getCellDecorator();
                border = new LineBorder(CellRenderingAttributes.newDataBorder);
            } else {
                toolTip = null;
            }
        }
        ip.getLabel().setToolTipText(toolTip);
        ip.getLabel().setBorder(border);
    }
}

