/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextField;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.specify.tasks.subpane.wb.FormPane;
import edu.ku.brc.specify.tasks.subpane.wb.InputPanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class EditFormControlDlg
extends CustomDialog
implements ChangeListener,
DocumentListener {
    protected InputPanel inputPanel;
    protected FormPane formPane;
    protected ValSpinner xCoord = null;
    protected ValSpinner yCoord;
    protected ValSpinner fieldWidth;
    protected ValSpinner numRows;
    protected JTextField labelTF;
    protected JComboBox textFieldType;
    protected boolean isTextField;
    protected boolean isFormattedText;
    protected int fieldTypeIndex = -1;
    protected boolean fieldTypeChanged = false;
    protected JLabel rowsLabels;
    protected JLabel typeLabel;
    protected String origLabel;
    protected Point origLocation;
    protected int origFieldLen;
    protected Short origFieldType;
    protected int origFieldTypeIndex;
    protected int origRows;
    protected Hashtable<Object, Boolean> changeTracker = new Hashtable();
    protected boolean parentHasChanged;

    public EditFormControlDlg(Frame frame, String title, InputPanel inputPanel, FormPane canvasPanel) throws HeadlessException {
        super(frame, title, true, 15, null);
        this.inputPanel = inputPanel;
        this.formPane = canvasPanel;
        this.parentHasChanged = this.formPane.getWorkbenchPane().isChanged();
    }

    @Override
    public void createUI() {
        if (this.xCoord == null) {
            super.createUI();
            this.isTextField = this.inputPanel.getComp() instanceof JTextComponent;
            this.isFormattedText = this.inputPanel.getComp() instanceof ValFormattedTextField;
            int y = 1;
            CellConstraints cc = new CellConstraints();
            PanelBuilder panelBlder = new PanelBuilder(new FormLayout("p,2px,p,p:g", UIHelper.createDuplicateJGoodiesDef("p", "2px", 8 + (this.isTextField && !this.isFormattedText ? 4 : 0))));
            JPanel panel = panelBlder.getPanel();
            Dimension canvasSize = this.formPane.getSize();
            Dimension controlSize = this.inputPanel.getSize();
            panelBlder.add((Component)UIHelper.createI18NFormLabel("WB_X"), cc.xy(1, y));
            this.xCoord = new ValSpinner(0, canvasSize.width - controlSize.width, false, false);
            panelBlder.add((Component)this.xCoord, cc.xy(3, y));
            panelBlder.add((Component)UIHelper.createI18NFormLabel("WB_Y"), cc.xy(1, y += 2));
            this.yCoord = new ValSpinner(0, canvasSize.height - controlSize.height, false, false);
            panelBlder.add((Component)this.yCoord, cc.xy(3, y));
            panelBlder.add((Component)UIHelper.createI18NFormLabel("WB_LABEL"), cc.xy(1, y += 2));
            this.labelTF = UIHelper.createTextField(25);
            panelBlder.add((Component)this.labelTF, cc.xywh(3, y, 2, 1));
            y += 2;
            if (this.isTextField) {
                panelBlder.add((Component)UIHelper.createI18NFormLabel("WB_FIELD_LEN"), cc.xy(1, y));
                this.fieldWidth = new ValSpinner(0, 100, false, false);
                panelBlder.add((Component)this.fieldWidth, cc.xy(3, y));
                y += 2;
                if (!this.isFormattedText) {
                    this.rowsLabels = UIHelper.createI18NFormLabel("WB_NUM_ROWS");
                    panelBlder.add((Component)this.rowsLabels, cc.xy(1, y));
                    this.numRows = new ValSpinner(1, 25, false, false);
                    panelBlder.add((Component)this.numRows, cc.xy(3, y));
                    this.typeLabel = UIHelper.createI18NFormLabel("WB_FIELD_TYPE");
                    panelBlder.add((Component)this.typeLabel, cc.xy(1, y += 2));
                    this.textFieldType = UIHelper.createComboBox(new Object[]{UIRegistry.getResourceString("WB_TEXTFIELD"), UIRegistry.getResourceString("WB_TEXTAREA")});
                    panelBlder.add((Component)this.textFieldType, cc.xy(3, y));
                    UIHelper.setControlSize(this.textFieldType);
                    y += 2;
                }
            }
            this.fill();
            if (this.fieldWidth != null) {
                this.origFieldLen = ((Integer)this.fieldWidth.getValue()).shortValue();
            }
            if (this.textFieldType != null) {
                this.origFieldTypeIndex = this.textFieldType.getSelectedIndex();
            }
            if (this.numRows != null) {
                this.origRows = ((Integer)this.numRows.getValue()).shortValue();
                this.origFieldType = this.inputPanel.getWbtmi().getFieldType();
                this.numRows.addChangeListener(this);
            }
            this.xCoord.addChangeListener(this);
            this.yCoord.addChangeListener(this);
            if (this.isTextField) {
                this.fieldWidth.addChangeListener(this);
            }
            if (this.textFieldType != null) {
                this.textFieldType.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean bl = EditFormControlDlg.this.fieldTypeChanged = EditFormControlDlg.this.textFieldType.getSelectedIndex() != EditFormControlDlg.this.fieldTypeIndex;
                        if (EditFormControlDlg.this.numRows != null) {
                            EditFormControlDlg.this.adjustTextRowsUI();
                            EditFormControlDlg.this.numRows.setValue(EditFormControlDlg.this.textFieldType.getSelectedIndex() == 0 ? 1 : (EditFormControlDlg.this.origRows == 1 ? 5 : EditFormControlDlg.this.origRows));
                        }
                    }
                });
            }
            this.labelTF.getDocument().addDocumentListener(this);
            this.mainPanel.add((Component)panel, "Center");
            this.pack();
        }
    }

    @Override
    protected void applyButtonPressed() {
        this.adjustControl();
        super.applyButtonPressed();
    }

    @Override
    protected void cancelButtonPressed() {
        this.reset();
        if (!this.parentHasChanged) {
            this.formPane.getWorkbenchPane().setChanged(false);
        }
        super.cancelButtonPressed();
    }

    @Override
    protected void helpButtonPressed() {
        super.helpButtonPressed();
    }

    @Override
    protected void okButtonPressed() {
        if (this.textFieldType != null && this.origFieldTypeIndex != this.textFieldType.getSelectedIndex()) {
            if (this.fieldTypeChanged) {
                this.adjustControl();
            }
            this.inputPanel.getWbtmi().setFieldType(this.inputPanel.getComp() instanceof JTextField ? (short)1 : 2);
        }
        this.inputPanel.getWbtmi().setXCoord((short)((Integer)this.xCoord.getValue()).intValue());
        this.inputPanel.getWbtmi().setYCoord((short)((Integer)this.yCoord.getValue()).intValue());
        this.inputPanel.getWbtmi().setCaption(this.labelTF.getText());
        this.inputPanel.setLabelText(String.valueOf(this.labelTF.getText()) + ":");
        if (this.fieldWidth != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("columns=");
            sb.append((Integer)this.fieldWidth.getValue());
            if (this.numRows != null) {
                sb.append(";rows=");
                sb.append((Integer)this.numRows.getValue());
            }
            this.inputPanel.getWbtmi().setMetaData(sb.toString());
        }
        this.adjustControl();
        this.formPane.getWorkbenchPane().setChanged(true);
        super.okButtonPressed();
    }

    public void setControl(InputPanel inputPanel) {
        this.changeTracker.size();
        this.inputPanel = inputPanel;
        this.fill();
        if (this.textFieldType != null) {
            this.origFieldTypeIndex = this.textFieldType.getSelectedIndex();
        }
    }

    protected void fill() {
        if (this.xCoord == null) {
            this.createUI();
        }
        Point location = this.inputPanel.getLocation();
        this.xCoord.setValue(Double.valueOf(location.getX()).intValue());
        this.yCoord.setValue(Double.valueOf(location.getY()).intValue());
        this.labelTF.setText(StringUtils.strip((String)this.inputPanel.getLabelText(), (String)":"));
        this.origLabel = this.inputPanel.getLabelText();
        this.origLocation = new Point(location.x, location.y);
        if (this.isTextField) {
            if (this.textFieldType != null) {
                this.fieldTypeIndex = this.inputPanel.getComp() instanceof JTextField ? 0 : 1;
                this.textFieldType.setSelectedIndex(this.fieldTypeIndex);
            }
            if (this.fieldWidth != null) {
                int cols = this.inputPanel.getComp() instanceof JTextField ? ((JTextField)this.inputPanel.getComp()).getColumns() : ((JTextArea)this.inputPanel.getComp()).getColumns();
                this.fieldWidth.setValue(cols);
            }
            if (this.numRows != null) {
                this.adjustTextRowsUI();
                int rows = this.inputPanel.getComp() instanceof JTextArea ? ((JTextArea)this.inputPanel.getComp()).getRows() : 1;
                this.numRows.setValue(rows);
            }
        }
        this.changeTracker.clear();
    }

    protected void adjustTextRowsUI() {
        if (this.numRows != null) {
            boolean isTexArea = this.textFieldType.getSelectedIndex() == 1;
            this.rowsLabels.setEnabled(isTexArea);
            this.numRows.setEnabled(isTexArea);
        }
    }

    protected void reset() {
        this.xCoord.setValue(this.origLocation.x);
        this.yCoord.setValue(this.origLocation.y);
        this.labelTF.setText(this.origLabel);
        if (this.isTextField) {
            if (this.textFieldType != null) {
                this.fieldTypeChanged = this.origFieldTypeIndex == 0 && this.inputPanel.getComp() instanceof JTextArea || this.origFieldTypeIndex == 1 && this.inputPanel.getComp() instanceof JTextField;
            }
            if (this.fieldWidth != null) {
                this.fieldWidth.setValue(this.origFieldLen);
            }
            if (this.numRows != null) {
                this.numRows.setValue(this.origRows);
            }
        }
        this.adjustControl();
    }

    protected void adjustControl() {
        if (this.changeTracker.get(this.xCoord) != null || this.changeTracker.get(this.yCoord) != null) {
            this.inputPanel.setLocation((Integer)this.xCoord.getValue(), (Integer)this.yCoord.getValue());
        }
        boolean doResize = false;
        if (this.changeTracker.get(this.labelTF.getDocument()) != null) {
            if (this.inputPanel.getComp() instanceof ValCheckBox) {
                ((ValCheckBox)this.inputPanel.getComp()).setText(this.labelTF.getText());
            } else {
                this.inputPanel.getLabel().setText(String.valueOf(StringUtils.strip((String)this.labelTF.getText(), (String)":")) + ":");
            }
            doResize = true;
        }
        if (this.isTextField) {
            if (this.fieldTypeChanged) {
                this.formPane.swapTextFieldType(this.inputPanel, ((Integer)this.fieldWidth.getValue()).shortValue());
                this.fieldTypeChanged = false;
                this.fieldTypeIndex = this.textFieldType.getSelectedIndex();
                this.adjustTextRowsUI();
            }
            if (this.changeTracker.get(this.fieldWidth) != null || this.numRows != null && this.changeTracker.get(this.numRows) != null) {
                if (this.inputPanel.getComp() instanceof JTextField) {
                    ((JTextField)this.inputPanel.getComp()).setColumns((Integer)this.fieldWidth.getValue());
                } else {
                    ((JTextArea)this.inputPanel.getComp()).setColumns((Integer)this.fieldWidth.getValue());
                    if (this.numRows != null) {
                        ((JTextArea)this.inputPanel.getComp()).setRows((Integer)this.numRows.getValue());
                    }
                    this.inputPanel.validate();
                    this.inputPanel.repaint();
                }
            }
            doResize = true;
        }
        if (doResize) {
            this.inputPanel.doLayout();
            this.inputPanel.repaint();
        }
        this.changeTracker.clear();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeTracker.put(e.getSource(), true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changeTracker.put(e.getDocument(), true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changeTracker.put(e.getDocument(), true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changeTracker.put(e.getDocument(), true);
    }
}

