/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.csvreader.CsvReader;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataBase;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureXLS;
import edu.ku.brc.specify.tasks.subpane.wb.DataImport;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MouseOverJLabel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class DataImportDialog
extends JDialog
implements ActionListener {
    protected static final Logger log = Logger.getLogger(DataImportDialog.class);
    private JButton cancelBtn;
    private JButton okBtn;
    private JButton helpBtn;
    public static final int OK_BTN = 1;
    public static final int CANCEL_BTN = 2;
    public static final int HELP_BTN = 4;
    protected int btnPressed = 2;
    protected JRadioButton tab;
    protected JRadioButton space;
    protected JRadioButton semicolon;
    protected JRadioButton comma;
    protected JRadioButton other;
    protected JTextField otherText;
    protected char stringQualifierChar;
    protected char delimChar;
    protected Charset charset;
    protected int escapeMode;
    protected boolean doesFirstRowHaveHeaders;
    protected boolean shouldUseTextQualifier;
    private JLabel textQualLabel;
    private JComboBox textQualCombo;
    private JLabel charSetLabel;
    private JComboBox charSetCombo;
    private JLabel escapeModeLabel;
    private JComboBox escapeModeCombo;
    protected JCheckBox containsHeaders;
    protected boolean isCancelled = true;
    protected boolean hasTooManyRows = false;
    private String fileName;
    private File file;
    protected ConfigureExternalDataBase config;
    protected ConfigureCSV configCSV;
    protected ConfigureXLS configXLS;
    private JTable myDisplayTable;
    protected PreviewTableModel model;
    protected DataErrorPanel errorPanel = new DataErrorPanel();
    protected int highestColumnCount;
    protected boolean ignoreActions = false;
    protected int geoDataCol = -1;
    protected Vector<Integer> imageDataCols = new Vector();

    public DataImportDialog(ConfigureCSV config, char defaultDelimChar, char defaultTextQual, Charset defaultCharSet, int defaultEscMode, boolean doesHaveHeaders, boolean useTxtQual) {
        this.config = config;
        this.configCSV = config;
        this.file = config.getFile();
        this.fileName = this.file.getAbsolutePath().toString();
        this.doesFirstRowHaveHeaders = doesHaveHeaders;
        this.charset = defaultCharSet;
        this.escapeMode = defaultEscMode;
        this.delimChar = defaultDelimChar;
        this.stringQualifierChar = defaultTextQual;
        this.shouldUseTextQualifier = useTxtQual;
        this.highestColumnCount = 0;
        this.myDisplayTable = new JTable();
        this.model = new PreviewTableModel();
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public DataImportDialog(ConfigureXLS config, boolean doesHaveHeaders) {
        this.config = config;
        this.configXLS = config;
        this.file = config.getFile();
        this.fileName = this.file.getAbsolutePath().toString();
        this.doesFirstRowHaveHeaders = doesHaveHeaders;
        this.myDisplayTable = null;
        this.model = new PreviewTableModel();
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public boolean init() {
        return this.createUiForXLS();
    }

    public boolean initForCSV() {
        return this.createUiForCSV();
    }

    private boolean createUiForCSV() {
        JPanel p = this.createConfigPanelForCSV();
        this.setContentPane(p);
        if (!this.hasTooManyRows) {
            this.init(UIRegistry.getResourceString("IMPORT_CVS"));
            return true;
        }
        return false;
    }

    private boolean createUiForXLS() {
        JPanel p = this.createConfigPanelForXLS();
        if (p != null) {
            this.setContentPane(p);
            if (!this.hasTooManyRows) {
                this.init(UIRegistry.getResourceString("IMPORT_XLS"));
            }
            return true;
        }
        return false;
    }

    private void init(String title) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setModal(true);
    }

    private JPanel createConfigPanelForCSV() {
        JPanel configPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("5px, 15px, p, 30px, p:g, 15px", "5px,p,3px, p,10px, p,3px, p,3px, p,10px, p, 3px,f:p:g,5px,30px,3px,p,10px"), configPanel);
        JLabel fileInfo = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("FILE_PREVIEW")) + " " + this.fileName);
        JPanel buttonpanel = this.buildButtons();
        this.containsHeaders = UIHelper.createCheckBox(UIRegistry.getResourceString("COLUMN_HEAD"));
        this.containsHeaders.setSelected(true);
        this.containsHeaders.addItemListener(new CheckboxItemListener());
        builder.addSeparator(UIRegistry.getResourceString("DATA_IMPORT_OPS"), cc.xyw(2, 2, 4));
        builder.add((Component)this.createDelimiterPanel(), cc.xy(3, 4));
        builder.add((Component)this.createOtherControlsForCSVPanel(), cc.xy(5, 4));
        builder.addSeparator(UIRegistry.getResourceString("FILE_IMPORT"), cc.xyw(2, 6, 4));
        builder.add((Component)fileInfo, cc.xyw(3, 8, 4));
        builder.add((Component)this.containsHeaders, cc.xyw(3, 10, 3));
        builder.addSeparator(UIRegistry.getResourceString("DATA_PREVIEW"), cc.xyw(2, 12, 4));
        this.myDisplayTable = this.setCSVTableData(this.myDisplayTable);
        builder.add((Component)this.addtoScroll(this.myDisplayTable), cc.xyw(3, 14, 3));
        builder.add((Component)this.errorPanel, cc.xyw(3, 16, 4));
        builder.add((Component)buttonpanel, cc.xyw(2, 18, 4));
        configPanel.setMinimumSize(buttonpanel.getMinimumSize());
        return configPanel;
    }

    private JPanel createConfigPanelForXLS() {
        JPanel configPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("5px, 15px, p, 30px, p:g, 15px", "5px,p,3px, p,3px, p,10px, p, 3px,f:p:g,5px,30px,3px,p,10px"), configPanel);
        JLabel fileInfo = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("FILE_PREVIEW")) + " " + this.fileName);
        JPanel buttonpanel = this.buildButtons();
        this.containsHeaders = UIHelper.createCheckBox(UIRegistry.getResourceString("COLUMN_HEAD"));
        this.containsHeaders.setSelected(true);
        this.containsHeaders.addItemListener(new CheckboxItemListener());
        builder.addSeparator(UIRegistry.getResourceString("FILE_IMPORT"), cc.xyw(2, 2, 4));
        builder.add((Component)fileInfo, cc.xyw(3, 4, 4));
        builder.add((Component)this.containsHeaders, cc.xyw(3, 6, 3));
        builder.addSeparator(UIRegistry.getResourceString("DATA_PREVIEW"), cc.xyw(2, 8, 4));
        this.myDisplayTable = this.setXLSTableData(this.myDisplayTable);
        if (this.myDisplayTable == null) {
            return null;
        }
        builder.add((Component)this.addtoScroll(this.myDisplayTable), cc.xyw(3, 10, 3));
        builder.add((Component)this.errorPanel, cc.xyw(3, 12, 4));
        builder.add((Component)buttonpanel, cc.xyw(2, 14, 4));
        configPanel.setMinimumSize(buttonpanel.getMinimumSize());
        return configPanel;
    }

    private JPanel buildButtons() {
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"User cancelled DataImportDialog");
                DataImportDialog.this.isCancelled = true;
                DataImportDialog.this.btnPressed = 2;
                DataImportDialog.this.setVisible(false);
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataImportDialog.this.isCancelled = false;
                DataImportDialog.this.btnPressed = 1;
                DataImportDialog.this.setVisible(false);
                DataImportDialog.this.config.setFirstRowHasHeaders(DataImportDialog.this.doesFirstRowHaveHeaders);
                if (DataImportDialog.this.config instanceof ConfigureCSV) {
                    DataImportDialog.this.configCSV = (ConfigureCSV)DataImportDialog.this.config;
                    DataImportDialog.this.configCSV.setTextQualifier(true, DataImportDialog.this.stringQualifierChar);
                    DataImportDialog.this.configCSV.setCharset(DataImportDialog.this.charset);
                    DataImportDialog.this.configCSV.setEscapeMode(DataImportDialog.this.escapeMode);
                    DataImportDialog.this.configCSV.setDelimiter(DataImportDialog.this.delimChar);
                }
            }
        });
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"User pressed help");
                DataImportDialog.this.btnPressed = 4;
            }
        });
        this.getRootPane().setDefaultButton(this.okBtn);
        if (this.config instanceof ConfigureCSV) {
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, "WorkbenchImportCSV");
        } else if (this.config instanceof ConfigureXLS) {
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, "WorkbenchImportXLS");
        } else {
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, "WorkbenchImportData");
        }
        return ButtonBarFactory.buildOKCancelHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn);
    }

    private JPanel createOtherControlsForCSVPanel() {
        JPanel myPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout formLayout = new FormLayout("p,3px, p,3px", "p,4px,   p,4px,  p,4px,  p,4px");
        PanelBuilder builder = new PanelBuilder(formLayout, myPanel);
        this.textQualLabel = UIHelper.createLabel(UIRegistry.getResourceString("TEXT_QUAL"));
        Object[] qualifiers = new String[]{"\"", "'", "{" + UIRegistry.getResourceString("WB_NONE") + "}"};
        this.textQualCombo = UIHelper.createComboBox(qualifiers);
        this.textQualCombo.setSelectedItem(String.valueOf(((ConfigureCSV)this.config).getTextQualifier()));
        this.textQualCombo.addActionListener(this);
        this.charSetLabel = UIHelper.createLabel(UIRegistry.getResourceString("CHAR_SET"));
        Object[] charsets = new String[]{UIRegistry.getResourceString("DEFAULT"), "US-ASCII", "ISO-8859-1", "UTF-8"};
        this.charSetCombo = UIHelper.createComboBox(charsets);
        this.charSetCombo.setSelectedIndex(0);
        this.charSetCombo.addActionListener(this);
        this.escapeModeLabel = UIHelper.createLabel(UIRegistry.getResourceString("ESCAPE_MODE"));
        Object[] escapeModes = new String[]{UIRegistry.getResourceString("BACKSLASH"), UIRegistry.getResourceString("DOUBLED")};
        this.escapeModeCombo = UIHelper.createComboBox(escapeModes);
        this.escapeModeCombo.setSelectedIndex(0);
        this.escapeModeCombo.addActionListener(this);
        this.setContentPane(this.textQualCombo);
        this.setContentPane(this.charSetCombo);
        this.setContentPane(this.escapeModeCombo);
        builder.add((Component)this.textQualLabel, cc.xy(1, 1));
        builder.add((Component)this.textQualCombo, cc.xy(3, 1));
        builder.add((Component)this.charSetLabel, cc.xy(1, 3));
        builder.add((Component)this.charSetCombo, cc.xy(3, 3));
        builder.add((Component)this.escapeModeLabel, cc.xy(1, 5));
        builder.add((Component)this.escapeModeCombo, cc.xy(3, 5));
        return myPanel;
    }

    protected void changeQualifier(String newQualifier) {
        ((ConfigureCSV)this.config).setTextQualifier(!StringUtils.isEmpty((String)newQualifier), newQualifier.charAt(0));
        this.updateTableDisplay();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String str = (String)cb.getSelectedItem();
        log.debug((Object)"actionPerformed");
        if (str.equals("\"")) {
            this.stringQualifierChar = (char)34;
            this.changeQualifier(str);
        } else if (str.equals("'")) {
            this.stringQualifierChar = (char)39;
            this.changeQualifier(str);
        } else if (str.equals("{" + UIRegistry.getResourceString("NONE") + "}")) {
            this.changeQualifier(str);
        } else if (str.equals("US-ASCII") || str.equals("ISO-8859-1") || str.equals("UTF-8")) {
            this.charset = Charset.forName(str);
        } else if (str.equals(UIRegistry.getResourceString("DEFAULT"))) {
            this.charset = Charset.defaultCharset();
        } else if (str.equals(UIRegistry.getResourceString("BACKSLASH"))) {
            this.escapeMode = 2;
        } else if (str.equals(UIRegistry.getResourceString("DOUBLED"))) {
            this.escapeMode = 1;
        }
        this.updateTableDisplay();
    }

    private JPanel createDelimiterPanel() {
        JPanel myPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout formLayout = new FormLayout("p,p,2px, p:g,2px, p,2px,p,2px,", "p,1px,   p,1px, p,1px , p,1px , p,1px , p,1px, p,1px ");
        PanelBuilder builder = new PanelBuilder(formLayout, myPanel);
        this.tab = UIHelper.createRadioButton(UIRegistry.getResourceString("TAB"));
        this.tab.addItemListener(new DelimButtonItemListener());
        this.space = UIHelper.createRadioButton(UIRegistry.getResourceString("SPACE"));
        this.space.addItemListener(new DelimButtonItemListener());
        this.comma = UIHelper.createRadioButton(UIRegistry.getResourceString("COMMA"));
        this.comma.addItemListener(new DelimButtonItemListener());
        this.comma.setSelected(true);
        this.semicolon = UIHelper.createRadioButton(UIRegistry.getResourceString("SEMICOLON"));
        this.semicolon.addItemListener(new DelimButtonItemListener());
        this.other = UIHelper.createRadioButton(UIRegistry.getResourceString("OTHER"));
        this.other.addItemListener(new DelimButtonItemListener());
        this.otherText = UIHelper.createTextField();
        this.otherText.addKeyListener(new CharFieldKeyAdapter());
        this.otherText.setColumns(1);
        this.otherText.setEnabled(false);
        this.otherText.setEditable(false);
        this.otherText.setDocument(new CharLengthLimitDocument(1));
        ButtonGroup group = new ButtonGroup();
        group.add(this.tab);
        group.add(this.space);
        group.add(this.other);
        group.add(this.comma);
        group.add(this.semicolon);
        builder.addSeparator(UIRegistry.getResourceString("SELECT_DELIMS"), cc.xyw(1, 1, 4));
        builder.add((Component)this.comma, cc.xyw(1, 3, 4));
        builder.add((Component)this.semicolon, cc.xyw(1, 5, 4));
        builder.add((Component)this.space, cc.xyw(1, 7, 4));
        builder.add((Component)this.tab, cc.xyw(1, 9, 4));
        builder.add((Component)this.other, cc.xy(1, 11));
        builder.add((Component)this.otherText, cc.xy(2, 11));
        return myPanel;
    }

    protected void updateTableDisplay() {
        if (this.config instanceof ConfigureCSV) {
            this.setCSVTableData(this.myDisplayTable);
        } else {
            this.setXLSTableData(this.myDisplayTable);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataImportDialog.this.okBtn.setEnabled(!DataImportDialog.this.hasTooManyRows);
            }
        });
    }

    public static void main(String[] args) {
        new ConfigureCSV(new File("demo_files\\workbench\\johsoncountyTrip.csv"));
    }

    private boolean checkForErrors(String[] headers, String[][] data) {
        JList listOfErrors = this.genListOfErrorWhereTableDataDefiesSizeConstraints(headers, data);
        if (listOfErrors == null) {
            return false;
        }
        return listOfErrors.getModel().getSize() > 0;
    }

    protected void showErrors() {
        JList listOfErrors = this.genListOfErrorWhereTableDataDefiesSizeConstraints(this.model.getColumnNames(), this.model.getData());
        if (this.model.getColumnNames() == null || this.model.getData() == null || listOfErrors == null || listOfErrors.getModel().getSize() == 0) {
            JTextArea textArea = new JTextArea();
            textArea.setRows(25);
            textArea.setColumns(60);
            textArea.append(UIRegistry.getResourceString("WB_PARSE_FILE_ERROR2"));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane pane = new JScrollPane(textArea, 22, 32);
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), pane, UIRegistry.getResourceString("DATA_IMPORT_ISSUES"), 2);
            this.okBtn.setEnabled(false);
        } else if (listOfErrors.getModel().getSize() > 0) {
            JTextArea textArea = new JTextArea();
            textArea.setRows(25);
            textArea.setColumns(60);
            String newline = "\n";
            int i = 0;
            while (i < listOfErrors.getModel().getSize()) {
                textArea.append(String.valueOf((String)listOfErrors.getModel().getElementAt(i)) + newline + newline);
                ++i;
            }
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane pane = new JScrollPane(textArea, 22, 32);
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), pane, UIRegistry.getResourceString("DATA_IMPORT_ISSUES"), 2);
        }
    }

    public int getLargestColumnCountFromCSV() {
        try {
            CsvReader csv = new CsvReader((InputStream)new FileInputStream(this.configCSV.getFile()), this.configCSV.getDelimiter(), this.configCSV.getCharset());
            csv.setEscapeMode(this.configCSV.getEscapeMode());
            csv.setTextQualifier(this.configCSV.getTextQualifier());
            int curRowColCount = 0;
            int highestColCount = 0;
            if (this.configCSV.getFirstRowHasHeaders()) {
                csv.readHeaders();
                highestColCount = Math.max(highestColCount, csv.getHeaders().length);
            }
            while (csv.readRecord()) {
                curRowColCount = csv.getColumnCount();
                highestColCount = Math.max(highestColCount, curRowColCount);
            }
            return highestColCount;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataImportDialog.class, e);
            log.error((Object)("Error attempting to parse input csv file:" + e));
            return 0;
        }
    }

    private boolean isStringShorterThan(int length, String colName) {
        if (colName == null) {
            return true;
        }
        return colName.length() <= length;
    }

    private void checkUserColInfo(String value, int colNum) {
        if (value.equals(DataImport.GEO_DATA_HEADING)) {
            this.geoDataCol = colNum;
        }
        if (value.equals(DataImport.IMAGE_PATH_HEADING)) {
            this.imageDataCols.add(colNum);
        }
    }

    private boolean isUserCol(int colNum) {
        return this.geoDataCol != colNum && !this.imageDataCols.contains(colNum);
    }

    private JTable setXLSTableData(JTable table) {
        int numRows = 0;
        int numCols = 0;
        String[] headers = new String[]{};
        Vector tableDataVector = new Vector();
        Vector<String> rowData = new Vector<String>();
        Vector<Object> headerVector = new Vector();
        DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        try {
            log.debug((Object)("setXLSTableData - file - " + this.configXLS.getFile().toString()));
            FileInputStream input = new FileInputStream(this.configXLS.getFile());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            Vector<Integer> badHeads = new Vector<Integer>();
            Vector<Integer> emptyCols = new Vector<Integer>();
            ((ConfigureXLS)this.config).checkHeadsAndCols(sheet, badHeads, emptyCols);
            if (badHeads.size() > 0 && this.doesFirstRowHaveHeaders) {
                if (table != null) {
                    ((ConfigureXLS)this.config).showBadHeadingsMsg(badHeads, emptyCols, this.getTitle());
                }
                this.doesFirstRowHaveHeaders = false;
                try {
                    this.ignoreActions = true;
                    this.containsHeaders.setSelected(false);
                }
                finally {
                    this.ignoreActions = false;
                }
                if (table != null) {
                    return table;
                }
            }
            boolean firstRow = true;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(20);
            nf.setGroupingUsed(false);
            int maxCols = 0;
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                numCols = 0;
                rowData = new Vector();
                HSSFRow row = (HSSFRow)rows.next();
                int maxSize = Math.max(row.getPhysicalNumberOfCells(), row.getLastCellNum());
                if (maxSize > maxCols) {
                    maxCols = maxSize;
                }
                while (numCols < maxSize) {
                    if (emptyCols.indexOf(new Integer(numCols)) == -1) {
                        HSSFCell cell = row.getCell(numCols);
                        String value = null;
                        if (cell == null) {
                            value = "";
                        } else {
                            int type = cell.getCellType();
                            switch (type) {
                                case 0: {
                                    if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                                        value = scrDateFormat.getSimpleDateFormat().format(cell.getDateCellValue());
                                        break;
                                    }
                                    double numeric = cell.getNumericCellValue();
                                    value = nf.format(numeric);
                                    break;
                                }
                                case 1: {
                                    value = cell.getRichStringCellValue().getString();
                                    break;
                                }
                                case 3: {
                                    value = "";
                                    break;
                                }
                                case 4: {
                                    value = Boolean.toString(cell.getBooleanCellValue());
                                    break;
                                }
                                case 2: {
                                    value = UIRegistry.getResourceString("WB_FORMULA_IMPORT_NO_PREVIEW");
                                    break;
                                }
                                default: {
                                    value = "";
                                    log.error((Object)"unsuported cell type");
                                }
                            }
                        }
                        if (firstRow && this.doesFirstRowHaveHeaders) {
                            this.checkUserColInfo(value, numCols);
                        }
                        if (this.isUserCol(numCols)) {
                            rowData.add(value.toString());
                        }
                    }
                    ++numCols;
                }
                if (this.doesFirstRowHaveHeaders && firstRow) {
                    headerVector = rowData;
                    headers = new String[rowData.size()];
                } else if (!this.doesFirstRowHaveHeaders && firstRow) {
                    tableDataVector.add(rowData);
                } else {
                    tableDataVector.add(rowData);
                }
                firstRow = false;
                ++numRows;
            }
            maxCols -= emptyCols.size();
            if (!this.doesFirstRowHaveHeaders) {
                headerVector = this.createDummyHeadersAsVector(maxCols);
                headers = new String[maxCols];
            }
            int i = 0;
            while (i < headerVector.size()) {
                headers[i] = (String)headerVector.elementAt(i);
                ++i;
            }
            this.printArray(headers);
            String[][] tableData = new String[tableDataVector.size()][maxCols];
            int i2 = 0;
            while (i2 < tableDataVector.size()) {
                Vector v = (Vector)tableDataVector.get(i2);
                int j = 0;
                while (j < v.size()) {
                    tableData[i2][j] = ((String)v.get(j)).toString();
                    ++j;
                }
                ++i2;
            }
            if (this.checkForErrors(headers, tableData)) {
                this.errorPanel.showDataImportStatusPanel(true);
            } else {
                this.errorPanel.showDataImportStatusPanel(false);
            }
            if ((this.doesFirstRowHaveHeaders ? numRows - 1 : numRows) > WorkbenchTask.MAX_ROWS) {
                this.hasTooManyRows = true;
                this.showTooManyRowsErrorDialog();
            } else {
                this.hasTooManyRows = false;
            }
            log.debug((Object)headers);
            log.debug((Object)tableData);
            this.model = new PreviewTableModel(headers, tableData);
            JTable result = null;
            if (table == null) {
                result = new JTable();
                result.setColumnSelectionAllowed(false);
                result.setRowSelectionAllowed(false);
                result.setCellSelectionEnabled(false);
                result.getTableHeader().setReorderingAllowed(false);
                result.setPreferredScrollableViewportSize(new Dimension(500, 100));
                result.setAutoResizeMode(0);
            } else {
                result = table;
            }
            result.setModel(this.model);
            result.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
            this.model.fireTableDataChanged();
            this.model.fireTableStructureChanged();
            return result;
        }
        catch (Exception ex) {
            UIRegistry.displayErrorDlgLocalized(UIRegistry.getResourceString("WB_ERROR_READING_IMPORT_FILE"), new Object[0]);
            if (table != null) {
                String[] columnNames = new String[]{};
                String[][] blankData = new String[][]{new String[0]};
                this.model = new PreviewTableModel(columnNames, blankData);
                table.setModel(this.model);
                table.setColumnSelectionAllowed(false);
                table.setRowSelectionAllowed(false);
                table.setCellSelectionEnabled(false);
                table.getTableHeader().setReorderingAllowed(false);
                table.setPreferredScrollableViewportSize(new Dimension(500, 100));
                table.setAutoResizeMode(0);
                table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
                this.model.fireTableDataChanged();
                this.model.fireTableStructureChanged();
                return table;
            }
            return null;
        }
    }

    private void showTooManyRowsErrorDialog() {
        PanelBuilder builder = new PanelBuilder(new FormLayout("p:g", "c:p:g"));
        CellConstraints cc = new CellConstraints();
        builder.add((Component)UIHelper.createLabel(String.format(UIRegistry.getResourceString("DataImportDialog.TooManyRows"), WorkbenchTask.getMaxRows())), cc.xy(1, 1));
        builder.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        CustomDialog maxRowExceededDlg = new CustomDialog((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("WB_MAXROWS"), true, 1, (Component)builder.getPanel());
        UIHelper.centerAndShow(maxRowExceededDlg);
    }

    private JTable setCSVTableData(JTable table) {
        try {
            log.debug((Object)("setTableData - file - " + this.configCSV.getFile().toString()));
            CsvReader csv = new CsvReader((InputStream)new FileInputStream(this.configCSV.getFile()), this.configCSV.getDelimiter(), this.configCSV.getCharset());
            csv.setEscapeMode(this.configCSV.getEscapeMode());
            csv.setTextQualifier(this.configCSV.getTextQualifier());
            String[] headers = new String[]{};
            Vector<String[]> tableDataVector = new Vector<String[]>();
            this.highestColumnCount = this.getLargestColumnCountFromCSV();
            if (this.configCSV.getFirstRowHasHeaders()) {
                csv.readHeaders();
                headers = csv.getHeaders();
            }
            int rowColumnCount = 0;
            while (csv.readRecord()) {
                rowColumnCount = csv.getColumnCount();
                String[] rowData = new String[csv.getColumnCount()];
                int col = 0;
                while (col < csv.getColumnCount()) {
                    rowData[col] = csv.get(col);
                    ++col;
                }
                String[] newArray = DataImportDialog.padArray(this.highestColumnCount, rowData, false);
                tableDataVector.add(newArray);
            }
            if (!this.configCSV.getFirstRowHasHeaders() || headers == null) {
                headers = this.createDummyHeaders(rowColumnCount);
            }
            headers = DataImportDialog.padArray(this.highestColumnCount, headers, true);
            log.debug((Object)"---------------------------------------------------");
            this.printArray(headers);
            log.debug((Object)"---------------------------------------------------");
            String[][] tableData = new String[tableDataVector.size()][rowColumnCount];
            int i = 0;
            while (i < tableData.length) {
                tableData[i] = (String[])tableDataVector.elementAt(i);
                this.printArray(tableData[i]);
                ++i;
            }
            if (this.checkForErrors(headers, tableData)) {
                this.errorPanel.showDataImportStatusPanel(true);
            } else {
                this.errorPanel.showDataImportStatusPanel(false);
            }
            if ((this.doesFirstRowHaveHeaders ? tableDataVector.size() - 1 : tableDataVector.size()) > WorkbenchTask.MAX_ROWS) {
                this.hasTooManyRows = true;
                this.showTooManyRowsErrorDialog();
            } else {
                this.hasTooManyRows = false;
            }
            this.model = new PreviewTableModel(headers, tableData);
            table.setModel(this.model);
            table.setColumnSelectionAllowed(false);
            table.setRowSelectionAllowed(false);
            table.setCellSelectionEnabled(false);
            table.getTableHeader().setReorderingAllowed(false);
            table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            table.setAutoResizeMode(0);
            table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
            this.model.fireTableDataChanged();
            this.model.fireTableStructureChanged();
            return table;
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataImportDialog.class, ex);
            log.error((Object)("Error attempting to parse input csv file:" + ex));
            return null;
        }
    }

    private JScrollPane addtoScroll(JTable t) {
        JScrollPane pane = new JScrollPane(t, 22, 32);
        return pane;
    }

    private JList genListOfErrorWhereTableDataDefiesSizeConstraints(String[] headers, String[][] data) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        JList<String> listOfImportDataErrors = new JList<String>();
        int i = 0;
        while (i < headers.length) {
            if (!this.isStringShorterThan(WorkbenchTemplateMappingItem.getImportedColNameMaxLength(), headers[i])) {
                String msg = "Column at index=" + i + " is too long to be inserted into the database.  It will be truncated.\n" + "Current Value:\n" + headers[i] + "\nTruncated Value:\n" + headers[i].substring(0, WorkbenchTemplateMappingItem.getImportedColNameMaxLength() - 1);
                log.warn((Object)msg);
                listModel.addElement(msg);
            }
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                String str = data[i][j];
                if (!this.isStringShorterThan(WorkbenchDataItem.getMaxWBCellLength(), str)) {
                    String msg = "The value in cell Row=" + i + ", Column=" + headers[j] + " is too long to be inserted into the database.  It will be truncated.\n" + "Current Value:\n" + str + "\nTruncated Value:\n" + str.substring(0, WorkbenchDataItem.getMaxWBCellLength() - 1);
                    log.warn((Object)msg);
                    listModel.addElement(msg);
                }
                ++j;
            }
            ++i;
        }
        listOfImportDataErrors.setModel(listModel);
        return listOfImportDataErrors;
    }

    public Vector<String> createDummyHeadersAsVector(int count) {
        Vector<String> headerVector = new Vector<String>();
        int i = 0;
        while (i < count) {
            headerVector.add(String.valueOf(UIRegistry.getResourceString("DEFAULT_COLUMN_NAME")) + " " + (i + 1));
            ++i;
        }
        return headerVector;
    }

    public String[] createDummyHeaders(int count) {
        String[] headers = new String[count];
        int i = 0;
        while (i < count) {
            headers[i] = String.valueOf(UIRegistry.getResourceString("DEFAULT_COLUMN_NAME")) + " " + (i + 1);
            ++i;
        }
        return headers;
    }

    public static String[] padArray(int highestColumnCnt, String[] array, boolean replaceWithColumnName) {
        if (array.length >= highestColumnCnt) {
            return array;
        }
        String[] newArray = new String[highestColumnCnt];
        int paddingIndex = 0;
        int i = 0;
        while (i < array.length) {
            newArray[i] = array[i];
            paddingIndex = i++;
        }
        int padDisplayIndex = 1;
        int i2 = ++paddingIndex;
        while (i2 < highestColumnCnt) {
            newArray[i2] = replaceWithColumnName ? String.valueOf(UIRegistry.getResourceString("DEFAULT_COLUMN_NAME")) + " " + (i2 + 1) : "";
            ++padDisplayIndex;
            ++i2;
        }
        return newArray;
    }

    private void printArray(String[] arrayList) {
        String str = "";
        int i = 0;
        while (i < arrayList.length) {
            str = String.valueOf(str) + "[" + i + "]" + arrayList[i] + " ";
            ++i;
        }
        log.debug((Object)str);
    }

    public char getStringQualifierChar() {
        return this.stringQualifierChar;
    }

    public char getDelimChar() {
        return this.delimChar;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    public boolean getDoesFirstRowHaveHeaders() {
        return this.doesFirstRowHaveHeaders;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean getShouldUseTextQualifier() {
        return this.shouldUseTextQualifier;
    }

    public int getHighestColumnCount() {
        return this.highestColumnCount;
    }

    private class CharFieldKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent ke) {
            if (DataImportDialog.this.otherText.getText().length() == 1) {
                DataImportDialog.this.delimChar = DataImportDialog.this.otherText.getText().toCharArray()[0];
                DataImportDialog.this.configCSV.setDelimiter(DataImportDialog.this.delimChar);
                log.debug((Object)("Other value selected for delimiter: [" + DataImportDialog.this.delimChar + "]"));
            } else if (DataImportDialog.this.otherText.getText().length() > 1) {
                log.error((Object)"Other field should not allow more that one character as a delimiter");
            }
            DataImportDialog.this.updateTableDisplay();
        }
    }

    private class CharLengthLimitDocument
    extends PlainDocument {
        int limit;

        public CharLengthLimitDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
            if (offset + s.length() <= this.limit) {
                super.insertString(offset, s, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class CheckboxItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!DataImportDialog.this.ignoreActions) {
                ItemSelectable source = e.getItemSelectable();
                log.debug((Object)"itemStateChanged");
                if (source != DataImportDialog.this.containsHeaders) {
                    log.error((Object)"Unexpected checkbox source");
                }
                log.debug((Object)"itemStateChange for first row has header checkbox");
                if (e.getStateChange() == 1) {
                    log.debug((Object)"itemStateChanges - SELECTED");
                    DataImportDialog.this.doesFirstRowHaveHeaders = true;
                    DataImportDialog.this.config.setFirstRowHasHeaders(true);
                } else {
                    log.debug((Object)"itemStateChanges - UNSELECTED");
                    DataImportDialog.this.doesFirstRowHaveHeaders = false;
                    DataImportDialog.this.config.setFirstRowHasHeaders(false);
                }
                DataImportDialog.this.updateTableDisplay();
            }
        }
    }

    private class DataErrorPanel
    extends JPanel {
        public DataErrorPanel() {
            CellConstraints cc = new CellConstraints();
            FormLayout formLayout = new FormLayout("p,5px,p", "d");
            PanelBuilder builder = new PanelBuilder(formLayout, (JPanel)this);
            MouseOverJLabel statusInfoLabel = new MouseOverJLabel();
            statusInfoLabel.setHorizontalTextPosition(4);
            statusInfoLabel.setIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
            statusInfoLabel.setText(UIRegistry.getResourceString("DATA_IMPORT_ERROR"));
            statusInfoLabel.setActivatedTextColor(Color.RED);
            statusInfoLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataImportDialog.this.showErrors();
                }
            });
            builder.add((Component)statusInfoLabel, cc.xy(1, 1));
        }

        protected JPanel showDataImportStatusPanel(boolean shouldShow) {
            if (!shouldShow) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            return this;
        }
    }

    private class DelimButtonItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DataImportDialog.this.other == null) {
                return;
            }
            if (DataImportDialog.this.other.isSelected()) {
                DataImportDialog.this.otherText.setEditable(true);
                DataImportDialog.this.otherText.requestFocus();
                DataImportDialog.this.otherText.setEnabled(true);
                if (DataImportDialog.this.otherText.getText().length() == 1) {
                    DataImportDialog.this.delimChar = DataImportDialog.this.otherText.getText().toCharArray()[0];
                    DataImportDialog.this.configCSV.setDelimiter(DataImportDialog.this.delimChar);
                }
            } else if (DataImportDialog.this.tab.isSelected()) {
                DataImportDialog.this.delimChar = (char)9;
                DataImportDialog.this.otherText.setEnabled(false);
            } else if (DataImportDialog.this.space.isSelected()) {
                DataImportDialog.this.delimChar = (char)32;
                DataImportDialog.this.otherText.setEditable(false);
                DataImportDialog.this.otherText.setEnabled(false);
            } else if (DataImportDialog.this.semicolon.isSelected()) {
                DataImportDialog.this.delimChar = (char)59;
                DataImportDialog.this.otherText.setEditable(false);
                DataImportDialog.this.otherText.setEnabled(false);
            } else if (DataImportDialog.this.comma.isSelected()) {
                DataImportDialog.this.delimChar = (char)44;
                DataImportDialog.this.otherText.setEditable(false);
                DataImportDialog.this.otherText.setEnabled(false);
            } else {
                DataImportDialog.this.otherText.setEditable(false);
                DataImportDialog.this.otherText.setEnabled(false);
            }
            DataImportDialog.this.configCSV.setDelimiter(DataImportDialog.this.delimChar);
            DataImportDialog.this.updateTableDisplay();
        }
    }

    private class PreviewTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[0];
        private String[][] data = new String[][]{new String[0]};

        public PreviewTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        public PreviewTableModel(String[] headers, String[][] data) {
            this.columnNames = headers;
            this.data = data;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value.toString();
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void setColumnNames(String[] headers) {
            this.columnNames = headers;
        }

        public String[][] getData() {
            return this.data;
        }

        public void setData(String[][] data) {
            this.data = data;
        }
    }
}

