/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportTruncation;
import java.util.Vector;

public class DataImport {
    protected Vector<DataImportTruncation> truncations;
    protected Vector<String> messages;
    protected DataImportIFace.Status status = DataImportIFace.Status.None;
    public static String IMAGE_PATH_HEADING = "cardImagePath";
    public static String GEO_DATA_HEADING = "bioGeomancerResults";

    public static boolean isSystemColumn(String columnName) {
        return columnName.equals(IMAGE_PATH_HEADING) || columnName.equals(GEO_DATA_HEADING);
    }

    protected String truncateIfNecessary(String value, int row, WorkbenchTemplateMappingItem wbtmi) {
        int maxLen = WorkbenchDataItem.getMaxWBCellLength();
        if (wbtmi.getDataFieldLength() != null && wbtmi.getDataFieldLength() != -1 && wbtmi.getDataFieldLength() < maxLen) {
            maxLen = wbtmi.getDataFieldLength().shortValue();
        }
        if (value == null || value.length() <= maxLen) {
            return value;
        }
        return this.trackTrunc(value, row, wbtmi.getViewOrder(), wbtmi.getCaption(), maxLen);
    }

    protected String trackTrunc(String value, int row, short col, String colHeader, int len) {
        this.truncations.add(new DataImportTruncation(row, col, len, colHeader, value));
        return value.substring(0, len);
    }

    public Vector<DataImportTruncation> getTruncations() {
        return this.truncations;
    }

    public Vector<String> getMessages() {
        return this.messages;
    }

    public DataImportIFace.Status getStatus() {
        return this.status;
    }

    protected DataImport() {
        this.truncations = new Vector(10);
        this.messages = new Vector(10);
    }
}

