/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataBase;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportDialog;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ConfigureXLS
extends ConfigureExternalDataBase {
    private static final Logger log = Logger.getLogger(ConfigureXLS.class);
    protected int numRows = 0;
    protected int numCols = 0;

    public ConfigureXLS(File file) {
        this.readConfig(file);
    }

    public ConfigureXLS(Properties props) {
        super(props);
    }

    public void checkHeadsAndCols(HSSFSheet sheet, Vector<Integer> badHeads, Vector<Integer> emptyCols) {
        boolean firstRow = true;
        Vector<Boolean> firstRowCells = new Vector<Boolean>();
        Vector<Boolean> restCells = new Vector<Boolean>();
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            HSSFRow row = (HSSFRow)rows.next();
            int maxSize = Math.max(row.getPhysicalNumberOfCells(), row.getLastCellNum());
            int col = 0;
            while (col < maxSize) {
                if (firstRow) {
                    if (row.getCell(col) == null) {
                        firstRowCells.add(false);
                    } else if (row.getCell(col).getCellType() == 1) {
                        firstRowCells.add(true);
                    } else {
                        firstRowCells.add(null);
                    }
                } else {
                    if (col == restCells.size()) {
                        restCells.add(false);
                    }
                    if (!((Boolean)restCells.get(col)).booleanValue()) {
                        restCells.set(col, row.getCell(col) != null);
                    }
                }
                ++col;
            }
            firstRow = false;
        }
        while (restCells.size() < firstRowCells.size()) {
            restCells.add(false);
        }
        while (firstRowCells.size() < restCells.size()) {
            firstRowCells.add(false);
        }
        int c = 0;
        while (c < firstRowCells.size()) {
            if (firstRowCells.get(c) == null || !((Boolean)firstRowCells.get(c)).booleanValue() && ((Boolean)restCells.get(c)).booleanValue()) {
                badHeads.add(c);
            }
            if (firstRowCells.get(c) != null && !((Boolean)firstRowCells.get(c)).booleanValue() && !((Boolean)restCells.get(c)).booleanValue()) {
                emptyCols.add(c);
            }
            ++c;
        }
    }

    @Override
    protected void interactiveConfig() {
        DataImportDialog dlg = new DataImportDialog(this, this.firstRowHasHeaders);
        if (!dlg.init() || dlg.hasTooManyRows) {
            this.status = ConfigureExternalDataIFace.Status.Cancel;
            return;
        }
        UIHelper.centerAndShow(dlg, 800, null);
        if (!dlg.isCancelled()) {
            this.firstRowHasHeaders = dlg.getDoesFirstRowHaveHeaders();
            this.nonInteractiveConfig();
        } else {
            this.status = ConfigureExternalDataIFace.Status.Cancel;
        }
    }

    public void showBadHeadingsMsg(Vector<Integer> badHeadingIdxs, Vector<Integer> emptyCols, String title) {
        String colStr = "";
        int c = 0;
        while (c < badHeadingIdxs.size()) {
            if (c > 0) {
                colStr = String.valueOf(colStr) + (c == badHeadingIdxs.size() - 1 ? " and " : ", ");
            }
            int adjust = 1;
            if (emptyCols != null) {
                for (Integer ec : emptyCols) {
                    if (ec > badHeadingIdxs.get(c)) continue;
                    --adjust;
                }
                colStr = String.valueOf(colStr) + (badHeadingIdxs.get(c) + adjust);
            }
            ++c;
        }
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString(badHeadingIdxs.size() == 1 ? "WB_IMPORT_INVALID_COL_HEADER" : "WB_IMPORT_INVALID_COL_HEADERS"), colStr), title, 0);
    }

    protected DocumentSummaryInformation getDocSummary(POIFSFileSystem poifs) {
        DirectoryNode dir = poifs.getRoot();
        DocumentSummaryInformation result = null;
        try {
            DocumentEntry dsiEntry = (DocumentEntry)dir.getEntry("\u0005DocumentSummaryInformation");
            DocumentInputStream dis = new DocumentInputStream(dsiEntry);
            PropertySet ps = new PropertySet((InputStream)dis);
            dis.close();
            result = new DocumentSummaryInformation(ps);
        }
        catch (FileNotFoundException ex) {
            result = null;
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ConfigureXLS.class, ex);
            log.debug((Object)ex);
            result = null;
        }
        catch (NoPropertySetStreamException ex) {
            log.debug((Object)ex);
            result = null;
        }
        catch (MarkUnsupportedException ex) {
            log.debug((Object)ex);
            result = null;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            log.debug((Object)ex);
            result = null;
        }
        catch (IllegalPropertySetDataException ex) {
            log.debug((Object)ex);
            result = null;
        }
        return result;
    }

    protected void readMappings(POIFSFileSystem poifs) {
        CustomProperties props;
        DocumentSummaryInformation dsi = this.getDocSummary(poifs);
        if (dsi != null && (props = dsi.getCustomProperties()) != null) {
            for (ImportColumnInfo col : this.colInfo) {
                if (props.get(col.getColTitle()) == null) continue;
                String[] mapping = ((String)props.get(col.getColTitle())).split("\t");
                col.setMapToTbl(mapping[0]);
                col.setMapToFld(mapping[1]);
                if (mapping.length != 7) continue;
                col.setFormXCoord(Integer.valueOf(mapping[2]));
                col.setFormYCoord(Integer.valueOf(mapping[3]));
                if (StringUtils.isNotBlank((String)mapping[4])) {
                    col.setCaption(mapping[4]);
                }
                col.setFrmFieldType(Integer.valueOf(mapping[5]));
                col.setFrmMetaData(mapping[6]);
            }
        }
    }

    @Override
    protected void nonInteractiveConfig() {
        try {
            FileInputStream input = new FileInputStream(this.externalFile);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            this.colInfo = new Vector(16);
            Hashtable<Integer, Boolean> colTracker = new Hashtable<Integer, Boolean>();
            boolean firstRow = true;
            int col = 0;
            colTracker.clear();
            Vector<Integer> badHeads = new Vector<Integer>();
            Vector<Integer> emptyCols = new Vector<Integer>();
            this.checkHeadsAndCols(sheet, badHeads, emptyCols);
            if (this.firstRowHasHeaders && badHeads.size() > 0) {
                this.status = ConfigureExternalDataIFace.Status.Error;
                this.showBadHeadingsMsg(badHeads, null, UIRegistry.getResourceString("Error"));
                return;
            }
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                HSSFRow row = (HSSFRow)rows.next();
                if (firstRow || this.numRows == 1) {
                    int colNum = 0;
                    int maxSize = Math.max(row.getPhysicalNumberOfCells(), row.getLastCellNum());
                    while (colNum < maxSize) {
                        if (emptyCols.indexOf(new Integer(colNum)) == -1) {
                            ImportColumnInfo.ColumnType disciplinee = ImportColumnInfo.ColumnType.Integer;
                            String value = null;
                            boolean skip = false;
                            HSSFCell cell = row.getCell(colNum);
                            if (cell == null) {
                                value = "";
                                disciplinee = ImportColumnInfo.ColumnType.String;
                            } else {
                                switch (cell.getCellType()) {
                                    case 0: {
                                        double numeric = cell.getNumericCellValue();
                                        value = Double.toString(numeric);
                                        disciplinee = ImportColumnInfo.ColumnType.Double;
                                        break;
                                    }
                                    case 1: {
                                        HSSFRichTextString richVal = cell.getRichStringCellValue();
                                        value = richVal.getString().trim();
                                        disciplinee = ImportColumnInfo.ColumnType.String;
                                        break;
                                    }
                                    case 3: {
                                        value = "";
                                        disciplinee = ImportColumnInfo.ColumnType.String;
                                        break;
                                    }
                                    case 4: {
                                        boolean bool = cell.getBooleanCellValue();
                                        value = Boolean.toString(bool);
                                        disciplinee = ImportColumnInfo.ColumnType.Boolean;
                                        break;
                                    }
                                    default: {
                                        skip = true;
                                    }
                                }
                            }
                            if (this.numRows == 1 && !skip) {
                                ((ImportColumnInfo)this.colInfo.get(col)).setData(value);
                                ++col;
                            } else if (!skip) {
                                if (this.firstRowHasHeaders) {
                                    this.colInfo.add(new ImportColumnInfo(colNum, disciplinee, value, value, null, null, null));
                                    colTracker.put(col, true);
                                } else {
                                    String colName = String.valueOf(UIRegistry.getResourceString("DEFAULT_COLUMN_NAME")) + " " + (colNum + 1);
                                    this.colInfo.add(new ImportColumnInfo(colNum, disciplinee, colName, colName, null, null, null));
                                    colTracker.put(colNum, true);
                                }
                                ++this.numCols;
                            }
                        }
                        ++colNum;
                    }
                    firstRow = false;
                }
                ++this.numRows;
            }
            Collections.sort(this.colInfo);
            this.readMappings(fs);
            this.status = ConfigureExternalDataIFace.Status.Valid;
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ConfigureXLS.class, ex);
            this.status = ConfigureExternalDataIFace.Status.Error;
        }
    }

    @Override
    public Properties getProperties() {
        Properties result = super.getProperties();
        result.setProperty("mimetype", ExportFileConfigurationFactory.XLS_MIME_TYPE);
        return result;
    }
}

