/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public abstract class ConfigureExternalDataBase
implements ConfigureExternalDataIFace {
    private static final Logger log = Logger.getLogger(ConfigureExternalDataBase.class);
    private final String TRUE = "true";
    private final String FALSE = "false";
    protected ConfigureExternalDataIFace.Status status = ConfigureExternalDataIFace.Status.None;
    protected File externalFile;
    protected String fileName;
    protected Vector<ImportColumnInfo> colInfo = null;
    protected boolean firstRowHasHeaders;
    protected boolean interactive;
    protected boolean appendData;
    protected String[] headers;

    public ConfigureExternalDataBase() {
        log.debug((Object)"ConfigureExternalDataBase()");
        this.interactive = true;
        this.firstRowHasHeaders = true;
        this.appendData = false;
    }

    public ConfigureExternalDataBase(Properties props) {
        log.debug((Object)"ConfigureExternalDataBase(Properties props)");
        this.interactive = props.getProperty("interactive", "true") == "true";
        this.firstRowHasHeaders = props.getProperty("firstRowHasHeaders", "false") == "true";
        this.appendData = props.getProperty("appendData", "false") == "false";
        this.fileName = props.getProperty("fileName");
        this.readHeaders(props.getProperty("headers"));
    }

    @Override
    public ConfigureExternalDataIFace.Status getStatus() {
        return this.status;
    }

    protected void readHeaders(String prop) {
        if (prop != null) {
            CsvReader csv = new CsvReader((Reader)new StringReader(prop), ',');
            try {
                if (csv.readHeaders()) {
                    this.headers = csv.getHeaders();
                }
            }
            catch (IOException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ConfigureExternalDataBase.class, e);
                log.error((Object)e);
            }
        }
    }

    protected String getHeaderString() {
        if (this.headers == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        CsvWriter csv = new CsvWriter((Writer)sw, ',');
        try {
            csv.writeRecord(this.headers, true);
            csv.flush();
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ConfigureExternalDataBase.class, e);
            log.error((Object)e);
        }
        return sw.toString();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    @Override
    public void setInteractive(boolean arg) {
        this.interactive = arg;
    }

    @Override
    public boolean getFirstRowHasHeaders() {
        return this.firstRowHasHeaders;
    }

    @Override
    public void setFirstRowHasHeaders(boolean value) {
        this.firstRowHasHeaders = value;
    }

    @Override
    public Vector<ImportColumnInfo> getColInfo() {
        return this.colInfo;
    }

    @Override
    public File getFile() {
        return this.externalFile;
    }

    public boolean getAppendData() {
        return this.appendData;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected boolean determineFirstRowHasHeaders() {
        Object[] options = new Object[]{UIRegistry.getResourceString("Yes"), UIRegistry.getResourceString("No")};
        int n = JOptionPane.showOptionDialog(null, UIRegistry.getResourceString("ConfigureExternalDataBase.DOES_1ST_COL_NM"), "", 0, 3, null, options, options[0]);
        return n == 0;
    }

    protected abstract void interactiveConfig();

    protected abstract void nonInteractiveConfig();

    @Override
    public void readConfig(File file) {
        log.debug((Object)("ConfigureExternalDataBase getConfig(File)" + file.toString()));
        this.externalFile = file;
        this.fileName = this.externalFile.getName();
        if (this.interactive) {
            this.interactiveConfig();
        } else {
            this.nonInteractiveConfig();
        }
    }

    @Override
    public Properties getProperties() {
        log.debug((Object)"ConfigureExternalDataBase getProperties()");
        Properties result = new Properties();
        this.addBoolProperty(result, "interactive", this.interactive);
        this.addBoolProperty(result, "firstRowHasHeaders", this.firstRowHasHeaders);
        this.addBoolProperty(result, "appendData", this.appendData);
        if (this.fileName != null) {
            result.setProperty("fileName", this.fileName);
        }
        result.setProperty("headers", this.getHeaderString());
        return result;
    }

    protected void addBoolProperty(Properties props, String key, boolean value) {
        props.setProperty(key, value ? "true" : "false");
    }
}

