/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.csvreader.CsvReader;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataBase;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportDialog;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConfigureCSV
extends ConfigureExternalDataBase {
    private static final Logger log = Logger.getLogger(ConfigureCSV.class);
    private int escapeMode;
    private char delimiter;
    private char textQualifier;
    private Charset charset;
    private int numOfColsToAppend;
    private boolean shouldUseTextQualifier;

    public ConfigureCSV(File file) {
        log.debug((Object)"ConfigureCSV");
        this.escapeMode = this.getDefaultEscapeMode();
        this.delimiter = this.getDefaultDelimiter();
        this.charset = this.getDefaultCharset();
        this.textQualifier = this.getDefaultTextQualifier();
        this.shouldUseTextQualifier = this.getDefaultUserTextQualifer();
        this.numOfColsToAppend = 0;
        this.readConfig(file);
    }

    public ConfigureCSV(Properties props) {
        super(props);
        String prop = props.getProperty("escapeMode");
        this.escapeMode = prop == "backslash" ? 2 : (prop == "doubled" ? 1 : this.getDefaultEscapeMode());
        prop = props.getProperty("delimiter");
        this.delimiter = prop == "comma" ? (char)44 : (prop == "tab" ? (char)9 : this.getDefaultDelimiter());
        prop = props.getProperty("charset");
        this.charset = prop == null || prop == "US-ASCII" ? Charset.defaultCharset() : Charset.forName(prop);
        prop = props.getProperty("textQualifier");
        if (prop == "doublequote") {
            this.textQualifier = (char)34;
        } else if (prop == "singlequote") {
            this.textQualifier = (char)39;
        } else if (prop == "{none}") {
            this.shouldUseTextQualifier = false;
        } else {
            this.textQualifier = this.getDefaultTextQualifier();
        }
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    private CsvReader makeReader(char delimiterArg, Charset charsetArg, int escapeModeArg, char txtQualArg) {
        log.debug((Object)"makeReader: ");
        log.debug((Object)("   delimiterArg: " + delimiterArg));
        log.debug((Object)("   charsetArg: " + charsetArg));
        log.debug((Object)("   escapeModeArg: " + escapeModeArg));
        log.debug((Object)("   txtQualArg: " + txtQualArg));
        if (this.externalFile != null) {
            try {
                FileInputStream input = new FileInputStream(this.externalFile);
                CsvReader result = new CsvReader((InputStream)input, delimiterArg, charsetArg);
                result.setEscapeMode(escapeModeArg);
                if (this.shouldUseTextQualifier) {
                    result.setTextQualifier(txtQualArg);
                }
                result.setUseTextQualifier(this.shouldUseTextQualifier);
                log.debug((Object)"Status being set to Valid");
                this.status = ConfigureExternalDataIFace.Status.Valid;
                return result;
            }
            catch (FileNotFoundException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ConfigureCSV.class, ex);
                ex.printStackTrace();
            }
        }
        this.status = ConfigureExternalDataIFace.Status.Error;
        return null;
    }

    private CsvReader makeReader() {
        return this.makeReader(this.delimiter, this.charset, this.escapeMode, this.textQualifier);
    }

    private String getDefaultColHeader() {
        return UIRegistry.getResourceString("DEFAULT_COLUMN_NAME");
    }

    private boolean getDefaultUserTextQualifer() {
        return true;
    }

    public String[] setupHeaders() {
        CsvReader csv = this.makeReader();
        if (csv != null && this.status == ConfigureExternalDataIFace.Status.Valid) {
            try {
                if (csv.readRecord()) {
                    String[] result = new String[csv.getColumnCount()];
                    int h = 0;
                    while (h < csv.getColumnCount()) {
                        result[h] = String.valueOf(this.getDefaultColHeader()) + String.valueOf(h + 1);
                        ++h;
                    }
                    this.status = ConfigureExternalDataIFace.Status.Valid;
                    return result;
                }
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ConfigureCSV.class, ex);
                ex.printStackTrace();
                this.status = ConfigureExternalDataIFace.Status.Error;
            }
        }
        this.status = ConfigureExternalDataIFace.Status.Error;
        return null;
    }

    private char determineDelimiter() {
        Vector<String> list = new Vector<String>();
        list.add(",");
        list.add("TAB");
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.get("frame"), "Delimiter?", null, 7, list, "WorkbenchImportCvs");
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        String delim = (String)dlg.getSelectedObject();
        if (delim == "TAB") {
            return '\t';
        }
        return ',';
    }

    private char determineTextQualifier() {
        Vector<String> list = new Vector<String>();
        list.add("\"");
        list.add("'");
        list.add("{none}");
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.get("frame"), "Text Qualifier?", null, 7, list, "WorkbenchImportCvs");
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        String delim = (String)dlg.getSelectedObject();
        if (delim == "\"") {
            return '\"';
        }
        if (delim == "'") {
            return '\"';
        }
        return ' ';
    }

    private char getDefaultDelimiter() {
        return ',';
    }

    private char getDefaultTextQualifier() {
        return '\'';
    }

    private Charset determineCharset() {
        Vector<String> list = new Vector<String>();
        list.add("default");
        list.add("US-ASCII");
        list.add("ISO-8859-1");
        list.add("UTF-8");
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.get("frame"), "Character Set", null, 7, list, "WorkbenchImportCvs");
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        String delim = (String)dlg.getSelectedObject();
        if (delim == "default") {
            return Charset.defaultCharset();
        }
        return Charset.forName(delim);
    }

    private Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    private int determineEscapeMode() {
        Vector<String> list = new Vector<String>();
        list.add("backslash");
        list.add("doubled");
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.get("frame"), "Escape Mode?", null, 7, list, "WorkbenchImportCvs");
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        String delim = (String)dlg.getSelectedObject();
        if (delim == "backslash") {
            return 2;
        }
        return 1;
    }

    private int getDefaultEscapeMode() {
        return 1;
    }

    private ImportColumnInfo.ColumnType getCellType(int colIndex) {
        return ImportColumnInfo.ColumnType.String;
    }

    @Override
    protected void interactiveConfig() {
        log.debug((Object)"interactiveConfig");
        DataImportDialog dlg = new DataImportDialog(this, this.delimiter, this.textQualifier, this.charset, this.escapeMode, this.firstRowHasHeaders, this.shouldUseTextQualifier);
        if (!dlg.initForCSV() || dlg.hasTooManyRows) {
            this.status = ConfigureExternalDataIFace.Status.Cancel;
            return;
        }
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            this.delimiter = dlg.getDelimChar();
            this.charset = dlg.getCharset();
            this.escapeMode = dlg.getEscapeMode();
            this.firstRowHasHeaders = dlg.getDoesFirstRowHaveHeaders();
            this.textQualifier = dlg.getStringQualifierChar();
            this.shouldUseTextQualifier = dlg.getShouldUseTextQualifier();
            this.numOfColsToAppend = dlg.getHighestColumnCount();
            this.nonInteractiveConfig();
        } else {
            this.status = ConfigureExternalDataIFace.Status.Cancel;
        }
        log.debug((Object)("delim: " + this.delimiter));
        log.debug((Object)("charset: " + this.charset));
        log.debug((Object)("escapemode: " + this.escapeMode));
        log.debug((Object)("furst row has headers: " + this.firstRowHasHeaders));
        log.debug((Object)("textqualifier: " + this.textQualifier));
    }

    @Override
    protected void nonInteractiveConfig() {
        log.debug((Object)"nonInteractiveConfig");
        CsvReader csv = this.makeReader();
        if (csv != null && this.status == ConfigureExternalDataIFace.Status.Valid) {
            try {
                if (this.firstRowHasHeaders) {
                    csv.readHeaders();
                } else {
                    csv.setHeaders(this.setupHeaders());
                }
                String[] newHeaders = null;
                if (this.numOfColsToAppend > csv.getHeaderCount()) {
                    newHeaders = this.padColumnHeaders(this.numOfColsToAppend, csv.getHeaders());
                    csv.setHeaders(newHeaders);
                }
                if (this.status == ConfigureExternalDataIFace.Status.Valid) {
                    this.colInfo = new Vector(csv.getHeaderCount());
                    int h = 0;
                    while (h < csv.getHeaderCount()) {
                        this.colInfo.add(new ImportColumnInfo((short)h, this.getCellType(h), csv.getHeader(h), csv.getHeader(h), null, null, null));
                        ++h;
                    }
                    Collections.sort(this.colInfo);
                    return;
                }
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ConfigureCSV.class, ex);
                ex.printStackTrace();
            }
        }
        this.status = ConfigureExternalDataIFace.Status.Error;
    }

    @Override
    public Properties getProperties() {
        Properties result = super.getProperties();
        result.setProperty("mimetype", ExportFileConfigurationFactory.CSV_MIME_TYPE);
        if (this.escapeMode == 2) {
            result.setProperty("escapeMode", "backslash");
        } else if (this.escapeMode == 1) {
            result.setProperty("escapeMode", "doubled");
        }
        if (this.delimiter == ',') {
            result.setProperty("delimiter", "comma");
        } else if (this.delimiter == '\t') {
            result.setProperty("delimiter", "tab");
        }
        if (this.textQualifier == '\"') {
            result.setProperty("textQualifer", "doublequote");
        } else if (this.textQualifier == '\'') {
            result.setProperty("textQualifer", "singlequote");
        }
        result.setProperty("charset", this.charset.name());
        return result;
    }

    public String[] padColumnHeaders(int highestColumnCnt, String[] array) {
        return DataImportDialog.padArray(highestColumnCnt, array, true);
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(boolean use, char textQualifier) {
        this.shouldUseTextQualifier = true;
        if (use) {
            this.textQualifier = textQualifier;
        }
    }

    public void setEscapeMode(int escapeMode) {
        this.escapeMode = escapeMode;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public int getNumOfColsToAppend() {
        return this.numOfColsToAppend;
    }

    public void setNumOfColsToAppend(int numOfColsToAppend) {
        this.numOfColsToAppend = numOfColsToAppend;
    }

    public boolean isShouldUseTextQualifier() {
        return this.shouldUseTextQualifier;
    }

    public void setShouldUseTextQualifier(boolean userTextQualifier) {
        this.shouldUseTextQualifier = userTextQualifier;
    }
}

