/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class CellRenderingAttributes {
    public static final Color HUNTER_ORANGE = new Color(252, 144, 29);
    public static final Color LIGHT_SABRE_BLUE = new Color(4, 184, 252);
    public static Color errorBorder;
    public static Color errorForeground;
    public static Color errorBackground;
    public static Color newDataBorder;
    public static Color newDataForeground;
    public static Color newDataBackground;
    public static Color multipleMatchBorder;
    public static Color multipleMatchBackground;
    public static Color multipleMatchForeground;
    public static Color notMatchedBorder;
    public static Color notMatchedBackground;
    public static Color notMatchedForeground;
    public static boolean highlightSkipped;

    static {
        errorForeground = errorBorder = Color.RED;
        errorBackground = new Color(errorBorder.getRed(), errorBorder.getGreen(), errorBorder.getBlue(), 37);
        newDataForeground = newDataBorder = HUNTER_ORANGE;
        newDataBackground = new Color(newDataBorder.getRed(), newDataBorder.getGreen(), newDataBorder.getBlue(), 37);
        multipleMatchBorder = LIGHT_SABRE_BLUE;
        multipleMatchBackground = new Color(multipleMatchBorder.getRed(), multipleMatchBorder.getGreen(), multipleMatchBorder.getBlue(), 37);
        multipleMatchForeground = multipleMatchBorder;
        notMatchedBorder = newDataBorder;
        notMatchedBackground = null;
        notMatchedForeground = notMatchedBorder;
        highlightSkipped = false;
    }

    protected Atts getAtts(int wbCellStatus, String statusText, boolean doIncrementalValidation, boolean doIncrementalMatching) {
        LineBorder bdr = null;
        Color bg = null;
        if (doIncrementalValidation && (wbCellStatus == 2 || wbCellStatus == 3)) {
            bdr = new LineBorder(errorBorder);
            bg = errorBackground;
        } else if (doIncrementalMatching && wbCellStatus == 4) {
            bdr = new LineBorder(newDataBorder);
            bg = newDataBackground;
        } else if (doIncrementalMatching && wbCellStatus == 5) {
            bdr = new LineBorder(multipleMatchBorder);
            bg = multipleMatchBackground;
        } else if (highlightSkipped && doIncrementalMatching && wbCellStatus == 6) {
            bdr = new LineBorder(notMatchedBorder);
            bg = notMatchedBackground;
        }
        return new Atts(statusText, bdr, bg);
    }

    public void addAttributes(JLabel lbl, WorkbenchDataItem wbCell, boolean doIncrementalValidation, boolean doIncrementalMatching) {
        if (doIncrementalValidation || doIncrementalMatching) {
            int cellStatus = 1;
            String cellStatusText = null;
            if (wbCell != null) {
                cellStatus = wbCell.getEditorValidationStatus();
                cellStatusText = wbCell.getStatusText();
            }
            if (cellStatus != 0 && cellStatus != 1) {
                Atts atts = this.getAtts(cellStatus, cellStatusText, doIncrementalValidation, doIncrementalMatching);
                lbl.setBorder(atts.border);
            }
        }
    }

    private class Atts {
        public String toolTip;
        public Border border;
        public Color background;

        public Atts(String toolTip, Border border, Color background) {
            this.toolTip = toolTip;
            this.border = border;
            this.background = background;
        }
    }
}

