/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.csvreader.CsvReader;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImport;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CSVImport
extends DataImport
implements DataImportIFace {
    private static final Logger log = Logger.getLogger(CSVImport.class);
    protected ConfigureExternalDataIFace config;

    public CSVImport(ConfigureExternalDataIFace config) {
        this.config = config;
    }

    @Override
    public ConfigureExternalDataIFace getConfig() {
        return this.config;
    }

    @Override
    public DataImportIFace.Status getData(Workbench workbench) {
        try {
            ConfigureCSV configCSV = null;
            if (this.config instanceof ConfigureCSV && (configCSV = (ConfigureCSV)this.config).getStatus() == ConfigureExternalDataIFace.Status.Valid) {
                CsvReader csv = new CsvReader((InputStream)new FileInputStream(this.config.getFile()), configCSV.getDelimiter(), configCSV.getCharset());
                csv.setEscapeMode(configCSV.getEscapeMode());
                csv.setTextQualifier(configCSV.getTextQualifier());
                Set<WorkbenchTemplateMappingItem> wbtmiSet = workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems();
                Vector<WorkbenchTemplateMappingItem> wbtmiList = new Vector<WorkbenchTemplateMappingItem>();
                wbtmiList.addAll(wbtmiSet);
                Collections.sort(wbtmiList);
                this.truncations.clear();
                if (this.config.getFirstRowHasHeaders()) {
                    csv.readHeaders();
                } else {
                    csv.setHeaders(configCSV.setupHeaders());
                }
                String[] newHeaders = null;
                if (configCSV.getNumOfColsToAppend() > csv.getColumnCount()) {
                    newHeaders = configCSV.padColumnHeaders(configCSV.getNumOfColsToAppend(), csv.getHeaders());
                    csv.setHeaders(newHeaders);
                }
                Hashtable<Short, WorkbenchTemplateMappingItem> colHash = new Hashtable<Short, WorkbenchTemplateMappingItem>();
                for (WorkbenchTemplateMappingItem wbtmi : wbtmiList) {
                    if (wbtmi.getOrigImportColumnIndex() > -1) {
                        colHash.put(wbtmi.getOrigImportColumnIndex(), wbtmi);
                        continue;
                    }
                    if (wbtmi.getViewOrder() == null || wbtmi.getViewOrder() == -1) continue;
                    colHash.put(wbtmi.getViewOrder(), wbtmi);
                }
                int row = this.config.getFirstRowHasHeaders() ? 1 : 0;
                while (csv.readRecord()) {
                    WorkbenchRow wbRow = workbench.addRow();
                    ++row;
                    int col = 0;
                    while (col < csv.getColumnCount()) {
                        WorkbenchTemplateMappingItem wbtmi = (WorkbenchTemplateMappingItem)colHash.get((short)col);
                        if (wbtmi != null) {
                            wbRow.setData(this.truncateIfNecessary(csv.get(col), this.config.getFirstRowHasHeaders() ? row - 1 : row, wbtmi), wbtmi.getViewOrder(), true);
                        }
                        ++col;
                    }
                }
                this.status = this.truncations.size() == 0 ? DataImportIFace.Status.Valid : DataImportIFace.Status.Modified;
                return this.status;
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CSVImport.class, ex);
            log.error((Object)ex);
        }
        this.status = DataImportIFace.Status.Error;
        return this.status;
    }

    @Override
    public void setConfig(ConfigureExternalDataIFace config) {
        this.config = config;
    }
}

