/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.csvreader.CsvWriter;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataExport;
import java.io.IOException;
import java.util.List;

public class CSVExport
implements DataExport {
    ConfigureCSV config;

    public CSVExport(ConfigureExternalDataIFace config) {
        this.config = (ConfigureCSV)config;
    }

    @Override
    public ConfigureExternalDataIFace getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ConfigureExternalDataIFace config) {
        this.config = (ConfigureCSV)config;
    }

    protected void writeHeaders(CsvWriter csv) throws IOException {
        try {
            csv.writeRecord(this.config.getHeaders(), true);
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CSVExport.class, e);
            throw e;
        }
    }

    @Override
    public void writeData(List<?> data) throws Exception {
        CsvWriter writer = new CsvWriter(this.config.getFileName());
        if (this.config.getFirstRowHasHeaders() && !this.config.getAppendData()) {
            this.writeHeaders(writer);
        }
        int r = 0;
        while (r < data.size()) {
            WorkbenchRow row = (WorkbenchRow)data.get(r);
            String[] record = new String[row.getWorkbenchDataItems().size()];
            int c = 0;
            while (c < row.getWorkbenchDataItems().size()) {
                record[c] = row.getData(c);
                ++c;
            }
            try {
                writer.writeRecord(record);
            }
            catch (IOException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(CSVExport.class, e);
                throw e;
            }
            ++r;
        }
        writer.flush();
    }
}

