/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultsDisplay;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;

public class BioGeomancerResultsChooser
extends CustomDialog {
    protected BioGeomancerResultsDisplay resultsDisplayPanel = new BioGeomancerResultsDisplay();
    protected List<WorkbenchRow> rows;
    protected List<BioGeomancerResultStruct> chosenResults;
    protected boolean hasBeenShown;
    protected int rowIndex;
    protected String baseTitle;

    public BioGeomancerResultsChooser(Frame parent, String title, List<WorkbenchRow> rows) {
        super(parent, title, true, 15, null);
        this.rows = rows;
        this.hasBeenShown = false;
        this.baseTitle = title;
        this.chosenResults = new Vector<BioGeomancerResultStruct>(rows.size());
        int i = 0;
        while (i < rows.size()) {
            this.chosenResults.add(null);
            ++i;
        }
        this.setContentPanel(this.resultsDisplayPanel);
        this.cancelLabel = UIRegistry.getResourceString("SKIP");
        this.applyLabel = UIRegistry.getResourceString("ACCEPT");
        this.okLabel = UIRegistry.getResourceString("QUIT");
        this.rowIndex = -1;
    }

    public List<BioGeomancerResultStruct> getResultsChosen() {
        if (!this.hasBeenShown) {
            this.setVisible(true);
        }
        return this.chosenResults;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.hasBeenShown && visible) {
            this.hasBeenShown = true;
            this.createUI();
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, "WorkbenchSpecialTools");
            this.showNextRecord();
            UIHelper.centerWindow(this);
            this.pack();
        }
        super.setVisible(visible);
    }

    @Override
    protected void applyButtonPressed() {
        super.applyButtonPressed();
        BioGeomancerResultStruct result = this.resultsDisplayPanel.getSelectedResult();
        this.chosenResults.set(this.rowIndex, result);
        if (this.onLastRecord()) {
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    @Override
    protected void okButtonPressed() {
        super.okButtonPressed();
    }

    @Override
    protected void cancelButtonPressed() {
        if (this.onLastRecord()) {
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    protected void showNextRecord() {
        ++this.rowIndex;
        this.setTitle(String.valueOf(this.baseTitle) + ": " + (this.rowIndex + 1) + " " + UIRegistry.getResourceString("of") + " " + this.rows.size());
        try {
            this.resultsDisplayPanel.setBioGeomancerResultsData(this.rows.get(this.rowIndex).getBioGeomancerResults());
            this.resultsDisplayPanel.setSelectedResult(0);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BioGeomancerResultsChooser.class, e);
            UIRegistry.getStatusBar().setErrorMessage("Error while displaying BioGeomancer results", e);
            super.setVisible(false);
        }
    }

    protected boolean onLastRecord() {
        return this.rowIndex == this.rows.size() - 1;
    }
}

