/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCellValueWrapper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class YesNoCellRenderer
extends DefaultTableCellRenderer {
    public final String YES = UIRegistry.getResourceString("YES");
    public final String NO = UIRegistry.getResourceString("NO");
    public Font boldFont = null;
    public Font normalFont = null;

    public YesNoCellRenderer() {
        this.setHorizontalAlignment(0);
        this.normalFont = this.getFont();
        this.boldFont = this.normalFont.deriveFont(1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Boolean) {
            label.setForeground((Boolean)value != false ? Color.BLACK : Color.LIGHT_GRAY);
            label.setFont((Boolean)value != false ? this.boldFont : this.normalFont);
            label.setText((Boolean)value != false ? this.YES : this.NO);
        } else if (value instanceof GeneralPermissionTableCellValueWrapper) {
            GeneralPermissionTableCellValueWrapper wrapper = (GeneralPermissionTableCellValueWrapper)value;
            if (!wrapper.isOverriden()) {
                label.setForeground(wrapper.getPermissionActionValue() ? Color.BLACK : Color.LIGHT_GRAY);
                label.setFont(wrapper.getPermissionActionValue() ? this.boldFont : this.normalFont);
                label.setText(wrapper.getPermissionActionValue() ? this.YES : this.NO);
            } else {
                label.setForeground(Color.DARK_GRAY);
                label.setFont(this.boldFont);
                label.setText("<html><center><font size=\"-2\">" + this.YES + "</font><br>" + "<font size=\"-3\">(" + wrapper.getOverrulingPermissionText() + ")</font><center></html>");
            }
        }
        return label;
    }
}

