/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.busrules.TableSearchResults;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserAgentVSQBldr
implements ViewBasedSearchQueryBuilderIFace {
    private static final Logger log = Logger.getLogger(UserAgentVSQBldr.class);
    protected ExpressResultsTableInfo esTblInfo = null;
    protected ValComboBoxFromQuery cbx;
    protected Integer disciplineID = null;

    public UserAgentVSQBldr(ValComboBoxFromQuery cbx) {
        this.cbx = cbx;
    }

    @Override
    public String buildSQL(Map<String, Object> dataMap, List<String> fieldNames) {
        Vector<Object> disciplineIds = BasicSQLUtils.querySingleCol("SELECT DisciplineID FROM discipline ORDER BY Name");
        if (disciplineIds.size() > 1) {
            Vector<Object> divisionNames = BasicSQLUtils.querySingleCol("SELECT Name FROM discipline ORDER BY Name");
            ToggleButtonChooserDlg<Object> divDlg = new ToggleButtonChooserDlg<Object>(null, UIRegistry.getResourceString("SEC_PK_SRCH"), (List<Object>)divisionNames, ToggleButtonChooserPanel.Type.RadioButton);
            divDlg.setUseScrollPane(true);
            divDlg.createUI();
            divDlg.getCancelBtn().setVisible(false);
            divDlg.setDefaultCloseOperation(2);
            UIHelper.centerAndShow(divDlg);
            int inx = divisionNames.indexOf(divDlg.getSelectedObject());
            this.disciplineID = (Integer)disciplineIds.get(inx);
        } else {
            this.disciplineID = (Integer)disciplineIds.get(0);
        }
        String searchName = this.cbx.getSearchName();
        if (searchName != null) {
            this.esTblInfo = ExpressSearchConfigCache.getTableInfoByName(searchName);
            if (this.esTblInfo != null) {
                String sqlStr = this.esTblInfo.getViewSql();
                return this.buildSearchString(dataMap, fieldNames, StringUtils.replace((String)sqlStr, (String)"DSPLNID", (String)this.disciplineID.toString()));
            }
        }
        return null;
    }

    @Override
    public String buildSQL(String searchText, boolean isForCount) {
        return null;
    }

    @Override
    public QueryForIdResultsIFace createQueryForIdResults() {
        return new TableSearchResults(DBTableIdMgr.getInstance().getInfoById(Agent.getClassTableId()), this.esTblInfo.getCaptionInfo());
    }

    protected String buildSearchString(Map<String, Object> dataMap, List<String> fieldNames, String sqlTemplate) {
        StringBuilder orderBy = new StringBuilder();
        StringBuilder criteria = new StringBuilder("agent.SpecifyUserID IS NULL AND (");
        int criCnt = 0;
        for (String colName : dataMap.keySet()) {
            String data = (String)dataMap.get(colName);
            if (!ESTermParser.getInstance().parse(data.toLowerCase(), true) || !StringUtils.isNotEmpty((String)data)) continue;
            List<SearchTermField> fields = ESTermParser.getInstance().getFields();
            SearchTermField firstTerm = fields.get(0);
            if (criCnt > 0) {
                criteria.append(" OR ");
            }
            String clause = ESTermParser.getInstance().createWhereClause(firstTerm, null, colName);
            criteria.append(clause);
            if (criCnt > 0) {
                orderBy.append(',');
            }
            orderBy.append(colName);
            ++criCnt;
        }
        criteria.append(")");
        String sqlStr = null;
        StringBuffer sb = new StringBuffer();
        sb.append((CharSequence)criteria);
        int inxGrpBy = sqlTemplate.toLowerCase().indexOf("group by");
        if (inxGrpBy == -1) {
            sb.append(" ORDER BY ");
            sb.append((CharSequence)orderBy);
            sqlStr = StringUtils.replace((String)sqlTemplate, (String)"(%s)", (String)sb.toString());
        } else {
            sqlStr = StringUtils.replace((String)sqlTemplate, (String)"(%s)", (String)sb.toString());
            sqlStr = String.valueOf(sqlStr) + " ORDER BY " + orderBy;
        }
        log.debug((Object)sqlStr);
        return sqlStr;
    }
}

