/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.StartUpTask;
import edu.ku.brc.af.tasks.StatsTrackerTask;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class TaskPermissionEnumerator
extends PermissionEnumerator {
    protected List<SecurityOptionIFace> taskOptions = null;

    public TaskPermissionEnumerator() {
        super("Task", "ADMININFO_DESC");
    }

    @Override
    protected List<SecurityOptionIFace> getSecurityOptions() {
        if (this.taskOptions == null) {
            XStream xstream = new XStream();
            PermissionOptionPersist.config(xstream);
            Hashtable hash = new Hashtable();
            for (Taskable task : TaskMgr.getInstance().getAllTasks()) {
                if (!task.isPermissionsSettable()) continue;
                String name = task.getName();
                Hashtable<String, PermissionOptionPersist> hashItem = new Hashtable<String, PermissionOptionPersist>();
                hash.put(name, hashItem);
                int i = 0;
                SpecifyUserTypes.UserType[] userTypeArray = SpecifyUserTypes.UserType.values();
                int n = userTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SpecifyUserTypes.UserType spUserType = userTypeArray[n2];
                    String typeName = spUserType.toString();
                    PermissionIFace perm = task.getDefaultPermissions(typeName);
                    if (perm == null) {
                        perm = new PermissionSettings(false, false, false, false);
                    }
                    hashItem.put(typeName, new PermissionOptionPersist(name, typeName, perm));
                    ++i;
                    ++n2;
                }
            }
            this.taskOptions = new ArrayList<SecurityOptionIFace>();
            for (Taskable task : TaskMgr.getInstance().getAllTasks()) {
                if (!task.isPermissionsSettable() || StatsTrackerTask.class.isAssignableFrom(task.getTaskClass()) || StartUpTask.class.isAssignableFrom(task.getTaskClass())) continue;
                this.taskOptions.add(task);
            }
        }
        return this.taskOptions;
    }
}

