/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.CollectingEventAttr;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.datamodel.PreparationAttr;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class TablePermissionEnumerator
extends PermissionEnumerator {
    protected List<SecurityOptionIFace> tableOptions = null;
    protected Hashtable<Integer, Boolean> tableIdHash = null;

    public TablePermissionEnumerator() {
        super("DO", "ADMININFO_DESC");
    }

    public TablePermissionEnumerator(int[] tableIds) {
        this();
        this.setTableIds(tableIds);
    }

    public void setTableIds(int[] tableIds) {
        if (this.tableIdHash == null) {
            this.tableIdHash = new Hashtable();
        } else {
            this.tableIdHash.clear();
        }
        int[] nArray = tableIds;
        int n = tableIds.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.tableIdHash.put(id, true);
            ++n2;
        }
        if (this.tableOptions != null) {
            this.tableOptions.clear();
        }
        this.tableOptions = null;
    }

    protected boolean isTableOK(DBTableInfo tblInfo) {
        String shortName;
        return !(tblInfo.getTableId() >= 500 || this.tableIdHash != null && this.tableIdHash.get(tblInfo.getTableId()) == null || (shortName = tblInfo.getShortClassName()).startsWith("Workbench") && !shortName.equals("Workbench") || shortName.equals("SpecifyUser") || TreeDefItemIface.class.isAssignableFrom(tblInfo.getClassObj()) || AttributeDef.class.isAssignableFrom(tblInfo.getClassObj()) || CollectionObjectAttr.class.isAssignableFrom(tblInfo.getClassObj()) || CollectingEventAttr.class.isAssignableFrom(tblInfo.getClassObj()) || PreparationAttr.class.isAssignableFrom(tblInfo.getClassObj()) || AutoNumberingScheme.class.isAssignableFrom(tblInfo.getClassObj()) || CollectionRelationship.class.isAssignableFrom(tblInfo.getClassObj()) || CollectionRelType.class.isAssignableFrom(tblInfo.getClassObj()) || RecordSet.class.isAssignableFrom(tblInfo.getClassObj()));
    }

    @Override
    protected List<SecurityOptionIFace> getSecurityOptions() {
        if (this.tableOptions == null) {
            this.tableOptions = new ArrayList<SecurityOptionIFace>();
            Hashtable<String, Hashtable<String, PermissionOptionPersist>> mainHash = BaseTask.readDefaultPermsFromXML("dataobjs.xml");
            for (DBTableInfo tblInfo : DBTableIdMgr.getInstance().getTables()) {
                Hashtable<String, PermissionOptionPersist> hash;
                if (!this.isTableOK(tblInfo)) continue;
                SecurityOption securityOption = new SecurityOption(tblInfo.getName(), tblInfo.getTitle(), "DO", tblInfo.getName());
                this.tableOptions.add(securityOption);
                if (mainHash == null || (hash = mainHash.get(tblInfo.getName())) == null) continue;
                for (PermissionOptionPersist tp : hash.values()) {
                    PermissionIFace defPerm = tp.getDefaultPerms();
                    securityOption.addDefaultPerm(tp.getUserType(), defPerm);
                }
            }
        }
        return this.tableOptions;
    }
}

