/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.specify.permission.PermissionService;
import edu.ku.brc.af.auth.specify.principal.UserPrincipalHibernateService;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.subpane.security.EditorPanel;
import edu.ku.brc.specify.tasks.subpane.security.IndvPanelPermEditor;
import edu.ku.brc.specify.tasks.subpane.security.ObjectPermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditor;
import edu.ku.brc.specify.tasks.subpane.security.PermissionPanelEditor;
import edu.ku.brc.specify.tasks.subpane.security.PrefsPermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.TablePermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.TaskPermissionEnumerator;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SecuritySummaryDlg
extends CustomDialog {
    public SecuritySummaryDlg(CustomDialog parentDlg) {
        super(parentDlg, UIRegistry.getResourceString("SecuritySummaryDlg.DLG_TITLE"), true, 5, null);
        this.helpContext = "SecuritySummary";
        this.okLabel = UIRegistry.getResourceString("CLOSE");
    }

    @Override
    public void createUI() {
        super.createUI();
        EditorPanel infoPanel = new EditorPanel(null);
        CellConstraints cc = new CellConstraints();
        PermissionEditor prefsEdt = new PermissionEditor("Preferences", new PrefsPermissionEnumerator(), infoPanel, true, "SEC_NAME_TITLE", "SEC_ENABLE_PREF", null, null, null);
        PermissionPanelEditor generalEditor = new PermissionPanelEditor(null, null);
        generalEditor.addPanel(new IndvPanelPermEditor("SEC_TOOLS", "SEC_TOOLS_DSC", new TaskPermissionEnumerator(), infoPanel, true));
        generalEditor.addPanel(new PermissionEditor("SEC_TABLES", new TablePermissionEnumerator(), infoPanel, true));
        generalEditor.addPanel(prefsEdt);
        PermissionPanelEditor objEditor = new PermissionPanelEditor(null, null);
        objEditor.addPanel(new IndvPanelPermEditor("SEC_DOS", "SEC_DOS_DSC", new ObjectPermissionEnumerator(), infoPanel));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(UIRegistry.getResourceString("SEC_GENERAL"), generalEditor);
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,5px,min(325px;p),2dlu,p"), (JPanel)infoPanel);
        mainPB.add((Component)tabbedPane, cc.xy(1, 1));
        this.contentPanel = infoPanel;
        this.mainPanel.add(this.contentPanel, "Center");
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        SpPrincipal principal = UserPrincipalHibernateService.getUserPrincipalBySpecifyUser(user);
        if (principal != null) {
            Hashtable<String, SpPermission> existingPerms = PermissionService.getExistingPermissions(principal.getId());
            Hashtable<String, SpPermission> overridingPerms = PermissionService.getOverridingPermissions(user);
            generalEditor.updateData(principal, null, existingPerms, overridingPerms, null);
        } else {
            UIRegistry.showError(String.format("The user '%s' doesn't have a User Principal object, which should not happen.\nPlease contact Specify Support.", user.getName()));
        }
        this.pack();
        this.setSize(600, 500);
    }
}

