/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.SearchBox;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.db.ViewBasedDisplayPanel;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import edu.ku.brc.specify.tasks.subpane.security.AdminInfoSubPanelWrapper;
import edu.ku.brc.specify.tasks.subpane.security.DataModelObjBaseWrapper;
import edu.ku.brc.specify.tasks.subpane.security.EditorPanel;
import edu.ku.brc.specify.tasks.subpane.security.IndvPanelPermEditor;
import edu.ku.brc.specify.tasks.subpane.security.NavigationTreeContextMenuMgr;
import edu.ku.brc.specify.tasks.subpane.security.NavigationTreeMgr;
import edu.ku.brc.specify.tasks.subpane.security.ObjectPermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditor;
import edu.ku.brc.specify.tasks.subpane.security.PermissionPanelEditor;
import edu.ku.brc.specify.tasks.subpane.security.PrefsPermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.TablePermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.TaskPermissionEnumerator;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SecurityAdminPane
extends BaseSubPane {
    private static final Logger log = Logger.getLogger(SecurityAdminPane.class);
    private JTree tree;
    private JPanel infoCards;
    private Set<SpecifyUser> spUsers;
    private Hashtable<String, AdminInfoSubPanelWrapper> infoSubPanels;
    private Hashtable<String, EditorPanel> editorPanels = new Hashtable();
    private AdminInfoSubPanelWrapper currentDisplayPanel = null;
    private EditorPanel currentEditorPanel = null;
    private String currentTitle = null;
    private JAutoCompTextField searchText;
    private Discipline nodesDiscipline = null;
    private Division nodesDivision = null;
    private NavigationTreeMgr navTreeMgr;
    private NavigationTreeContextMenuMgr navTreeContextMgr;
    private boolean hasPermissionToModify = false;
    private boolean hasPermissionToAdd = SecurityMgr.getInstance().checkPermission("Task.SecurityAdmin", "add");
    private boolean hasPermissionToDelete = false;
    private DataModelObjBaseWrapper objWrapper = null;
    private DataModelObjBaseWrapper secondObjWrapper = null;
    private DataModelObjBaseWrapper collectionWrapper = null;
    private final int formOptions = 20;

    public SecurityAdminPane(String name, Taskable task) {
        super(name, task);
        this.hasPermissionToModify = SecurityMgr.getInstance().checkPermission("Task.SecurityAdmin", "modify");
        this.hasPermissionToDelete = SecurityMgr.getInstance().checkPermission("Task.SecurityAdmin", "delete");
    }

    public JPanel createMainControlUI() {
        this.setLayout(new BorderLayout());
        JPanel securityAdminPanel = new JPanel();
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("3dlu,p,4px,3dlu,4px,f:p:g,3dlu", "3dlu,f:p:g,3dlu,p,3dlu,p,3dlu"), securityAdminPanel);
        CellConstraints cc = new CellConstraints();
        mainPB.add((Component)this.createNavigationPanel(), cc.xy(2, 2));
        mainPB.add((Component)new VerticalSeparator(new Color(224, 224, 224), new Color(124, 124, 124)), cc.xy(4, 2));
        mainPB.add((Component)this.createInformationPanel(), cc.xy(6, 2));
        this.updateUIEnabled(null);
        this.add((Component)UIHelper.createScrollPane(securityAdminPanel), "Center");
        return securityAdminPanel;
    }

    private JPanel createNavigationPanel() {
        JPanel navigationPanel = new JPanel();
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("min(210px;p)", "p,3dlu,p,3dlu,f:p:g,2px,p,10px,p"), navigationPanel);
        CellConstraints cc = new CellConstraints();
        JPanel navTreePanel = this.createFullTreeNavPanel();
        navTreePanel.setMinimumSize(new Dimension(200, 200));
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("p,4px,p,4px,p,4px,p,4px,p,f:p:g", "p"));
        JButton addUserBtn = UIHelper.createIconBtn("add-person", IconManager.IconSize.NonStd, "SEC_ADDNEWUSERGRP_TT", null);
        JButton addExtUserBtn = UIHelper.createIconBtn("addext-person", IconManager.IconSize.NonStd, "SEC_ADDEXTUSERGRP_TT", null);
        JButton addToAdminBtn = UIHelper.createIconBtn("AdminGroup", IconManager.IconSize.Std24, "SEC_ADDADMUSERGRP_TT", null);
        JButton delUserBtn = UIHelper.createIconBtn("del-person", IconManager.IconSize.NonStd, "SEC_DELUSRGRP_TT", null);
        btnPB.add((Component)addUserBtn, cc.xy(1, 1));
        btnPB.add((Component)addExtUserBtn, cc.xy(3, 1));
        btnPB.add((Component)addToAdminBtn, cc.xy(5, 1));
        btnPB.add((Component)delUserBtn, cc.xy(7, 1));
        this.navTreeContextMgr.setBtn(addUserBtn, addExtUserBtn, addToAdminBtn, delUserBtn);
        PanelBuilder tbRightPB = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
        mainPB.add((Component)tbRightPB.getPanel(), cc.xy(1, 6));
        int y = 1;
        PanelBuilder lpb = new PanelBuilder(new FormLayout("p,10px,p:g", "p,2px,p,2px,p,2px,p,2px,p,2px"));
        lpb.addSeparator(UIRegistry.getResourceString("SEC_LGND"), cc.xyw(1, y, 3));
        y += 2;
        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        String[] lbl = new String[]{"SEC_DSP", "SEC_COLL", "SEC_ADMINGRP", "SEC_PERSON"};
        String[] icn = new String[]{discipline.getType(), "Collection", "AdminGroup", "person"};
        int i = 0;
        while (i < lbl.length) {
            lpb.add((Component)UIHelper.createLabel("", IconManager.getIcon(icn[i], IconManager.STD_ICON_SIZE)), cc.xy(1, y));
            lpb.add((Component)UIHelper.createI18NLabel(lbl[i]), cc.xy(3, y));
            y += 2;
            ++i;
        }
        mainPB.add((Component)btnPB.getPanel(), cc.xy(1, 7));
        mainPB.add((Component)lpb.getPanel(), cc.xy(1, 9));
        DocumentAdaptor searchDL = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                FilteredTreeModel model = (FilteredTreeModel)SecurityAdminPane.this.tree.getModel();
                Filter filter = StringUtils.isNotEmpty((String)SecurityAdminPane.this.searchText.getText()) ? new Filter(SecurityAdminPane.this.searchText.getText()) : null;
                model.setFilter(filter);
            }
        };
        this.searchText = new JAutoCompTextField(UIHelper.isMacOS() ? 15 : 22);
        this.searchText.getDocument().addDocumentListener(searchDL);
        SearchBox searchBox = new SearchBox(this.searchText, null);
        PanelBuilder toolbarPB = new PanelBuilder(new FormLayout("l:p,1dlu,p,1dlu,p,1dlu,p,15dlu,r:p", "p"));
        toolbarPB.add((Component)searchBox, cc.xy(1, 1));
        mainPB.add((Component)toolbarPB.getPanel(), cc.xy(1, 3));
        mainPB.add((Component)navTreePanel, cc.xy(1, 5));
        return navigationPanel;
    }

    private void createNavigationTree() {
        TreeSelectionListener tsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SecurityAdminPane.this.tree.getLastSelectedPathComponent();
                if (node == null || !(node.getUserObject() instanceof DataModelObjBaseWrapper)) {
                    SecurityAdminPane.this.clearPanels();
                    return;
                }
                if (!SecurityAdminPane.this.aboutToShutdown()) {
                    SecurityAdminPane.this.clearPanels();
                    return;
                }
                DataModelObjBaseWrapper dataWrp = (DataModelObjBaseWrapper)node.getUserObject();
                DataModelObjBaseWrapper secondObjWrp = null;
                DataModelObjBaseWrapper collectionWrp = null;
                FormDataObjIFace dataObj = dataWrp.getDataObj();
                if (dataObj instanceof SpecifyUser) {
                    SpecifyUser currentUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    SpecifyUser spUser = (SpecifyUser)dataObj;
                    if (!spUser.getIsLoggedIn().booleanValue() || currentUser.getId().equals(spUser.getId())) {
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                        secondObjWrp = (DataModelObjBaseWrapper)parent.getUserObject();
                        collectionWrp = (DataModelObjBaseWrapper)((DefaultMutableTreeNode)parent.getParent()).getUserObject();
                    } else {
                        UIRegistry.showLocalizedError("SecuirytAdminPane.USR_IS_ON", spUser.getName());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SecurityAdminPane.this.tree.clearSelection();
                            }
                        });
                        return;
                    }
                }
                SecurityAdminPane.this.nodesDiscipline = (Discipline)SecurityAdminPane.this.navTreeMgr.getParentOfClass(node, Discipline.class);
                SecurityAdminPane.this.nodesDivision = SecurityAdminPane.this.nodesDiscipline != null ? SecurityAdminPane.this.nodesDiscipline.getDivision() : null;
                SecurityAdminPane.this.showInfoPanel(dataWrp, secondObjWrp, collectionWrp, node.toString());
                SecurityAdminPane.this.updateUIEnabled(dataWrp);
            }
        };
        DefaultTreeModel model = this.createNavigationTreeModel();
        this.tree = new JTree(model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addTreeSelectionListener(tsl);
        int i = 0;
        while (i < this.tree.getRowCount()) {
            this.tree.expandRow(i);
            ++i;
        }
        i = this.tree.getRowCount() - 1;
        while (i >= 1) {
            if (this.tree.getPathForRow(i).getPathCount() > 3) {
                this.tree.collapseRow(i);
            }
            --i;
        }
        this.navTreeMgr = new NavigationTreeMgr(this.tree, this.spUsers);
        this.navTreeContextMgr = new NavigationTreeContextMenuMgr(this.navTreeMgr);
        IconManager.IconSize iconSize = IconManager.IconSize.Std20;
        ImageIcon sysIcon = IconManager.getIcon("SystemSetup", iconSize);
        JLabel label = UIHelper.createLabel("XXXX");
        label.setIcon(sysIcon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.tree.setRowHeight(label.getPreferredSize().height);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SecurityAdminPane.this.tree.expandRow(1);
            }
        });
    }

    private boolean formHasChanged() {
        if (this.currentDisplayPanel != null) {
            MultiView mv = this.currentDisplayPanel.getMultiView();
            return mv != null ? mv.hasChanged() : false;
        }
        return false;
    }

    private DefaultTreeModel createNavigationTreeModel() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(UIRegistry.getAppName());
        try {
            try {
                this.addInstitutionsRecursively(session, root);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SecurityAdminPane.class, ex);
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        FilteredTreeModel model = new FilteredTreeModel(root, null);
        return model;
    }

    private void addInstitutionsRecursively(DataProviderSessionIFace session, DefaultMutableTreeNode root) {
        this.spUsers = new HashSet<SpecifyUser>();
        List<Institution> institutions = session.getDataList(Institution.class);
        Collections.sort(institutions, new ComparatorByStringRepresentation());
        for (Institution institution : institutions) {
            DefaultMutableTreeNode instNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(institution));
            root.add(instNode);
            this.addDivisionsRecursively(session, instNode, institution);
            this.addGroup(session, instNode, institution);
        }
    }

    private void addDivisionsRecursively(DataProviderSessionIFace session, DefaultMutableTreeNode instNode, Institution institution) {
        TreeSet<Division> divisions = new TreeSet<Division>(institution.getDivisions());
        for (Division division : divisions) {
            for (Discipline discipline : division.getDisciplines()) {
                DataModelObjBaseWrapper dmob = new DataModelObjBaseWrapper(discipline);
                DefaultMutableTreeNode discNode = new DefaultMutableTreeNode(dmob);
                instNode.add(discNode);
                this.addCollectionsRecursively(session, discNode, discipline);
                this.addGroup(session, discNode, discipline);
            }
        }
    }

    private void addDisciplinesRecursively(DataProviderSessionIFace session, DefaultMutableTreeNode divNode, Division division) {
        TreeSet<Discipline> disciplines = new TreeSet<Discipline>(division.getDisciplines());
        for (Discipline discipline : disciplines) {
            log.debug((Object)("    Adding Discipline " + discipline.getName()));
            DefaultMutableTreeNode discNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(discipline));
            divNode.add(discNode);
            this.addCollectionsRecursively(session, discNode, discipline);
            this.addGroup(session, discNode, discipline);
        }
    }

    private void addCollectionsRecursively(DataProviderSessionIFace session, DefaultMutableTreeNode discNode, Discipline discipline) {
        TreeSet<Collection> collections = new TreeSet<Collection>(discipline.getCollections());
        for (Collection collection : collections) {
            log.debug((Object)("    Adding Collection " + collection.getCollectionName()));
            DefaultMutableTreeNode collNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(collection));
            discNode.add(collNode);
            this.addGroup(session, collNode, collection);
        }
    }

    private void addGroup(DataProviderSessionIFace session, DefaultMutableTreeNode node, UserGroupScope scope) {
        String subClass;
        String userPrin = UserPrincipal.class.getName();
        Vector<SpPrincipal> groups = new Vector<SpPrincipal>();
        for (SpPrincipal group : scope.getUserGroups()) {
            subClass = group.getGroupSubClass();
            if (group.getGroupType() == null && StringUtils.isNotEmpty((String)subClass) && subClass.equals(userPrin)) continue;
            groups.add(group);
        }
        Collections.sort(groups, new Comparator<SpPrincipal>(){

            @Override
            public int compare(SpPrincipal obj1, SpPrincipal obj2) {
                if (obj1 != null && obj1.getPriority() != null && obj2 != null && obj2.getPriority() != null) {
                    return obj2.getPriority().compareTo(obj1.getPriority());
                }
                return 100;
            }
        });
        for (SpPrincipal group : groups) {
            subClass = group.getGroupSubClass();
            if (group.getGroupType() == null && StringUtils.isNotEmpty((String)subClass) && subClass.equals(userPrin)) continue;
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(group));
            node.add(groupNode);
            TreeSet<SpecifyUser> users = new TreeSet<SpecifyUser>(group.getSpecifyUsers());
            for (SpecifyUser user : users) {
                this.spUsers.add(user);
                user.getSpPrincipals().size();
                DefaultMutableTreeNode userNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(user));
                groupNode.add(userNode);
            }
        }
    }

    private JPanel createFullTreeNavPanel() {
        this.createNavigationTree();
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("min(210px;p):g", "f:p:g"));
        CellConstraints cc = new CellConstraints();
        JScrollPane sp = UIHelper.createScrollPane(this.tree, true);
        sp.setPreferredSize(new Dimension(200, 50));
        mainPB.add((Component)sp, cc.xy(1, 1));
        return mainPB.getPanel();
    }

    private JPanel createInformationPanel() {
        this.infoCards = new JPanel();
        this.infoCards.setLayout(new CardLayout());
        this.createInitialInfoSubPanels();
        return this.infoCards;
    }

    private void clearPanels() {
        CardLayout cardLayout = (CardLayout)this.infoCards.getLayout();
        cardLayout.show(this.infoCards, Collection.class.getCanonicalName());
    }

    private void showInfoPanel(DataModelObjBaseWrapper objWrapperArg, DataModelObjBaseWrapper secondObjWrapperArg, DataModelObjBaseWrapper collectionWrapperArg, String selectedObjTitle) {
        FormDataObjIFace dataObj;
        DataModelObjBaseWrapper wrpr;
        String className = objWrapperArg.getType();
        CardLayout cardLayout = (CardLayout)this.infoCards.getLayout();
        DataModelObjBaseWrapper dataModelObjBaseWrapper = wrpr = secondObjWrapperArg != null ? secondObjWrapperArg : objWrapperArg;
        if (wrpr != null && (dataObj = wrpr.getDataObj()) instanceof SpPrincipal && ((SpPrincipal)dataObj).getGroupSubClass().equals(AdminPrincipal.class.getName())) {
            cardLayout.show(this.infoCards, AdminPrincipal.class.getCanonicalName());
            return;
        }
        if (this.currentEditorPanel != null && this.currentEditorPanel.hasChanged()) {
            Object[] optionLabels = new String[]{UIRegistry.getResourceString("SaveChangesBtn"), UIRegistry.getResourceString("DiscardChangesBtn"), UIRegistry.getResourceString("CANCEL")};
            int rv = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("SaveChanges", this.currentTitle), UIRegistry.getResourceString("SaveChangesTitle"), 1, 3, null, optionLabels, optionLabels[0]);
            if (rv == 0) {
                this.doSave(true);
            }
        }
        this.currentTitle = selectedObjTitle;
        AdminInfoSubPanelWrapper panelWrapper = this.infoSubPanels.get(className);
        this.currentEditorPanel = this.editorPanels.get(className);
        if (this.currentEditorPanel != null) {
            this.currentEditorPanel.setHasChanged(false);
        }
        if (panelWrapper != null) {
            this.currentDisplayPanel = panelWrapper;
            if (this.currentDisplayPanel.setData(objWrapperArg, secondObjWrapperArg, collectionWrapperArg, this.nodesDivision) && this.currentEditorPanel != null) {
                this.currentEditorPanel.setHasChanged(true);
            }
            cardLayout.show(this.infoCards, className);
        }
        this.objWrapper = objWrapperArg;
        this.secondObjWrapper = secondObjWrapperArg;
        this.collectionWrapper = collectionWrapperArg;
    }

    private void createInitialInfoSubPanels() {
        this.infoSubPanels = new Hashtable();
        JPanel blankPanel = new JPanel();
        this.createBlankInfoSubPanel(Institution.class, blankPanel);
        this.createBlankInfoSubPanel(Discipline.class, blankPanel);
        this.createBlankInfoSubPanel(Collection.class, blankPanel);
        JPanel allPermissions = new JPanel(new BorderLayout());
        JLabel lbl = UIHelper.createI18NLabel("SEC_ALL_PERMISSIONS", 0);
        lbl.setFont(lbl.getFont().deriveFont(18.0f));
        allPermissions.add((Component)lbl, "Center");
        this.createBlankInfoSubPanel(AdminPrincipal.class, allPermissions);
        this.createUserPanel();
        this.createGroupPanel();
    }

    private void createBlankInfoSubPanel(Class<?> clazz, JPanel panel) {
        AdminInfoSubPanelWrapper panelWrapper = new AdminInfoSubPanelWrapper(panel);
        this.infoCards.add((Component)panel, clazz.getCanonicalName());
        this.infoSubPanels.put(clazz.getCanonicalName(), panelWrapper);
    }

    private void createUserPanel() {
        EditorPanel infoPanel = new EditorPanel(this);
        CellConstraints cc = new CellConstraints();
        PermissionEditor prefsEdt = new PermissionEditor("SEC_PREFS", new PrefsPermissionEnumerator(), infoPanel, false, "SEC_NAME_TITLE", "SEC_ENABLE_PREF", null, null, null);
        JButton selectAllBtn = UIHelper.createI18NButton("SELECTALL");
        JButton deselectAllBtn = UIHelper.createI18NButton("DESELECTALL");
        PermissionPanelEditor generalEditor = new PermissionPanelEditor(selectAllBtn, deselectAllBtn);
        generalEditor.addPanel(new IndvPanelPermEditor("SEC_TOOLS", "SEC_TOOLS_DSC", new TaskPermissionEnumerator(), infoPanel));
        generalEditor.addPanel(new PermissionEditor("SEC_TABLES", new TablePermissionEnumerator(), infoPanel));
        generalEditor.addPanel(prefsEdt);
        PermissionPanelEditor objEditor = new PermissionPanelEditor(selectAllBtn, deselectAllBtn);
        objEditor.addPanel(new IndvPanelPermEditor("SEC_DOS", "SEC_DOS_DSC", new ObjectPermissionEnumerator(), infoPanel));
        ViewBasedDisplayPanel panel = SecurityAdminPane.createViewBasedDisplayPanelForUser(infoPanel);
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(UIRegistry.getResourceString("SEC_GENERAL"), generalEditor);
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("f:p:g", "t:p,4px,p,5px,f:p:g,2dlu,p"), (JPanel)infoPanel);
        int y = 1;
        mainPB.add((Component)panel, cc.xy(1, y));
        mainPB.addSeparator(UIRegistry.getResourceString("SEC_PERMS"), cc.xy(1, y += 2));
        mainPB.add((Component)tabbedPane, cc.xy(1, y += 2));
        y += 2;
        PanelBuilder saveBtnPB = new PanelBuilder(new FormLayout("f:p:g,p,2px,p,2px,p,2px,p", "p"));
        Viewable viewable = panel.getMultiView().getCurrentView();
        JButton valBtn = FormViewObj.createValidationIndicator(viewable.getUIComponent(), viewable.getValidator());
        panel.getMultiView().getCurrentValidator().setValidationBtn(valBtn);
        saveBtnPB.add((Component)selectAllBtn, cc.xy(2, 1));
        saveBtnPB.add((Component)deselectAllBtn, cc.xy(4, 1));
        saveBtnPB.add((Component)valBtn, cc.xy(6, 1));
        saveBtnPB.add((Component)infoPanel.getSaveBtn(), cc.xy(8, 1));
        mainPB.add((Component)saveBtnPB.getPanel(), cc.xy(1, y));
        y += 2;
        String className = SpecifyUser.class.getCanonicalName();
        this.infoCards.add((Component)infoPanel, className);
        AdminInfoSubPanelWrapper subPanel = new AdminInfoSubPanelWrapper(panel);
        subPanel.addPermissionEditor(generalEditor);
        subPanel.addPermissionEditor(objEditor);
        this.infoSubPanels.put(className, subPanel);
        this.editorPanels.put(className, infoPanel);
        selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PermissionPanelEditor)tabbedPane.getComponentAt(tabbedPane.getSelectedIndex())).selectAll();
            }
        });
        deselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PermissionPanelEditor)tabbedPane.getComponentAt(tabbedPane.getSelectedIndex())).deselectAll();
            }
        });
    }

    private void createGroupPanel() {
        EditorPanel infoPanel = new EditorPanel(this);
        CellConstraints cc = new CellConstraints();
        JButton selectAllBtn = UIHelper.createI18NButton("SELECTALL");
        JButton deselectAllBtn = UIHelper.createI18NButton("DESELECTALL");
        final PermissionPanelEditor generalEditor = new PermissionPanelEditor(selectAllBtn, deselectAllBtn);
        generalEditor.addPanel(new IndvPanelPermEditor("SEC_TOOLS", "SEC_TOOLS_DSC", new TaskPermissionEnumerator(), infoPanel));
        generalEditor.addPanel(new PermissionEditor("SEC_TABLES", new TablePermissionEnumerator(), infoPanel));
        generalEditor.addPanel(new PermissionEditor("SEC_PREFS", new PrefsPermissionEnumerator(), infoPanel));
        ViewBasedDisplayPanel panel = SecurityAdminPane.createViewBasedDisplayPanelForGroup(infoPanel);
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("f:p:g", "t:p,4px,p,5px,f:p:g,2dlu,p"), (JPanel)infoPanel);
        int y = 1;
        mainPB.add((Component)panel, cc.xy(1, y));
        mainPB.addSeparator(UIRegistry.getResourceString("SEC_PERMS"), cc.xy(1, y += 2));
        mainPB.add((Component)generalEditor, cc.xy(1, y += 2));
        y += 2;
        PanelBuilder saveBtnPB = new PanelBuilder(new FormLayout("f:p:g,p,2px,p,2px,p,2px,p", "p"));
        Viewable viewable = panel.getMultiView().getCurrentView();
        JButton valBtn = FormViewObj.createValidationIndicator(viewable.getUIComponent(), viewable.getValidator());
        panel.getMultiView().getCurrentValidator().setValidationBtn(valBtn);
        saveBtnPB.add((Component)selectAllBtn, cc.xy(2, 1));
        saveBtnPB.add((Component)deselectAllBtn, cc.xy(4, 1));
        saveBtnPB.add((Component)valBtn, cc.xy(6, 1));
        saveBtnPB.add((Component)infoPanel.getSaveBtn(), cc.xy(8, 1));
        mainPB.add((Component)saveBtnPB.getPanel(), cc.xy(1, y));
        y += 2;
        String className = SpPrincipal.class.getCanonicalName();
        this.infoCards.add((Component)infoPanel, className);
        AdminInfoSubPanelWrapper subPanel = new AdminInfoSubPanelWrapper(panel);
        subPanel.addPermissionEditor(generalEditor);
        this.infoSubPanels.put(className, subPanel);
        this.editorPanels.put(className, infoPanel);
        selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                generalEditor.selectAll();
            }
        });
        deselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                generalEditor.deselectAll();
            }
        });
    }

    protected void doSave(boolean refreshObj) {
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                this.currentDisplayPanel.savePermissionData(session);
                this.currentEditorPanel.setHasChanged(false);
                session.commit();
                if (refreshObj) {
                    this.refreshTreeNode();
                }
            }
            catch (Exception ex) {
                if (session != null) {
                    session.rollback();
                }
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SecurityAdminPane.class, ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected void refreshTreeNode() {
        if (this.currentDisplayPanel.setData(this.objWrapper, this.secondObjWrapper, this.collectionWrapper, this.nodesDivision) && this.currentEditorPanel != null) {
            this.currentEditorPanel.setHasChanged(true);
        }
    }

    protected static ViewBasedDisplayPanel createViewBasedDisplayPanelForUser(EditorPanel edtPanel) {
        ViewBasedDisplayPanel vbp = new ViewBasedDisplayPanel(null, "SystemSetup", "User", "User", SpecifyUser.class.getCanonicalName(), "specifyUserId", true, 8);
        vbp.getMultiView().getCurrentValidator().addDataChangeListener(edtPanel);
        edtPanel.setFormValidator(vbp.getMultiView().getCurrentValidator());
        return vbp;
    }

    protected static ViewBasedDisplayPanel createViewBasedDisplayPanelForGroup(EditorPanel edtPanel) {
        ViewBasedDisplayPanel vbp = new ViewBasedDisplayPanel(null, "SystemSetup", "UserGroup", "User Group", SpPrincipal.class.getCanonicalName(), "spUserGroupId", true, 8);
        vbp.getMultiView().getCurrentValidator().addDataChangeListener(edtPanel);
        edtPanel.setFormValidator(vbp.getMultiView().getCurrentValidator());
        return vbp;
    }

    private void updateUIEnabled(DataModelObjBaseWrapper objWrapperArg) {
    }

    @Override
    public boolean aboutToShutdown() {
        boolean result = true;
        if (this.formHasChanged()) {
            String msg = String.format(UIRegistry.getResourceString("SaveChanges"), this.getTitle());
            JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
            int rv = JOptionPane.showConfirmDialog(topFrame, msg, UIRegistry.getResourceString("SaveChangesTitle"), 1);
            if (rv == 0) {
                this.doSave(false);
            } else if (rv == 2 || rv == -1) {
                return false;
            }
        }
        return result;
    }

    private class Filter {
        private String patternStr;
        private Pattern p;
        private Matcher m;

        public Filter(String patternStr) {
            this.patternStr = "(?i).*" + patternStr + ".*";
            try {
                this.p = Pattern.compile(this.patternStr);
            }
            catch (PatternSyntaxException pse) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SecurityAdminPane.class, pse);
                this.p = null;
            }
        }

        public boolean accepts(String subject) {
            if (StringUtils.isEmpty((String)this.patternStr)) {
                return true;
            }
            if (this.p == null) {
                return false;
            }
            this.m = this.p.matcher(subject);
            return this.m.matches();
        }
    }

    private class FilteredTreeModel
    extends DefaultTreeModel {
        private Filter filter;

        public FilteredTreeModel(DefaultMutableTreeNode root, Filter filter) {
            super(root);
            this.filter = filter;
        }

        @Override
        public Object getChild(Object parent, int index) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            if (!(node.getUserObject() instanceof DataModelObjBaseWrapper)) {
                return node.getChildAt(index);
            }
            DataModelObjBaseWrapper parentWrapper = (DataModelObjBaseWrapper)node.getUserObject();
            if (this.filter == null || !parentWrapper.isGroup()) {
                return node.getChildAt(index);
            }
            int pos = 0;
            int i = 0;
            int cnt = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                DataModelObjBaseWrapper childWrapper = (DataModelObjBaseWrapper)child.getUserObject();
                if (this.filter.accepts(childWrapper.getName()) && cnt++ == index) {
                    pos = i;
                    break;
                }
                ++i;
            }
            return node.getChildAt(pos);
        }

        @Override
        public int getChildCount(Object parent) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            if (!(node.getUserObject() instanceof DataModelObjBaseWrapper)) {
                return node.getChildCount();
            }
            DataModelObjBaseWrapper parentWrapper = (DataModelObjBaseWrapper)node.getUserObject();
            if (this.filter == null || !parentWrapper.isGroup()) {
                return node.getChildCount();
            }
            int childCount = 0;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                DataModelObjBaseWrapper childWrapper = (DataModelObjBaseWrapper)child.getUserObject();
                if (!this.filter.accepts(childWrapper.getName())) continue;
                ++childCount;
            }
            return childCount;
        }

        public void setFilter(Filter filter) {
            if (this.filter == null && filter == null) {
                return;
            }
            if (this.filter != null && this.filter.equals(filter)) {
                return;
            }
            this.filter = filter;
            Object[] path = new Object[]{this.root};
            int[] childIndices = new int[this.root.getChildCount()];
            Object[] children = new Object[this.root.getChildCount()];
            int i = 0;
            while (i < this.root.getChildCount()) {
                childIndices[i] = i;
                children[i] = this.root.getChildAt(i);
                ++i;
            }
            this.fireTreeStructureChanged(this, path, childIndices, children);
            this.openUserNodesRecursive(this.root);
        }

        public void openUserNodesRecursive(TreeNode node) {
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            if (defNode.getUserObject() instanceof DataModelObjBaseWrapper) {
                DataModelObjBaseWrapper nodeWrapper = (DataModelObjBaseWrapper)defNode.getUserObject();
                if (this.filter != null && nodeWrapper.isUser()) {
                    SecurityAdminPane.this.tree.scrollPathToVisible(new TreePath(defNode.getPath()));
                    return;
                }
            }
            int i = 0;
            while (i < this.getChildCount(node)) {
                this.openUserNodesRecursive((TreeNode)this.getChild(node, i));
                ++i;
            }
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree rnTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean rnHasFocus) {
            super.getTreeCellRendererComponent(rnTree, value, sel, expanded, leaf, row, rnHasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DataModelObjBaseWrapper) {
                DataModelObjBaseWrapper wrp = (DataModelObjBaseWrapper)obj;
                String text = obj.toString();
                this.setText(text);
                this.setToolTipText(text);
                this.setIcon(wrp.getIcon());
            }
            return this;
        }
    }
}

