/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class PrefsPermissionEnumerator
extends PermissionEnumerator {
    protected List<SecurityOptionIFace> prefOptions = null;

    public PrefsPermissionEnumerator() {
        super("Prefs", "ADMININFO_DESC");
    }

    protected void loadPrefs() {
        block8: {
            this.prefOptions = new ArrayList<SecurityOptionIFace>();
            try {
                Element root = XMLHelper.readDOMFromConfigDir("prefs_init.xml");
                if (root == null) break block8;
                Hashtable<String, Hashtable<String, PermissionOptionPersist>> mainHash = BaseTask.readDefaultPermsFromXML("prefsperms.xml");
                Node prefsNode = root.selectSingleNode("/prefs");
                String i18NResourceName = XMLHelper.getAttr((Element)prefsNode, "i18nresname", null);
                ResourceBundle resBundle = null;
                if (StringUtils.isNotEmpty((String)i18NResourceName)) {
                    resBundle = UIRegistry.getResourceBundle(i18NResourceName);
                }
                List sections = root.selectNodes("/prefs/section/pref");
                for (Element pref : sections) {
                    Hashtable<String, PermissionOptionPersist> hash;
                    String name = XMLHelper.getAttr(pref, "name", null);
                    String title = XMLHelper.getAttr(pref, "title", null);
                    String iconName = XMLHelper.getAttr(pref, "icon", null);
                    if (!StringUtils.isNotEmpty((String)name)) continue;
                    if (resBundle != null) {
                        try {
                            title = resBundle.getString(title);
                        }
                        catch (MissingResourceException ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(PrefsPermissionEnumerator.class, ex);
                        }
                    }
                    SecurityOption securityOption = new SecurityOption(name, title, "Prefs", iconName);
                    this.prefOptions.add(securityOption);
                    if (mainHash == null || (hash = mainHash.get(name)) == null) continue;
                    for (PermissionOptionPersist pp : hash.values()) {
                        PermissionIFace defPerm = pp.getDefaultPerms();
                        securityOption.addDefaultPerm(pp.getUserType(), defPerm);
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PrefsPermissionEnumerator.class, ex);
                ex.printStackTrace();
            }
        }
    }

    protected void createDefaultPrefPerms() {
        this.prefOptions = new ArrayList<SecurityOptionIFace>();
        try {
            XStream xstream = new XStream();
            PermissionOptionPersist.config(xstream);
            Hashtable hash = new Hashtable();
            Element root = XMLHelper.readDOMFromConfigDir("prefs_init.xml");
            if (root != null) {
                List sections = root.selectNodes("/prefs/section/pref");
                for (Element pref : sections) {
                    String name = XMLHelper.getAttr(pref, "name", null);
                    if (!StringUtils.isNotEmpty((String)name)) continue;
                    Hashtable<String, PermissionOptionPersist> hashItem = new Hashtable<String, PermissionOptionPersist>();
                    hash.put(name, hashItem);
                    List defPerms = pref.selectNodes("defperm");
                    if (defPerms == null || defPerms.isEmpty()) continue;
                    for (Element defPref : defPerms) {
                        String[] p;
                        String defPermName = XMLHelper.getAttr(defPref, "name", null);
                        String perms = XMLHelper.getAttr(defPref, "perm", null);
                        if (!StringUtils.isNotEmpty((String)defPermName) || !StringUtils.isNotEmpty((String)perms) || (p = StringUtils.split((String)perms, (char)',')).length != 4) continue;
                        boolean[] b = new boolean[4];
                        int i = 0;
                        while (i < b.length) {
                            b[i] = Boolean.parseBoolean(p[i]);
                            ++i;
                        }
                        PermissionOptionPersist securityOption = new PermissionOptionPersist(name, defPermName, b[0], b[1], b[2], b[3]);
                        hashItem.put(defPermName, securityOption);
                    }
                }
            }
            FileUtils.writeStringToFile((File)new File("prefsperms.xml"), (String)xstream.toXML(hash));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected List<SecurityOptionIFace> getSecurityOptions() {
        if (this.prefOptions == null) {
            this.loadPrefs();
        }
        return this.prefOptions;
    }
}

