/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionPanelContainerIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class PermissionPanelEditor
extends JPanel {
    protected JPanel cardPanel = new JPanel();
    protected CardLayout cardLayout = new CardLayout();
    protected JComboBox switcherCBX;
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected Vector<PermissionPanelContainerIFace> panels = new Vector();

    public PermissionPanelEditor(final JButton selectAllBtn, final JButton deselectAllBtn) {
        this.selectAllBtn = selectAllBtn;
        this.deselectAllBtn = deselectAllBtn;
        this.cardPanel = new JPanel(this.cardLayout);
        this.switcherCBX = new JComboBox(new DefaultComboBoxModel());
        this.cardPanel.setPreferredSize(new Dimension(200, 50));
        CellConstraints cc = new CellConstraints();
        PanelBuilder topPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        topPB.add((Component)this.switcherCBX, cc.xy(2, 1));
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,10px,f:p:g"), (JPanel)this);
        pb.add((Component)topPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)this.cardPanel, cc.xy(1, 3));
        this.switcherCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionPanelEditor.this.cardLayout.show(PermissionPanelEditor.this.cardPanel, PermissionPanelEditor.this.switcherCBX.getSelectedItem().toString());
                boolean supportsSelectAll = PermissionPanelEditor.this.doesSupportSelectAll();
                if (selectAllBtn != null) {
                    selectAllBtn.setEnabled(supportsSelectAll);
                    deselectAllBtn.setEnabled(supportsSelectAll);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            boolean supportsSelectAll = this.doesSupportSelectAll();
            if (this.selectAllBtn != null) {
                this.selectAllBtn.setEnabled(supportsSelectAll);
                this.deselectAllBtn.setEnabled(supportsSelectAll);
            }
        }
    }

    public void addPanel(PermissionPanelContainerIFace panel) {
        this.cardPanel.add(panel.getPanelName(), panel.getUIComponent());
        this.panels.add(panel);
        ((DefaultComboBoxModel)this.switcherCBX.getModel()).addElement(panel.getPanelName());
    }

    public void savePermissions(DataProviderSessionIFace session) throws Exception {
        for (PermissionPanelContainerIFace panel : this.panels) {
            panel.savePermissions(session);
        }
    }

    public boolean doesSupportSelectAll() {
        int inx = this.switcherCBX.getSelectedIndex();
        if (inx > -1) {
            return this.panels.get(inx).doesSupportSelectAll();
        }
        return false;
    }

    public void selectAll() {
        int inx = this.switcherCBX.getSelectedIndex();
        if (inx > -1) {
            this.panels.get(inx).selectAll();
        }
    }

    public void deselectAll() {
        int inx = this.switcherCBX.getSelectedIndex();
        if (inx > -1) {
            this.panels.get(inx).deselectAll();
        }
    }

    public void updateData(SpPrincipal principal, SpPrincipal overrulingPrincipal, Hashtable<String, SpPermission> existingPerms, Hashtable<String, SpPermission> overrulingPerms, String userType) {
        for (PermissionPanelContainerIFace panel : this.panels) {
            panel.updateData(principal, overrulingPrincipal, existingPerms, overrulingPerms, userType);
        }
    }

    public Vector<PermissionPanelContainerIFace> getPanels() {
        return this.panels;
    }
}

