/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.auth.specify.principal.UserPrincipalSQLService;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionEditorRow;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import edu.ku.brc.ui.UIRegistry;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;

public abstract class PermissionEnumerator {
    private String permBaseName = null;
    private String descKey = null;

    public PermissionEnumerator(String permBaseName, String descKey) {
        this.permBaseName = permBaseName;
        this.descKey = descKey;
    }

    protected void checkAndAddPermission(List<PermissionEditorRowIFace> perms, SecurityOptionIFace securityOption, ImageIcon icon, SpPrincipal principal, Hashtable<String, SpPermission> existingPerms, Hashtable<String, SpPermission> overrulingPerms, String userType, boolean admin) {
        SpPermission oPerm;
        String secName = String.valueOf(this.permBaseName) + "." + securityOption.getPermissionName();
        SpPermission perm = existingPerms.get(secName);
        SpPermission spPermission = oPerm = overrulingPerms != null ? overrulingPerms.get(secName) : null;
        if (perm == null) {
            perm = new SpPermission();
            perm.initialize();
            perm.setName(secName);
            perm.setActions("");
            perm.setPermissionClass(BasicSpPermission.class.getCanonicalName());
        }
        String desc = UIRegistry.getLocalizedMessage(this.descKey, securityOption.getShortDesc());
        PermissionEditorIFace editPanel = securityOption.getPermEditorPanel();
        perms.add(new GeneralPermissionEditorRow(perm, oPerm, this.permBaseName, securityOption.getPermissionTitle(), desc, icon, editPanel, admin));
    }

    public List<PermissionEditorRowIFace> getPermissions(SpPrincipal principal, Hashtable<String, SpPermission> existingPerms, Hashtable<String, SpPermission> overrulingPerms, String userType) {
        List<SecurityOptionIFace> list = this.getSecurityOptions();
        if (list == null) {
            return null;
        }
        boolean admin = UserPrincipalSQLService.isPrincipalAdmin(principal.getId());
        ArrayList<PermissionEditorRowIFace> perms = new ArrayList<PermissionEditorRowIFace>(list.size());
        for (SecurityOptionIFace securityOption : list) {
            ImageIcon taskIcon = securityOption.getIcon(20);
            this.checkAndAddPermission(perms, securityOption, taskIcon, principal, existingPerms, overrulingPerms, userType, admin);
            List<SecurityOptionIFace> additionalOptions = securityOption.getAdditionalSecurityOptions();
            if (additionalOptions == null) continue;
            for (SecurityOptionIFace sOpt : additionalOptions) {
                ImageIcon icon = sOpt.getIcon(20);
                if (icon == null) {
                    icon = taskIcon;
                }
                this.checkAndAddPermission(perms, sOpt, icon, principal, existingPerms, overrulingPerms, userType, admin);
            }
        }
        return perms;
    }

    protected abstract List<SecurityOptionIFace> getSecurityOptions();
}

