/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.PermissionPanelContainerIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCellEditor;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCellRenderer;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCellValueWrapper;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.YesNoCellRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class PermissionEditor
extends JPanel
implements PermissionPanelContainerIFace {
    private static final Logger log = Logger.getLogger(PermissionEditor.class);
    protected String panelName;
    protected JTable table;
    protected PermissionEnumerator enumerator;
    protected SpPrincipal principal;
    protected ChangeListener listener;
    protected boolean readOnly;
    protected DefaultTableModel model;
    protected ImageIcon icon;
    protected String nameColTitle;
    protected String viewColTitle;
    protected String addColTitle;
    protected String modColTitle;
    protected String delColTitle;
    protected Vector<PermissionEditorRowIFace> rowDataList = new Vector();

    public PermissionEditor(String panelNameKey, PermissionEnumerator enumerator, ChangeListener listener) {
        this(panelNameKey, enumerator, listener, false, "SEC_NAME_TITLE", "SEC_VIEW_TITLE", "SEC_ADD_TITLE", "SEC_MOD_TITLE", "SEC_DEL_TITLE");
    }

    public PermissionEditor(String panelNameKey, PermissionEnumerator enumerator, ChangeListener listener, boolean readOnly) {
        this(panelNameKey, enumerator, listener, readOnly, "SEC_NAME_TITLE", "SEC_VIEW_TITLE", "SEC_ADD_TITLE", "SEC_MOD_TITLE", "SEC_DEL_TITLE");
    }

    public PermissionEditor(String panelNameKey, PermissionEnumerator enumerator, ChangeListener listener, boolean readOnly, String nameKey, String viewKey, String addKey, String modKey, String delKey) {
        super(new BorderLayout());
        this.nameColTitle = UIRegistry.getResourceString(nameKey);
        this.viewColTitle = viewKey != null ? UIRegistry.getResourceString(viewKey) : null;
        this.addColTitle = addKey != null ? UIRegistry.getResourceString(addKey) : null;
        this.modColTitle = modKey != null ? UIRegistry.getResourceString(modKey) : null;
        this.delColTitle = delKey != null ? UIRegistry.getResourceString(delKey) : null;
        this.panelName = UIRegistry.getResourceString(panelNameKey);
        this.table = new JTable(new DefaultTableModel());
        this.enumerator = enumerator;
        this.principal = null;
        this.listener = listener;
        this.readOnly = readOnly;
        UIHelper.makeTableHeadersCentered(this.table, false);
        JScrollPane sp = new JScrollPane(this.table, 20, 30);
        this.add((Component)sp, "Center");
    }

    private int getColumnsForSelection() {
        String[] captions = new String[]{this.viewColTitle, this.addColTitle, this.modColTitle, this.delColTitle};
        int[] opts = new int[]{1, 8, 2, 4};
        ArrayList<String> list = new ArrayList<String>(captions.length);
        String[] stringArray = captions;
        int n = captions.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            if (title != null) {
                list.add(title);
            }
            ++n2;
        }
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("SEC_SEL_TITLE"), UIRegistry.getResourceString("SEC_SEL_DESC"), list);
        dlg.setVisible(true);
        int options = 0;
        for (String str : dlg.getSelectedObjects()) {
            int inx = list.indexOf(str);
            options |= opts[inx];
        }
        return options;
    }

    @Override
    public boolean doesSupportSelectAll() {
        return true;
    }

    @Override
    public void deselectAll() {
        this.setSelection(false);
    }

    @Override
    public void selectAll() {
        this.setSelection(true);
    }

    private void setSelection(boolean value) {
        int options = this.getColumnsForSelection();
        int numRows = this.model.getRowCount();
        int viewCol = this.viewColTitle != null ? this.table.getColumn(this.viewColTitle).getModelIndex() : -1;
        int addCol = this.addColTitle != null ? this.table.getColumn(this.addColTitle).getModelIndex() : -1;
        int modCol = this.modColTitle != null ? this.table.getColumn(this.modColTitle).getModelIndex() : -1;
        int delCol = this.delColTitle != null ? this.table.getColumn(this.delColTitle).getModelIndex() : -1;
        int row = 0;
        while (row < numRows) {
            if (PermissionSettings.isOn(options, 1)) {
                this.setValueAt(row, viewCol, value);
            }
            if (PermissionSettings.isOn(options, 2)) {
                this.setValueAt(row, modCol, value);
            }
            if (PermissionSettings.isOn(options, 4)) {
                this.setValueAt(row, delCol, value);
            }
            if (PermissionSettings.isOn(options, 8)) {
                this.setValueAt(row, addCol, value);
            }
            ++row;
        }
        ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
    }

    private void setCellRenderer() {
        GeneralPermissionTableCellEditor editor;
        DefaultTableCellRenderer renderer;
        if (this.readOnly) {
            renderer = new YesNoCellRenderer();
            editor = null;
        } else {
            renderer = new GeneralPermissionTableCellRenderer();
            editor = new GeneralPermissionTableCellEditor();
        }
        TableColumnModel tblModel = this.table.getColumnModel();
        int i = 2;
        while (i < tblModel.getColumnCount()) {
            tblModel.getColumn(i).setCellRenderer(renderer);
            tblModel.getColumn(i).setCellEditor(editor);
            ++i;
        }
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    public PermissionEnumerator getPermissionEnumerator() {
        return this.enumerator;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateData(SpPrincipal principalArg, SpPrincipal overrulingPrincipalArg, Hashtable<String, SpPermission> existingPerms, Hashtable<String, SpPermission> overrulingPerms, String userType) {
        this.principal = principalArg;
        this.model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ImageIcon.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return GeneralPermissionTableCellValueWrapper.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return !PermissionEditor.this.readOnly && column >= 2;
            }
        };
        this.addColumnHeaders(this.model);
        iconSize = IconManager.IconSize.Std20;
        this.icon = IconManager.getIcon("SystemSetup", iconSize);
        label = UIHelper.createLabel("XXXX");
        label.setIcon(this.icon);
        this.rowDataList.clear();
        perms = this.enumerator.getPermissions(principalArg, existingPerms, overrulingPerms, userType);
        Collections.sort(perms, new ComparatorByStringRepresentation<T>(true));
        for (PermissionEditorRowIFace permWrapper : perms) {
            this.rowDataList.add(permWrapper);
        }
        if (this.model != null) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            this.model.removeRow(0);
lbl18:
            // 2 sources

            ** while (this.model.getRowCount() > 0)
        }
lbl19:
        // 2 sources

        for (PermissionEditorRowIFace permWrapper : this.rowDataList) {
            permWrapper.addTableRow(this.model, this.icon);
        }
        this.table.setModel(this.model);
        this.table.setRowHeight(label.getPreferredSize().height + 5);
        this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredScrollableViewportSize().width, 50));
        column = this.table.getColumnModel().getColumn(0);
        cellWidth = iconSize.size() + 4;
        column.setMinWidth(cellWidth);
        column.setMaxWidth(cellWidth);
        column.setPreferredWidth(cellWidth);
        column = this.table.getColumnModel().getColumn(1);
        column.setMinWidth(100);
        column.setMaxWidth(400);
        column.setPreferredWidth(200);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (PermissionEditor.this.listener != null) {
                    PermissionEditor.this.listener.stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.setCellRenderer();
    }

    protected void addColumnHeaders(DefaultTableModel modelArg) {
        modelArg.addColumn("");
        modelArg.addColumn(this.nameColTitle);
        if (this.viewColTitle != null) {
            modelArg.addColumn(this.viewColTitle);
        }
        if (this.addColTitle != null) {
            modelArg.addColumn(this.addColTitle);
        }
        if (this.modColTitle != null) {
            modelArg.addColumn(this.modColTitle);
        }
        if (this.delColTitle != null) {
            modelArg.addColumn(this.delColTitle);
        }
    }

    @Override
    public void savePermissions(DataProviderSessionIFace session) throws Exception {
        if (this.principal == null) {
            return;
        }
        int numRows = this.model.getRowCount();
        int taskCol = this.nameColTitle != null ? this.table.getColumn(this.nameColTitle).getModelIndex() : -1;
        int viewCol = this.viewColTitle != null ? this.table.getColumn(this.viewColTitle).getModelIndex() : -1;
        int addCol = this.addColTitle != null ? this.table.getColumn(this.addColTitle).getModelIndex() : -1;
        int modCol = this.modColTitle != null ? this.table.getColumn(this.modColTitle).getModelIndex() : -1;
        int delCol = this.delColTitle != null ? this.table.getColumn(this.delColTitle).getModelIndex() : -1;
        int row = 0;
        while (row < numRows) {
            PermissionEditorRowIFace wrapper = (PermissionEditorRowIFace)this.model.getValueAt(row, taskCol);
            SpPermission perm = wrapper.getPermissionList().get(0);
            Boolean canView = this.getValueAt(row, viewCol);
            Boolean canAdd = this.getValueAt(row, addCol);
            Boolean canMod = this.getValueAt(row, modCol);
            Boolean canDel = this.getValueAt(row, delCol);
            if (!(canView.booleanValue() || canAdd.booleanValue() || canMod.booleanValue() || canDel.booleanValue())) {
                if (perm.getId() != null) {
                    log.debug((Object)("Clearing: " + perm.getName() + " [" + perm.getActions() + "]"));
                    perm.setActions("");
                    session.saveOrUpdate(session.merge(perm));
                    perm.setHasChanged(false);
                }
            } else if (perm.hasChanged()) {
                log.debug((Object)("Saving: " + perm.getName() + " [" + perm.getActions() + "] " + this.principal.getName() + ", " + this.principal.getGroupType() + ", " + this.principal.getGroupSubClass() + ", " + this.principal.getPriority()));
                perm.setActions(canView, canAdd, canMod, canDel);
                if (perm.getId() == null) {
                    perm.getPrincipals().add(this.principal);
                }
                session.saveOrUpdate(session.merge(perm));
                perm.setHasChanged(false);
            }
            ++row;
        }
    }

    private boolean getValueAt(int row, int column) {
        if (column <= -1) {
            return false;
        }
        GeneralPermissionTableCellValueWrapper wrapper = (GeneralPermissionTableCellValueWrapper)this.model.getValueAt(row, column);
        return wrapper.getPermissionActionValue();
    }

    private void setValueAt(int row, int column, boolean value) {
        if (column > -1) {
            GeneralPermissionTableCellValueWrapper wrapper = (GeneralPermissionTableCellValueWrapper)this.model.getValueAt(row, column);
            wrapper.setPermissionActionValue(value);
        }
    }
}

