/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.auth.specify.principal.UserPrincipalSQLService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.tasks.subpane.security.ObjectPermissionEditorRow;
import edu.ku.brc.specify.tasks.subpane.security.ObjectPermissionPanel;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import edu.ku.brc.ui.UIRegistry;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ObjectPermissionEnumerator
extends PermissionEnumerator {
    protected static final String prefPrefix = "DO";

    public ObjectPermissionEnumerator() {
        super(prefPrefix, "");
    }

    @Override
    public List<PermissionEditorRowIFace> getPermissions(SpPrincipal principal, Hashtable<String, SpPermission> existingPerms, Hashtable<String, SpPermission> overrulingPerms, String userType) {
        int userId = UserPrincipalSQLService.getSpecifyUserId(principal);
        ArrayList<PermissionEditorRowIFace> perms = new ArrayList<PermissionEditorRowIFace>();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                Class[] classes;
                SpecifyUser user = new SpecifyUser(userId);
                session.attach(user);
                ObjectPermissionPanel panel = new ObjectPermissionPanel();
                Class[] classArray = classes = new Class[]{Workbench.class, RecordSet.class, SpQuery.class, SpReport.class};
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class cls = classArray[n2];
                    DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(cls.getName());
                    this.addPermissions(cls, session, user, existingPerms, perms, prefPrefix, tblInfo, panel);
                    ++n2;
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ObjectPermissionEnumerator.class, e);
                e.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return perms;
    }

    private SpPermission createPermission(String taskName, String subType, Integer targetId, Hashtable<String, SpPermission> existingPerms) {
        SpPermission perm = existingPerms.get(String.valueOf(taskName) + "." + subType);
        if (perm == null) {
            perm = new SpPermission();
            perm.initialize();
            perm.setName(String.valueOf(taskName) + "." + subType);
            perm.setActions("");
            perm.setTargetId(targetId);
            perm.setPermissionClass(BasicSpPermission.class.getCanonicalName());
        }
        return perm;
    }

    private void addCustomPermissions(ObjectPermissionEditorRow wrapper, String taskName, Integer targetId, Hashtable<String, SpPermission> existingPerms) {
    }

    private <T> void addPermissions(Class<T> clazz, DataProviderSessionIFace session, SpecifyUser user, Hashtable<String, SpPermission> existingPerms, List<PermissionEditorRowIFace> perms, String objBaseType, DBTableInfo tblInfo, PermissionEditorIFace editorPanel) {
        String desc = UIRegistry.getLocalizedMessage("ADMININFO_DESC", tblInfo.getTitle());
        String sql = String.format("SELECT DISTINCT %s, Name FROM %s WHERE SpecifyUserID = %d", tblInfo.getIdColumnName(), tblInfo.getName(), user.getId());
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = DBConnection.getInstance().getConnection().createStatement();
                if (stmt != null) {
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        int targetId = rs.getInt(1);
                        String name = rs.getString(2);
                        String taskName = "Object." + tblInfo.getTitle() + "." + targetId;
                        SpPermission owner = this.createPermission(taskName, "Owner", targetId, existingPerms);
                        SpPermission group = this.createPermission(taskName, "Group", targetId, existingPerms);
                        SpPermission other = this.createPermission(taskName, "Other", targetId, existingPerms);
                        String title = String.valueOf(tblInfo.getTitle()) + ": " + name;
                        String description = String.valueOf(desc) + name;
                        ObjectPermissionEditorRow wrapper = new ObjectPermissionEditorRow(owner, group, other, objBaseType, title, description, null, editorPanel);
                        this.addCustomPermissions(wrapper, taskName, targetId, existingPerms);
                        perms.add(wrapper);
                    }
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ObjectPermissionEnumerator.class, ex);
                ex.printStackTrace();
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    protected List<SecurityOptionIFace> getSecurityOptions() {
        return null;
    }
}

