/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;

public class ObjectPermissionEditorRow
implements PermissionEditorRowIFace {
    private String type;
    private String title;
    private String description;
    private SpPermission ownerPermission;
    private SpPermission groupPermission;
    private SpPermission otherPermission;
    private List<SpPermission> customPermissions;
    private ImageIcon icon;
    protected PermissionEditorIFace editorPanel;
    protected boolean adminPrincipal;

    public ObjectPermissionEditorRow(SpPermission ownerPermission, SpPermission groupPermission, SpPermission otherPermission, String type, String title, String description, ImageIcon icon, PermissionEditorIFace editorPanel) {
        this.ownerPermission = ownerPermission;
        this.groupPermission = groupPermission;
        this.otherPermission = otherPermission;
        this.customPermissions = null;
        this.type = type;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.editorPanel = editorPanel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PermissionEditorIFace getEditorPanel() {
        return this.editorPanel;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private PermissionIFace createPermissionSettings(SpPermission permission) {
        int options = 0;
        options |= permission.canModify() ? 2 : 0;
        options |= permission.canView() ? 1 : 0;
        options |= permission.canAdd() ? 8 : 0;
        return new PermissionSettings(options |= permission.canDelete() ? 4 : 0);
    }

    @Override
    public List<PermissionIFace> getPermissions() {
        ArrayList<PermissionIFace> list = new ArrayList<PermissionIFace>(1);
        list.add(this.createPermissionSettings(this.ownerPermission));
        list.add(this.createPermissionSettings(this.groupPermission));
        list.add(this.createPermissionSettings(this.otherPermission));
        return list;
    }

    private void setPermSettings(PermissionIFace permSettings, SpPermission permission) {
        permission.setActions(permSettings.canView(), permSettings.canAdd(), permSettings.canModify(), permSettings.canDelete());
    }

    @Override
    public void setPermissions(List<PermissionIFace> permSettings) {
        this.setPermSettings(permSettings.get(0), this.ownerPermission);
        this.setPermSettings(permSettings.get(1), this.groupPermission);
        this.setPermSettings(permSettings.get(2), this.otherPermission);
    }

    @Override
    public List<SpPermission> getPermissionList() {
        ArrayList<SpPermission> list = new ArrayList<SpPermission>();
        list.add(this.ownerPermission);
        list.add(this.groupPermission);
        list.add(this.otherPermission);
        return list;
    }

    public SpPermission getOwnerPermission() {
        return this.ownerPermission;
    }

    public void setOwnerPermission(SpPermission ownerPermission) {
        this.ownerPermission = ownerPermission;
    }

    public SpPermission getGroupPermission() {
        return this.groupPermission;
    }

    public void setGroupPermission(SpPermission groupPermission) {
        this.groupPermission = groupPermission;
    }

    public SpPermission getOtherPermission() {
        return this.otherPermission;
    }

    public void setOtherPermission(SpPermission otherPermission) {
        this.otherPermission = otherPermission;
    }

    public List<SpPermission> getCustomPermissions() {
        return this.customPermissions;
    }

    public void addCustomPermission(SpPermission permission) {
        this.customPermissions.add(permission);
    }

    public void removeCustomPermission(SpPermission permission) {
        this.customPermissions.remove(permission);
    }

    public void clearCustomPermission() {
        this.customPermissions.clear();
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public void addTableRow(DefaultTableModel model, ImageIcon defaultIcon) {
        model.addRow(new Object[]{this.icon != null ? this.icon : defaultIcon, this, new Boolean(this.ownerPermission.canView()), new Boolean(this.ownerPermission.canAdd()), new Boolean(this.ownerPermission.canModify()), new Boolean(this.ownerPermission.canDelete()), new Boolean(this.groupPermission.canView()), new Boolean(this.groupPermission.canAdd()), new Boolean(this.groupPermission.canModify()), new Boolean(this.groupPermission.canDelete()), new Boolean(this.otherPermission.canView()), new Boolean(this.otherPermission.canAdd()), new Boolean(this.otherPermission.canModify()), new Boolean(this.otherPermission.canDelete())});
    }

    @Override
    public String getOverrideText(int option) {
        return null;
    }

    public void savePermissions(DataProviderSessionIFace session, DefaultTableModel model, SpPrincipal principal, int row) throws Exception {
        Boolean[] values = new Boolean[12];
        int col = 0;
        while (col < 12) {
            values[col] = (Boolean)model.getValueAt(row, col + 2);
            ++col;
        }
        this.savePermission(session, this.ownerPermission, values, principal, 0);
        this.savePermission(session, this.groupPermission, values, principal, 4);
        this.savePermission(session, this.otherPermission, values, principal, 8);
    }

    private void savePermission(DataProviderSessionIFace session, SpPermission perm, Boolean[] values, SpPrincipal principal, int col) throws Exception {
        Boolean canView = values[col + 0];
        Boolean canAdd = values[col + 1];
        Boolean canMod = values[col + 2];
        Boolean canDel = values[col + 3];
        if (!(canView.booleanValue() || canAdd.booleanValue() || canMod.booleanValue() || canDel.booleanValue())) {
            if (perm.getId() != null) {
                Set<SpPermission> perms = principal.getPermissions();
                for (SpPermission currPerm : perms) {
                    if (!currPerm.getId().equals(perm.getId())) continue;
                    session.evict(perm);
                    perms.remove(currPerm);
                    session.delete(currPerm);
                    break;
                }
            }
        } else if (!perm.hasSameFlags(canView, canAdd, canMod, canDel)) {
            perm.setActions(canView, canAdd, canMod, canDel);
            if (perm.getId() == null) {
                principal.getPermissions().add(perm);
                perm.getPrincipals().add(principal);
            }
        }
    }

    @Override
    public void updatePerm(SpPermission oldPerm, SpPermission newPerm) {
        if (oldPerm == this.ownerPermission) {
            this.ownerPermission = newPerm;
        } else if (oldPerm == this.groupPermission) {
            this.groupPermission = newPerm;
        } else if (oldPerm == this.otherPermission) {
            this.otherPermission = newPerm;
        }
    }

    @Override
    public int compareTo(PermissionEditorRowIFace o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    @Override
    public boolean isAdminPrincipal() {
        return this.adminPrincipal;
    }

    @Override
    public void setAdminPrincipal(boolean adminPrincipal) {
        this.adminPrincipal = adminPrincipal;
    }
}

