/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.config.Scriptlet;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import edu.ku.brc.specify.datamodel.busrules.SpecifyUserBusRules;
import edu.ku.brc.specify.tasks.subpane.security.AddExistingUserDlg;
import edu.ku.brc.specify.tasks.subpane.security.DataModelObjBaseWrapper;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NavigationTreeMgr {
    private static final Logger log = Logger.getLogger(NavigationTreeMgr.class);
    private JTree tree;
    private Set<SpecifyUser> spUsers;

    public NavigationTreeMgr(JTree tree, Set<SpecifyUser> spUsers) {
        this.tree = tree;
        this.spUsers = spUsers;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public boolean canRemoveUserFromGroup(DefaultMutableTreeNode userNode) {
        DataProviderSessionIFace session = null;
        boolean result = false;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)userNode.getUserObject();
                FormDataObjIFace object = wrapper.getDataObj();
                SpecifyUser user = (SpecifyUser)object;
                result = user.canRemoveFromGroup();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public boolean canAddToAdmin(DefaultMutableTreeNode userNode) {
        if (userNode != null) {
            SpecifyUser spu = null;
            Object userObject = userNode.getUserObject();
            FormDataObjIFace dmObject = ((DataModelObjBaseWrapper)userObject).getDataObj();
            if (dmObject instanceof SpecifyUser) {
                SpPrincipal principal;
                DataModelObjBaseWrapper pWrapper;
                spu = (SpecifyUser)dmObject;
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)userNode.getParent();
                if (parentTreeNode != null && (pWrapper = (DataModelObjBaseWrapper)(parentTreeNode.getUserObject() instanceof DataModelObjBaseWrapper ? parentTreeNode.getUserObject() : null)) != null && (principal = (SpPrincipal)(pWrapper.getDataObj() instanceof SpPrincipal ? pWrapper.getDataObj() : null)) != null) {
                    return principal.getGroupType().equals("Manager") && !spu.isInAdminGroup();
                }
            }
        }
        return false;
    }

    public void removeUserFromGroup(DefaultMutableTreeNode userNode) {
        DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)userNode.getUserObject();
        FormDataObjIFace object = wrapper.getDataObj();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)userNode.getParent();
        DataModelObjBaseWrapper parentWrapper = (DataModelObjBaseWrapper)parent.getUserObject();
        FormDataObjIFace parentObject = parentWrapper.getDataObj();
        if (!(object instanceof SpecifyUser && parentObject instanceof SpPrincipal && this.canRemoveUserFromGroup(userNode))) {
            return;
        }
        SpecifyUser user = (SpecifyUser)object;
        SpPrincipal group = (SpPrincipal)parentObject;
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                user = session.get(SpecifyUser.class, user.getId());
                ArrayList<UserGroupScope> dspDivList = new ArrayList<UserGroupScope>();
                for (SpPrincipal p : new Vector<SpPrincipal>(user.getSpPrincipals())) {
                    session.attach(p);
                    if (!p.getId().equals(group.getId())) continue;
                    UserGroupScope ugs = p.getScope();
                    if (ugs.getDataClass() == Discipline.class || ugs.getDataClass() == Division.class || ugs.getDataClass() == Collection.class) {
                        dspDivList.add(ugs);
                    }
                    user.getSpPrincipals().remove(p);
                }
                session.saveOrUpdate(user);
                session.commit();
                this.replaceUserInOtherNodes(user, (DefaultMutableTreeNode)this.tree.getModel().getRoot());
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                model.removeNodeFromParent(userNode);
                this.tree.clearSelection();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void replaceUserInOtherNodes(SpecifyUser updatedUser, DefaultMutableTreeNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)child.getUserObject();
            FormDataObjIFace dmObj = wrapper.getDataObj();
            if (dmObj instanceof SpecifyUser) {
                SpecifyUser spu = (SpecifyUser)dmObj;
                if (updatedUser.getId().equals(spu.getId())) {
                    wrapper.setDataObj(updatedUser);
                }
            }
            this.replaceUserInOtherNodes(updatedUser, child);
            ++i;
        }
    }

    public boolean canDeleteUser(DefaultMutableTreeNode userNode) {
        if (userNode == null) {
            return false;
        }
        SpecifyUser currentUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)userNode.getUserObject();
        FormDataObjIFace object = wrapper.getDataObj();
        if (!(object instanceof SpecifyUser)) {
            return false;
        }
        SpecifyUser user = (SpecifyUser)object;
        if (currentUser.getSpecifyUserId().equals(user.getSpecifyUserId())) {
            UIRegistry.showLocalizedMsg("NAVTREEMGR_NO_DEL_SELF");
            return false;
        }
        DataProviderSessionIFace session = null;
        boolean result = false;
        try {
            session = DataProviderFactory.getInstance().createSession();
            user = (SpecifyUser)session.getData("FROM SpecifyUser WHERE id = " + user.getId());
            if (user != null) {
                wrapper.setDataObj(user);
                int numOfGrpsUserBelonedTo = user.getUserGroupCount();
                boolean bl = numOfGrpsUserBelonedTo == 1;
                return bl;
            }
            try {
                result = true;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public void deleteUser(DefaultMutableTreeNode userNode) {
        DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)userNode.getUserObject();
        FormDataObjIFace object = wrapper.getDataObj();
        if (!(object instanceof SpecifyUser) || !this.canDeleteUser(userNode)) {
            return;
        }
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                Integer spuId = ((SpecifyUser)object).getId();
                SpecifyUser user = session.get(SpecifyUser.class, spuId);
                for (Agent agent : user.getAgents()) {
                    agent.setSpecifyUser(null);
                }
                user.getAgents().clear();
                BaseBusRules.removeById(this.spUsers, user);
                Vector<Integer> recSetIds = BasicSQLUtils.queryForInts("SELECT RecordSetID FROM recordset WHERE SpecifyUserID = " + spuId);
                for (Integer rsId : recSetIds) {
                    RecordSet rs = session.get(RecordSet.class, rsId);
                    session.delete(rs);
                }
                for (SpPrincipal principal : user.getSpPrincipals()) {
                    if (!UserPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass())) continue;
                    session.delete(principal);
                }
                user.getSpPrincipals().clear();
                user.setModifiedByAgent(null);
                session.delete(user);
                session.commit();
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                model.removeNodeFromParent(userNode);
                this.tree.clearSelection();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public boolean canAddNewUser(DefaultMutableTreeNode node) {
        DataModelObjBaseWrapper wrapper;
        FormDataObjIFace object;
        if (node != null && (object = (wrapper = (DataModelObjBaseWrapper)node.getUserObject()).getDataObj()) instanceof SpPrincipal) {
            SpPrincipal principal = (SpPrincipal)object;
            return !AdminPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass());
        }
        return false;
    }

    public boolean canDeleteItem(DefaultMutableTreeNode node) {
        if (node != null) {
            DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)node.getUserObject();
            FormDataObjIFace object = wrapper.getDataObj();
            if (!(object instanceof SpPrincipal || object instanceof Collection || object instanceof Discipline)) {
                return false;
            }
            return node.getChildCount() == 0;
        }
        return false;
    }

    public void deleteItem(DefaultMutableTreeNode node) {
        DataModelObjBaseWrapper wrapper = (DataModelObjBaseWrapper)node.getUserObject();
        FormDataObjIFace object = wrapper.getDataObj();
        if (!this.canDeleteItem(node)) {
            return;
        }
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                session.delete(object);
                session.commit();
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                model.removeNodeFromParent(node);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private Discipline getParentDiscipline(DefaultMutableTreeNode grpNode) {
        Discipline parentDiscipline = null;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)grpNode.getParent();
        while (parent != null) {
            DataModelObjBaseWrapper wrp;
            FormDataObjIFace obj;
            if (parent.getUserObject() instanceof DataModelObjBaseWrapper && (obj = (wrp = (DataModelObjBaseWrapper)parent.getUserObject()).getDataObj()) instanceof Discipline) {
                parentDiscipline = (Discipline)obj;
            }
            parent = (DefaultMutableTreeNode)parent.getParent();
        }
        return parentDiscipline;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultMutableTreeNode addNewUser(DefaultMutableTreeNode grpNode) {
        ViewBasedDisplayDialog dlg;
        SpecifyUser specifyUser;
        SpPrincipal grpPrin;
        DataModelObjBaseWrapper parentWrp;
        Collection collection;
        Division parentDivision;
        Discipline parentDiscipline;
        block24: {
            if (grpNode == null || !(grpNode.getUserObject() instanceof DataModelObjBaseWrapper)) {
                return null;
            }
            parentDiscipline = this.getParentDiscipline(grpNode);
            parentDivision = parentDiscipline.getDivision();
            collection = (Collection)this.getParentOfClass(grpNode, Collection.class);
            parentWrp = (DataModelObjBaseWrapper)grpNode.getUserObject();
            if (!parentWrp.isGroup()) {
                return null;
            }
            grpPrin = (SpPrincipal)parentWrp.getDataObj();
            specifyUser = new SpecifyUser();
            specifyUser.initialize();
            specifyUser.setUserType(grpPrin.getGroupType());
            dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getMostRecentWindow(), null, "User", null, DBTableIdMgr.getInstance().getTitleForId(SpecifyUser.getClassTableId()), null, specifyUser.getClass().getName(), "specifyUserId", true, 780);
            dlg.createUI();
            Component cbx = dlg.getMultiView().getCurrentViewAsFormViewObj().getControlByName("agent");
            JLabel lbl = dlg.getMultiView().getCurrentViewAsFormViewObj().getLabelFor(cbx);
            cbx.setEnabled(false);
            cbx.setVisible(false);
            lbl.setVisible(false);
            AppContextMgr acMgr = AppContextMgr.getInstance();
            Discipline currDiscipline = acMgr.getClassObject(Discipline.class);
            Division currDivision = acMgr.getClassObject(Division.class);
            acMgr.setClassObject(Discipline.class, parentDiscipline);
            acMgr.setClassObject(Division.class, parentDiscipline.getDivision());
            try {
                try {
                    dlg.setData(specifyUser);
                    dlg.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, ex);
                    acMgr.setClassObject(Discipline.class, currDiscipline);
                    acMgr.setClassObject(Division.class, currDivision);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                acMgr.setClassObject(Discipline.class, currDiscipline);
                acMgr.setClassObject(Division.class, currDivision);
                throw throwable;
            }
            acMgr.setClassObject(Discipline.class, currDiscipline);
            acMgr.setClassObject(Division.class, currDivision);
        }
        if (!dlg.isCancelled()) {
            DataModelObjBaseWrapper userWrp;
            block25: {
                List<Agent> userAgents;
                String textPwd = specifyUser.getPassword();
                specifyUser.setPassword(Encryption.encrypt(textPwd, textPwd));
                DataProviderSessionIFace session = null;
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.attach(parentDiscipline);
                    session.attach(parentDiscipline.getDivision());
                    userAgents = this.getAgent(session, parentDiscipline.getDivision(), parentDiscipline, specifyUser, true);
                    if (userAgents == null || userAgents.size() == 0) {
                        if (session != null) {
                            session.close();
                        }
                        return null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                    session.rollback();
                    if (session != null) {
                        session.close();
                    }
                    break block25;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                {
                    session.beginTransaction();
                    SpecifyUserBusRules busRules = new SpecifyUserBusRules();
                    busRules.initialize(dlg.getMultiView().getCurrentView());
                    busRules.beforeMerge(specifyUser, session);
                    busRules.beforeSave(specifyUser, session);
                    session.save(specifyUser);
                    SpPrincipal localGroup = session.get(SpPrincipal.class, grpPrin.getUserGroupId());
                    specifyUser.getSpPrincipals().add(localGroup);
                    localGroup.getSpecifyUsers().add(specifyUser);
                    boolean fndParentDiv = false;
                    for (Agent userAgent : userAgents) {
                        if (userAgent.getId() != null) {
                            session.attach(userAgent);
                        }
                        if (!fndParentDiv && parentDivision.getId().equals(userAgent.getDivision().getId())) {
                            fndParentDiv = true;
                        }
                        userAgent.setSpecifyUser(specifyUser);
                        specifyUser.getAgents().add(userAgent);
                        session.saveOrUpdate(userAgent);
                    }
                    if (userAgents.size() > 0 && !fndParentDiv) {
                        Agent userAgent;
                        userAgent = (Agent)userAgents.get(0).clone();
                        userAgent.setDivision(parentDiscipline.getDivision());
                        userAgent.setSpecifyUser(specifyUser);
                        specifyUser.getAgents().add(userAgent);
                        session.saveOrUpdate(userAgent);
                    }
                    SpPrincipal userPrincipal = DataBuilder.createUserPrincipal(specifyUser, collection);
                    session.save(userPrincipal);
                    specifyUser.addUserToSpPrincipalGroup(userPrincipal);
                    session.saveOrUpdate(specifyUser);
                    session.commit();
                    parentWrp.setDataObj(localGroup);
                    this.spUsers.add(specifyUser);
                    specifyUser = session.get(SpecifyUser.class, specifyUser.getId());
                }
                if (session != null) {
                    session.close();
                }
            }
            if ((userWrp = new DataModelObjBaseWrapper(specifyUser)) != null) {
                DefaultMutableTreeNode userNode = new DefaultMutableTreeNode(userWrp);
                if (userNode != null) {
                    DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                    model.insertNodeInto(userNode, grpNode, grpNode.getChildCount());
                    this.tree.setSelectionPath(new TreePath(model.getPathToRoot(userNode)));
                }
                return userNode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultMutableTreeNode addExistingUser(DefaultMutableTreeNode grpNode) {
        SpecifyUser specifyUser;
        block16: {
            List<Agent> userAgents;
            AddExistingUserDlg dlg;
            SpPrincipal prinGroup;
            DataModelObjBaseWrapper wrp = (DataModelObjBaseWrapper)grpNode.getUserObject();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)grpNode.getParent();
            ArrayList<SpPrincipal> groups = new ArrayList<SpPrincipal>();
            int i = 0;
            while (true) {
                if (i >= parentNode.getChildCount()) {
                    prinGroup = (SpPrincipal)wrp.getDataObj();
                    dlg = new AddExistingUserDlg(groups);
                    dlg.createUI();
                    dlg.pack();
                    dlg.setSize(400, 300);
                    UIHelper.centerAndShow(dlg);
                    if (!dlg.isCancelled()) break;
                    return null;
                }
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                DataModelObjBaseWrapper childWrp = (DataModelObjBaseWrapper)childNode.getUserObject();
                SpPrincipal prin = (SpPrincipal)childWrp.getDataObj();
                groups.add(prin);
                ++i;
            }
            specifyUser = null;
            SpecifyUser[] selUsers = dlg.getSelectedUsers();
            if (selUsers == null) return null;
            if (selUsers.length == 0) {
                return null;
            }
            specifyUser = selUsers[0];
            if (specifyUser == null || grpNode == null || !(grpNode.getUserObject() instanceof DataModelObjBaseWrapper)) {
                return null;
            }
            DataModelObjBaseWrapper parentWrp = (DataModelObjBaseWrapper)grpNode.getUserObject();
            if (!parentWrp.isGroup()) {
                return null;
            }
            Discipline parentDiscipline = this.getParentDiscipline(grpNode);
            AppContextMgr acMgr = AppContextMgr.getInstance();
            Discipline currDiscipline = acMgr.getClassObject(Discipline.class);
            Division currDivision = acMgr.getClassObject(Division.class);
            acMgr.setClassObject(Discipline.class, parentDiscipline);
            acMgr.setClassObject(Division.class, parentDiscipline.getDivision());
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                prinGroup = session.merge(prinGroup);
                wrp.setDataObj(prinGroup);
                specifyUser = (SpecifyUser)session.getData("FROM SpecifyUser WHERE id = " + specifyUser.getId());
                prinGroup.getSpecifyUsers().add(specifyUser);
                specifyUser.getSpPrincipals().add(prinGroup);
                userAgents = this.getAgent(session, parentDiscipline.getDivision(), parentDiscipline, specifyUser, false);
                if (userAgents == null || userAgents.size() == 0) {
                    acMgr.setClassObject(Discipline.class, currDiscipline);
                    acMgr.setClassObject(Division.class, currDivision);
                    if (session != null) {
                        session.close();
                    }
                    return null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                session.rollback();
                log.error((Object)("Exception caught: " + e1.toString()));
                acMgr.setClassObject(Discipline.class, currDiscipline);
                acMgr.setClassObject(Division.class, currDivision);
                if (session != null) {
                    session.close();
                }
                break block16;
            }
            catch (Throwable throwable) {
                acMgr.setClassObject(Discipline.class, currDiscipline);
                acMgr.setClassObject(Division.class, currDivision);
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            {
                session.beginTransaction();
                for (Agent userAgent : userAgents) {
                    userAgent.setSpecifyUser(specifyUser);
                    specifyUser.getAgents().add(userAgent);
                    session.saveOrUpdate(specifyUser);
                    session.saveOrUpdate(userAgent);
                }
                Collection collection = (Collection)this.getParentOfClass(grpNode, Collection.class);
                SpPrincipal userPrincipal = DataBuilder.createUserPrincipal(specifyUser, collection);
                session.save(userPrincipal);
                specifyUser.addUserToSpPrincipalGroup(userPrincipal);
                session.commit();
            }
            acMgr.setClassObject(Discipline.class, currDiscipline);
            acMgr.setClassObject(Division.class, currDivision);
            if (session != null) {
                session.close();
            }
        }
        DefaultMutableTreeNode lastUserNode = this.addUsersToTree(grpNode, specifyUser);
        this.tree.setSelectionPath(new TreePath(lastUserNode.getPath()));
        return lastUserNode;
    }

    private List<Agent> getAgent(DataProviderSessionIFace session, Division parentDivision, Discipline parentDiscipline, SpecifyUser specifyUser, boolean doAddNewUser) throws CloneNotSupportedException {
        String sql;
        Vector<Object[]> agentRow;
        ArrayList<Agent> agentsList = new ArrayList<Agent>();
        Agent userAgent = null;
        Integer agentId = null;
        String lastName = null;
        String firstName = null;
        if (specifyUser.getId() != null) {
            String sql2 = String.format("SELECT AgentID, LastName, FirstName FROM agent WHERE SpecifyUserID = %d", specifyUser.getId());
            Vector<Object[]> agentRow2 = BasicSQLUtils.query(sql2);
            if (agentRow2 == null || agentRow2.size() == 0) {
                UIRegistry.showError("Error finding an agent for the current division");
                return null;
            }
            Object[] row = agentRow2.get(0);
            lastName = (String)row[1];
            firstName = (String)row[2];
        }
        int newAgentOption = 2;
        if (doAddNewUser && (newAgentOption = UIRegistry.askYesNoLocalized("NVTM.NEW_AGT", "NVTM.EXT_AGT", UIRegistry.getResourceString("NVTM.USRAGTMSGF"), "NVTM.USRAGTMSGF_TITLE")) == 1) {
            ViewBasedSearchDialogIFace dlg;
            block17: {
                Division currDivision = AppContextMgr.getInstance().getClassObject(Division.class);
                Discipline currDiscipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
                AppContextMgr.getInstance().setClassObject(Division.class, parentDivision);
                AppContextMgr.getInstance().setClassObject(Discipline.class, parentDiscipline);
                dlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, "UserAgentSearch");
                try {
                    try {
                        dlg.registerQueryBuilder(null);
                        dlg.setMultipleSelection(true);
                        dlg.getDialog().setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        AppContextMgr.getInstance().setClassObject(Division.class, currDivision);
                        AppContextMgr.getInstance().setClassObject(Discipline.class, currDiscipline);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    AppContextMgr.getInstance().setClassObject(Division.class, currDivision);
                    AppContextMgr.getInstance().setClassObject(Discipline.class, currDiscipline);
                    throw throwable;
                }
                AppContextMgr.getInstance().setClassObject(Division.class, currDivision);
                AppContextMgr.getInstance().setClassObject(Discipline.class, currDiscipline);
            }
            if (!dlg.isCancelled()) {
                for (Object obj : dlg.getSelectedObjects()) {
                    Agent agt = session.get(Agent.class, ((Agent)obj).getAgentId());
                    agt.getDivision().getId();
                    agentsList.add(agt);
                }
                return agentsList;
            }
        }
        if (!doAddNewUser && (agentRow = BasicSQLUtils.query(sql = String.format("SELECT DISTINCT AgentID, LastName, FirstName, MiddleInitial FROM agent WHERE LastName = '%s' AND FirstName = '%s' AND DivisionID = %d", lastName, firstName, parentDivision.getId()))) != null && agentRow.size() > 0) {
            Scriptlet scriptlet = new Scriptlet();
            ArrayList<AgentInfo> list = new ArrayList<AgentInfo>();
            for (Object[] agtRow : agentRow) {
                Integer aId = (Integer)agtRow[0];
                String lName = (String)agtRow[1];
                String fName = (String)agtRow[2];
                String mid = (String)agtRow[3];
                AgentInfo pair = new AgentInfo(aId, scriptlet.buildNameString(fName, lName, mid));
                list.add(pair);
            }
            ChooseFromListDlg agtDlg = new ChooseFromListDlg((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("NVTM.CHSE_AGT"), list);
            UIHelper.centerAndShow(agtDlg);
            if (!agtDlg.isCancelled()) {
                Pair pair = (Pair)agtDlg.getSelectedObject();
                agentId = (Integer)pair.first;
            } else {
                return null;
            }
        }
        if (agentId == null) {
            if (!doAddNewUser && specifyUser.getAgents().size() > 0) {
                Agent agent = specifyUser.getAgents().iterator().next();
                userAgent = (Agent)agent.clone();
                userAgent.setDivision(parentDivision);
                agentsList.add(userAgent);
                return agentsList;
            }
            userAgent = this.createNewAgent();
            if (userAgent != null) {
                userAgent.setDivision(parentDivision);
                agentsList.add(userAgent);
                return agentsList;
            }
            return null;
        }
        userAgent = (Agent)session.getData("FROM Agent agent WHERE id = " + agentId);
        agentsList.add(userAgent);
        return agentsList;
    }

    private Agent createNewAgent() {
        Agent agent = new Agent();
        agent.initialize();
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getMostRecentWindow(), null, "Agent", null, DBTableIdMgr.getInstance().getTitleForId(Agent.getClassTableId()), null, Agent.class.getName(), "agentId", true, 780);
        dlg.createUI();
        dlg.setData(agent);
        dlg.pack();
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            return agent;
        }
        return null;
    }

    private DefaultMutableTreeNode addUsersToTree(DefaultMutableTreeNode grpNode, SpecifyUser spUser) {
        DataModelObjBaseWrapper userWrp = new DataModelObjBaseWrapper(spUser);
        DefaultMutableTreeNode userNode = new DefaultMutableTreeNode(userWrp);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.insertNodeInto(userNode, grpNode, grpNode.getChildCount());
        return userNode;
    }

    protected <T> T getParentOfClass(DefaultMutableTreeNode node, Class<?> cls) {
        DefaultMutableTreeNode parent = node;
        while (parent != null) {
            DataModelObjBaseWrapper userData;
            if (parent.getUserObject() instanceof DataModelObjBaseWrapper && (userData = (DataModelObjBaseWrapper)parent.getUserObject()).getDataObj().getClass() == cls) {
                return (T)userData.getDataObj();
            }
            parent = (DefaultMutableTreeNode)parent.getParent();
        }
        return null;
    }

    class AgentInfo
    extends Pair<Integer, String> {
        public AgentInfo() {
        }

        public AgentInfo(Integer first, String second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return (String)this.second;
        }
    }
}

