/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.subpane.security.DataModelObjBaseWrapper;
import edu.ku.brc.specify.tasks.subpane.security.NavigationTreeMgr;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;

public class NavigationTreeContextMenuMgr
extends MouseAdapter
implements TreeSelectionListener {
    private NavigationTreeMgr treeMgr;
    private JButton addUserBtn;
    private JButton addExtUserBtn;
    private JButton delUserBtn;
    private JButton addToAdminBtn;
    private DefaultMutableTreeNode lastClickComp = null;

    public NavigationTreeContextMenuMgr(NavigationTreeMgr treeMgr) {
        this.treeMgr = treeMgr;
        this.getTree().addTreeSelectionListener(this);
        this.getTree().addMouseListener(this);
    }

    public void setBtn(JButton addBtn, JButton addExtBtn, JButton addToAdminBtn, JButton delBtn) {
        this.addUserBtn = addBtn;
        this.addExtUserBtn = addExtBtn;
        this.delUserBtn = delBtn;
        this.addToAdminBtn = addToAdminBtn;
        this.addUserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationTreeContextMenuMgr.this.lastClickComp = NavigationTreeContextMenuMgr.this.getTreeMgr().addNewUser(NavigationTreeContextMenuMgr.this.lastClickComp);
                NavigationTreeContextMenuMgr.this.updateBtnUI();
            }
        });
        this.addExtUserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationTreeContextMenuMgr.this.lastClickComp = NavigationTreeContextMenuMgr.this.getTreeMgr().addExistingUser(NavigationTreeContextMenuMgr.this.lastClickComp);
                NavigationTreeContextMenuMgr.this.updateBtnUI();
            }
        });
        this.delUserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isDoingDelete = NavigationTreeContextMenuMgr.this.delUserBtn.getToolTipText().equals(UIRegistry.getResourceString("SEC_DEL_USR_GRP"));
                if (isDoingDelete && NavigationTreeContextMenuMgr.this.getTreeMgr().canDeleteUser(NavigationTreeContextMenuMgr.this.lastClickComp)) {
                    if (UIHelper.promptForAction("DELETE", "CANCEL", "SEC_ASKDELUSR_TITLE", UIRegistry.getResourceString("SEC_ASKDELUSR"))) {
                        NavigationTreeContextMenuMgr.this.getTreeMgr().deleteUser(NavigationTreeContextMenuMgr.this.lastClickComp);
                    }
                } else if (!isDoingDelete && NavigationTreeContextMenuMgr.this.getTreeMgr().canRemoveUserFromGroup(NavigationTreeContextMenuMgr.this.lastClickComp) && UIHelper.promptForAction("REMOVE", "CANCEL", "SEC_ASKRMUSRGRP_TITLE", UIRegistry.getResourceString("SEC_ASKRMUSRGRP"))) {
                    NavigationTreeContextMenuMgr.this.getTreeMgr().removeUserFromGroup(NavigationTreeContextMenuMgr.this.lastClickComp);
                }
                NavigationTreeContextMenuMgr.this.lastClickComp = null;
                NavigationTreeContextMenuMgr.this.updateBtnUI();
            }
        });
        addToAdminBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationTreeContextMenuMgr.this.addToAdminGroup(NavigationTreeContextMenuMgr.this.lastClickComp);
            }
        });
    }

    public void updateBtnUI() {
        if (this.lastClickComp != null) {
            Object userObject = this.lastClickComp.getUserObject();
            FormDataObjIFace dmObject = ((DataModelObjBaseWrapper)userObject).getDataObj();
            if (dmObject instanceof SpecifyUser) {
                boolean canRemUser;
                boolean canDelUser;
                SpPrincipal parentsPrin;
                DataModelObjBaseWrapper pWrapper;
                SpecifyUser specifyUser = (SpecifyUser)dmObject;
                this.addUserBtn.setEnabled(false);
                this.addExtUserBtn.setEnabled(false);
                String sqlFmt = "SELECT COUNT(*) FROM spprincipal Inner Join specifyuser_spprincipal ON spprincipal.SpPrincipalID = specifyuser_spprincipal.SpPrincipalID Inner Join specifyuser ON specifyuser_spprincipal.SpecifyUserID = specifyuser.SpecifyUserID WHERE GroupSubClass = '%s'";
                boolean isLastAdminUser = false;
                boolean isParentMgrGrp = false;
                boolean isParentAdmGrp = false;
                String sql = String.format(sqlFmt, AdminPrincipal.class.getCanonicalName());
                sql = String.valueOf(sql) + " AND specifyuser.SpecifyUserID = " + specifyUser.getId();
                boolean isUserInAdmGrp = BasicSQLUtils.getCountAsInt(sql) > 0;
                sql = String.format(sqlFmt, AdminPrincipal.class.getCanonicalName());
                int allAdminUsersCnt = BasicSQLUtils.getCountAsInt(sql);
                sql = String.format(sqlFmt, GroupPrincipal.class.getCanonicalName());
                sql = String.valueOf(sql) + " AND specifyuser.SpecifyUserID = " + specifyUser.getId();
                int grpUserCnt = BasicSQLUtils.getCountAsInt(sql);
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)this.lastClickComp.getParent();
                if (parentTreeNode != null && (pWrapper = (DataModelObjBaseWrapper)(parentTreeNode.getUserObject() instanceof DataModelObjBaseWrapper ? parentTreeNode.getUserObject() : null)) != null && (parentsPrin = (SpPrincipal)(pWrapper.getDataObj() instanceof SpPrincipal ? pWrapper.getDataObj() : null)) != null) {
                    isLastAdminUser = allAdminUsersCnt == 1;
                    isParentMgrGrp = parentsPrin.getGroupType() != null && parentsPrin.getGroupType().equals("Manager");
                    isParentAdmGrp = parentsPrin.getGroupSubClass().equals(AdminPrincipal.class.getCanonicalName());
                }
                this.addToAdminBtn.setEnabled(isParentMgrGrp && !isUserInAdmGrp);
                String toolTip = "";
                boolean bl = canDelUser = !isUserInAdmGrp && grpUserCnt == 1;
                if (isUserInAdmGrp && isParentAdmGrp) {
                    canRemUser = allAdminUsersCnt > 1 && (grpUserCnt > 1 || !isLastAdminUser);
                } else {
                    boolean bl2 = canRemUser = grpUserCnt > 1;
                    if (canRemUser && dmObject instanceof SpecifyUser) {
                        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                        boolean bl3 = canRemUser = !((SpecifyUser)dmObject).getId().equals(spUser.getId());
                    }
                }
                if (canDelUser) {
                    toolTip = "SEC_DEL_USR_GRP";
                } else if (canRemUser) {
                    toolTip = "SEC_RM_USR_GRP";
                }
                this.delUserBtn.setEnabled(canDelUser || canRemUser);
                this.delUserBtn.setToolTipText(StringUtils.isNotEmpty((String)toolTip) ? UIRegistry.getResourceString(toolTip) : null);
            } else if (dmObject instanceof SpPrincipal) {
                boolean enable = this.getTreeMgr().canAddNewUser(this.lastClickComp);
                this.addUserBtn.setEnabled(enable);
                this.addExtUserBtn.setEnabled(enable);
                this.delUserBtn.setEnabled(false);
            } else {
                boolean enable = this.getTreeMgr().canAddNewUser(this.lastClickComp);
                this.addUserBtn.setEnabled(enable);
                this.addExtUserBtn.setEnabled(enable);
                this.delUserBtn.setEnabled(false);
            }
        } else {
            this.addUserBtn.setEnabled(this.treeMgr.canAddNewUser(this.lastClickComp));
            this.addExtUserBtn.setEnabled(this.treeMgr.canAddNewUser(this.lastClickComp));
            this.delUserBtn.setEnabled(this.treeMgr.canDeleteUser(this.lastClickComp));
            this.addToAdminBtn.setEnabled(this.treeMgr.canAddToAdmin(this.lastClickComp));
        }
    }

    public JTree getTree() {
        return this.treeMgr.getTree();
    }

    private NavigationTreeMgr getTreeMgr() {
        return this.treeMgr;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath clickedElement = this.getTree().getPathForLocation(e.getX(), e.getY());
        this.updateSelection(clickedElement);
        TreePath tp = clickedElement;
        if (tp != null) {
            this.lastClickComp = (DefaultMutableTreeNode)tp.getLastPathComponent();
            this.updateBtnUI();
        }
    }

    private DefaultMutableTreeNode getAdminTreeNode(DefaultMutableTreeNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            String name;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            FormDataObjIFace dmObj = ((DataModelObjBaseWrapper)child.getUserObject()).getDataObj();
            if (dmObj instanceof SpPrincipal && (name = ((SpPrincipal)dmObj).getName()).equals("Administrator")) {
                return child;
            }
            DefaultMutableTreeNode cNode = this.getAdminTreeNode(child);
            if (cNode != null) {
                return cNode;
            }
            ++i;
        }
        return null;
    }

    private void addToAdminGroup(DefaultMutableTreeNode node) {
        FormDataObjIFace dmObject;
        Object userObject;
        if (node != null && (userObject = node.getUserObject()) != null && (dmObject = ((DataModelObjBaseWrapper)userObject).getDataObj()) != null && dmObject instanceof SpecifyUser) {
            SpPrincipal adminPrin = null;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    adminPrin = session.getData(SpPrincipal.class, "name", "Administrator", DataProviderSessionIFace.CompareType.Equals);
                    if (adminPrin != null) {
                        SpecifyUser spUser = session.get(SpecifyUser.class, ((SpecifyUser)dmObject).getId());
                        spUser.addUserToSpPrincipalGroup(adminPrin);
                        session.beginTransaction();
                        session.saveOrUpdate(spUser);
                        session.saveOrUpdate(adminPrin);
                        session.commit();
                        DefaultMutableTreeNode adminNode = this.getAdminTreeNode((DefaultMutableTreeNode)this.treeMgr.getTree().getModel().getRoot());
                        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new DataModelObjBaseWrapper(spUser));
                        DefaultTreeModel model = (DefaultTreeModel)this.getTree().getModel();
                        model.insertNodeInto(newNode, adminNode, adminNode.getChildCount());
                        model.nodeChanged(adminNode);
                        model.nodeChanged(newNode);
                        this.getTree().repaint();
                        this.getTree().setSelectionPath(new TreePath(newNode.getPath()));
                        this.lastClickComp = null;
                        this.updateBtnUI();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                    session.rollback();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private void updateSelection(TreePath clickedElement) {
        boolean clickedElementSelected = false;
        TreePath[] selection = this.getTree().getSelectionPaths();
        if (clickedElement != null && selection != null) {
            int index = 0;
            while (index < selection.length) {
                if (clickedElement.equals(selection[index])) {
                    clickedElementSelected = true;
                    break;
                }
                ++index;
            }
        }
        if (!clickedElementSelected) {
            if (clickedElement != null) {
                this.getTree().setSelectionPath(clickedElement);
            } else {
                this.getTree().clearSelection();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
    }
}

