/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionPanelContainerIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditor;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEnumerator;
import edu.ku.brc.specify.tasks.subpane.security.TablePermissionEnumerator;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class IndvPanelPermEditor
extends JPanel
implements PermissionPanelContainerIFace {
    private static final Logger log = Logger.getLogger(IndvPanelPermEditor.class);
    protected String panelName;
    protected PermissionEnumerator enumerator;
    protected SpPrincipal principal = null;
    protected SpPrincipal overrulingPrincipal;
    protected Hashtable<String, SpPermission> existingPerms;
    protected Hashtable<String, SpPermission> overrulingPerms;
    protected String userType;
    protected ChangeListener listener;
    protected boolean readOnly;
    protected JList list;
    protected DefaultListModel model = new DefaultListModel();
    protected JPanel mainPanel;
    protected ImageIcon icon;
    protected Vector<PermissionEditorRowIFace> rowDataList = new Vector();
    protected PermissionEditorIFace editor = null;
    protected PermissionEditorRowIFace prevRowData = null;
    protected BasicPermisionPanel basicEditor = new BasicPermisionPanel();
    protected PermissionEditor tableEditor;
    protected TablePermissionEnumerator tblEnumerator = null;
    protected boolean doAddTableEditor = false;

    public IndvPanelPermEditor(String panelNameKey, String descKey, PermissionEnumerator enumerator, ChangeListener listener) {
        this(panelNameKey, descKey, enumerator, listener, false);
    }

    public IndvPanelPermEditor(String panelNameKey, String descKey, PermissionEnumerator enumerator, final ChangeListener listener, final boolean readOnly) {
        super(new BorderLayout());
        this.panelName = UIRegistry.getResourceString(panelNameKey);
        this.enumerator = enumerator;
        this.principal = null;
        this.listener = listener;
        this.readOnly = readOnly;
        if (this.doAddTableEditor) {
            this.tblEnumerator = new TablePermissionEnumerator();
            this.tblEnumerator.setTableIds(new int[0]);
            this.tableEditor = new PermissionEditor("SEC_TABLES", this.tblEnumerator, listener);
            this.tableEditor.setVisible(false);
        }
        this.list = new JList(this.model);
        JScrollPane sp = UIHelper.createScrollPane(this.list);
        this.list.setCellRenderer(new PermWrapperRenderer());
        this.mainPanel = new JPanel(new BorderLayout());
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,10px,p:g,5px,p,5px,f:p:g", "p,2px,f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createI18NLabel(descKey, 0), cc.xy(1, 1));
        pb.add((Component)sp, cc.xy(1, 3));
        pb.add((Component)this.mainPanel, cc.xywh(3, 1, 1, 3));
        if (this.doAddTableEditor) {
            pb.add((Component)new VerticalSeparator(new Color(224, 224, 224), new Color(124, 124, 124)), cc.xywh(5, 1, 1, 3));
            pb.add((Component)this.tableEditor, cc.xy(7, 3));
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PermissionEditorRowIFace rowData;
                    if (IndvPanelPermEditor.this.editor != null) {
                        IndvPanelPermEditor.this.editor.removeChangeListener(listener);
                        IndvPanelPermEditor.this.mainPanel.remove(IndvPanelPermEditor.this.editor.getUIComponent());
                        if (IndvPanelPermEditor.this.editor.hasChanged() && IndvPanelPermEditor.this.prevRowData != null) {
                            IndvPanelPermEditor.this.prevRowData.setPermissions(IndvPanelPermEditor.this.editor.getPermissions());
                            IndvPanelPermEditor.this.editor.setChanged(false);
                        }
                    }
                    if ((rowData = (PermissionEditorRowIFace)IndvPanelPermEditor.this.list.getSelectedValue()) != null) {
                        IndvPanelPermEditor.this.editor = rowData.getEditorPanel();
                        if (IndvPanelPermEditor.this.editor == null) {
                            IndvPanelPermEditor.this.editor = IndvPanelPermEditor.this.basicEditor;
                        }
                        int i = 1;
                        while (i < 9) {
                            IndvPanelPermEditor.this.editor.setOverrideText(i, rowData.getOverrideText(i), readOnly);
                            i *= 2;
                        }
                        IndvPanelPermEditor.this.editor.setTitle(rowData.getTitle());
                        IndvPanelPermEditor.this.editor.setPermissions(rowData.getPermissions());
                        if (IndvPanelPermEditor.this.doAddTableEditor) {
                            int[] tableIds = IndvPanelPermEditor.this.editor.getAssociatedTableIds();
                            if (tableIds != null && tableIds.length > 0) {
                                IndvPanelPermEditor.this.tblEnumerator.setTableIds(tableIds);
                                IndvPanelPermEditor.this.tableEditor.setVisible(true);
                                if (IndvPanelPermEditor.this.tableEditor != null && IndvPanelPermEditor.this.principal != null) {
                                    IndvPanelPermEditor.this.tableEditor.updateData(IndvPanelPermEditor.this.principal, IndvPanelPermEditor.this.overrulingPrincipal, IndvPanelPermEditor.this.existingPerms, IndvPanelPermEditor.this.overrulingPerms, IndvPanelPermEditor.this.userType);
                                }
                            } else {
                                IndvPanelPermEditor.this.tableEditor.setVisible(false);
                            }
                        }
                        IndvPanelPermEditor.this.mainPanel.add(IndvPanelPermEditor.this.editor.getUIComponent(), "Center");
                        IndvPanelPermEditor.this.mainPanel.invalidate();
                        IndvPanelPermEditor.this.mainPanel.validate();
                        IndvPanelPermEditor.this.mainPanel.repaint();
                    }
                    IndvPanelPermEditor.this.prevRowData = rowData;
                    IndvPanelPermEditor.this.editor.addChangeListener(listener);
                }
            }
        });
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public PermissionEnumerator getPermissionEnumerator() {
        return this.enumerator;
    }

    @Override
    public void savePermissions(DataProviderSessionIFace session) throws Exception {
        if (this.principal == null) {
            return;
        }
        if (this.editor != null && this.editor.hasChanged() && this.prevRowData != null) {
            this.prevRowData.setPermissions(this.editor.getPermissions());
            this.editor.setChanged(false);
            this.editor.removeChangeListener(this.listener);
        }
        final int selectedIndex = this.list.getSelectedIndex();
        for (PermissionEditorRowIFace rowData : this.rowDataList) {
            Iterator<SpPermission> iterator = rowData.getPermissionList().iterator();
            while (iterator.hasNext()) {
                SpPermission perm;
                SpPermission newPerm = perm = iterator.next();
                if (!(perm.canView() || perm.canAdd() || perm.canModify() || perm.canDelete())) {
                    log.debug((Object)("Clearing: " + perm.getName() + " [" + perm.getActions() + "]"));
                    if (perm.getId() != null) {
                        perm.setActions("");
                        newPerm = session.merge(perm);
                        session.saveOrUpdate(newPerm);
                        perm.setHasChanged(false);
                    }
                } else if (perm.hasChanged()) {
                    log.debug((Object)("Saving: " + perm.getName() + " [" + perm.getActions() + "]"));
                    if (perm.getId() == null) {
                        perm.getPrincipals().add(this.principal);
                    }
                    newPerm = perm.getId() == null ? perm : session.merge(perm);
                    session.saveOrUpdate(newPerm);
                    perm.setHasChanged(false);
                }
                rowData.updatePerm(perm, newPerm);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndvPanelPermEditor.this.list.setSelectedIndex(selectedIndex);
            }
        });
    }

    @Override
    public void updateData(SpPrincipal principalArg, SpPrincipal overrulingPrincipalArg, Hashtable<String, SpPermission> existingPermsArg, Hashtable<String, SpPermission> overrulingPermsArg, String userTypeArg) {
        final int selectedIndex = this.list.getSelectedIndex();
        this.principal = principalArg;
        this.overrulingPrincipal = overrulingPrincipalArg;
        this.existingPerms = existingPermsArg;
        this.overrulingPerms = overrulingPermsArg;
        this.userType = userTypeArg;
        this.rowDataList.clear();
        List<PermissionEditorRowIFace> perms = this.enumerator.getPermissions(principalArg, existingPermsArg, overrulingPermsArg, userTypeArg);
        Collections.sort(perms, new ComparatorByStringRepresentation(true));
        for (PermissionEditorRowIFace perm : perms) {
            this.rowDataList.add(perm);
        }
        if (this.model == null) {
            return;
        }
        this.model.clear();
        IconManager.IconSize iconSize = IconManager.IconSize.Std20;
        this.icon = IconManager.getIcon("SystemSetup", iconSize);
        JLabel label = UIHelper.createLabel("XXXX");
        label.setIcon(this.icon);
        for (PermissionEditorRowIFace permWrapper : this.rowDataList) {
            this.model.addElement(permWrapper);
        }
        if (this.doAddTableEditor && this.tableEditor != null && this.principal != null) {
            this.tableEditor.updateData(this.principal, this.overrulingPrincipal, this.existingPerms, this.overrulingPerms, this.userType);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndvPanelPermEditor.this.list.setSelectedIndex(selectedIndex == -1 ? 0 : selectedIndex);
            }
        });
    }

    @Override
    public boolean doesSupportSelectAll() {
        return false;
    }

    private void setAllRows(int options) {
        for (PermissionEditorRowIFace rowData : this.rowDataList) {
            List<PermissionIFace> permList = rowData.getPermissions();
            for (PermissionIFace item : permList) {
                item.setOptions(options);
            }
            rowData.setPermissions(permList);
            if (rowData.getEditorPanel() == null) continue;
            rowData.getEditorPanel().setPermissions(permList);
            rowData.getEditorPanel().setChanged(true);
        }
    }

    @Override
    public void deselectAll() {
        this.setAllRows(0);
    }

    @Override
    public void selectAll() {
        this.setAllRows(15);
    }

    public class PermWrapperRenderer
    extends DefaultListCellRenderer {
        protected ImageIcon blankIcon;

        public PermWrapperRenderer() {
            this.setOpaque(false);
            this.blankIcon = null;
        }

        @Override
        public Component getListCellRendererComponent(JList listArg, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)listArg, value, index, iss, chf);
            PermissionEditorRowIFace rowData = (PermissionEditorRowIFace)value;
            this.setIcon(rowData.getIcon() != null ? rowData.getIcon() : this.blankIcon);
            if (iss) {
                this.setOpaque(true);
                this.setBackground(IndvPanelPermEditor.this.list.getSelectionBackground());
                this.setForeground(IndvPanelPermEditor.this.list.getSelectionForeground());
                IndvPanelPermEditor.this.list.setSelectedIndex(index);
            } else {
                this.setOpaque(false);
                this.setBackground(IndvPanelPermEditor.this.list.getBackground());
                this.setForeground(IndvPanelPermEditor.this.list.getForeground());
            }
            this.setText(rowData.getTitle());
            return this;
        }
    }
}

