/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCheckBox;
import edu.ku.brc.ui.UIRegistry;

public class GeneralPermissionTableCellValueWrapper {
    private boolean permissionActionValue;
    private boolean overrulingPermissionActionValue;
    private String overrulingPermissionText;
    private boolean admin;

    public GeneralPermissionTableCellValueWrapper(SpPermission permission, SpPermission overrulingPermission, String permissionAction, boolean adminPrincipal) {
        this.admin = adminPrincipal;
        this.permissionActionValue = permission.hasAction(permissionAction);
        if (adminPrincipal) {
            this.overrulingPermissionActionValue = true;
            this.overrulingPermissionText = "Admin";
        } else if (overrulingPermission != null) {
            this.overrulingPermissionActionValue = overrulingPermission.hasAction(permissionAction);
            for (SpPrincipal principal : overrulingPermission.getPrincipals()) {
                if (!GroupPrincipal.class.getCanonicalName().equals(principal.getGroupSubClass())) continue;
                this.overrulingPermissionText = principal.getName();
            }
        }
    }

    public boolean getPermissionActionValue() {
        return this.permissionActionValue;
    }

    public void setPermissionActionValue(boolean permissionActionValue) {
        this.permissionActionValue = permissionActionValue;
    }

    public boolean getOverrulingPermissionActionValue() {
        return this.overrulingPermissionActionValue;
    }

    public void setOverrulingPermissionActionValue(boolean overrulingPermissionActionValue) {
        this.overrulingPermissionActionValue = overrulingPermissionActionValue;
    }

    public String getOverrulingPermissionText() {
        return this.overrulingPermissionText;
    }

    public void setOverrulingPermissionText(String overrulingPermissionText) {
        this.overrulingPermissionText = overrulingPermissionText;
    }

    public boolean isOverriden() {
        return this.overrulingPermissionActionValue;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void prepareComponent(GeneralPermissionTableCheckBox customCheckbox) {
        customCheckbox.setCellValue(this);
        if (this.isAdmin()) {
            customCheckbox.setText(UIRegistry.getResourceString("SEC_ALWAYS_ADM"));
            customCheckbox.setEnabled(false);
            customCheckbox.setSelected(true);
        } else if (this.isOverriden()) {
            customCheckbox.setText("(" + this.getOverrulingPermissionText() + ")");
            customCheckbox.setEnabled(false);
            customCheckbox.setSelected(true);
        } else {
            customCheckbox.setText("");
            customCheckbox.setEnabled(true);
        }
    }
}

