/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.tasks.subpane.security.GeneralPermissionTableCellValueWrapper;
import edu.ku.brc.specify.tasks.subpane.security.PermissionEditorRowIFace;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;

public class GeneralPermissionEditorRow
implements PermissionEditorRowIFace {
    protected String type;
    protected SpPermission permission;
    protected SpPermission overrulingPermission;
    protected String title;
    protected String description;
    protected ImageIcon icon;
    protected PermissionEditorIFace editorPanel;
    protected boolean adminPrincipal;
    protected GeneralPermissionTableCellValueWrapper viewWrap = null;
    protected GeneralPermissionTableCellValueWrapper modWrap = null;
    protected GeneralPermissionTableCellValueWrapper delWrap = null;
    protected GeneralPermissionTableCellValueWrapper addWrap = null;

    public GeneralPermissionEditorRow(SpPermission permission, SpPermission overrulingPermission, String type, String title, String description, ImageIcon icon, PermissionEditorIFace editorPanel, boolean adminPrincipal) {
        this.permission = permission;
        this.overrulingPermission = overrulingPermission;
        this.type = type;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.editorPanel = editorPanel;
        this.adminPrincipal = adminPrincipal;
        this.viewWrap = new GeneralPermissionTableCellValueWrapper(permission, overrulingPermission, "view", adminPrincipal);
        this.addWrap = new GeneralPermissionTableCellValueWrapper(permission, overrulingPermission, "add", adminPrincipal);
        this.modWrap = new GeneralPermissionTableCellValueWrapper(permission, overrulingPermission, "modify", adminPrincipal);
        this.delWrap = new GeneralPermissionTableCellValueWrapper(permission, overrulingPermission, "delete", adminPrincipal);
    }

    @Override
    public List<SpPermission> getPermissionList() {
        ArrayList<SpPermission> list = new ArrayList<SpPermission>(1);
        PermissionSettings ps = new PermissionSettings(this.getPermOptions());
        this.permission.setActions(ps.canView(), ps.canAdd(), ps.canModify(), ps.canDelete());
        list.add(this.permission);
        return list;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PermissionEditorIFace getEditorPanel() {
        return this.editorPanel;
    }

    protected int getPermOptions() {
        int options = 0;
        options |= (this.modWrap.isOverriden() ? this.modWrap.getOverrulingPermissionActionValue() : this.modWrap.getPermissionActionValue()) ? 2 : 0;
        options |= (this.viewWrap.isOverriden() ? this.viewWrap.getOverrulingPermissionActionValue() : this.viewWrap.getPermissionActionValue()) ? 1 : 0;
        options |= (this.addWrap.isOverriden() ? this.addWrap.getOverrulingPermissionActionValue() : this.addWrap.getPermissionActionValue()) ? 8 : 0;
        return options |= (this.delWrap.isOverriden() ? this.delWrap.getOverrulingPermissionActionValue() : this.delWrap.getPermissionActionValue()) ? 4 : 0;
    }

    @Override
    public List<PermissionIFace> getPermissions() {
        ArrayList<PermissionIFace> list = new ArrayList<PermissionIFace>(1);
        list.add(new PermissionSettings(this.getPermOptions()));
        return list;
    }

    @Override
    public void setPermissions(List<PermissionIFace> permissionSettings) {
        PermissionIFace permSettings = permissionSettings.get(0);
        if (this.viewWrap.isOverriden()) {
            this.viewWrap.setOverrulingPermissionActionValue(permSettings.canView());
        } else {
            this.viewWrap.setPermissionActionValue(permSettings.canView());
        }
        if (this.modWrap.isOverriden()) {
            this.modWrap.setOverrulingPermissionActionValue(permSettings.canModify());
        } else {
            this.modWrap.setPermissionActionValue(permSettings.canModify());
        }
        if (this.addWrap.isOverriden()) {
            this.addWrap.setOverrulingPermissionActionValue(permSettings.canAdd());
        } else {
            this.addWrap.setPermissionActionValue(permSettings.canAdd());
        }
        if (this.delWrap.isOverriden()) {
            this.delWrap.setOverrulingPermissionActionValue(permSettings.canDelete());
        } else {
            this.delWrap.setPermissionActionValue(permSettings.canDelete());
        }
    }

    @Override
    public void addTableRow(DefaultTableModel model, ImageIcon defaultIcon) {
        model.addRow(new Object[]{this.icon != null ? this.icon : defaultIcon, this, this.viewWrap, this.addWrap, this.modWrap, this.delWrap});
    }

    @Override
    public String getOverrideText(int option) {
        switch (option) {
            case 1: {
                return this.viewWrap != null && this.viewWrap.isOverriden() ? this.viewWrap.getOverrulingPermissionText() : null;
            }
            case 2: {
                return this.modWrap != null && this.modWrap.isOverriden() ? this.modWrap.getOverrulingPermissionText() : null;
            }
            case 4: {
                return this.delWrap != null && this.delWrap.isOverriden() ? this.delWrap.getOverrulingPermissionText() : null;
            }
            case 8: {
                return this.addWrap != null && this.addWrap.isOverriden() ? this.addWrap.getOverrulingPermissionText() : null;
            }
        }
        return null;
    }

    @Override
    public void updatePerm(SpPermission oldPerm, SpPermission newPerm) {
        if (oldPerm == this.permission) {
            this.permission = newPerm;
        } else if (this.overrulingPermission == this.permission) {
            this.overrulingPermission = newPerm;
        }
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public int compareTo(PermissionEditorRowIFace o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    @Override
    public boolean isAdminPrincipal() {
        return this.adminPrincipal;
    }

    @Override
    public void setAdminPrincipal(boolean adminPrincipal) {
        this.adminPrincipal = adminPrincipal;
    }
}

