/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.specify.tasks.subpane.security.SecurityAdminPane;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorPanel
extends JPanel
implements ChangeListener,
DataChangeListener {
    private JButton saveBtn = UIHelper.createButton(UIRegistry.getResourceString("SAVE"));
    private boolean hasChanged = false;
    private FormValidator formValidator = null;

    public EditorPanel(final SecurityAdminPane sap) {
        this.saveBtn.setEnabled(false);
        AbstractAction saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sap.doSave(true);
            }
        };
        this.saveBtn.addActionListener(saveAction);
        UIHelper.addSaveKeyBinding(this.saveBtn, saveAction);
    }

    public void setFormValidator(FormValidator formValidator) {
        this.formValidator = formValidator;
    }

    public JButton getSaveBtn() {
        return this.saveBtn;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean changed) {
        if (!this.hasChanged && changed) {
            this.saveBtn.setEnabled(true);
        } else if (this.hasChanged && !changed) {
            this.saveBtn.setEnabled(false);
        }
        this.hasChanged = changed;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setHasChanged(true);
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        this.setHasChanged(this.formValidator.isFormValid());
    }
}

