/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.IconManager;
import javax.swing.ImageIcon;

public class DataModelObjBaseWrapper {
    private static IconManager.IconSize iconSize = IconManager.IconSize.Std20;
    private String title = null;
    private FormDataObjIFace dataObj;
    private ImageIcon icon;

    public DataModelObjBaseWrapper(FormDataObjIFace dataObj) {
        this.dataObj = dataObj;
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(dataObj.getTableId());
        if (dataObj instanceof SpPrincipal) {
            this.icon = IconManager.getIcon("AdminGroup", iconSize);
        } else if (dataObj instanceof SpecifyUser) {
            this.icon = IconManager.getIcon("person", iconSize);
        } else if (dataObj instanceof Institution) {
            this.icon = IconManager.getIcon("AdminInst", iconSize);
        } else if (dataObj instanceof Discipline) {
            String iconName = "";
            Discipline discipline = (Discipline)dataObj;
            this.icon = IconManager.getIcon(discipline.getType(), iconSize);
            if (this.icon == null) {
                this.icon = IconManager.getIcon(iconName, iconSize);
            }
        } else {
            if (tableInfo == null) {
                return;
            }
            this.icon = tableInfo.getIcon(iconSize);
        }
    }

    public FormDataObjIFace getDataObj() {
        return this.dataObj;
    }

    public void setDataObj(FormDataObjIFace dataObj) {
        this.dataObj = dataObj;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.dataObj.getIdentityTitle();
    }

    public boolean isInstitution() {
        return this.dataObj.getClass().equals(Institution.class);
    }

    public boolean isDivision() {
        return this.dataObj.getClass().equals(Division.class);
    }

    public boolean isDiscipline() {
        return this.dataObj.getClass().equals(Discipline.class);
    }

    public boolean isCollection() {
        return this.dataObj.getClass().equals(Collection.class);
    }

    public boolean isGroup() {
        if (this.dataObj instanceof SpPrincipal) {
            SpPrincipal pc = (SpPrincipal)this.dataObj;
            return GroupPrincipal.class.getCanonicalName().equals(pc.getGroupSubClass()) || AdminPrincipal.class.getCanonicalName().equals(pc.getGroupSubClass());
        }
        return this.dataObj.getClass().equals(GroupPrincipal.class);
    }

    public boolean isUser() {
        return this.dataObj.getClass().equals(UserPrincipal.class) || this.dataObj.getClass().equals(SpecifyUser.class);
    }

    public String getType() {
        return this.dataObj.getClass().getCanonicalName();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        if (this.title == null) {
            this.title = this.dataObj instanceof Discipline ? ((Discipline)this.dataObj).getName() : this.dataObj.getIdentityTitle();
        }
        return this.title;
    }
}

