/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import edu.ku.brc.af.auth.specify.permission.PermissionService;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayPanel;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.subpane.security.DataModelObjBaseWrapper;
import edu.ku.brc.specify.tasks.subpane.security.PermissionPanelEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AdminInfoSubPanelWrapper {
    private static final Logger log = Logger.getLogger(AdminInfoSubPanelWrapper.class);
    private JPanel displayPanel;
    private List<PermissionPanelEditor> permissionEditors;
    private TextFieldWithInfo agentTFWI = null;
    private SpPrincipal principal = null;
    private SpPrincipal principal2 = null;
    private SpecifyUser user = null;
    private DataModelObjBaseWrapper firstWrp = null;
    private DataModelObjBaseWrapper secondWrp = null;

    public AdminInfoSubPanelWrapper(JPanel displayPanel) {
        FormViewObj fvo;
        Component cbx;
        this.displayPanel = displayPanel;
        this.permissionEditors = new ArrayList<PermissionPanelEditor>();
        MultiView mv = this.getMultiView();
        if (mv != null && (cbx = (fvo = mv.getCurrentViewAsFormViewObj()).getControlByName("agent")) != null && cbx instanceof TextFieldWithInfo) {
            this.agentTFWI = (TextFieldWithInfo)cbx;
        }
    }

    public void clearPermissionEditors() {
        this.permissionEditors.clear();
    }

    public void addPermissionEditor(PermissionPanelEditor permissionEditor) {
        this.permissionEditors.add(permissionEditor);
    }

    public void removePermissionEditor(PermissionPanelEditor permissionEditor) {
        this.permissionEditors.remove(permissionEditor);
    }

    public JPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public List<PermissionPanelEditor> getPermissionEditors() {
        return this.permissionEditors;
    }

    public boolean setData(DataModelObjBaseWrapper firstWrpArg, DataModelObjBaseWrapper secondWrpArg, DataModelObjBaseWrapper collectionWrpArg, Division division) {
        SpPrincipal secondPrincipal;
        SpPrincipal firstPrincipal;
        String userType;
        boolean hasChanged;
        block15: {
            DataProviderSessionIFace session;
            block14: {
                this.firstWrp = firstWrpArg;
                this.secondWrp = secondWrpArg;
                hasChanged = false;
                if (!(this.displayPanel instanceof ViewBasedDisplayPanel)) {
                    return false;
                }
                FormDataObjIFace firstObj = this.firstWrp.getDataObj();
                FormDataObjIFace secondObj = this.secondWrp != null ? this.secondWrp.getDataObj() : null;
                ViewBasedDisplayPanel panel = (ViewBasedDisplayPanel)this.displayPanel;
                panel.setData(null);
                this.user = null;
                userType = null;
                firstPrincipal = null;
                secondPrincipal = null;
                session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        if (firstObj instanceof SpecifyUser) {
                            this.user = session.get(SpecifyUser.class, ((SpecifyUser)firstObj).getId());
                            userType = this.user.getUserType();
                            Collection collection = (Collection)collectionWrpArg.getDataObj();
                            firstPrincipal = this.user.getUserPrincipal(UserPrincipal.class.getCanonicalName(), collection.getId());
                            secondPrincipal = (SpPrincipal)secondObj;
                            panel.setData(this.user);
                            for (Agent agent : this.user.getAgents()) {
                                if (!agent.getDivision().getId().equals(division.getId())) continue;
                                this.agentTFWI.setValue(agent, null);
                                break block14;
                            }
                            break block14;
                        }
                        if (firstObj instanceof SpPrincipal) {
                            this.user = null;
                            firstPrincipal = session.get(SpPrincipal.class, ((SpPrincipal)firstObj).getId());
                            panel.setData(firstPrincipal);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (session != null) {
                            session.close();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
            }
            if (session != null) {
                session.close();
            }
        }
        if (firstPrincipal == null || this.permissionEditors.size() == 0) {
            return false;
        }
        this.principal = firstPrincipal;
        this.principal2 = secondPrincipal;
        Hashtable<String, SpPermission> existingPerms = PermissionService.getExistingPermissions(this.principal.getId());
        Hashtable<String, SpPermission> overrulingPerms = null;
        if (this.principal2 != null) {
            overrulingPerms = PermissionService.getExistingPermissions(this.principal2.getId());
        }
        for (PermissionPanelEditor editor : this.permissionEditors) {
            editor.updateData(firstPrincipal, secondPrincipal, existingPerms, overrulingPerms, userType);
        }
        return hasChanged;
    }

    public void savePermissionData(DataProviderSessionIFace session) throws Exception {
        MultiView mv = this.getMultiView();
        mv.getDataFromUI();
        Object obj = mv.getData();
        BusinessRulesIFace busRules = null;
        FormViewObj fvo = mv.getCurrentViewAsFormViewObj();
        if (fvo != null && fvo.getBusinessRules() != null) {
            busRules = fvo.getBusinessRules();
        }
        if (busRules != null) {
            if (obj instanceof SpecifyUser) {
                this.user = (SpecifyUser)obj;
                busRules.beforeMerge(this.user, session);
                this.user = session.merge(this.user);
                busRules.beforeSave(this.user, session);
            } else {
                obj = session.merge(obj);
                session.saveOrUpdate(obj);
            }
        } else {
            log.error((Object)"Error - Can't get business rules for form.");
        }
        this.principal = session.merge(this.principal);
        session.saveOrUpdate(this.principal);
        for (PermissionPanelEditor editor : this.permissionEditors) {
            editor.savePermissions(session);
        }
        if (this.user != null) {
            this.user = session.merge(this.user);
            this.firstWrp.setDataObj(this.user);
            this.secondWrp.setDataObj(this.principal2);
        } else {
            this.firstWrp.setDataObj(this.principal);
        }
    }

    public MultiView getMultiView() {
        if (this.displayPanel instanceof ViewBasedDisplayPanel) {
            ViewBasedDisplayPanel panel = (ViewBasedDisplayPanel)this.displayPanel;
            return panel.getMultiView();
        }
        return null;
    }
}

