/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class AddExistingUserDlg
extends CustomDialog {
    private final String AED = "AddExistingUserDlg.";
    private JList userList;
    private List<SpPrincipal> groups;

    public AddExistingUserDlg(List<SpPrincipal> groups) {
        super((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("AddExistingUserDlg.TITLE"), true, 3, null);
        this.groups = groups;
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("f:p:g", "p,5px,f:p:g,2dlu,p"));
        mainPB.addSeparator(UIRegistry.getResourceString("AddExistingUserDlg.SEL_ADD"), cc.xy(1, 1));
        this.userList = this.createUserList();
        mainPB.add((Component)UIHelper.createScrollPane(this.userList, true), cc.xy(1, 3));
        mainPB.setDefaultDialogBorder();
        this.contentPanel = mainPB.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    public static List<SpecifyUser> getUsers(List<SpPrincipal> groups) {
        StringBuilder usedIds = new StringBuilder();
        for (SpPrincipal grp : groups) {
            if (usedIds.length() != 0) {
                usedIds.append(',');
            }
            usedIds.append(grp.getId());
        }
        String sql = "SELECT DISTINCT u.SpecifyUserID FROM specifyuser u INNER JOIN specifyuser_spprincipal upr ON u.SpecifyUserID = upr.SpecifyUserID INNER JOIN spprincipal p ON upr.SpPrincipalID = p.SpPrincipalID WHERE p.SpPrincipalID in (" + usedIds.toString() + ")";
        HashSet<Integer> usersHash = new HashSet<Integer>();
        Vector<Integer> ids = BasicSQLUtils.queryForInts(sql);
        for (Integer id : ids) {
            usersHash.add(id);
        }
        sql = "SELECT DISTINCT u.SpecifyUserID FROM specifyuser u INNER JOIN specifyuser_spprincipal upr ON u.SpecifyUserID = upr.SpecifyUserID INNER JOIN spprincipal p ON upr.SpPrincipalID = p.SpPrincipalID WHERE NOT (p.SpPrincipalID in (" + usedIds.toString() + "))";
        HashSet<Integer> usersOKHash = new HashSet<Integer>();
        for (Integer id : BasicSQLUtils.queryForInts(sql)) {
            if (usersHash.contains(id)) continue;
            usersOKHash.add(id);
        }
        if (usersOKHash.size() > 0) {
            StringBuilder sb = new StringBuilder("FROM SpecifyUser WHERE id in (");
            int i = 0;
            for (Integer id : usersOKHash) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(id);
                ++i;
            }
            sb.append(") ORDER BY name");
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                List<SpecifyUser> list = session.getDataList(sb.toString());
                return list;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                session.close();
            }
        }
        return new ArrayList<SpecifyUser>();
    }

    private JList createUserList() {
        boolean listEmpty;
        DefaultListModel<Object> listModel;
        block7: {
            listModel = new DefaultListModel<Object>();
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    for (SpecifyUser user : AddExistingUserDlg.getUsers(this.groups)) {
                        listModel.addElement(user);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    session.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        boolean bl = listEmpty = listModel.size() == 0;
        if (listEmpty) {
            listModel.addElement(UIRegistry.getResourceString("AddExistingUserDlg.GRP_ALL"));
        }
        JList usrList = new JList(listModel);
        usrList.setEnabled(!listEmpty);
        usrList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AddExistingUserDlg.this.okBtn.doClick();
                }
            }
        });
        return usrList;
    }

    public SpecifyUser[] getSelectedUsers() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            Object[] objs = this.userList.getSelectedValues();
            int n = objs.length;
            if (this.btnPressed == 1 && n > 0) {
                SpecifyUser[] selectedUsers = new SpecifyUser[n];
                int i = 0;
                while (i < n) {
                    selectedUsers[i] = (SpecifyUser)objs[i];
                    session.attach(selectedUsers[i]);
                    selectedUsers[i].getSpPrincipals().size();
                    ++i;
                }
                SpecifyUser[] specifyUserArray = selectedUsers;
                return specifyUserArray;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            session.close();
        }
        return new SpecifyUser[0];
    }
}

