/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;

public class TreeLevelQRI
extends FieldQRI {
    protected final int rankId;
    protected final int treeDefId;
    protected final String realFldName;
    protected final String rankName;
    protected String tableAlias = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TreeLevelQRI(TableQRI parent, DBFieldInfo fi, int rankId, String realFldName, TreeDefIface<?, ?, ?> treeDef) throws Exception {
        super(parent, fi);
        this.rankId = rankId;
        this.realFldName = realFldName;
        if (treeDef == null) throw new NoTreeDefException(realFldName);
        this.treeDefId = treeDef.getTreeDefId();
        TreeDefItemIface treeDefItem = null;
        treeDefItem = (TreeDefItemIface)treeDef.getDefItemByRank(rankId);
        if (treeDefItem == null) throw new NoTreeDefItemException(rankId);
        this.title = treeDefItem.getDisplayText();
        this.rankName = treeDefItem.getName();
        if ("name".equals(realFldName)) return;
        this.title = String.valueOf(this.title) + " " + realFldName.substring(0, 1).toUpperCase() + realFldName.substring(1);
    }

    public int getRankId() {
        return this.rankId;
    }

    @Override
    public String getFieldName() {
        return this.title;
    }

    public String getRealFieldName() {
        return this.realFldName;
    }

    @Override
    protected String getFieldNameForStringId() {
        String result = this.rankName;
        if (!"name".equals(this.realFldName)) {
            result = String.valueOf(result) + " " + this.realFldName.substring(0, 1).toUpperCase() + this.realFldName.substring(1);
        }
        return result;
    }

    @Override
    public DBTableInfo getTableInfo() {
        return this.table.getTableTree().getTableInfo();
    }

    protected String getSQLFldName(TableAbbreviator ta) {
        this.tableAlias = ta.getAbbreviation(this.table.getTableTree());
        return String.valueOf(this.tableAlias) + ".id";
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public int getTreeDefId() {
        return this.treeDefId;
    }

    public Class<?> getTreeDataClass() {
        return this.getTableInfo().getClassObj();
    }

    protected String getTreeDefIdFldName() {
        return "definition";
    }

    @Override
    public String getSQLFldSpec(TableAbbreviator ta, boolean forWhereClause, boolean forSchemaExport) {
        String result = this.getSQLFldName(ta);
        return result;
    }

    @Override
    public boolean isFieldHidden() {
        return false;
    }

    protected String capitalize(String toCap) {
        return toCap.substring(0, 1).toUpperCase().concat(toCap.substring(1));
    }

    protected int getMaxNodeConditions() {
        return 523;
    }

    @Override
    public String getNullCondition(TableAbbreviator ta, boolean forSchemaExport, boolean negate) {
        String result = "exists (select treetbl.nodeNumber from " + this.table.getTableTree().getName() + " treetbl where " + "treetbl.rankId = " + this.rankId + " and " + ta.getAbbreviation(this.table.getTableTree()) + ".nodeNumber between " + "treetbl.nodeNumber and treetbl.highestChildNodeNumber and " + ta.getAbbreviation(this.table.getTableTree()) + ".definition = treetbl.definition)";
        if (!negate) {
            result = "not " + result;
        }
        return result;
    }

    public String getNodeNumberCriteria(String criteria, TableAbbreviator ta, String operStr, boolean negate) throws ParseException {
        if (criteria.equals("'%'") || criteria.equals("'*'")) {
            return null;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
            TreeDefIface<?, ?, ?> treeDef = spMgr.getTreeDefForClass(this.getTableInfo().getClassObj());
            String className = this.getTableInfo().getClassObj().getSimpleName();
            List<?> matches = session.getDataList("from " + className + " where " + this.realFldName + " " + operStr + " " + criteria + " and " + className + "TreeDefId = " + treeDef.getTreeDefId() + " and rankId =" + String.valueOf(this.rankId));
            LinkedList<Pair<Integer, Integer>> nodeInfo = new LinkedList<Pair<Integer, Integer>>();
            if (matches.size() == 0) {
                return "2+2=2";
            }
            if (this.getMaxNodeConditions() > 0 && matches.size() > this.getMaxNodeConditions()) {
                throw new ParseException(UIRegistry.getResourceString("QB_TOO_MANY_TREE_RANK_MATCHES"), -1);
            }
            for (Object match : matches) {
                Treeable node = (Treeable)match;
                nodeInfo.add(new Pair<Integer, Integer>(node.getNodeNumber(), node.getHighestChildNodeNumber()));
            }
            StringBuilder result = new StringBuilder();
            for (Pair pair : nodeInfo) {
                if (result.length() > 0) {
                    if (negate) {
                        result.append(" and ");
                    } else {
                        result.append(" or ");
                    }
                }
                result.append(String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + ".nodeNumber");
                if (negate) {
                    result.append(" not ");
                }
                result.append(" between ");
                result.append(pair.getFirst());
                result.append(" and ");
                result.append(pair.getSecond());
            }
            String string = "(" + result.toString() + ")";
            return string;
        }
        finally {
            session.close();
        }
    }

    public class NoTreeDefException
    extends Exception {
        public NoTreeDefException(String fldName) {
            super("Unable to determine tree for " + fldName);
        }
    }

    public class NoTreeDefItemException
    extends Exception {
        public NoTreeDefItemException(int rankId) {
            super("No TreeDefItem for " + String.valueOf(rankId));
        }
    }
}

