/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTreePathPoint;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TableTree
implements Cloneable,
Comparable<TableTree> {
    protected String name;
    protected String field;
    protected TableTree parent = null;
    protected Vector<TableTree> kids = new Vector();
    protected String abbrev = null;
    protected DBTableInfo tableInfo = null;
    protected boolean isAlias = false;
    protected TableQRI tableQRI = null;

    public TableTree(String name, String field, boolean isAlias) {
        this.name = name;
        this.field = field;
        this.isAlias = isAlias;
        this.processTblInfo();
    }

    public TableTree(String name, String field, String abbrev, DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.processTblInfo();
        this.name = name;
        this.field = field;
        this.abbrev = abbrev;
    }

    protected void processTblInfo() {
        if (this.tableInfo != null) {
            this.tableQRI = new TableQRI(this);
            for (DBFieldInfo fi : this.tableInfo.getFields()) {
                this.tableQRI.addField(fi);
            }
        }
    }

    public void setParent(TableTree parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbrev() {
        if (this.abbrev != null) {
            return this.abbrev;
        }
        if (this.tableInfo != null) {
            return this.tableInfo.getAbbrev();
        }
        throw new RuntimeException("TableInfo is null for [" + this.name + "]");
    }

    public String getField() {
        return this.field;
    }

    public TableTree getParent() {
        return this.parent;
    }

    public DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public int getKids() {
        return this.kids.size();
    }

    public TableTree getKid(int k) {
        return this.kids.get(k);
    }

    public TableTree addKid(TableTree kid) {
        if (this.kids.add(kid)) {
            kid.setParent(this);
            return kid;
        }
        return null;
    }

    public void clearKids() {
        this.kids.clear();
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public void setAlias(boolean isAlias) {
        this.isAlias = isAlias;
    }

    @Override
    public int compareTo(TableTree o) {
        return this.name.compareTo(o.name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setTableInfo(DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public Object clone() throws CloneNotSupportedException {
        TableTree obj = (TableTree)super.clone();
        obj.kids = new Vector();
        for (TableTree tt : this.kids) {
            TableTree newKid = (TableTree)tt.clone();
            obj.addKid(newKid);
        }
        if (this.tableQRI != null) {
            obj.setTableQRIClone(this.tableQRI);
        }
        return obj;
    }

    public TableQRI getTableQRI() {
        return this.tableQRI;
    }

    public void setTableQRIClone(TableQRI tableQRI) throws CloneNotSupportedException {
        this.tableQRI = (TableQRI)tableQRI.clone();
        this.tableQRI.setTableTree(this);
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && this.tableInfo.getTableId() == ((TableTree)obj).getTableInfo().getTableId() && this.field.equals(((TableTree)obj).getField());
    }

    public List<TableTreePathPoint> getPathFromRoot() {
        LinkedList<TableTreePathPoint> result = new LinkedList<TableTreePathPoint>();
        result.add(new TableTreePathPoint(this));
        TableTree p = this.getParent();
        while (p != null && p.getTableInfo() != null) {
            result.addFirst(new TableTreePathPoint(p));
            p = p.getParent();
        }
        return result;
    }

    public String getPathFromRootAsString() {
        List<TableTreePathPoint> path = this.getPathFromRoot();
        StringBuilder result = new StringBuilder();
        boolean comma = false;
        for (TableTreePathPoint ttpp : path) {
            if (comma) {
                result.append(",");
            } else {
                comma = true;
            }
            result.append(ttpp.toString());
        }
        return result.toString();
    }
}

