/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.qb.DateAccessorQRI;
import edu.ku.brc.specify.tasks.subpane.qb.ExpandableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import edu.ku.brc.specify.tasks.subpane.qb.TreeLevelQRI;
import java.util.Calendar;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TableQRI
extends ExpandableQRI {
    protected static final Logger log = Logger.getLogger(TableQRI.class);
    protected DBRelationshipInfo relationship = null;
    protected boolean relChecked = false;

    public TableQRI(TableTree tableTree) {
        super(tableTree);
        this.determineRel();
    }

    public void addField(DBFieldInfo fieldInfo) {
        this.fields.add(new FieldQRI(this, fieldInfo));
        if (Calendar.class.isAssignableFrom(fieldInfo.getDataClass()) && this.addDateAccessors(fieldInfo)) {
            this.fields.add(new DateAccessorQRI(this, fieldInfo, DateAccessorQRI.DATEPART.NumericDay));
            this.fields.add(new DateAccessorQRI(this, fieldInfo, DateAccessorQRI.DATEPART.NumericMonth));
            this.fields.add(new DateAccessorQRI(this, fieldInfo, DateAccessorQRI.DATEPART.NumericYear));
        }
    }

    protected boolean addDateAccessors(DBFieldInfo fieldInfo) {
        return true;
    }

    public void addField(FieldQRI fieldQRI) {
        fieldQRI.setTable(this);
        this.fields.add(fieldQRI);
    }

    public void addFieldClone(FieldQRI fieldQRI) throws CloneNotSupportedException {
        FieldQRI newField = (FieldQRI)fieldQRI.clone();
        newField.setTable(this);
        this.fields.add(newField);
    }

    protected void determineRel() {
        Class<?> classObj = this.getTableTree().getTableInfo().getClassObj();
        LinkedList<DBRelationshipInfo> rels = new LinkedList<DBRelationshipInfo>();
        if (this.getTableTree().getParent() != null && this.getTableTree().getParent().getTableInfo() != null) {
            for (DBRelationshipInfo rel : this.getTableTree().getParent().getTableInfo().getRelationships()) {
                if (!rel.getDataClass().equals(classObj) || !this.isRelevantRel(rel, classObj)) continue;
                rels.add(rel);
            }
            if (rels.size() == 1) {
                this.relationship = (DBRelationshipInfo)rels.get(0);
                return;
            }
            if (rels.size() > 1 && this.tableTree.getField() != null) {
                for (DBRelationshipInfo rel : rels) {
                    if (!rel.getName().equalsIgnoreCase(this.tableTree.getField())) continue;
                    this.relationship = rel;
                    return;
                }
            }
            if (this.relationship == null && this.isLocToCollectingEventsLink()) {
                this.relationship = this.buildLocToCollectingEventsRel();
            }
            if (this.relationship == null) {
                log.error((Object)("Unable to determine relationship for " + this.getTableTree().getField() + " <-> " + this.getTableTree().getParent().getField()));
            }
        }
    }

    protected DBRelationshipInfo buildLocToCollectingEventsRel() {
        return new DBRelationshipInfo("collectingEvents", DBRelationshipInfo.RelationshipType.OneToMany, CollectingEvent.class.getName(), null, "locality", null, false, false, false, false);
    }

    protected boolean isLocToCollectingEventsLink() {
        return this.tableTree.getParent() != null && this.tableTree.getParent().getTableInfo().getClassObj().equals(Locality.class) && this.getTableTree().getTableInfo().getClassObj().equals(CollectingEvent.class) && this.tableTree.getField().equals("collectingEvents");
    }

    protected boolean isRelevantRel(DBRelationshipInfo rel, Class<?> classObj) {
        if (classObj.equals(Agent.class)) {
            if (rel.getColName() == null) {
                return true;
            }
            if (!rel.getColName().equalsIgnoreCase("modifiedbyagentid") && !rel.getColName().equalsIgnoreCase("createdbyagentid")) {
                return !this.tableTree.getField().equals("modifiedByAgent") && !this.tableTree.getField().equals("createdByAgent");
            }
            return !(rel.getColName().equalsIgnoreCase("modifiedbyagentid") && !this.tableTree.getField().equals("modifiedByAgent") || rel.getColName().equalsIgnoreCase("createdbyagentid") && !this.tableTree.getField().equals("createdByAgent"));
        }
        return true;
    }

    public DBRelationshipInfo getRelationship() {
        if (this.relationship == null && !this.relChecked) {
            this.determineRel();
            this.relChecked = true;
        }
        return this.relationship;
    }

    @Override
    public String getTitle() {
        if (this.relationship == null) {
            return super.getTitle();
        }
        return this.relationship.getTitle();
    }

    @Override
    public void setTableTree(TableTree tableTree) {
        super.setTableTree(tableTree);
        this.determineRel();
        if (this.getHostCollId(this.getDefaultHostTaxonRelName()) != null) {
            this.rebuildTreeLevelQRIs();
        }
    }

    protected String getDefaultHostTaxonRelName() {
        return "Host Taxon";
    }

    protected Integer getHostCollId(String hostTaxonRelName) {
        SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        String sql = String.format("SELECT RightSideCollectionID FROM collectionreltype WHERE Name = '%s' AND LeftSideCollectionID = %d", hostTaxonRelName, spMgr.getClassObject(Collection.class).getId());
        return BasicSQLUtils.getCount(sql);
    }

    protected TreeDefIface<?, ?, ?> findTreeDef() {
        SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        if (this.getTableTree().getField().equalsIgnoreCase("HostTaxon")) {
            TaxonTreeDef result = null;
            Integer hostCollId = this.getHostCollId(this.getDefaultHostTaxonRelName());
            if (hostCollId != null) {
                DataProviderSessionIFace session = null;
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Collection rightCol = session.get(Collection.class, hostCollId);
                    if (rightCol != null && rightCol.getDiscipline() != null) {
                        result = rightCol.getDiscipline().getTaxonTreeDef();
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            return result;
        }
        return spMgr.getTreeDefForClass(this.getTableInfo().getClassObj());
    }

    protected void rebuildTreeLevelQRIs() {
        if (Taxon.class.isAssignableFrom(this.ti.getClassObj())) {
            int f = this.fields.size() - 1;
            while (f > -1) {
                if (this.fields.get(f) instanceof TreeLevelQRI) {
                    this.fields.remove(f);
                }
                --f;
            }
            try {
                TreeDefIface<?, ?, ?> treeDef = this.findTreeDef();
                TreeSet defItems = new TreeSet(new Comparator<TreeDefItemIface<?, ?, ?>>(){

                    @Override
                    public int compare(TreeDefItemIface<?, ?, ?> o1, TreeDefItemIface<?, ?, ?> o2) {
                        Integer r1 = o1.getRankId();
                        Integer r2 = o2.getRankId();
                        return r1.compareTo(r2);
                    }
                });
                defItems.addAll(treeDef.getTreeDefItems());
                for (TreeDefItemIface defItem : defItems) {
                    if (defItem.getRankId() <= 0) continue;
                    try {
                        this.addField(new TreeLevelQRI(this, null, defItem.getRankId(), "name", treeDef));
                        if (!(defItem instanceof TaxonTreeDefItem)) continue;
                        this.addField(new TreeLevelQRI(this, null, defItem.getRankId(), "author", treeDef));
                    }
                    catch (Exception ex) {
                        if (ex instanceof TreeLevelQRI.NoTreeDefItemException) {
                            log.error((Object)ex);
                            continue;
                        }
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean hasMultiChildren() {
        return this.relationship != null && (this.relationship.getType() == DBRelationshipInfo.RelationshipType.OneToMany || this.relationship.getType() == DBRelationshipInfo.RelationshipType.ManyToMany);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        TableQRI result = (TableQRI)super.clone();
        result.fields = new Vector(this.fields.size());
        for (FieldQRI f : this.fields) {
            result.addFieldClone(f);
        }
        return result;
    }
}

