/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.specify.tasks.subpane.qb.SortElement;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class ResultRowComparator
implements Comparator<Vector<Object>> {
    protected final List<SortElement> sortDef;
    protected final boolean adjustForRecIds;

    public ResultRowComparator(List<SortElement> sortDef, boolean adjustForRecIds) {
        this.sortDef = sortDef;
        this.adjustForRecIds = adjustForRecIds;
    }

    public ResultRowComparator(List<SortElement> sortDef) {
        this.sortDef = sortDef;
        this.adjustForRecIds = false;
    }

    @Override
    public int compare(Vector<Object> o1, Vector<Object> o2) {
        for (SortElement s : this.sortDef) {
            int result = this.doCompare(s, o1, o2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    protected int doCompare(SortElement s, Vector<Object> o1, Vector<Object> o2) {
        Object obj2;
        int column = this.adjustForRecIds ? s.getColumn() + 1 : s.getColumn();
        Object obj1 = s.getDirection() == 0 ? o1.get(column) : o2.get(column);
        Object object = obj2 = s.getDirection() == 0 ? o2.get(column) : o1.get(column);
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        Class<?> cls = obj1.getClass();
        if (cls.equals(obj2.getClass()) && Comparable.class.isAssignableFrom(cls)) {
            return ((Comparable)obj1).compareTo(obj2);
        }
        return obj1.toString().compareTo(obj2.toString());
    }
}

