/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import org.apache.log4j.Logger;

public class ReportParametersPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger(ReportParametersPanel.class);
    protected final JasperReport jasperReport;
    protected final boolean userPanel;
    protected int paramCount = 0;
    protected JTextField[] paramTexts;
    protected String[] paramNames;

    public ReportParametersPanel(JasperReport jasperReport, boolean userPanel) {
        this.jasperReport = jasperReport;
        this.userPanel = userPanel;
        this.createUI();
    }

    protected boolean shouldDisplay(JRParameter param) {
        return param.isSystemDefined() != this.userPanel && param.isForPrompting();
    }

    protected String getRowLayoutAndCountParams() {
        String result = "10dlu";
        JRParameter[] params = this.jasperReport.getParameters();
        int p = 0;
        while (p < params.length) {
            JRParameter param = params[p];
            if (this.shouldDisplay(param)) {
                result = String.valueOf(result) + ", f:p, 2dlu";
                ++this.paramCount;
            }
            ++p;
        }
        return result;
    }

    public void createUI() {
        try {
            Map defaultVals = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)this.jasperReport, null);
            PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, r:p, 2dlu, f:85dlu:g, 5dlu", this.getRowLayoutAndCountParams()), (JPanel)this);
            JRParameter[] params = this.jasperReport.getParameters();
            int currentParam = 0;
            CellConstraints cc = new CellConstraints();
            this.paramTexts = new JTextField[this.paramCount];
            this.paramNames = new String[this.paramCount];
            int p = 0;
            while (p < params.length) {
                JRParameter param = params[p];
                if (this.shouldDisplay(param)) {
                    Object paramValObj = defaultVals.get(param.getName());
                    String paramVal = paramValObj != null ? paramValObj.toString() : null;
                    this.paramTexts[currentParam] = new JTextField(paramVal);
                    this.paramNames[currentParam] = param.getName();
                    pb.add((Component)new JLabel(param.getName()), cc.xy(2, 2 * currentParam + 2));
                    pb.add((Component)this.paramTexts[currentParam], cc.xy(4, 2 * currentParam + 2));
                    ++currentParam;
                }
                ++p;
            }
            this.validate();
        }
        catch (JRException jrex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ReportParametersPanel.class, (Exception)((Object)jrex));
            throw new RuntimeException(jrex);
        }
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public Pair<String, String> getParam(int paramIdx) {
        return new Pair<String, String>(this.paramNames[paramIdx], this.paramTexts[paramIdx].getText());
    }
}

