/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RelQRI
extends FieldQRI {
    protected DBRelationshipInfo relationshipInfo;

    public RelQRI(TableQRI parent, DBRelationshipInfo ri) {
        super(parent, null);
        this.relationshipInfo = ri;
        try {
            this.iconName = Class.forName(ri.getClassName()).getSimpleName();
            this.title = ri.getTitle();
            if (StringUtils.isEmpty((String)this.title)) {
                this.title = UIHelper.makeNamePretty(this.iconName);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RelQRI.class, ex);
            ex.printStackTrace();
            this.iconName = "BlankIcon";
            this.title = "????";
        }
    }

    @Override
    public void setIsInUse(Boolean isInUse) {
        super.setIsInUse(isInUse);
        this.table.setIsInUse(isInUse);
    }

    @Override
    public String getFieldName() {
        if (this.fi != null) {
            return super.getFieldName();
        }
        if (this.relationshipInfo != null) {
            return this.relationshipInfo.getName();
        }
        return this.table.getTableInfo().getName();
    }

    @Override
    public DBTableInfo getTableInfo() {
        return this.table.getTableInfo();
    }

    public DataObjDataFieldFormatIFace getDataObjFormatter() {
        List<DataObjSwitchFormatter> sfs = DataObjFieldFormatMgr.getInstance().getFormatterList(this.getTableInfo().getClassObj());
        for (DataObjSwitchFormatter sf : sfs) {
            if (!sf.isDefault() || !sf.isSingle()) continue;
            return sf.getSingle();
        }
        return null;
    }

    protected String deCapitalize(String toDecap) {
        return toDecap.substring(0, 1).toLowerCase().concat(toDecap.substring(1));
    }

    @Override
    public String getSQLFldSpec(TableAbbreviator ta, boolean forWhereClause, boolean forSchemaExport) {
        String formatField;
        DataObjDataFieldFormatIFace formatter;
        if (this.relationshipInfo.getType().equals((Object)DBRelationshipInfo.RelationshipType.OneToMany) || this.relationshipInfo.getType().equals((Object)DBRelationshipInfo.RelationshipType.ZeroOrOne)) {
            String name;
            if (StringUtils.isEmpty((String)this.relationshipInfo.getColName())) {
                name = this.table.getTableTree().getParent().getTableInfo().getIdFieldName();
            } else {
                name = this.deCapitalize(this.relationshipInfo.getColName());
                if (name.endsWith("ID")) {
                    name = String.valueOf(name.substring(0, name.length() - 2)) + "Id";
                }
            }
            return String.valueOf(ta.getAbbreviation(this.table.getTableTree().getParent())) + "." + name;
        }
        if (this.relationshipInfo.getType() == DBRelationshipInfo.RelationshipType.ManyToOne && !forWhereClause && (formatter = this.getDataObjFormatter()) != null && (formatField = formatter.getSingleField()) != null) {
            return String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + "." + formatField;
        }
        return String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + "." + this.deCapitalize(this.table.getTableInfo().getClassObj().getSimpleName()) + "Id";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public DBRelationshipInfo getRelationshipInfo() {
        return this.relationshipInfo;
    }

    @Override
    public boolean isFieldHidden() {
        if (this.relationshipInfo.isHidden()) {
            return true;
        }
        return DBTableIdMgr.getInstance().getInfoByTableName(this.relationshipInfo.getDataClass().getSimpleName().toLowerCase()).isHidden();
    }

    public static String stripDescriptiveStuff(String lbl) {
        if (lbl.endsWith(" " + UIRegistry.getResourceString("QB_AGGREGATED"))) {
            return lbl.substring(0, lbl.length() - UIRegistry.getResourceString("QB_AGGREGATED").length() - 1);
        }
        if (lbl.endsWith(" " + UIRegistry.getResourceString("QB_FORMATTED"))) {
            return lbl.substring(0, lbl.length() - UIRegistry.getResourceString("QB_FORMATTED").length() - 1);
        }
        if (lbl.endsWith("_" + UIRegistry.getResourceString("QB_AGGREGATED"))) {
            return lbl.substring(0, lbl.length() - UIRegistry.getResourceString("QB_AGGREGATED").length() - 1);
        }
        if (lbl.endsWith("_" + UIRegistry.getResourceString("QB_FORMATTED"))) {
            return lbl.substring(0, lbl.length() - UIRegistry.getResourceString("QB_FORMATTED").length() - 1);
        }
        return lbl;
    }
}

