/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.dbsupport.RecordTypeCodeBuilder;
import edu.ku.brc.specify.tasks.subpane.qb.DateAccessorQRI;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.PickListCriteriaCombo;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanelContainerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.RelQRI;
import edu.ku.brc.specify.tasks.subpane.qb.SortElement;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import edu.ku.brc.specify.tasks.subpane.qb.TreeLevelQRI;
import edu.ku.brc.specify.ui.CatalogNumberFormatter;
import edu.ku.brc.specify.ui.CatalogNumberUIFieldFormatter;
import edu.ku.brc.specify.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.specify.ui.db.PickListTableAdapter;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MultiStateIconButon;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DateConverter;
import edu.ku.brc.util.Pair;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QueryFieldPanel
extends JPanel
implements ActionListener {
    protected static final Logger log = Logger.getLogger(QueryFieldPanel.class);
    protected String noMappingStr = UIRegistry.getResourceString("WB_NO_MAPPING");
    protected QueryFieldPanelContainerIFace ownerQuery;
    protected String columnDefStr;
    protected ImageIcon blankIcon = IconManager.getIcon("BlankIcon", IconManager.IconSize.Std24);
    protected boolean hasFocus = false;
    protected Color bgColor = null;
    protected JLabel fieldLabel;
    protected boolean labelQualified = false;
    protected JButton closeBtn;
    protected JLabel schemaItemLabel;
    protected JLabel iconLabel;
    protected ImageIcon icon;
    protected IconManager.IconSize iconSize = IconManager.IconSize.Std24;
    protected JCheckBox isNotCheckbox;
    protected JComboBox operatorCBX;
    protected JComponent criteria;
    protected MultiStateIconButon sortCheckbox;
    protected JCheckBox isDisplayedCkbx;
    protected JCheckBox isPromptCkbx;
    protected JCheckBox isEnforcedCkbx;
    protected JComponent[] comps;
    protected FieldQRI fieldQRI;
    protected SpQueryField queryField = null;
    protected SpExportSchemaItem schemaItem = null;
    protected boolean conditionForSchema = false;
    protected PickListDBAdapterIFace pickList = null;
    protected FormValidator validator;
    protected QueryFieldPanel thisItem;
    protected String[] labelStrs;
    protected SpQueryField.OperatorType[] comparators;
    protected DateConverter dateConverter = null;
    protected boolean selected = false;

    protected PickListDBAdapterIFace buildPickList() {
        if (this.fieldQRI instanceof RelQRI) {
            PickListDBAdapterIFace pl = PickListDBAdapterFactory.getInstance().create(this.fieldQRI.getTableInfo().getName(), false);
            if (pl instanceof PickListTableAdapter) {
                return pl;
            }
            return null;
        }
        if (this.fieldQRI != null && this.fieldQRI.getTableInfo() != null && this.fieldQRI.getFieldInfo() != null) {
            if (StringUtils.isNotEmpty((String)this.fieldQRI.getFieldInfo().getPickListName())) {
                return PickListDBAdapterFactory.getInstance().create(this.fieldQRI.getFieldInfo().getPickListName(), false);
            }
            return RecordTypeCodeBuilder.getTypeCode(this.fieldQRI.getFieldInfo());
        }
        return null;
    }

    public QueryFieldPanel(QueryFieldPanelContainerIFace ownerQuery, FieldQRI fieldQRI, String columnDefStr, Component saveBtn, SpQueryField queryField, SpExportSchemaItem schemaItem) {
        this(ownerQuery, fieldQRI, IconManager.IconSize.Std24, columnDefStr, saveBtn, queryField, schemaItem, false);
    }

    public QueryFieldPanel(QueryFieldPanelContainerIFace ownerQuery, FieldQRI fieldQRI, String columnDefStr, Component saveBtn, SpQueryField queryField, SpExportSchemaItem schemaItem, boolean conditionForSchema) {
        this(ownerQuery, fieldQRI, IconManager.IconSize.Std24, columnDefStr, saveBtn, queryField, schemaItem, conditionForSchema);
    }

    public QueryFieldPanel(QueryFieldPanelContainerIFace ownerQuery, FieldQRI fieldQRI, IconManager.IconSize iconSize, String columnDefStr, Component saveBtn, SpQueryField queryField, SpExportSchemaItem schemaItem, boolean conditionForSchema) {
        this.ownerQuery = ownerQuery;
        this.conditionForSchema = conditionForSchema;
        this.labelStrs = this.ownerQuery.isPromptMode() ? (!conditionForSchema && schemaItem == null ? new String[]{" ", UIRegistry.getResourceString("QB_FIELD"), UIRegistry.getResourceString("QB_NOT"), UIRegistry.getResourceString("QB_OPERATOR"), UIRegistry.getResourceString("QB_CRITERIA"), UIRegistry.getResourceString("QB_SORT")} : new String[]{UIRegistry.getResourceString("QB_SCHEMAITEM"), " ", UIRegistry.getResourceString("QB_FIELD"), UIRegistry.getResourceString("QB_NOT"), UIRegistry.getResourceString("QB_OPERATOR"), UIRegistry.getResourceString("QB_CRITERIA"), UIRegistry.getResourceString("QB_SORT"), UIRegistry.getResourceString("QB_ALLOW_NULL")}) : (schemaItem == null ? new String[]{" ", " ", UIRegistry.getResourceString("QB_NOT"), UIRegistry.getResourceString("QB_OPERATOR"), UIRegistry.getResourceString("QB_CRITERIA"), UIRegistry.getResourceString("QB_SORT"), UIRegistry.getResourceString("QB_DISPLAY"), UIRegistry.getResourceString("QB_PROMPT"), UIRegistry.getResourceString("QB_ALWAYS_ENFORCE"), " ", " "} : new String[]{UIRegistry.getResourceString("QB_SCHEMAITEM"), " ", " ", UIRegistry.getResourceString("QB_NOT"), UIRegistry.getResourceString("QB_OPERATOR"), UIRegistry.getResourceString("QB_CRITERIA"), UIRegistry.getResourceString("QB_SORT"), UIRegistry.getResourceString("QB_ALLOW_NULL"), " ", " "});
        this.iconSize = iconSize;
        this.fieldQRI = fieldQRI;
        if (fieldQRI != null && (fieldQRI.getDataClass().equals(Calendar.class) || fieldQRI.getDataClass().equals(Timestamp.class))) {
            this.dateConverter = new DateConverter();
        }
        this.pickList = this.buildPickList();
        this.columnDefStr = columnDefStr;
        this.thisItem = this;
        this.validator = new FormValidator(null);
        if (saveBtn != null) {
            this.validator.addEnableItem(saveBtn, FormValidator.EnableType.ValidAndChangedItems);
        }
        this.validator.setEnabled(true);
        boolean createAsHeader = StringUtils.isEmpty((String)columnDefStr);
        this.schemaItem = schemaItem;
        int[] widths = this.buildControlLayout(iconSize, createAsHeader, saveBtn);
        if (createAsHeader) {
            this.removeAll();
            this.buildLabelLayout(widths);
            ownerQuery.setColumnDefStr(this.columnDefStr);
        }
        this.setQueryField(queryField);
        if (!createAsHeader && this.getFieldInfo() != null) {
            this.setToolTipText(this.getQualifiedLabel(fieldQRI.getTableTree(), true));
        }
    }

    public void updateQueryField() {
        this.updateQueryField(this.queryField);
    }

    protected String getCriteriaText(boolean useValues) {
        if (this.criteria instanceof JTextField) {
            return ((JTextField)this.criteria).getText();
        }
        if (this.criteria instanceof PickListCriteriaCombo) {
            return ((PickListCriteriaCombo)this.criteria).getText(useValues);
        }
        if (this.criteria instanceof CriteriaPair) {
            return ((CriteriaPair)this.criteria).getCriteriaText();
        }
        throw new RuntimeException("Unrecognized criteria component: " + this.criteria.getClass());
    }

    public void updateQueryField(SpQueryField qField) {
        if (qField != null && !this.ownerQuery.isPromptMode()) {
            qField.setIsDisplay(this.isDisplayedCkbx.isSelected());
            qField.setIsPrompt(this.isPromptCkbx.isSelected());
            if (this.conditionForSchema) {
                qField.setAllowNulls(this.isEnforcedCkbx.isSelected());
            } else {
                qField.setAlwaysFilter(this.isEnforcedCkbx.isSelected());
            }
            qField.setIsNot(this.isNotCheckbox.isSelected());
            if (this.validator.hasChanged() && qField.getSpQueryFieldId() != null) {
                FormHelper.updateLastEdittedInfo(qField);
            }
            qField.setSortType((byte)this.sortCheckbox.getState());
            qField.setOperStart((byte)this.operatorCBX.getSelectedIndex());
            qField.setStartValue(this.getCriteriaText(false));
            String lbl = this.getLabel();
            if (this.fieldQRI instanceof RelQRI) {
                lbl = RelQRI.stripDescriptiveStuff(lbl);
            }
            qField.setContextTableIdent(this.fieldQRI.getTableInfo().getTableId());
            qField.setColumnAliasTitle(lbl, this.fieldQRI instanceof TreeLevelQRI);
            qField.setIsRelFld(this.fieldQRI instanceof RelQRI);
            Vector<Integer> idList = new Vector<Integer>();
            TableQRI parent = this.fieldQRI.getTable();
            while (parent != null) {
                idList.add(parent.getTableInfo().getTableId());
                parent = parent.getTableTree().getParent().getTableQRI();
            }
            String tablesIds = this.fieldQRI.getTableTree().getPathFromRootAsString();
            log.debug((Object)tablesIds);
            qField.setTableList(tablesIds);
            qField.setStringId(this.getStringId());
        } else {
            log.error((Object)"QueryField is null or ownerQuery is prompt only. Unable to update database object.");
        }
    }

    public SpQueryField getQueryField() {
        return this.queryField;
    }

    protected void setCriteriaText(String text, String text2, SpQueryField.OperatorType op) {
        if (op != null && op.equals((Object)SpQueryField.OperatorType.BETWEEN) && !(this.criteria instanceof CriteriaPair)) {
            log.error((Object)"operator is 'BETWEEN' but criteria control is not CriteriaPair");
        }
        if (this.criteria instanceof JTextField) {
            ((JTextField)this.criteria).setText(text);
        } else if (this.criteria instanceof PickListCriteriaCombo) {
            ((PickListCriteriaCombo)this.criteria).setSelections(text);
        } else if (this.criteria instanceof CriteriaPair) {
            ((CriteriaPair)this.criteria).setCriteriaText(text, text2, op);
        } else {
            throw new RuntimeException("Unrecognized criteria component: " + this.criteria.getClass());
        }
    }

    private void setQueryField(SpQueryField queryField) {
        this.queryField = queryField;
        if (queryField != null) {
            if (queryField.getSpQueryFieldId() != null) {
                this.isNotCheckbox.setSelected(queryField.getIsNot());
                try {
                    this.operatorCBX.setSelectedIndex(queryField.getOperStart().byteValue());
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)("unable to set operator index for " + queryField.getStringId() + ": " + ex));
                    this.operatorCBX.setSelectedIndex(0);
                }
                this.setCriteriaText(queryField.getStartValue(), queryField.getEndValue(), (SpQueryField.OperatorType)((Object)this.operatorCBX.getSelectedItem()));
                this.sortCheckbox.setState(queryField.getSortType().byteValue());
                this.sortCheckbox.setEnabled(queryField.getIsDisplay());
                if (!this.ownerQuery.isPromptMode()) {
                    this.isDisplayedCkbx.setSelected(queryField.getIsDisplay());
                    this.isPromptCkbx.setSelected(queryField.getIsPrompt() == null ? true : queryField.getIsPrompt());
                    if (this.conditionForSchema || this.schemaItem != null) {
                        this.isEnforcedCkbx.setSelected(queryField.getAllowNulls() == null ? false : queryField.getAllowNulls());
                    } else {
                        this.isEnforcedCkbx.setSelected(queryField.getAlwaysFilter() == null ? true : queryField.getAlwaysFilter());
                    }
                } else if (this.conditionForSchema) {
                    this.isEnforcedCkbx.setSelected(queryField.getAllowNulls() == null ? true : queryField.getAllowNulls());
                }
                this.validator.setHasChanged(false);
            } else {
                this.validator.reset(true);
                this.validator.setHasChanged(true);
                this.queryField.setStringId(this.fieldQRI.getStringId());
            }
            this.validator.validateForm();
            this.validator.wasValidated(null);
        }
    }

    public void setField(FieldQRI fqri, SpQueryField qf) {
        String fieldLabelText;
        this.fieldQRI = fqri;
        if (this.fieldQRI != null && (this.fieldQRI.getDataClass().equals(Calendar.class) || this.fieldQRI.getDataClass().equals(Timestamp.class))) {
            this.dateConverter = new DateConverter();
        }
        if (this.fieldQRI != null) {
            this.icon = IconManager.getIcon(this.fieldQRI.getTableInfo().getName(), this.iconSize);
            this.setIcon(this.icon);
        }
        this.pickList = this.buildPickList();
        this.comparators = this.getComparatorList(this.fieldQRI);
        String string = fieldLabelText = this.fieldQRI != null ? this.fieldQRI.getTitle() : null;
        if (this.fieldQRI instanceof RelQRI) {
            DBRelationshipInfo.RelationshipType relType = ((RelQRI)this.fieldQRI).getRelationshipInfo().getType();
            fieldLabelText = relType.equals((Object)DBRelationshipInfo.RelationshipType.OneToMany) || relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany) ? String.valueOf(fieldLabelText) + " " + UIRegistry.getResourceString("QB_AGGREGATED") : String.valueOf(fieldLabelText) + " " + UIRegistry.getResourceString("QB_FORMATTED");
        }
        this.fieldLabel.setText(fieldLabelText);
        boolean isBool = this.fieldQRI != null && this.fieldQRI.getDataClass().equals(Boolean.class);
        boolean isRel = this.fieldQRI != null && this.fieldQRI instanceof RelQRI;
        this.operatorCBX.setModel(new DefaultComboBoxModel<SpQueryField.OperatorType>(this.comparators));
        int c = 1;
        while (c < this.comps.length) {
            if (this.comps[c] != null) {
                this.comps[c].setVisible(this.fieldQRI != null);
            }
            ++c;
        }
        this.isNotCheckbox.setVisible(this.fieldQRI != null && !isRel);
        this.operatorCBX.setVisible(this.fieldQRI != null && !isRel);
        this.criteria.setVisible(this.fieldQRI != null && !isRel && !isBool);
        if (!isRel) {
            this.sortCheckbox.setVisible(this.fieldQRI != null);
        } else {
            this.sortCheckbox.setVisible(((RelQRI)this.fieldQRI).getRelationshipInfo().getType() != DBRelationshipInfo.RelationshipType.OneToMany);
        }
        if (this.schemaItem == null) {
            if (this.conditionForSchema) {
                this.schemaItemLabel.setText(UIRegistry.getResourceString("QueryFieldPanel.UnmappedCondition"));
                this.sortCheckbox.setVisible(false);
                this.isDisplayedCkbx.setVisible(false);
                this.isPromptCkbx.setVisible(false);
            }
            if (!this.ownerQuery.isPromptMode()) {
                this.isDisplayedCkbx.setVisible(this.fieldQRI != null && !isRel);
                this.isPromptCkbx.setVisible(this.fieldQRI != null && !isRel);
                this.isEnforcedCkbx.setVisible(this.fieldQRI != null && !isRel);
            }
        } else {
            this.isDisplayedCkbx.setVisible(false);
            this.isPromptCkbx.setVisible(false);
        }
        this.setQueryField(qf);
    }

    public void resetValidator() {
        this.validator.reset(true);
    }

    protected SpQueryField.OperatorType[] getComparatorList(FieldQRI field) {
        if (this.fieldQRI == null) {
            return new SpQueryField.OperatorType[0];
        }
        if (this.pickList != null) {
            return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.IN, SpQueryField.OperatorType.EMPTY};
        }
        if (this.fieldQRI instanceof TreeLevelQRI) {
            return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.LIKE, SpQueryField.OperatorType.IN, SpQueryField.OperatorType.EMPTY};
        }
        if (field.getFieldInfo() != null && field.getFieldInfo().getName().equalsIgnoreCase("catalognumber") && field.getTableInfo().getClassObj().equals(CollectionObject.class)) {
            if (field.getFieldInfo().getFormatter() != null && field.getFieldInfo().getFormatter().isNumeric()) {
                return QueryFieldPanel.getComparatorListForClass(Number.class);
            }
            SpQueryField.OperatorType[] stringCmps = QueryFieldPanel.getComparatorListForClass(String.class);
            SpQueryField.OperatorType[] result = new SpQueryField.OperatorType[stringCmps.length + 3];
            int c = 0;
            SpQueryField.OperatorType[] operatorTypeArray = stringCmps;
            int n = stringCmps.length;
            int n2 = 0;
            while (n2 < n) {
                SpQueryField.OperatorType ot = operatorTypeArray[n2];
                result[c++] = ot;
                ++n2;
            }
            result[c++] = SpQueryField.OperatorType.GREATERTHAN;
            result[c++] = SpQueryField.OperatorType.LESSTHAN;
            result[c++] = SpQueryField.OperatorType.BETWEEN;
            return result;
        }
        return QueryFieldPanel.getComparatorListForClass(field.getDataClass());
    }

    public static SpQueryField.OperatorType[] getComparatorListForClass(Class<?> classObj) {
        if (classObj != null) {
            if (classObj.equals(String.class)) {
                return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.CONTAINS, SpQueryField.OperatorType.LIKE, SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.IN, SpQueryField.OperatorType.BETWEEN, SpQueryField.OperatorType.EMPTY};
            }
            if (classObj.equals(Boolean.class)) {
                return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.DONTCARE, SpQueryField.OperatorType.TRUE, SpQueryField.OperatorType.FALSE, SpQueryField.OperatorType.TRUEORNULL, SpQueryField.OperatorType.FALSEORNULL, SpQueryField.OperatorType.EMPTY};
            }
            if (classObj.equals(Timestamp.class)) {
                return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.GREATERTHAN, SpQueryField.OperatorType.LESSTHAN, SpQueryField.OperatorType.BETWEEN, SpQueryField.OperatorType.EMPTY};
            }
        }
        return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.GREATERTHAN, SpQueryField.OperatorType.LESSTHAN, SpQueryField.OperatorType.GREATERTHANEQUALS, SpQueryField.OperatorType.LESSTHANEQUALS, SpQueryField.OperatorType.BETWEEN, SpQueryField.OperatorType.IN, SpQueryField.OperatorType.EMPTY};
    }

    public SortElement getOrderSpec(int pos) {
        Byte sortType = this.ownerQuery.isPromptMode() ? Byte.valueOf((byte)this.sortCheckbox.getState()) : this.queryField.getSortType();
        if (sortType.equals(SpQueryField.SORT_NONE)) {
            return null;
        }
        int direction = sortType.equals(SpQueryField.SORT_ASC) ? 0 : 1;
        return new SortElement(pos, direction);
    }

    protected boolean hasCriteria() {
        if (this.fieldQRI.getDataClass().equals(Boolean.class)) {
            return !this.operatorCBX.getSelectedItem().equals((Object)SpQueryField.OperatorType.DONTCARE);
        }
        if (this.operatorCBX.getSelectedItem().equals((Object)SpQueryField.OperatorType.EMPTY)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)this.getCriteriaText(true).trim());
    }

    protected Object[] parseCriteria(String origCriteriaEntry) throws ParseException {
        UIFieldFormatterIFace formatter = this.fieldQRI.getFormatter();
        String criteriaEntry = formatter instanceof CatalogNumberUIFieldFormatter && ((CatalogNumberUIFieldFormatter)formatter).isNumeric() ? CatalogNumberFormatter.preParseNumericCatalogNumbers(origCriteriaEntry, formatter) : origCriteriaEntry;
        String[] raw = this.operatorCBX.getSelectedItem() == SpQueryField.OperatorType.BETWEEN || this.operatorCBX.getSelectedItem() == SpQueryField.OperatorType.IN || formatter instanceof CatalogNumberUIFieldFormatter ? criteriaEntry.split(",") : new String[]{criteriaEntry};
        if (this.operatorCBX.getSelectedItem() == SpQueryField.OperatorType.BETWEEN ? raw.length != 2 : this.operatorCBX.getSelectedItem() != SpQueryField.OperatorType.IN && raw.length != 1) {
            throw new ParseException(String.valueOf(this.getLabel()) + " - " + UIRegistry.getResourceString("QB_INVALID_CRITERIA"), -1);
        }
        Object[] result = new String[raw.length];
        int e = 0;
        while (e < raw.length) {
            try {
                Object object = result[e] = formatter != null ? formatter.formatFromUI(raw[e].trim()) : raw[e].trim();
                if (formatter instanceof CatalogNumberUIFieldFormatter && ((CatalogNumberUIFieldFormatter)formatter).isNumeric()) {
                    result[e] = raw[e].trim();
                }
            }
            catch (Exception ex) {
                throw new ParseException(String.valueOf(this.getLabel()) + " - " + String.format(UIRegistry.getResourceString("QB_PARSE_ERROR"), ex.getLocalizedMessage()), -1);
            }
            ++e;
        }
        return result;
    }

    protected Object escape(Object escapee, char escaper) {
        if (escaper == ' ') {
            return escapee;
        }
        if (!(escapee instanceof String)) {
            throw new RuntimeException("Escapee is not a String!");
        }
        String escapeeStr = (String)escapee;
        StringBuilder result = new StringBuilder();
        int c = 0;
        while (c < escapeeStr.length()) {
            if (escapeeStr.charAt(c) == escaper) {
                result.append(escaper);
            }
            result.append(escapeeStr.charAt(c));
            ++c;
        }
        return result.toString();
    }

    protected String concatCriteria(Object[] criteriaObjs, String operatorStr, boolean quote) {
        char quoteStr = quote ? (char)'\'' : ' ';
        String result = String.valueOf(quoteStr) + this.escape(criteriaObjs[0], quoteStr).toString() + quoteStr;
        if (SpQueryField.OperatorType.getOrdForName(operatorStr) == SpQueryField.OperatorType.LIKE.getOrdinal() || SpQueryField.OperatorType.getOrdForName(operatorStr) == SpQueryField.OperatorType.CONTAINS.getOrdinal()) {
            int s;
            int skip;
            if (result.contains("*")) {
                StringBuilder newResult = new StringBuilder();
                skip = -1;
                s = 0;
                while (s < result.length()) {
                    if (skip != s && result.charAt(s) == '\\') {
                        skip = s + 1;
                    }
                    if (skip != s && result.charAt(s) == '*') {
                        newResult.append('%');
                    } else {
                        newResult.append(result.charAt(s));
                    }
                    if (skip == s) {
                        skip = -1;
                    }
                    ++s;
                }
                result = newResult.toString();
            }
            boolean unEscapedWildcard = false;
            skip = 0;
            s = 0;
            while (!unEscapedWildcard && s < result.length()) {
                if (skip != 0) {
                    skip = 0;
                } else if (result.charAt(s) == '\\') {
                    skip = 1;
                } else if (result.charAt(s) == '%') {
                    unEscapedWildcard = true;
                }
                ++s;
            }
            if (SpQueryField.OperatorType.getOrdForName(operatorStr) == SpQueryField.OperatorType.CONTAINS.getOrdinal()) {
                result = String.valueOf(quoteStr) + "%" + result.substring(1, result.length() - 1) + "%" + quoteStr;
            }
        } else if (SpQueryField.OperatorType.getOrdForName(operatorStr) == SpQueryField.OperatorType.BETWEEN.getOrdinal()) {
            result = String.valueOf(result) + " and " + quoteStr + this.escape(criteriaObjs[1], quoteStr) + quoteStr;
        } else if (SpQueryField.OperatorType.getOrdForName(operatorStr) == SpQueryField.OperatorType.IN.getOrdinal()) {
            int p = 1;
            while (p < criteriaObjs.length) {
                result = String.valueOf(result) + ", " + quoteStr + this.escape(criteriaObjs[p], quoteStr) + quoteStr;
                ++p;
            }
            result = "(" + result + ")";
        }
        return result;
    }

    public boolean isNegated() {
        return this.isNotCheckbox != null && this.isNotCheckbox.isSelected();
    }

    protected boolean isNumericCatalogNumber() {
        UIFieldFormatterIFace formatter = this.fieldQRI.getFormatter();
        return formatter instanceof CatalogNumberUIFieldFormatter && ((CatalogNumberUIFieldFormatter)formatter).isNumeric();
    }

    public boolean isEmptyCriterion() {
        return this.operatorCBX.getSelectedItem().equals((Object)SpQueryField.OperatorType.EMPTY);
    }

    public String getCriteriaFormula(TableAbbreviator ta, List<Pair<String, Object>> paramList) throws ParseException {
        if (this.operatorCBX.getSelectedItem().equals((Object)SpQueryField.OperatorType.EMPTY)) {
            return this.fieldQRI.getNullCondition(ta, this.schemaItem != null, this.isNotCheckbox.isSelected());
        }
        if (this.hasCriteria()) {
            boolean addNullConjunction = false;
            Object[] criteriaStrs = this.parseCriteria(this.getCriteriaText(true).trim());
            String criteriaFormula = "";
            String operStr = this.operatorCBX.getSelectedItem().toString();
            if (!(criteriaStrs[0] instanceof String)) {
                log.info((Object)(this.fieldQRI.getFieldInfo() + ": formatter returned non-string data."));
                criteriaFormula = this.concatCriteria(criteriaStrs, operStr, false);
            } else if (this.fieldQRI.getDataClass().equals(Boolean.class)) {
                criteriaFormula = operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.TRUE.getOrdinal())) || operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.TRUEORNULL.getOrdinal())) ? "true" : "false";
                addNullConjunction = operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.FALSEORNULL.getOrdinal())) || operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.TRUEORNULL.getOrdinal()));
                operStr = "=";
            } else if (this.fieldQRI.getDataClass().equals(String.class) && !this.isNumericCatalogNumber()) {
                criteriaFormula = this.concatCriteria(criteriaStrs, operStr, !(this.pickList instanceof PickListTableAdapter));
            } else if (this.fieldQRI.getDataClass().equals(Calendar.class) || this.fieldQRI.getDataClass().equals(Timestamp.class)) {
                int p = 0;
                while (p < criteriaStrs.length) {
                    String paramName = "spparam" + paramList.size();
                    try {
                        if (this.fieldQRI instanceof DateAccessorQRI) {
                            new Integer((String)criteriaStrs[p]);
                        } else {
                            Comparable<Calendar> arg = this.dateConverter.convert((String)criteriaStrs[p]);
                            if (this.fieldQRI.getDataClass().equals(Timestamp.class)) {
                                arg = new Timestamp(arg.getTimeInMillis());
                            }
                            paramList.add(new Pair<String, Calendar>(paramName, (Calendar)arg));
                        }
                    }
                    catch (ParseException ex) {
                        throw new ParseException(String.valueOf(this.getLabel()) + " - " + String.format(UIRegistry.getResourceString("QB_PARSE_ERROR"), ex.getLocalizedMessage()), -1);
                    }
                    if (p > 0) {
                        criteriaFormula = this.operatorCBX.getSelectedItem() == SpQueryField.OperatorType.BETWEEN ? String.valueOf(criteriaFormula) + " and " : String.valueOf(criteriaFormula) + ", ";
                    }
                    criteriaFormula = this.fieldQRI instanceof DateAccessorQRI ? String.valueOf(criteriaFormula) + (String)criteriaStrs[p] : String.valueOf(criteriaFormula) + ":" + paramName;
                    ++p;
                }
                if (SpQueryField.OperatorType.getOrdForName(operStr) == SpQueryField.OperatorType.IN.getOrdinal()) {
                    criteriaFormula = "(" + criteriaFormula + ")";
                }
            } else if (Number.class.isAssignableFrom(this.fieldQRI.getDataClass()) || this.isNumericCatalogNumber()) {
                try {
                    Constructor tester = this.isNumericCatalogNumber() ? Integer.class.getConstructor(String.class) : this.fieldQRI.getDataClass().getConstructor(String.class);
                    int s = 0;
                    while (s < criteriaStrs.length) {
                        tester.newInstance((String)criteriaStrs[s]);
                        String newString = criteriaStrs[s].toString();
                        boolean isZeroes = false;
                        while (newString.startsWith("0")) {
                            newString = newString.substring(1);
                            isZeroes = true;
                        }
                        if (isZeroes && StringUtils.isBlank((String)newString)) {
                            newString = "0";
                        }
                        criteriaStrs[s] = newString;
                        ++s;
                    }
                }
                catch (NoSuchMethodException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryFieldPanel.class, ex);
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof NumberFormatException) {
                        String msg = ex.getTargetException().getLocalizedMessage();
                        if (StringUtils.isBlank((String)msg)) {
                            msg = ex.getTargetException().getClass().getSimpleName();
                        }
                        throw new ParseException(String.valueOf(this.getLabel()) + " - " + String.format(UIRegistry.getResourceString("QB_PARSE_ERROR"), msg), -1);
                    }
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryFieldPanel.class, ex);
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryFieldPanel.class, ex);
                    throw new RuntimeException(ex);
                }
                catch (NumberFormatException ex) {
                    String msg = ex.getLocalizedMessage();
                    if (StringUtils.isBlank((String)msg)) {
                        msg = ex.getClass().getSimpleName();
                    }
                    throw new ParseException(String.valueOf(this.getLabel()) + " - " + String.format(UIRegistry.getResourceString("QB_PARSE_ERROR"), msg), -1);
                }
                criteriaFormula = this.concatCriteria(criteriaStrs, operStr, false);
            }
            if (operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.CONTAINS.getOrdinal()))) {
                operStr = "Like";
            }
            if (criteriaFormula.length() > 0 || this.fieldQRI instanceof TreeLevelQRI) {
                if (this.fieldQRI instanceof TreeLevelQRI) {
                    try {
                        return ((TreeLevelQRI)this.fieldQRI).getNodeNumberCriteria(criteriaFormula, ta, operStr, this.isNotCheckbox.isSelected());
                    }
                    catch (ParseException pe) {
                        throw new ParseException(String.valueOf(this.getLabel()) + " - " + String.format(UIRegistry.getResourceString("QB_PARSE_ERROR"), pe.getLocalizedMessage()), -1);
                    }
                }
                StringBuilder str = new StringBuilder();
                str.append(this.isNotCheckbox.isSelected() ? "(NOT " : "");
                str.append(String.valueOf(this.fieldQRI.getSQLFldSpec(ta, true, this.schemaItem != null)) + " ");
                str.append(operStr);
                str.append(" ");
                str.append(criteriaFormula);
                if (this.isNotCheckbox.isSelected()) {
                    if (!operStr.equals(SpQueryField.OperatorType.getString(SpQueryField.OperatorType.EMPTY.getOrdinal()))) {
                        str.append(" or " + this.fieldQRI.getSQLFldSpec(ta, true, this.schemaItem != null) + " is null");
                    }
                    str.append(")");
                }
                String result = str.toString();
                if (addNullConjunction || StringUtils.isNotBlank((String)result) && this.isEnforcedCkbx != null && this.isEnforcedCkbx.isSelected() && this.conditionForSchema) {
                    result = "(" + result + " or " + this.fieldQRI.getSQLFldSpec(ta, true, this.schemaItem != null) + " is null)";
                }
                return result;
            }
        }
        return null;
    }

    public FieldQRI getFieldQRI() {
        return this.fieldQRI;
    }

    protected JTextField createTextField(String id) {
        ValTextField textField = new ValTextField();
        textField.setRequired(false);
        this.validator.hookupTextField(textField, id, false, UIValidator.Type.Changed, "", true);
        return textField;
    }

    protected PickListCriteriaCombo createPickList(final Component saveBtn) {
        PickListCriteriaCombo result = new PickListCriteriaCombo(this.pickList);
        if (!this.ownerQuery.isPromptMode()) {
            result.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getID() == 1001) {
                        saveBtn.setEnabled(true);
                    }
                }
            });
        }
        return result;
    }

    protected JCheckBox createCheckBox(String id) {
        ValCheckBox checkbox = new ValCheckBox("", false, false);
        DataChangeNotifier dcn = this.validator.createDataChangeNotifer(id, checkbox, null);
        checkbox.addActionListener(dcn);
        return checkbox;
    }

    protected JComboBox createComboBox(SpQueryField.OperatorType[] items) {
        ValComboBox cbx = new ValComboBox((Object[])items, false);
        DataChangeNotifier dcn = this.validator.hookupComponent(cbx, "cbx", UIValidator.Type.Changed, "", true);
        cbx.getComboBox().addActionListener(dcn);
        return cbx.getComboBox();
    }

    protected int[] buildControlLayout(IconManager.IconSize iconSize, boolean returnWidths, Component saveBtn) {
        boolean isBool;
        String fieldLabelText;
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (QueryFieldPanel.this.ownerQuery.getAddBtn() != null && e.getOppositeComponent() != QueryFieldPanel.this.ownerQuery.getAddBtn()) {
                    QueryFieldPanel.this.ownerQuery.selectQFP(QueryFieldPanel.this);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        KeyListener enterListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\n' && QueryFieldPanel.this.ownerQuery != null) {
                    QueryFieldPanel.this.ownerQuery.doSearch();
                }
            }
        };
        this.comparators = this.getComparatorList(this.fieldQRI);
        if (this.schemaItem != null) {
            this.schemaItemLabel = UIHelper.createLabel(this.schemaItem.getFieldName());
            this.schemaItemLabel.setHorizontalAlignment(0);
            this.schemaItemLabel.setText(this.schemaItem.getFieldName());
        } else if (this.conditionForSchema) {
            String caption = this.fieldQRI == null ? UIRegistry.getResourceString("QueryFieldPanel.AddUnmappedCondition") : UIRegistry.getResourceString("QueryFieldPanel.UnmappedCondition");
            this.schemaItemLabel = UIHelper.createLabel(caption);
            this.schemaItemLabel.setHorizontalAlignment(0);
            this.schemaItemLabel.setText(UIRegistry.getResourceString(caption));
        } else {
            this.schemaItemLabel = null;
        }
        this.iconLabel = new JLabel(this.icon);
        this.iconLabel.addFocusListener(focusListener);
        String string = fieldLabelText = this.fieldQRI != null ? this.fieldQRI.getTitle() : "WXYZ";
        if (this.fieldQRI instanceof RelQRI) {
            DBRelationshipInfo.RelationshipType relType = ((RelQRI)this.fieldQRI).getRelationshipInfo().getType();
            fieldLabelText = relType.equals((Object)DBRelationshipInfo.RelationshipType.OneToMany) || relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany) ? String.valueOf(fieldLabelText) + " " + UIRegistry.getResourceString("QB_AGGREGATED") : String.valueOf(fieldLabelText) + " " + UIRegistry.getResourceString("QB_FORMATTED");
        }
        this.fieldLabel = UIHelper.createLabel(fieldLabelText);
        this.fieldLabel.addFocusListener(focusListener);
        this.fieldLabel.addKeyListener(enterListener);
        this.isNotCheckbox = this.createCheckBox("isNotCheckbox");
        this.isNotCheckbox.addFocusListener(focusListener);
        this.isNotCheckbox.addKeyListener(enterListener);
        this.operatorCBX = this.createComboBox(this.comparators);
        this.operatorCBX.addFocusListener(focusListener);
        this.operatorCBX.addKeyListener(enterListener);
        boolean bl = isBool = this.fieldQRI != null && this.fieldQRI.getDataClass().equals(Boolean.class);
        if (!isBool) {
            this.operatorCBX.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        QueryFieldPanel.this.criteria.setVisible(!QueryFieldPanel.this.operatorCBX.getSelectedItem().equals((Object)SpQueryField.OperatorType.EMPTY));
                    }
                }
            });
        }
        if (this.pickList == null) {
            boolean hasBetweenOp = false;
            int o = 0;
            while (o < this.comparators.length) {
                if (this.comparators[o].equals((Object)SpQueryField.OperatorType.BETWEEN)) {
                    hasBetweenOp = true;
                    break;
                }
                ++o;
            }
            if (hasBetweenOp) {
                this.criteria = new CriteriaPair(enterListener);
                this.operatorCBX.addActionListener(this);
            } else {
                this.criteria = this.createTextField("1");
                this.criteria.addKeyListener(enterListener);
            }
        } else {
            this.criteria = this.createPickList(saveBtn);
            if (!this.ownerQuery.isPromptMode()) {
                ((PickListCriteriaCombo)this.criteria).setCurrentOp((SpQueryField.OperatorType)((Object)this.operatorCBX.getModel().getElementAt(0)));
            }
            this.criteria.addKeyListener(enterListener);
            this.operatorCBX.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ((PickListCriteriaCombo)QueryFieldPanel.this.criteria).setCurrentOp((SpQueryField.OperatorType)((Object)QueryFieldPanel.this.operatorCBX.getSelectedItem()));
                    }
                }
            });
        }
        this.sortCheckbox = new MultiStateIconButon(new ImageIcon[]{IconManager.getImage("GrayDot", IconManager.IconSize.Std16), IconManager.getImage("UpArrow", IconManager.IconSize.Std16), IconManager.getImage("DownArrow", IconManager.IconSize.Std16)});
        DataChangeNotifier dcn = this.validator.hookupComponent(this.sortCheckbox, "scb", UIValidator.Type.Changed, "", true);
        this.sortCheckbox.addFocusListener(focusListener);
        this.sortCheckbox.addActionListener(dcn);
        this.sortCheckbox.addKeyListener(enterListener);
        if (!this.ownerQuery.isPromptMode() || this.conditionForSchema || this.schemaItem != null) {
            this.isEnforcedCkbx = this.createCheckBox("isEnforcedCkbx");
            dcn = this.validator.hookupComponent(this.isEnforcedCkbx, "iecb", UIValidator.Type.Changed, "", true);
            this.isEnforcedCkbx.addActionListener(dcn);
            this.isEnforcedCkbx.addFocusListener(focusListener);
            this.isEnforcedCkbx.addKeyListener(enterListener);
        }
        if (!this.ownerQuery.isPromptMode()) {
            this.isDisplayedCkbx = this.createCheckBox("isDisplayedCkbx");
            dcn = this.validator.hookupComponent(this.isDisplayedCkbx, "idcb", UIValidator.Type.Changed, "", true);
            this.isDisplayedCkbx.addFocusListener(focusListener);
            this.isDisplayedCkbx.addKeyListener(enterListener);
            this.isDisplayedCkbx.addActionListener(dcn);
            this.isDisplayedCkbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).QueryFieldPanel.this.sortCheckbox.setEnabled((this).QueryFieldPanel.this.isDisplayedCkbx.isSelected());
                        }
                    });
                }
            });
            this.isPromptCkbx = this.createCheckBox("isPromptCkbx");
            dcn = this.validator.hookupComponent(this.isPromptCkbx, "ipcb", UIValidator.Type.Changed, "", true);
            this.isPromptCkbx.addActionListener(dcn);
            this.isPromptCkbx.addFocusListener(focusListener);
            this.isPromptCkbx.addKeyListener(enterListener);
            this.closeBtn = UIHelper.createIconBtn("Close", "QB_REMOVE_FLD", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean clearIt = QueryFieldPanel.this.schemaItem != null;
                    QueryFieldPanel.this.ownerQuery.removeQueryFieldItem((QueryFieldPanel)((JComponent)ae.getSource()).getParent());
                    if (clearIt) {
                        QueryFieldPanel.this.setField(null, null);
                    }
                }
            });
            this.closeBtn.setEnabled(true);
            this.closeBtn.setFocusable(false);
            this.closeBtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((JButton)e.getSource()).setIcon(IconManager.getIcon("CloseHover"));
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((JButton)e.getSource()).setIcon(IconManager.getIcon("Close"));
                    super.mouseExited(e);
                }
            });
        } else {
            this.isDisplayedCkbx = null;
            this.isPromptCkbx = null;
            if (!this.conditionForSchema && this.schemaItem == null) {
                this.isEnforcedCkbx = null;
            }
            this.closeBtn = null;
        }
        JComponent[] jComponentArray = new JComponent[11];
        jComponentArray[0] = this.iconLabel;
        jComponentArray[1] = this.fieldLabel;
        jComponentArray[2] = this.isNotCheckbox;
        jComponentArray[3] = this.operatorCBX;
        jComponentArray[4] = this.criteria;
        jComponentArray[5] = this.sortCheckbox;
        jComponentArray[6] = this.isDisplayedCkbx;
        jComponentArray[7] = this.isPromptCkbx;
        jComponentArray[8] = this.isEnforcedCkbx;
        jComponentArray[9] = this.closeBtn;
        JComponent[] qComps = jComponentArray;
        JComponent[] jComponentArray2 = new JComponent[10];
        jComponentArray2[0] = this.schemaItemLabel;
        jComponentArray2[1] = this.iconLabel;
        jComponentArray2[2] = this.fieldLabel;
        jComponentArray2[3] = this.isNotCheckbox;
        jComponentArray2[4] = this.operatorCBX;
        jComponentArray2[5] = this.criteria;
        jComponentArray2[6] = this.sortCheckbox;
        jComponentArray2[7] = this.isEnforcedCkbx;
        jComponentArray2[8] = this.closeBtn;
        JComponent[] sComps = jComponentArray2;
        this.comps = this.schemaItem == null && !this.conditionForSchema ? qComps : sComps;
        StringBuilder sb = new StringBuilder();
        if (this.columnDefStr == null) {
            int i = 0;
            while (i < this.comps.length) {
                sb.append(i == 0 ? "" : ",");
                if (this.isCenteredComp(i)) {
                    sb.append("c:");
                }
                if (i != 0 || this.schemaItem == null || !this.conditionForSchema) {
                    sb.append("p");
                } else {
                    sb.append("300px");
                }
                if (this.isGrowComp(i)) {
                    sb.append(":g");
                }
                sb.append(",4px");
                ++i;
            }
        } else {
            sb.append(this.columnDefStr);
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("3px, " + sb.toString() + ", 3px", "3px, p, 3px"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        int col = 1;
        JComponent[] jComponentArray3 = this.comps;
        int n = this.comps.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent comp = jComponentArray3[n2];
            if (comp != null) {
                builder.add((Component)comp, cc.xy(col + 1, 2));
            }
            col += 2;
            ++n2;
        }
        if (this.fieldQRI != null) {
            this.icon = IconManager.getIcon(this.fieldQRI.getTableInfo().getName(), iconSize);
            this.setIcon(this.icon);
        }
        if (!this.ownerQuery.isPromptMode()) {
            this.isDisplayedCkbx.setSelected(true);
            this.isPromptCkbx.setSelected(!(this.fieldQRI instanceof RelQRI));
            this.isEnforcedCkbx.setSelected(false);
        }
        if (this.fieldQRI == null && !returnWidths) {
            int c = 1;
            while (c < this.comps.length) {
                if (this.comps[c] != null) {
                    this.comps[c].setVisible(false);
                }
                ++c;
            }
        } else {
            boolean isRel = this.fieldQRI != null && this.fieldQRI instanceof RelQRI;
            this.isNotCheckbox.setVisible(!isRel || this.pickList != null);
            this.operatorCBX.setVisible(!isRel || this.pickList != null);
            this.criteria.setVisible(!isRel && !isBool || this.pickList != null);
            if (!isRel) {
                this.sortCheckbox.setVisible(true);
            } else {
                this.sortCheckbox.setVisible(((RelQRI)this.fieldQRI).getRelationshipInfo().getType() != DBRelationshipInfo.RelationshipType.OneToMany);
            }
            if (!this.ownerQuery.isPromptMode()) {
                this.isDisplayedCkbx.setVisible(!isRel);
                this.isPromptCkbx.setVisible(!isRel);
                this.isEnforcedCkbx.setVisible(!isRel);
            }
        }
        this.validate();
        this.doLayout();
        int[] widths = null;
        if (returnWidths) {
            widths = new int[this.comps.length];
            int i = 0;
            while (i < this.comps.length) {
                widths[i] = this.comps[i] != null ? this.comps[i].getSize().width : 0;
                ++i;
            }
            if (this.schemaItemLabel == null) {
                widths[0] = iconSize.size();
                widths[1] = 200;
            } else {
                widths[1] = iconSize.size();
                widths[2] = 200;
            }
        }
        return widths;
    }

    protected boolean isCenteredComp(int compIdx) {
        if (this.schemaItemLabel == null) {
            return compIdx == 1 || compIdx == 2 || compIdx == 5 || compIdx == 6 || compIdx == 7;
        }
        return compIdx == 2 || compIdx == 3 || compIdx == 6 || compIdx == 7 || compIdx == 8;
    }

    protected boolean isGrowComp(int compIdx) {
        return this.schemaItemLabel == null ? compIdx == 4 : compIdx == 5;
    }

    protected void buildLabelLayout(int[] widths) {
        StringBuilder sb = new StringBuilder();
        JLabel[] labels = new JLabel[this.labelStrs.length];
        int[] labelWidths = new int[this.labelStrs.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = UIHelper.createLabel(this.labelStrs[i], 0);
            labelWidths[i] = Math.max(widths[i], labels[i].getPreferredSize().width);
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            sb.append(i == 0 ? "" : ",");
            if (this.isCenteredComp(i)) {
                sb.append("c:");
            }
            sb.append("max(");
            sb.append(labelWidths[i]);
            sb.append(";p)");
            if (this.isGrowComp(i)) {
                sb.append(":g");
            }
            sb.append(",4px");
            ++i;
        }
        this.columnDefStr = sb.toString();
        PanelBuilder builder = new PanelBuilder(new FormLayout(sb.toString(), "p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        int x = 1;
        JLabel[] jLabelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel label = jLabelArray[n2];
            builder.add((Component)label, cc.xy(x, 1));
            x += 2;
            ++n2;
        }
    }

    protected String fixName(String nameToFix) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < nameToFix.length()) {
            if (i == 0) {
                s.append(Character.toUpperCase(nameToFix.charAt(i)));
            } else {
                char c = nameToFix.charAt(i);
                if (Character.isUpperCase(c)) {
                    s.append(' ');
                }
                s.append(c);
            }
            ++i;
        }
        return s.toString();
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon == null ? this.blankIcon : icon;
        this.iconLabel.setIcon(this.icon);
    }

    public DBFieldInfo getFieldInfo() {
        if (this.fieldQRI != null) {
            return this.fieldQRI.getFieldInfo();
        }
        return null;
    }

    public String getFieldName() {
        return this.fieldLabel.getText();
    }

    public boolean isForDisplay() {
        return !this.conditionForSchema && (this.ownerQuery.isPromptMode() || this.isDisplayedCkbx.isSelected());
    }

    public String getLabel() {
        return this.fieldLabel.getText();
    }

    public boolean isLabelQualified() {
        return this.labelQualified;
    }

    public String qualifyLabel(List<String> otherLabels, boolean unQualify) {
        List<String> labels;
        boolean needToQualify;
        if (otherLabels == null) {
            needToQualify = false;
            labels = new ArrayList<String>(this.ownerQuery.getFields() - 1);
            int i = 0;
            while (i < this.ownerQuery.getFields()) {
                QueryFieldPanel p = this.ownerQuery.getField(i);
                if (this != p) {
                    labels.add(p.getLabel());
                    if (p.getFieldTitle().equals(this.getFieldTitle())) {
                        needToQualify = true;
                    }
                }
                ++i;
            }
        } else {
            needToQualify = !unQualify;
            labels = otherLabels;
        }
        if (needToQualify) {
            String newLabel = this.getFieldTitle();
            TableTree parent = this.fieldQRI.getTableTree();
            int checkParent = 1;
            do {
                newLabel = this.getQualifiedLabel(parent, checkParent-- > 0);
            } while ((parent = parent.getParent()) != null && labels.indexOf(newLabel) != -1 && !parent.getName().equals("root"));
            this.labelQualified = true;
            this.fieldLabel.setText(newLabel);
        } else {
            this.labelQualified = false;
            this.fieldLabel.setText(this.getFieldTitle());
        }
        return this.fieldLabel.getText();
    }

    protected String getFieldTitle() {
        if (this.fieldQRI != null) {
            return this.fieldQRI.getTitle();
        }
        return null;
    }

    protected String getQualifiedLabel(TableTree parent, boolean checkParent) {
        TableTree reParent = parent;
        if (checkParent && reParent.getTableInfo().getClassObj().equals(Agent.class) && (StringUtils.isEmpty((String)reParent.getField()) || reParent.getName().equalsIgnoreCase(reParent.getField())) && reParent.getParent().getTableQRI() != null) {
            reParent = reParent.getParent();
        }
        return String.valueOf(reParent.getTableQRI().getTitle()) + "/" + this.getFieldTitle();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.selected) {
            g.setColor(RolloverCommand.getActiveColor());
            Insets insets = this.getInsets();
            insets.set(1, 1, 1, 1);
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.bottom - insets.top, 10.0, 10.0);
            g2d.draw(rr);
            rr = new RoundRectangle2D.Double(insets.left + 1, insets.top + 1, size.width - insets.right - insets.left - 2, size.height - insets.bottom - insets.top - 2, 10.0, 10.0);
            g2d.draw(rr);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEnforced() {
        if (this.isEnforcedCkbx != null) {
            return this.isEnforcedCkbx.isSelected();
        }
        if (this.queryField != null) {
            return this.queryField.getAlwaysFilter();
        }
        return false;
    }

    public boolean isAllowNulls() {
        if (this.isEnforcedCkbx != null) {
            return this.isEnforcedCkbx.isSelected();
        }
        if (this.queryField != null) {
            return this.queryField.getAllowNulls();
        }
        return false;
    }

    public String getStringId() {
        return this.fieldQRI.getStringId();
    }

    public PickListDBAdapterIFace getPickList() {
        return this.pickList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.operatorCBX)) {
            SpQueryField.OperatorType op = (SpQueryField.OperatorType)((Object)this.operatorCBX.getSelectedItem());
            if (op != null && op.equals((Object)SpQueryField.OperatorType.BETWEEN)) {
                ((CriteriaPair)this.criteria).setShowingPair(true);
            } else if (this.criteria instanceof CriteriaPair) {
                ((CriteriaPair)this.criteria).setShowingPair(false);
            }
        }
    }

    public SpExportSchemaItem getSchemaItem() {
        return this.schemaItem;
    }

    public SpExportSchemaItemMapping getItemMapping() {
        return this.queryField != null ? this.queryField.getMapping() : null;
    }

    public boolean isConditionForSchema() {
        return this.conditionForSchema;
    }

    private class CriteriaPair
    extends JPanel {
        protected JTextField text1;
        protected JTextField text2;
        protected JLabel connectorText;
        protected JPanel rangePanel;
        protected JTextField text;
        protected boolean showingPair = false;

        public CriteriaPair(KeyListener listener) {
            this.buildUI(listener);
        }

        protected void buildUI(KeyListener listener) {
            this.text1 = QueryFieldPanel.this.createTextField("1");
            this.text1.addKeyListener(listener);
            this.text2 = QueryFieldPanel.this.createTextField("2");
            this.text2.addKeyListener(listener);
            this.connectorText = new JLabel(" " + UIRegistry.getResourceString("AND") + " ");
            this.rangePanel = new JPanel();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g, f:p, f:p:g", "f:p"), this.rangePanel);
            CellConstraints cc = new CellConstraints();
            pb.add((Component)this.text1, cc.xy(1, 1));
            pb.add((Component)this.connectorText, cc.xy(2, 1));
            pb.add((Component)this.text2, cc.xy(3, 1));
            this.rangePanel.validate();
            this.setLayout(new CardLayout());
            this.text = QueryFieldPanel.this.createTextField("3");
            this.text.addKeyListener(listener);
            this.add("text", this.text);
            this.add("rangePanel", this.rangePanel);
            this.validate();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.setSize(Math.min((double)(QueryFieldPanel.this.sortCheckbox.getX() - 4 - (QueryFieldPanel.this.operatorCBX.getX() + QueryFieldPanel.this.operatorCBX.getWidth() + 4)), result.getWidth()), result.getHeight());
            return result;
        }

        public void setCriteriaText(String entry, String entry2, SpQueryField.OperatorType op) {
            if (op != null && op.equals((Object)SpQueryField.OperatorType.BETWEEN)) {
                this.setShowingPair(true);
                String[] entries = StringUtils.isBlank((String)entry2) ? entry.split(",") : new String[]{entry, entry2};
                if (entries.length > 0) {
                    this.text1.setText(entries[0]);
                    if (entries.length > 1) {
                        this.text2.setText(entries[1]);
                    } else {
                        this.text2.setText(null);
                    }
                } else {
                    this.text1.setText(null);
                }
            } else {
                this.setShowingPair(false);
                this.text.setText(entry);
            }
        }

        public String getCriteriaText() {
            if (this.showingPair) {
                return String.valueOf(this.text1.getText()) + "," + this.text2.getText();
            }
            return this.text.getText();
        }

        public void setShowingPair(boolean showingPair) {
            if (this.showingPair != showingPair) {
                this.showingPair = showingPair;
                if (showingPair) {
                    ((CardLayout)this.getLayout()).last(this);
                } else {
                    ((CardLayout)this.getLayout()).first(this);
                }
                this.text.setText(null);
                this.text1.setText(null);
                this.text2.setText(null);
                this.validate();
            }
        }
    }
}

