/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.dbsupport.RecordTypeCodeBuilder;
import edu.ku.brc.specify.tasks.ExportMappingTask;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.tasks.subpane.JasperCompilerRunnable;
import edu.ku.brc.specify.tasks.subpane.qb.BaseQRI;
import edu.ku.brc.specify.tasks.subpane.qb.DateAccessorQRI;
import edu.ku.brc.specify.tasks.subpane.qb.DateExportFormatter;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoRel;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoTreeLevel;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoTreeLevelGrp;
import edu.ku.brc.specify.tasks.subpane.qb.ExpandableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.HQLSpecs;
import edu.ku.brc.specify.tasks.subpane.qb.HorzLayoutManager;
import edu.ku.brc.specify.tasks.subpane.qb.ProcessNode;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSource;
import edu.ku.brc.specify.tasks.subpane.qb.QBQueryForIdResultsHQL;
import edu.ku.brc.specify.tasks.subpane.qb.QBReportInfoPanel;
import edu.ku.brc.specify.tasks.subpane.qb.QBResultSetTableModel;
import edu.ku.brc.specify.tasks.subpane.qb.QBResultsSubPane;
import edu.ku.brc.specify.tasks.subpane.qb.QBResultsTablePanel;
import edu.ku.brc.specify.tasks.subpane.qb.QryListRenderer;
import edu.ku.brc.specify.tasks.subpane.qb.QryListRendererIFace;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanel;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanelContainerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.QueryParameterPanel;
import edu.ku.brc.specify.tasks.subpane.qb.RelQRI;
import edu.ku.brc.specify.tasks.subpane.qb.ReportParametersPanel;
import edu.ku.brc.specify.tasks.subpane.qb.SortElement;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import edu.ku.brc.specify.tasks.subpane.qb.TableTreePathPoint;
import edu.ku.brc.specify.tasks.subpane.qb.TreeLevelQRI;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchJRDataSource;
import edu.ku.brc.specify.tools.export.ConceptMapUtils;
import edu.ku.brc.specify.tools.export.MappedFieldInfo;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DropDownButton;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QueryBldrPane
extends BaseSubPane
implements QueryFieldPanelContainerIFace,
CommandListener {
    protected static final Logger log = Logger.getLogger(QueryBldrPane.class);
    protected static final Color TITLEBAR_COLOR = new Color(82, 160, 52);
    protected static final int ExportSchemaPreviewSize = 120;
    protected static final int maxParentChainLen = 7;
    protected JList tableList;
    protected Vector<QueryFieldPanel> queryFieldItems = new Vector();
    protected QueryFieldPanel selectedQFP = null;
    protected int currentInx = -1;
    protected JPanel queryFieldsPanel;
    protected JScrollPane queryFieldsScroll;
    protected SpQuery query = null;
    protected JButton addBtn;
    protected ImageIcon blankIcon = IconManager.getIcon("BlankIcon", IconManager.IconSize.Std24);
    protected String columnDefStr = null;
    protected JPanel listBoxPanel;
    protected Vector<JList> listBoxList = new Vector();
    protected JScrollPane scrollPane;
    protected Vector<JScrollPane> spList = new Vector();
    protected Vector<TableTree> tableTreeList = new Vector();
    protected JPanel contextPanel;
    protected DropDownButton saveBtn;
    protected JButton searchBtn;
    protected JCheckBox distinctChk;
    protected JCheckBox countOnlyChk;
    protected JCheckBox searchSynonymyChk;
    protected boolean searchSynonymy = true;
    protected boolean countOnly = false;
    protected Hashtable<String, Boolean> fieldsToSkipHash = new Hashtable();
    protected QryListRenderer qryRenderer = new QryListRenderer(IconManager.STD_ICON_SIZE);
    protected int listCellHeight;
    protected TableTree tableTree;
    protected Hashtable<String, TableTree> tableTreeHash;
    protected boolean processingLists = false;
    protected RolloverCommand queryNavBtn = null;
    protected JButton orderUpBtn = null;
    protected JButton orderDwnBtn = null;
    protected boolean doOrdering = false;
    protected ExpressSearchResultsPaneIFace esrp = null;
    protected boolean isHeadless = false;
    protected SpExportSchema exportSchema;
    protected SpExportSchemaMapping schemaMapping;
    protected boolean reloadMsgShown = false;
    protected final AtomicReference<QBQueryForIdResultsHQL> runningResults = new AtomicReference();
    protected final AtomicReference<QBQueryForIdResultsHQL> completedResults = new AtomicReference();
    protected final AtomicLong doneTime = new AtomicLong(-1L);
    protected final AtomicLong startTime = new AtomicLong(-1L);

    public QueryBldrPane(String name, Taskable task, SpQuery query) {
        this(name, task, query, false);
    }

    public QueryBldrPane(String name, Taskable task, SpQuery query, boolean isHeadless) {
        this(name, task, query, isHeadless, null, null);
    }

    public QueryBldrPane(String name, Taskable task, SpQuery query, boolean isHeadless, SpExportSchema exportSchema, SpExportSchemaMapping schemaMapping) {
        super(name, task);
        String[] skipItems;
        this.query = query;
        this.isHeadless = isHeadless;
        SpExportSchema spExportSchema = exportSchema != null ? exportSchema : (this.exportSchema = schemaMapping != null ? schemaMapping.getSpExportSchema() : null);
        if (exportSchema != null && schemaMapping == null) {
            this.schemaMapping = new SpExportSchemaMapping();
            this.schemaMapping.initialize();
            this.schemaMapping.setSpExportSchema(exportSchema);
        } else {
            this.schemaMapping = schemaMapping;
        }
        String[] stringArray = skipItems = new String[]{"TimestampCreated", "LastEditedBy", "TimestampModified"};
        int n = skipItems.length;
        int n2 = 0;
        while (n2 < n) {
            String nameStr = stringArray[n2];
            this.fieldsToSkipHash.put(nameStr, true);
            ++n2;
        }
        QueryTask qt = (QueryTask)task;
        Pair<TableTree, Hashtable<String, TableTree>> trees = qt.getTableTrees();
        this.tableTree = trees.getFirst();
        this.tableTreeHash = trees.getSecond();
        this.createUI();
        this.setupUI();
        CommandDispatcher.register("Reports", this);
    }

    protected void createUI() {
        this.removeAll();
        JMenuItem saveItem = new JMenuItem(UIRegistry.getResourceString("QB_SAVE"));
        AbstractAction saveActionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueryBldrPane.this.saveQuery(false)) {
                    QueryBldrPane.this.saveBtn.setEnabled(false);
                }
            }
        };
        saveItem.addActionListener(saveActionListener);
        JMenuItem saveAsItem = new JMenuItem(UIRegistry.getResourceString("QB_SAVE_AS"));
        AbstractAction saveAsActionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueryBldrPane.this.saveQuery(true)) {
                    QueryBldrPane.this.saveBtn.setEnabled(false);
                }
            }
        };
        saveAsItem.addActionListener(saveAsActionListener);
        JComponent[] itemSample = new JComponent[]{saveItem, saveAsItem};
        this.saveBtn = new DropDownButton(UIRegistry.getResourceString("QB_SAVE"), null, 1, Arrays.asList(itemSample));
        this.saveBtn.addActionListener(saveActionListener);
        String ACTION_KEY = "SAVE";
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        InputMap inputMap = this.saveBtn.getInputMap(2);
        inputMap.put(ctrlS, ACTION_KEY);
        ActionMap actionMap = this.saveBtn.getActionMap();
        actionMap.put(ACTION_KEY, saveActionListener);
        ACTION_KEY = "SAVE_AS";
        KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(ctrlA, ACTION_KEY);
        actionMap.put(ACTION_KEY, saveAsActionListener);
        this.saveBtn.setActionMap(actionMap);
        UIHelper.setControlSize(this.saveBtn);
        this.listBoxPanel = new JPanel(new HorzLayoutManager(2, 2));
        Vector<TableQRI> list = new Vector<TableQRI>();
        int k = 0;
        while (k < this.tableTree.getKids()) {
            list.add(this.tableTree.getKid(k).getTableQRI());
            ++k;
        }
        Collections.sort(list);
        DefaultListModel<TableQRI> model = new DefaultListModel<TableQRI>();
        for (TableQRI qri : list) {
            model.addElement(qri);
        }
        this.tableList = new JList(model);
        QryListRenderer qr = new QryListRenderer(IconManager.IconSize.Std16);
        qr.setDisplayKidIndicator(false);
        this.tableList.setCellRenderer(qr);
        JScrollPane spt = new JScrollPane(this.tableList, 20, 31);
        Dimension pSize = spt.getPreferredSize();
        pSize.height = 200;
        spt.setPreferredSize(pSize);
        JPanel topPanel = new JPanel(new BorderLayout());
        this.scrollPane = new JScrollPane(this.listBoxPanel, 21, 32);
        this.tableList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int inx = QueryBldrPane.this.tableList.getSelectedIndex();
                    if (inx > -1) {
                        QueryBldrPane.this.fillNextList(QueryBldrPane.this.tableList);
                    } else {
                        QueryBldrPane.this.listBoxPanel.removeAll();
                    }
                }
            }
        });
        this.addBtn = new JButton(IconManager.getImage("PlusSign", IconManager.IconSize.Std16));
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BaseQRI qri = (BaseQRI)QueryBldrPane.this.listBoxList.get(QueryBldrPane.this.currentInx).getSelectedValue();
                if (qri.isInUse.booleanValue()) {
                    return;
                }
                if (QueryBldrPane.this.exportSchema != null && QueryBldrPane.this.selectedQFP == null) {
                    return;
                }
                try {
                    FieldQRI fieldQRI = QueryBldrPane.buildFieldQRI(qri);
                    if (fieldQRI == null) {
                        throw new Exception("null FieldQRI");
                    }
                    SpQueryField qf = new SpQueryField();
                    qf.initialize();
                    qf.setFieldName(fieldQRI.getFieldName());
                    qf.setStringId(fieldQRI.getStringId());
                    QueryBldrPane.this.query.addReference(qf, "fields");
                    if (QueryBldrPane.this.exportSchema == null) {
                        QueryBldrPane.this.addQueryFieldItem(fieldQRI, qf, false);
                    } else {
                        QueryBldrPane.this.addNewMapping(fieldQRI, qf, QueryBldrPane.this.selectedQFP);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                    return;
                }
            }
        });
        this.contextPanel = new JPanel(new BorderLayout());
        this.contextPanel.add((Component)UIHelper.createLabel("Search Context", 0), "North");
        this.contextPanel.add((Component)spt, "Center");
        this.contextPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel schemaPanel = new JPanel(new BorderLayout());
        schemaPanel.add((Component)this.scrollPane, "Center");
        topPanel.add((Component)this.contextPanel, "West");
        topPanel.add((Component)schemaPanel, "Center");
        this.add((Component)topPanel, "North");
        this.queryFieldsPanel = new JPanel();
        this.queryFieldsPanel.setLayout(new NavBoxLayoutManager(0, 2));
        this.queryFieldsScroll = new JScrollPane(this.queryFieldsPanel, 20, 31);
        this.queryFieldsScroll.setBorder(null);
        this.add(this.queryFieldsScroll);
        if (this.exportSchema == null) {
            JPanel mover = this.buildMoverPanel(false);
            this.add((Component)mover, "East");
        }
        String searchLbl = this.schemaMapping == null ? UIRegistry.getResourceString("QB_SEARCH") : UIRegistry.getResourceString("QB_EXPORT_PREVIEW");
        this.searchBtn = UIHelper.createButton(searchLbl);
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryBldrPane.this.doSearch(false);
            }
        });
        this.distinctChk = UIHelper.createCheckBox(UIRegistry.getResourceString("QB_DISTINCT"));
        this.distinctChk.setVisible(this.schemaMapping == null);
        if (this.schemaMapping == null) {
            this.distinctChk.setSelected(false);
            this.distinctChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    new SwingWorker(){

                        @Override
                        public Object construct() {
                            if ((this).QueryBldrPane.this.distinctChk.isSelected()) {
                                UsageTracker.incrUsageCount("QB.DistinctOn");
                            } else {
                                UsageTracker.incrUsageCount("QB.DistinctOff");
                            }
                            if ((QueryBldrPane.this.isTreeLevelSelected() || QueryBldrPane.this.isAggFieldSelected()) && (this).QueryBldrPane.this.countOnly && (this).QueryBldrPane.this.distinctChk.isSelected()) {
                                (this).QueryBldrPane.this.countOnlyChk.setSelected(false);
                                (this).QueryBldrPane.this.countOnly = false;
                            }
                            (this).QueryBldrPane.this.query.setCountOnly((this).QueryBldrPane.this.countOnly);
                            (this).QueryBldrPane.this.query.setSelectDistinct((this).QueryBldrPane.this.distinctChk.isSelected());
                            (this).QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.thereAreItems());
                            return null;
                        }
                    }.start();
                }
            });
        }
        this.countOnlyChk = UIHelper.createCheckBox(UIRegistry.getResourceString("QB_COUNT_ONLY"));
        this.countOnlyChk.setSelected(false);
        this.countOnlyChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new SwingWorker(){

                    @Override
                    public Object construct() {
                        if ((this).QueryBldrPane.this.runningResults.get() == null) {
                            boolean bl = (this).QueryBldrPane.this.countOnly = !(this).QueryBldrPane.this.countOnly;
                            if ((this).QueryBldrPane.this.countOnly) {
                                UsageTracker.incrUsageCount("QB.CountOnlyOn");
                            } else {
                                UsageTracker.incrUsageCount("QB.CountOnlyOff");
                            }
                            if ((QueryBldrPane.this.isTreeLevelSelected() || QueryBldrPane.this.isAggFieldSelected()) && (this).QueryBldrPane.this.countOnly && (this).QueryBldrPane.this.distinctChk.isSelected()) {
                                (this).QueryBldrPane.this.distinctChk.setSelected(false);
                            }
                        } else {
                            (this).QueryBldrPane.this.countOnlyChk.setSelected((this).QueryBldrPane.this.countOnly);
                        }
                        (this).QueryBldrPane.this.query.setCountOnly((this).QueryBldrPane.this.countOnly);
                        (this).QueryBldrPane.this.query.setSelectDistinct((this).QueryBldrPane.this.distinctChk.isSelected());
                        (this).QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.thereAreItems());
                        return null;
                    }
                }.start();
            }
        });
        this.searchSynonymyChk = UIHelper.createCheckBox(UIRegistry.getResourceString("QB_SRCH_SYNONYMS"));
        this.searchSynonymyChk.setSelected(this.searchSynonymy);
        this.searchSynonymyChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new SwingWorker(){

                    @Override
                    public Object construct() {
                        boolean bl = (this).QueryBldrPane.this.searchSynonymy = !(this).QueryBldrPane.this.searchSynonymy;
                        if (!(this).QueryBldrPane.this.searchSynonymy) {
                            UsageTracker.incrUsageCount("QB.SearchSynonymyOff");
                        } else {
                            UsageTracker.incrUsageCount("QB.SearchSynonymyOn");
                        }
                        (this).QueryBldrPane.this.query.setSearchSynonymy((this).QueryBldrPane.this.searchSynonymy);
                        (this).QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.thereAreItems());
                        return null;
                    }
                }.start();
            }
        });
        PanelBuilder outer = new PanelBuilder(new FormLayout("p, 2dlu, p, 2dlu, p, 2dlu, p, 6dlu, p", "p"));
        CellConstraints cc = new CellConstraints();
        outer.add((Component)this.searchSynonymyChk, cc.xy(1, 1));
        outer.add((Component)this.distinctChk, cc.xy(3, 1));
        outer.add((Component)this.countOnlyChk, cc.xy(5, 1));
        outer.add((Component)this.searchBtn, cc.xy(7, 1));
        outer.add((Component)this.saveBtn, cc.xy(9, 1));
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)outer.getPanel(), "East");
        JButton helpBtn = UIHelper.createHelpIconButton("QB");
        bottom.add((Component)helpBtn, "West");
        this.add((Component)bottom, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected void addNewMapping(FieldQRI fieldQRI, SpQueryField qf, QueryFieldPanel qfp) {
        if (qfp != null) {
            QueryFieldPanel newQfp = null;
            if (qfp.getFieldQRI() != null && qfp.getFieldQRI().isInUse()) {
                FieldQRI qfpqri = qfp.getFieldQRI();
                try {
                    FieldQRI qri = qfpqri instanceof RelQRI ? ((RelQRI)qfpqri).getTable() : qfpqri;
                    boolean done = false;
                    for (JList lb : this.listBoxList) {
                        if (lb.isVisible()) {
                            int i = 0;
                            while (i < ((DefaultListModel)lb.getModel()).getSize()) {
                                BaseQRI qriI = (BaseQRI)((DefaultListModel)lb.getModel()).getElementAt(i);
                                if (qriI != null) {
                                    boolean match;
                                    boolean bl = match = qriI == qri;
                                    if (!match) {
                                        match = QueryBldrPane.buildFieldQRI(qri).getStringId().equals(QueryBldrPane.buildFieldQRI(qriI).getStringId());
                                    }
                                    if (match) {
                                        qriI.setIsInUse(false);
                                        lb.repaint();
                                        done = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!done) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                    log.error((Object)ex);
                }
            }
            if (qfp.getQueryField() != null) {
                this.removeFieldFromQuery(qfp.getQueryField());
                if (!qfp.isConditionForSchema()) {
                    this.removeSchemaItemMapping(qfp.getItemMapping());
                }
            }
            if (!qfp.isConditionForSchema()) {
                SpExportSchemaItemMapping newMapping = new SpExportSchemaItemMapping();
                newMapping.initialize();
                newMapping.setExportSchemaItem(qfp.getSchemaItem());
                newMapping.setExportSchemaMapping(this.schemaMapping);
                newMapping.setQueryField(qf);
                this.schemaMapping.getMappings().add(newMapping);
                qf.setMapping(newMapping);
            }
            qfp.setField(fieldQRI, qf);
            fieldQRI.setIsInUse(true);
            if (qfp.isConditionForSchema()) {
                final QueryFieldPanel theNewQfp = new QueryFieldPanel(this, null, this.columnDefStr, this.saveBtn, null, null, true);
                theNewQfp.addMouseListener(new MouseInputAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        QueryBldrPane.this.selectQFP(theNewQfp);
                    }
                });
                this.queryFieldItems.add(theNewQfp);
                newQfp = theNewQfp;
            }
            this.updateUIAfterAddOrMap(fieldQRI, newQfp, false, newQfp != null);
        }
    }

    protected boolean removeSchemaItemMapping(SpExportSchemaItemMapping itemMapping) {
        int size = this.schemaMapping.getMappings().size();
        SpExportSchemaItemMapping theOne = null;
        for (SpExportSchemaItemMapping esim : this.schemaMapping.getMappings()) {
            if (!esim.getExportSchemaItem().getId().equals(itemMapping.getExportSchemaItem().getId())) continue;
            theOne = esim;
            break;
        }
        if (theOne != null) {
            this.schemaMapping.getMappings().remove(theOne);
            theOne.setExportSchemaItem(null);
            theOne.setExportSchemaMapping(null);
            theOne.getQueryField().setMapping(null);
            if (theOne != itemMapping) {
                itemMapping.setExportSchemaMapping(null);
                itemMapping.getQueryField().setMapping(null);
                itemMapping.setQueryField(null);
            }
        }
        return this.schemaMapping.getMappings().size() < size;
    }

    protected boolean removeFieldFromQuery(SpQueryField toRemove) {
        int size = this.query.getFields().size();
        SpQueryField theFieldObjectInTheFieldsSetToRemove = null;
        for (SpQueryField fld : this.query.getFields()) {
            if (fld == toRemove) {
                theFieldObjectInTheFieldsSetToRemove = fld;
                break;
            }
            if (fld.getId() != null && toRemove.getId() != null && fld.getId().equals(toRemove.getId())) {
                theFieldObjectInTheFieldsSetToRemove = fld;
                break;
            }
            if (!fld.getStringId().equals(toRemove.getStringId())) continue;
            theFieldObjectInTheFieldsSetToRemove = fld;
            break;
        }
        if (theFieldObjectInTheFieldsSetToRemove != null) {
            this.query.getFields().remove(theFieldObjectInTheFieldsSetToRemove);
            theFieldObjectInTheFieldsSetToRemove.setQuery(null);
        }
        if (toRemove != theFieldObjectInTheFieldsSetToRemove) {
            toRemove.getQuery().getFields().remove(toRemove);
            toRemove.setQuery(null);
        }
        return this.query.getFields().size() < size;
    }

    public void setEsrp(ExpressSearchResultsPaneIFace esrp) {
        this.esrp = esrp;
    }

    @Override
    public void doSearch() {
        this.doSearch(false);
    }

    public void doSearch(boolean doOr) {
        if (this.canSearch()) {
            if (this.distinctChk.isSelected()) {
                UsageTracker.incrUsageCount("QB.DoSearchDistinct." + this.query.getContextName());
            } else {
                UsageTracker.incrUsageCount("QB.DoSearch." + this.query.getContextName());
            }
            this.doSearch((TableQRI)this.tableList.getSelectedValue(), this.distinctChk.isSelected(), doOr);
        } else {
            this.cancelSearch();
        }
    }

    protected void cancelSearch() {
        if (this.runningResults.get() != null) {
            log.debug((Object)"cancelling search");
            UsageTracker.incrUsageCount("QB.CancelSearch." + this.query.getContextName());
            this.runningResults.get().cancel();
        }
    }

    public static String fixFieldName(String fieldName) {
        return String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
    }

    protected static Vector<QueryFieldPanel> getQueryFieldPanels(SpQuery q, QueryFieldPanelContainerIFace container, TableTree tblTree, Hashtable<String, TableTree> ttHash) {
        return QueryBldrPane.getQueryFieldPanels(container, q.getFields(), tblTree, ttHash, null, null);
    }

    protected void setupUI() {
        Short tblId;
        if (!this.isHeadless && !SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Method called from invalid thread.");
        }
        this.queryFieldsPanel.removeAll();
        this.queryFieldItems.clear();
        this.queryFieldsPanel.validate();
        this.columnDefStr = null;
        this.tableList.clearSelection();
        this.contextPanel.setVisible(this.query == null);
        this.tableList.setSelectedIndex(-1);
        if (this.query != null && (tblId = this.query.getContextTableId()) != null) {
            int i = 0;
            while (i < this.tableList.getModel().getSize()) {
                TableQRI qri = (TableQRI)this.tableList.getModel().getElementAt(i);
                if (qri.getTableInfo().getTableId() == tblId.intValue()) {
                    this.tableList.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        Vector<QueryFieldPanel> qfps = null;
        boolean dirty = false;
        LinkedList<String> missingFlds = new LinkedList<String>();
        if (this.query != null) {
            TableQRI qri = (TableQRI)this.tableList.getSelectedValue();
            if (qri == null) {
                throw new RuntimeException("Invalid context for query.");
            }
            Vector<QueryFieldPanel> vector = qfps = this.exportSchema == null ? QueryBldrPane.getQueryFieldPanels(this, this.query.getFields(), this.tableTree, this.tableTreeHash, this.saveBtn, missingFlds) : QueryBldrPane.getQueryFieldPanelsForMapping(this, this.query.getFields(), this.tableTree, this.tableTreeHash, this.saveBtn, this.schemaMapping, missingFlds, ConceptMapUtils.getDefaultDarwinCoreMappings());
            if (missingFlds.size() > 0) {
                JList<String> list = new JList<String>(new Vector<String>(missingFlds));
                CellConstraints cc = new CellConstraints();
                PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p:g,2px,f:p:g"));
                pb.add((Component)UIHelper.createI18NLabel("QB_FIELDS_NOT_ADDED"), cc.xy(1, 1));
                pb.add((Component)UIHelper.createScrollPane(list), cc.xy(1, 3));
                pb.setDefaultDialogBorder();
                dirty = true;
                CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("QB_FIELD_MISSING_TITLE"), true, 1, (Component)pb.getPanel());
                dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
                dlg.setVisible(true);
            }
        }
        boolean header = true;
        boolean doAutoMap = true;
        for (final QueryFieldPanel qfp : qfps) {
            if (header) {
                header = false;
                this.queryFieldsScroll.setColumnHeaderView(qfp);
                continue;
            }
            this.queryFieldItems.add(qfp);
            qfp.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    QueryBldrPane.this.selectQFP(qfp);
                }
            });
            qfp.resetValidator();
            this.queryFieldsPanel.add(qfp);
            doAutoMap &= qfp.getFieldQRI() == null;
        }
        this.qualifyFieldLabels();
        if (doAutoMap) {
            block2: for (final QueryFieldPanel qfp : this.queryFieldItems) {
                Vector<MappedFieldInfo> mappedTos;
                if (qfp.isConditionForSchema() || (mappedTos = ConceptMapUtils.getDefaultDarwinCoreMappings().get(qfp.getSchemaItem().getFieldName().toLowerCase())) == null) continue;
                for (MappedFieldInfo mappedTo : mappedTos) {
                    FieldQRI fqri = QueryBldrPane.getFieldQRI(this.tableTree, mappedTo.getFieldName(), mappedTo.isRel(), mappedTo.getStringId(), QueryBldrPane.getTableIds(mappedTo.getTableIds()), 0, this.tableTreeHash);
                    if (fqri == null) continue;
                    SpQueryField qf = new SpQueryField();
                    qf.initialize();
                    qf.setFieldName(fqri.getFieldName());
                    qf.setStringId(fqri.getStringId());
                    this.query.addReference(qf, "fields");
                    this.addNewMapping(fqri, qf, qfp);
                    dirty = true;
                    continue block2;
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBldrPane.this.distinctChk.setSelected(QueryBldrPane.this.query.isSelectDistinct());
                QueryBldrPane.this.countOnlyChk.setSelected(QueryBldrPane.this.query.getCountOnly() == null ? false : QueryBldrPane.this.query.getCountOnly());
                QueryBldrPane.this.countOnly = QueryBldrPane.this.countOnlyChk.isSelected();
                QueryBldrPane.this.searchSynonymyChk.setSelected(QueryBldrPane.this.query.getSearchSynonymy() == null ? true : QueryBldrPane.this.query.getSearchSynonymy());
                QueryBldrPane.this.searchSynonymy = QueryBldrPane.this.searchSynonymyChk.isSelected();
            }
        });
        final boolean saveBtnEnabled = dirty;
        if (!this.isHeadless) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryBldrPane.this.adjustPanelUI(saveBtnEnabled);
                }
            });
        } else {
            this.adjustPanelUI(saveBtnEnabled);
        }
    }

    protected boolean canSave() {
        boolean result = true;
        return result;
    }

    protected void adjustPanelUI(boolean saveBtnEnabled) {
        this.tableList.setEnabled(this.queryFieldItems.size() == 0);
        if (this.queryFieldItems.size() > 0) {
            this.selectQFP(this.queryFieldItems.get(0));
        }
        for (JList list : this.listBoxList) {
            list.repaint();
        }
        this.saveBtn.setEnabled(saveBtnEnabled);
        this.saveBtn.setVisible(this.canSave());
        this.updateSearchBtn();
        this.validate();
    }

    public static HQLSpecs buildHQL(TableQRI rootTable, boolean distinct, Vector<QueryFieldPanel> qfps, TableTree tblTree, RecordSetIFace keysToRetrieve, boolean searchSynonymy, boolean isSchemaExport, Timestamp lastExportTime) throws ParseException {
        return QueryBldrPane.buildHQL(rootTable, distinct, qfps, tblTree, keysToRetrieve, searchSynonymy, isSchemaExport, lastExportTime, false);
    }

    public static HQLSpecs buildHQL(TableQRI rootTable, boolean distinct, Vector<QueryFieldPanel> qfps, TableTree tblTree, RecordSetIFace keysToRetrieve, boolean searchSynonymy, boolean isSchemaExport, Timestamp lastExportTime, boolean disjunct) throws ParseException {
        String result;
        if (qfps.size() == 0) {
            return null;
        }
        if (keysToRetrieve != null && keysToRetrieve.getNumItems() == 0) {
            return null;
        }
        StringBuilder fieldsStr = new StringBuilder();
        Vector<BaseQRI> list = new Vector<BaseQRI>();
        StringBuilder criteriaStr = new StringBuilder();
        StringBuilder orderStr = new StringBuilder();
        LinkedList<SortElement> sortElements = new LinkedList<SortElement>();
        boolean postSortPresent = false;
        boolean debug = false;
        ProcessNode root = new ProcessNode();
        int fldPosition = distinct ? 0 : 1;
        for (QueryFieldPanel qfi : qfps) {
            SortElement orderSpec;
            if (qfi.getFieldQRI() == null) continue;
            qfi.updateQueryField();
            if (qfi.isForDisplay()) {
                ++fldPosition;
            }
            if (debug) {
                log.debug((Object)("\nNode: " + qfi.getFieldName()));
            }
            if ((orderSpec = qfi.getOrderSpec(distinct ? fldPosition - 1 : fldPosition - 2)) != null) {
                postSortPresent |= qfi.getFieldQRI() instanceof TreeLevelQRI || qfi.getFieldQRI() instanceof RelQRI;
                sortElements.add(orderSpec);
            }
            list.clear();
            FieldQRI pqri = qfi.getFieldQRI();
            TableTree parent = pqri.getTableTree();
            if (!qfi.isForDisplay() && !qfi.hasCriteria() && orderSpec == null && !(pqri instanceof RelQRI)) continue;
            boolean addToList = true;
            if (pqri instanceof RelQRI) {
                RelQRI relQRI = (RelQRI)pqri;
                Object relType = relQRI.getRelationshipInfo().getType();
                if (!relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToOne) && !relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany)) {
                    parent = parent.getParent();
                    addToList = isSchemaExport && lastExportTime != null;
                } else {
                    DataObjDataFieldFormatIFace dataObjDataFieldFormatIFace = relQRI.getDataObjFormatter();
                    addToList = dataObjDataFieldFormatIFace != null ? dataObjDataFieldFormatIFace.getSingleField() != null || isSchemaExport && lastExportTime != null : false;
                }
            }
            if (addToList) {
                list.insertElementAt(pqri, 0);
            }
            while (parent != tblTree) {
                list.insertElementAt(parent.getTableQRI(), 0);
                parent = parent.getParent();
            }
            if (debug) {
                log.debug((Object)"Path From Top Down:");
                for (BaseQRI qri : list) {
                    log.debug((Object)("  " + qri.getTitle()));
                }
            }
            ProcessNode parentNode = root;
            int q = 0;
            block3: for (BaseQRI baseQRI : list) {
                if (debug) {
                    log.debug((Object)("ProcessNode[" + baseQRI.getTitle() + "]"));
                }
                if (!parentNode.contains(baseQRI) && (baseQRI instanceof TableQRI || ++q == list.size())) {
                    ProcessNode newNode = new ProcessNode(baseQRI);
                    parentNode.getKids().add(newNode);
                    if (debug) {
                        log.debug((Object)("Adding new node[" + newNode.getQri().getTitle() + "] to Node[" + (parentNode.getQri() == null ? "root" : parentNode.getQri().getTitle()) + "]"));
                    }
                    parentNode = newNode;
                    continue;
                }
                for (ProcessNode kidNode : parentNode.getKids()) {
                    if (!kidNode.getQri().equals(baseQRI)) continue;
                    parentNode = kidNode;
                    continue block3;
                }
            }
            if (!debug) continue;
            log.debug((Object)"Current Tree:");
            QueryBldrPane.printTree(root, 0);
        }
        if (debug) {
            QueryBldrPane.printTree(root, 0);
        }
        StringBuilder fromStr = new StringBuilder();
        TableAbbreviator tableAbbreviator = new TableAbbreviator();
        LinkedList<Pair<DBTableInfo, String>> fromTbls = new LinkedList<Pair<DBTableInfo, String>>();
        boolean hqlHasSynJoins = QueryBldrPane.processTree(root, fromStr, fromTbls, 0, tableAbbreviator, tblTree, qfps, searchSynonymy, isSchemaExport, lastExportTime);
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select ");
        if (distinct || hqlHasSynJoins) {
            sqlStr.append(" distinct ");
        }
        if (!distinct) {
            fieldsStr.append(tableAbbreviator.getAbbreviation(rootTable.getTableTree()));
            fieldsStr.append(".");
            fieldsStr.append(rootTable.getTableInfo().getIdFieldName());
        }
        LinkedList<Pair<String, Object>> paramsToSet = new LinkedList<Pair<String, Object>>();
        boolean visibleFldExists = false;
        for (QueryFieldPanel qfi : qfps) {
            String criteria;
            boolean isDisplayOnly;
            if (qfi.getFieldQRI() == null) continue;
            if (qfi.isForDisplay()) {
                visibleFldExists = true;
                String fldSpec = qfi.getFieldQRI().getSQLFldSpec(tableAbbreviator, false, isSchemaExport);
                if (StringUtils.isNotEmpty((String)fldSpec)) {
                    if (fieldsStr.length() > 0) {
                        fieldsStr.append(", ");
                    }
                    fieldsStr.append(fldSpec);
                }
            }
            if (keysToRetrieve != null && !qfi.isEnforced() || (isDisplayOnly = StringUtils.isEmpty((String)(criteria = qfi.getCriteriaFormula(tableAbbreviator, paramsToSet))))) continue;
            if (criteria.equals("2+2=2") && qfi.isNegated()) {
                criteria = "";
            }
            if (criteria.length() > 0 && hqlHasSynJoins && QueryBldrPane.isSynSearchable(qfi.getFieldQRI()) && !qfi.isEmptyCriterion()) {
                criteria = QueryBldrPane.adjustForSynSearch(tableAbbreviator.getAbbreviation(qfi.getFieldQRI().getTable().getTableTree()), criteria, qfi.isNegated());
            }
            if (!isDisplayOnly && criteriaStr.length() > 0 && criteria.length() > 0) {
                criteriaStr.append(disjunct ? " OR " : " AND ");
            }
            criteriaStr.append(criteria);
        }
        if (!visibleFldExists) {
            throw new ParseException(UIRegistry.getResourceString("QueryBldrPane.NoVisibleColumns"), -1);
        }
        sqlStr.append((CharSequence)fieldsStr);
        sqlStr.append(" from ");
        sqlStr.append((CharSequence)fromStr);
        if (keysToRetrieve != null) {
            if (!StringUtils.isEmpty((String)criteriaStr.toString())) {
                criteriaStr.append(" and ");
            }
            criteriaStr.append(String.valueOf(tableAbbreviator.getAbbreviation(rootTable.getTableTree())) + "." + rootTable.getTableInfo().getIdFieldName() + " in(");
            boolean comma = false;
            for (RecordSetItemIFace recordSetItemIFace : keysToRetrieve.getOrderedItems()) {
                if (comma) {
                    criteriaStr.append(",");
                } else {
                    comma = true;
                }
                criteriaStr.append(recordSetItemIFace.getRecordId());
            }
            criteriaStr.append(")");
        } else {
            boolean isRootTbl = true;
            Iterator<Object> iterator = fromTbls.iterator();
            if (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                String specialColumnWhere = QueryAdjusterForDomain.getInstance().getSpecialColumns((DBTableInfo)pair.getFirst(), true, !isRootTbl, (String)pair.getSecond());
                isRootTbl = false;
                if (StringUtils.isNotEmpty((String)specialColumnWhere)) {
                    if (criteriaStr.length() > 0) {
                        criteriaStr.append(" AND ");
                    }
                    criteriaStr.append(specialColumnWhere);
                }
            }
            if (isSchemaExport && lastExportTime != null) {
                if (criteriaStr.length() > 0) {
                    criteriaStr.append(" AND (");
                }
                String string = "spparam" + paramsToSet.size();
                paramsToSet.add(new Pair<String, Timestamp>(string, lastExportTime));
                criteriaStr.append(QueryBldrPane.getTimestampWhere(fromTbls, string, lastExportTime));
                criteriaStr.append(") ");
            }
        }
        if (criteriaStr.length() > 0) {
            sqlStr.append(" where ");
            sqlStr.append((CharSequence)criteriaStr);
        }
        if (sortElements.size() > 0 && !postSortPresent) {
            for (SortElement se : sortElements) {
                if (!StringUtils.isEmpty((String)orderStr.toString())) {
                    orderStr.append(", ");
                }
                orderStr.append(distinct ? se.getColumn() + 1 : se.getColumn() + 2);
                if (se.getDirection() != 1) continue;
                orderStr.append(" DESC");
            }
            sortElements.clear();
        }
        if (orderStr.length() > 0) {
            sqlStr.append(" order by ");
            sqlStr.append((CharSequence)orderStr);
        }
        if (debug) {
            log.debug((Object)sqlStr.toString());
            log.debug((Object)"sort:");
            for (SortElement s : sortElements) {
                log.debug((Object)("  " + s.getColumn() + " - " + s.getDirection()));
            }
        }
        if (!QueryBldrPane.checkHQL(result = sqlStr.toString())) {
            return null;
        }
        log.info((Object)result);
        return new HQLSpecs(result, paramsToSet, sortElements);
    }

    protected static boolean checkHQL(String hql) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            session.createQuery(hql, false);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
            return false;
        }
        finally {
            session.close();
        }
    }

    public static String getCountHql(String hql) {
        int fromStart = hql.toLowerCase().indexOf(" from ");
        int orderStart = hql.toLowerCase().indexOf(" order by ");
        return "select count(*) " + (orderStart > fromStart ? hql.substring(fromStart, orderStart) : hql.substring(fromStart));
    }

    public static String getCountDistinctHql(String hql) {
        int fromStart = hql.toLowerCase().indexOf(" from ");
        int orderStart = hql.toLowerCase().indexOf(" order by ");
        int idEnd = hql.indexOf(44, 0);
        String fldPart = hql.substring(0, idEnd);
        if (fldPart.indexOf("distinct") != -1) {
            fldPart = fldPart.replaceFirst("select distinct ", "select ");
        }
        String distinctFldPart = String.valueOf(fldPart.replaceFirst("select ", "select count(distinct ")) + ") ";
        String distinctHql = String.valueOf(distinctFldPart) + " " + (orderStart > fromStart ? hql.substring(fromStart, orderStart) : hql.substring(fromStart));
        return distinctHql;
    }

    public static Pair<Boolean, Long> checkUniqueRecIds(String hql, List<Pair<String, Object>> params) {
        String countHql = QueryBldrPane.getCountHql(hql);
        String distinctHql = QueryBldrPane.getCountDistinctHql(hql);
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            DataProviderSessionIFace.QueryIFace q1 = session.createQuery(countHql, false);
            DataProviderSessionIFace.QueryIFace q2 = session.createQuery(distinctHql, false);
            for (Pair<String, Object> param : params) {
                q1.setParameter(param.getFirst(), param.getSecond());
                q2.setParameter(param.getFirst(), param.getSecond());
            }
            Long q1Size = Long.valueOf(q1.list().get(0).toString());
            Long q2Size = Long.valueOf(q2.list().get(0).toString());
            Pair<Boolean, Long> pair = new Pair<Boolean, Long>(q1Size.equals(q2Size), q1Size);
            return pair;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
        }
        finally {
            session.close();
        }
        return new Pair<Boolean, Long>(false, 0L);
    }

    protected static String getNextAlias(String rootAlias, ProcessNode node) {
        return String.valueOf(rootAlias) + "_" + DBTableIdMgr.getInstance().getByClassName(node.getRel().getClassName()).getAbbrev();
    }

    protected static String getTimestampFrom(String rootAlias, ProcessNode node, List<Pair<DBTableInfo, String>> fromTbls) {
        String nextAlias = QueryBldrPane.getNextAlias(rootAlias, node);
        String result = " left join " + rootAlias + "." + node.getRel().getName() + " " + nextAlias;
        fromTbls.add(new Pair<Object, String>(null, nextAlias));
        for (ProcessNode kid : node.getKids()) {
            result = String.valueOf(result) + QueryBldrPane.getTimestampFrom(nextAlias, kid, fromTbls);
        }
        return result;
    }

    protected static String getTimestampWhere(List<Pair<DBTableInfo, String>> fromTbls, String timestampParam, Timestamp lastExportTime) {
        String result = "";
        int f = 0;
        for (Pair<DBTableInfo, String> fromTbl : fromTbls) {
            if (f > 0) {
                result = String.valueOf(result) + " or ";
            }
            ++f;
            result = String.valueOf(result) + fromTbl.getSecond() + ".timestampModified > :" + timestampParam;
            result = String.valueOf(result) + " or ";
            result = String.valueOf(result) + fromTbl.getSecond() + ".timestampCreated > :" + timestampParam;
        }
        return result;
    }

    protected static void processFormatter(DataObjDataFieldFormatIFace formatter, ProcessNode node) {
        DataObjDataField[] dataObjDataFieldArray = formatter.getFields();
        int n = dataObjDataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjDataField fld = dataObjDataFieldArray[n2];
            if (fld.getObjFormatter() != null) {
                ProcessNode subNode = null;
                for (DataObjDataFieldFormatIFace subformatter : fld.getObjFormatter().getFormatters()) {
                    if (subNode == null) {
                        subNode = new ProcessNode(fld.getRelInfo());
                        node.getKids().add(subNode);
                    }
                    QueryBldrPane.processFormatter(subformatter, subNode);
                }
            }
            ++n2;
        }
    }

    protected static String adjustForSynSearch(String tblAlias, String criteria, boolean isNegated) {
        String result = "(" + criteria;
        String chunk = criteria.replace(String.valueOf(tblAlias) + ".", String.valueOf(QueryBldrPane.getAcceptedChildrenAlias(tblAlias)) + ".");
        if (isNegated) {
            chunk = "(" + QueryBldrPane.getAcceptedChildrenAlias(tblAlias) + ".nodeNumber is null or " + chunk.substring(1);
            result = String.valueOf(result) + " AND " + chunk;
        } else {
            result = String.valueOf(result) + " OR " + chunk;
        }
        chunk = criteria.replace(String.valueOf(tblAlias) + ".", String.valueOf(QueryBldrPane.getAcceptedParentAlias(tblAlias)) + ".");
        if (isNegated) {
            chunk = "(" + QueryBldrPane.getAcceptedParentAlias(tblAlias) + ".nodeNumber is null or " + chunk.substring(1);
            result = String.valueOf(result) + " AND " + chunk;
        } else {
            result = String.valueOf(result) + " OR " + chunk;
        }
        chunk = criteria.replace(String.valueOf(tblAlias) + ".", String.valueOf(QueryBldrPane.getAcceptedParentChildrenAlias(tblAlias)) + ".");
        if (isNegated) {
            chunk = "(" + QueryBldrPane.getAcceptedParentChildrenAlias(tblAlias) + ".nodeNumber is null or " + chunk.substring(1);
            result = String.valueOf(result) + " AND " + chunk + ") ";
        } else {
            result = String.valueOf(result) + " OR " + chunk + ") ";
        }
        return result;
    }

    protected void doSearch(TableQRI rootTable, boolean distinct, boolean disjunct) {
        try {
            HQLSpecs hql = QueryBldrPane.buildHQL(rootTable, distinct, this.queryFieldItems, this.tableTree, null, this.searchSynonymy, false, null, disjunct);
            this.processSQL(this.queryFieldItems, hql, rootTable.getTableInfo(), distinct);
        }
        catch (Exception ex) {
            String msg = StringUtils.isBlank((String)ex.getLocalizedMessage()) ? UIRegistry.getResourceString("QB_RUN_ERROR") : ex.getLocalizedMessage();
            UIRegistry.getStatusBar().setErrorMessage(msg, ex);
            UIRegistry.writeTimedSimpleGlassPaneMsg(msg, Color.RED);
            this.runningResults.set(null);
            this.completedResults.set(null);
        }
    }

    protected JPanel buildMoverPanel(boolean horizontal) {
        PanelBuilder upDownPanel;
        this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "QB_FLD_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryBldrPane.this.orderUp();
            }
        });
        this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "QB_FLD_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryBldrPane.this.orderDown();
            }
        });
        if (horizontal) {
            upDownPanel = new PanelBuilder(new FormLayout("f:p:g, p, 2px, p, f:p:g", "p"));
            CellConstraints cc = new CellConstraints();
            upDownPanel.add((Component)this.orderUpBtn, cc.xy(2, 1));
            upDownPanel.add((Component)this.orderDwnBtn, cc.xy(4, 1));
        } else {
            upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
            CellConstraints cc = new CellConstraints();
            upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
            upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
        }
        return upDownPanel.getPanel();
    }

    protected void orderUp() {
        this.moveField(this.selectedQFP, this.queryFieldItems.get(this.queryFieldItems.indexOf(this.selectedQFP) - 1));
    }

    protected void orderDown() {
        this.moveField(this.selectedQFP, this.queryFieldItems.get(this.queryFieldItems.indexOf(this.selectedQFP) + 1));
    }

    protected static boolean fieldHasCriteria(FieldQRI fld, List<QueryFieldPanel> fieldPanels) {
        for (QueryFieldPanel fldPanel : fieldPanels) {
            if (fldPanel.getFieldQRI() == null || fldPanel.getFieldQRI() != fld && !fldPanel.getFieldQRI().getStringId().equals(fld.getStringId())) continue;
            return fldPanel.hasCriteria();
        }
        return false;
    }

    protected static String getJoin(ProcessNode node) {
        return " left join ";
    }

    protected static String getAcceptedParentAlias(String taxAlias) {
        return String.valueOf(taxAlias) + "accpar";
    }

    protected static String getAcceptedParentChildrenAlias(String taxAlias) {
        return String.valueOf(taxAlias) + "accparchi";
    }

    protected static String getAcceptedChildrenAlias(String taxAlias) {
        return String.valueOf(taxAlias) + "accchi";
    }

    protected static boolean isSynSearchable(FieldQRI fld) {
        if (!Treeable.class.isAssignableFrom(fld.getTableInfo().getClassObj())) {
            return false;
        }
        SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        TreeDefIface<?, ?, ?> treeDef = spMgr.getTreeDefForClass(fld.getTableInfo().getClassObj());
        if (treeDef.isSynonymySupported()) {
            return fld.getFieldName().equalsIgnoreCase("name") || fld.getFieldName().equalsIgnoreCase("fullname") || fld instanceof TreeLevelQRI;
        }
        return false;
    }

    protected static boolean processTree(ProcessNode parent, StringBuilder sqlStr, List<Pair<DBTableInfo, String>> fromTbls, int level, TableAbbreviator tableAbbreviator, TableTree tblTree, List<QueryFieldPanel> fieldPanels, boolean searchSynonymy, boolean isSchemaExport, Timestamp exportTimestamp) {
        BaseQRI qri = parent.getQri();
        boolean hqlHasSynJoins = false;
        if (qri != null && qri.getTableTree() != tblTree) {
            if (qri instanceof TableQRI) {
                String extraJoin;
                boolean skipExtraJoin;
                TableTree tt = qri.getTableTree();
                String alias = tableAbbreviator.getAbbreviation(tt);
                fromTbls.add(new Pair<DBTableInfo, String>(tt.getTableInfo(), alias));
                if (level == 1) {
                    sqlStr.append(tt.getName());
                    sqlStr.append(' ');
                    sqlStr.append(alias);
                    sqlStr.append(' ');
                } else {
                    sqlStr.append(QueryBldrPane.getJoin(parent));
                    sqlStr.append(tableAbbreviator.getAbbreviation(tt.getParent()));
                    sqlStr.append('.');
                    sqlStr.append(tt.getField());
                    sqlStr.append(' ');
                    sqlStr.append(alias);
                    sqlStr.append(' ');
                    if (searchSynonymy && Treeable.class.isAssignableFrom(((TableQRI)qri).getTableInfo().getClassObj())) {
                        TableQRI tqri = (TableQRI)qri;
                        boolean addSynJoin = false;
                        for (QueryFieldPanel qfp : fieldPanels) {
                            if (qfp.getFieldQRI() == null || !QueryBldrPane.isSynSearchable(qfp.getFieldQRI()) || !qfp.hasCriteria()) continue;
                            addSynJoin = true;
                            break;
                        }
                        if (addSynJoin) {
                            hqlHasSynJoins = true;
                            sqlStr.append("left join ");
                            sqlStr.append(String.valueOf(alias) + ".acceptedChildren " + QueryBldrPane.getAcceptedChildrenAlias(alias) + " ");
                            sqlStr.append("left join ");
                            sqlStr.append(String.valueOf(alias) + ".accepted" + tqri.getTableInfo().getShortClassName() + " " + QueryBldrPane.getAcceptedParentAlias(alias) + " left join " + QueryBldrPane.getAcceptedParentAlias(alias) + ".acceptedChildren " + QueryBldrPane.getAcceptedParentChildrenAlias(alias) + " ");
                        }
                    }
                }
                boolean bl = skipExtraJoin = level > 1;
                if (!skipExtraJoin && StringUtils.isNotEmpty((String)(extraJoin = QueryAdjusterForDomain.getInstance().getJoinClause(tt.getTableInfo(), true, alias, false)))) {
                    sqlStr.append(String.valueOf(extraJoin) + " ");
                }
            } else if (qri instanceof RelQRI && isSchemaExport && exportTimestamp != null) {
                RelQRI relQRI = (RelQRI)qri;
                DBRelationshipInfo.RelationshipType relType = relQRI.getRelationshipInfo().getType();
                DataObjDataFieldFormatIFace formatter = relQRI.getDataObjFormatter();
                if (!relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToOne) && !relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany) || formatter.getSingleField() == null) {
                    ProcessNode newNode = new ProcessNode(relQRI);
                    if (formatter != null) {
                        QueryBldrPane.processFormatter(formatter, newNode);
                    }
                    String rootAlias = tableAbbreviator.getAbbreviation(relQRI.getTableTree().getParent());
                    String formFrom = QueryBldrPane.getTimestampFrom(rootAlias, newNode, fromTbls);
                    sqlStr.append(" ");
                    sqlStr.append(formFrom);
                    sqlStr.append(" ");
                }
            }
        }
        for (ProcessNode kid : parent.getKids()) {
            hqlHasSynJoins |= QueryBldrPane.processTree(kid, sqlStr, fromTbls, level + 1, tableAbbreviator, tblTree, fieldPanels, searchSynonymy, isSchemaExport, exportTimestamp);
        }
        return hqlHasSynJoins;
    }

    public static String fixFldNameForJR(String fldName) {
        return fldName.trim().replaceAll(" ", "_");
    }

    protected static UIFieldFormatterIFace getColumnFormatter(FieldQRI fqri, boolean forSchemaExport) {
        if (fqri instanceof RelQRI) {
            DataObjDataFieldFormatIFace formatter = ((RelQRI)fqri).getDataObjFormatter();
            if (formatter != null && formatter.getSingleField() != null) {
                return fqri.getTableInfo().getFieldByName(formatter.getSingleField()).getFormatter();
            }
            return null;
        }
        if (forSchemaExport && (fqri.getDataClass().equals(Calendar.class) || Date.class.isAssignableFrom(fqri.getDataClass()))) {
            return new DateExportFormatter();
        }
        return fqri.getFormatter();
    }

    public static List<ERTICaptionInfoQB> getColumnInfo(Vector<QueryFieldPanel> queryFieldItemsArg, boolean fixLabels, DBTableInfo rootTbl, boolean forSchemaExport) {
        Vector<ERTICaptionInfoQB> result = new Vector<ERTICaptionInfoQB>();
        Vector<ERTICaptionInfoTreeLevelGrp> treeGrps = new Vector<ERTICaptionInfoTreeLevelGrp>(5);
        for (QueryFieldPanel qfp : queryFieldItemsArg) {
            String lbl;
            if (qfp.getFieldQRI() == null) continue;
            DBFieldInfo fi = qfp.getFieldInfo();
            DBTableInfo ti = null;
            if (fi != null) {
                ti = fi.getTableInfo();
            }
            String colName = qfp.getFieldName();
            if (ti != null && fi != null) {
                colName = String.valueOf(ti.getAbbrev()) + '.' + fi.getColumn();
            }
            if (!qfp.isForDisplay()) continue;
            String string = lbl = qfp.getSchemaItem() == null ? qfp.getLabel() : qfp.getSchemaItem().getFieldName();
            if (fixLabels) {
                lbl = QueryBldrPane.fixFldNameForJR(lbl);
            }
            ERTICaptionInfoQB erti = null;
            boolean buildRelERTI = false;
            if (qfp.getFieldQRI() instanceof RelQRI) {
                DataObjDataFieldFormatIFace formatter;
                DBRelationshipInfo.RelationshipType relType = ((RelQRI)qfp.getFieldQRI()).getRelationshipInfo().getType();
                buildRelERTI = relType != DBRelationshipInfo.RelationshipType.ManyToOne ? true : ((formatter = ((RelQRI)qfp.getFieldQRI()).getDataObjFormatter()) != null ? formatter.getSingleField() == null : true);
            }
            if (buildRelERTI) {
                RelQRI rqri = (RelQRI)qfp.getFieldQRI();
                DBRelationshipInfo.RelationshipType relType = rqri.getRelationshipInfo().getType();
                boolean useCache = relType == DBRelationshipInfo.RelationshipType.ManyToOne || relType == DBRelationshipInfo.RelationshipType.ManyToMany ? true : rootTbl != null && rootTbl.getTableId() != rqri.getTableInfo().getTableId();
                erti = new ERTICaptionInfoRel(colName, lbl, true, qfp.getFieldQRI().getFormatter(), 0, qfp.getStringId(), ((RelQRI)qfp.getFieldQRI()).getRelationshipInfo(), useCache, null);
            } else if (qfp.getFieldQRI() instanceof TreeLevelQRI) {
                TreeLevelQRI tqri = (TreeLevelQRI)qfp.getFieldQRI();
                for (ERTICaptionInfoTreeLevelGrp tg : treeGrps) {
                    erti = tg.addRank((TreeLevelQRI)qfp.getFieldQRI(), colName, lbl, qfp.getStringId(), tqri.getRealFieldName());
                    if (erti != null) break;
                }
                if (erti == null) {
                    ERTICaptionInfoTreeLevelGrp newTg = new ERTICaptionInfoTreeLevelGrp(tqri.getTreeDataClass(), tqri.getTreeDefId(), tqri.getTableAlias(), true, null);
                    erti = newTg.addRank(tqri, colName, lbl, qfp.getStringId(), tqri.getRealFieldName());
                    treeGrps.add(newTg);
                }
            } else {
                erti = new ERTICaptionInfoQB(colName, lbl, true, QueryBldrPane.getColumnFormatter(qfp.getFieldQRI(), forSchemaExport), 0, qfp.getStringId(), qfp.getPickList(), fi);
            }
            erti.setColClass(qfp.getFieldQRI().getDataClass());
            if (!forSchemaExport && qfp.getFieldInfo() != null && !(qfp.getFieldQRI() instanceof DateAccessorQRI) && qfp.getFieldQRI().getFieldInfo().isPartialDate()) {
                String precName = qfp.getFieldQRI().getFieldInfo().getDatePrecisionName();
                Vector<ERTICaptionInfo.ColInfo> colInfoList = new Vector<ERTICaptionInfo.ColInfo>();
                ERTICaptionInfoQB eRTICaptionInfoQB = erti;
                eRTICaptionInfoQB.getClass();
                ERTICaptionInfo.ColInfo columnInfo = eRTICaptionInfoQB.new ERTICaptionInfo.ColInfo(StringUtils.capitalize((String)precName), precName);
                columnInfo.setPosition(0);
                colInfoList.add(columnInfo);
                ERTICaptionInfoQB eRTICaptionInfoQB2 = erti;
                eRTICaptionInfoQB2.getClass();
                columnInfo = eRTICaptionInfoQB2.new ERTICaptionInfo.ColInfo(qfp.getFieldQRI().getFieldInfo().getColumn(), qfp.getFieldQRI().getFieldInfo().getName());
                columnInfo.setPosition(1);
                colInfoList.add(columnInfo);
                erti.setColInfoList(colInfoList);
                erti.setColName(null);
                erti.setUiFieldFormatter(UIFieldFormatterMgr.getInstance().getFormatter("PartialDate"));
            }
            result.add(erti);
        }
        for (ERTICaptionInfoTreeLevelGrp tg : treeGrps) {
            try {
                tg.setUp();
            }
            catch (SQLException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public static List<ERTICaptionInfo> getColumnInfo(String queryName, boolean fixLabels) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpQuery fndQuery = session.getData(SpQuery.class, "name", queryName, DataProviderSessionIFace.CompareType.Equals);
            if (fndQuery == null) {
                throw new Exception("Unable to load query " + queryName);
            }
            List<ERTICaptionInfo> list = QueryBldrPane.getColumnInfoSp(fndQuery.getFields(), fixLabels);
            return list;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryBldrPane.class, e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    protected static Class<?> getDataClass(SpQueryField qf, DBFieldInfo fi) {
        String idString;
        if (Calendar.class.isAssignableFrom(fi.getDataClass()) && ((idString = qf.getStringId()).endsWith(String.valueOf(fi.getName()) + DateAccessorQRI.DATEPART.NumericDay.toString()) || idString.endsWith(String.valueOf(fi.getName()) + DateAccessorQRI.DATEPART.NumericMonth.toString()) || idString.endsWith(String.valueOf(fi.getName()) + DateAccessorQRI.DATEPART.NumericYear.toString()))) {
            return Integer.class;
        }
        return fi.getDataClass();
    }

    public static List<ERTICaptionInfo> getColumnInfoSp(Set<SpQueryField> queryFields, boolean fixLabels) {
        Vector<ERTICaptionInfo> result = new Vector<ERTICaptionInfo>();
        for (SpQueryField qf : queryFields) {
            if (qf.getContextTableIdent() != null) {
                ERTICaptionInfoQB erti;
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(qf.getContextTableIdent());
                if (AppContextMgr.isSecurityOn() && !ti.getPermissions().canView()) continue;
                DBFieldInfo fi = ti.getFieldByColumnName(qf.getFieldName());
                String colName = String.valueOf(ti.getAbbrev()) + '.' + qf.getFieldName();
                if (!qf.getIsDisplay().booleanValue()) continue;
                String lbl = qf.getColumnAliasTitle();
                if (fixLabels) {
                    lbl = lbl.replaceAll(" ", "_");
                    lbl = lbl.replaceAll("/", "_");
                    lbl = lbl.replaceAll("#", "_");
                }
                if (fi != null) {
                    erti = new ERTICaptionInfoQB(colName, lbl, true, fi.getFormatter(), 0, qf.getStringId(), RecordTypeCodeBuilder.getTypeCode(fi), fi);
                    erti.setColClass(QueryBldrPane.getDataClass(qf, fi));
                } else {
                    erti = new ERTICaptionInfoQB(colName, lbl, true, null, 0, qf.getStringId(), null, fi);
                    erti.setColClass(String.class);
                }
                result.add(erti);
                continue;
            }
            log.error((Object)("null contextTableIdent for " + qf.getFieldName()));
        }
        return result;
    }

    protected List<SpReport> getReports() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpReport> list = session.getDataList(SpReport.class, "query", this.query);
            return list;
        }
        finally {
            session.close();
        }
    }

    public static void runReport(SpReport report, String title, RecordSetIFace rs) {
        block26: {
            boolean isQueryBuilderRep = report.getReportObject() instanceof SpQuery;
            if (isQueryBuilderRep) {
                UsageTracker.incrUsageCount("QB.RunReport." + report.getQuery().getContextName());
            } else {
                UsageTracker.incrUsageCount("WB.RunReport");
            }
            TableTree tblTree = null;
            Hashtable<String, TableTree> ttHash = null;
            QueryParameterPanel qpp = null;
            if (isQueryBuilderRep) {
                UsageTracker.incrUsageCount("QB.RunReport." + report.getQuery().getContextName());
                QueryTask qt = (QueryTask)ContextMgr.getTaskByClass(QueryTask.class);
                if (qt == null) {
                    log.error((Object)("Could not find the Query task when running report " + report.getName()));
                    throw new RuntimeException("Could not find the Query task when running report " + report.getName());
                }
                Pair<TableTree, Hashtable<String, TableTree>> trees = qt.getTableTrees();
                tblTree = trees.getFirst();
                ttHash = trees.getSecond();
                qpp = new QueryParameterPanel();
                qpp.setQuery(report.getQuery(), tblTree, ttHash);
            }
            boolean go = true;
            try {
                JasperCompilerRunnable jcr = new JasperCompilerRunnable(null, report.getName(), null);
                jcr.findFiles();
                if (jcr.isCompileRequired()) {
                    jcr.get();
                }
                JasperReport jr = !jcr.isCompileRequired() ? (JasperReport)JRLoader.loadObject((File)jcr.getCompiledFile()) : null;
                ReportParametersPanel rpp = jr != null ? new ReportParametersPanel(jr, true) : null;
                Object src = null;
                if (rs == null && (qpp != null && qpp.getHasPrompts() || rpp != null && rpp.getParamCount() > 0)) {
                    JComponent pane = null;
                    if (qpp != null && qpp.getHasPrompts() && rpp != null && rpp.getParamCount() > 0) {
                        pane = new JTabbedPane();
                        ((JTabbedPane)pane).addTab(UIRegistry.getResourceString("QB_REP_RUN_CRITERIA_TAB_TITLE"), new JScrollPane(qpp, 20, 31));
                        ((JTabbedPane)pane).addTab(UIRegistry.getResourceString("QB_REP_RUN_PARAM_TAB_TITLE"), new JScrollPane(rpp, 20, 31));
                    } else {
                        pane = qpp != null && qpp.getHasPrompts() ? new JScrollPane(qpp, 20, 31) : new JScrollPane(rpp, 20, 31);
                    }
                    CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("QB_GET_REPORT_CONTENTS_TITLE"), true, 7, (Component)pane);
                    cd.setHelpContext("RepRunSettings");
                    cd.createUI();
                    Dimension ps = cd.getPreferredSize();
                    ps.setSize(ps.getWidth() * 1.3, ps.getHeight());
                    cd.setSize(ps);
                    UIHelper.centerAndShow(cd);
                    go = !cd.isCancelled();
                    cd.dispose();
                }
                if (!go) break block26;
                if (isQueryBuilderRep) {
                    TableQRI rootQRI = null;
                    short cId = report.getQuery().getContextTableId();
                    for (TableTree tt : ttHash.values()) {
                        if (cId != tt.getTableInfo().getTableId()) continue;
                        rootQRI = tt.getTableQRI();
                        break;
                    }
                    Vector<QueryFieldPanel> qfps = new Vector<QueryFieldPanel>(qpp.getFields());
                    int f = 0;
                    while (f < qpp.getFields()) {
                        qfps.add(qpp.getField(f));
                        ++f;
                    }
                    HQLSpecs sql = null;
                    boolean includeRecordIds = !report.getQuery().isSelectDistinct();
                    try {
                        sql = QueryBldrPane.buildHQL(rootQRI, !includeRecordIds, qfps, tblTree, rs, report.getQuery().getSearchSynonymy() == null ? false : report.getQuery().getSearchSynonymy(), false, null);
                    }
                    catch (Exception ex) {
                        String msg = StringUtils.isBlank((String)ex.getLocalizedMessage()) ? UIRegistry.getResourceString("QB_RUN_ERROR") : ex.getLocalizedMessage();
                        UIRegistry.getStatusBar().setErrorMessage(msg, ex);
                        UIRegistry.writeTimedSimpleGlassPaneMsg(msg, Color.RED);
                        return;
                    }
                    src = new QBDataSource(sql.getHql(), sql.getArgs(), sql.getSortElements(), QueryBldrPane.getColumnInfo(qfps, true, rootQRI.getTableInfo(), false), includeRecordIds, report.getRepeats());
                    ((QBDataSource)src).startDataAcquisition();
                } else {
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    try {
                        Workbench wb;
                        boolean loadedWB = false;
                        if (rs != null && rs.getOnlyItem() != null && (wb = session.get(Workbench.class, rs.getOnlyItem().getRecordId())) != null) {
                            wb.forceLoad();
                            src = new WorkbenchJRDataSource(wb, true);
                            loadedWB = true;
                        }
                        if (!loadedWB) {
                            UIRegistry.displayErrorDlgLocalized("QueryBldrPane.WB_LOAD_ERROR_FOR_REPORT", rs != null ? rs.getName() : "[" + UIRegistry.getResourceString("NONE") + "]");
                            return;
                        }
                    }
                    finally {
                        session.close();
                    }
                }
                CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", src);
                cmd.setProperty("title", title);
                cmd.setProperty("file", report.getName());
                if (rs == null) {
                    cmd.setProperty("skip-parameter-prompt", "true");
                }
                if (!jcr.isCompileRequired()) {
                    cmd.setProperty("compiled-file", jcr.getCompiledFile());
                }
                if (rpp != null && rpp.getParamCount() > 0) {
                    StringBuilder params = new StringBuilder();
                    int p = 0;
                    while (p < rpp.getParamCount()) {
                        Pair<String, String> param = rpp.getParam(p);
                        if (StringUtils.isNotBlank((String)param.getSecond())) {
                            params.append(param.getFirst());
                            params.append("=");
                            params.append(param.getSecond());
                            params.append(";");
                        }
                        cmd.setProperty("params", params.toString());
                        ++p;
                    }
                }
                CommandDispatcher.dispatch(cmd);
            }
            catch (JRException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryBldrPane.class, (Exception)((Object)ex));
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
    }

    public void resultsComplete() {
        this.completedResults.set(this.runningResults.get());
        this.runningResults.set(null);
        if (this.completedResults.get() != null && !this.completedResults.get().getCancelled()) {
            int results = this.completedResults.get().getQuery().getDataObjects().size();
            if (results > this.completedResults.get().getMaxTableRows() && !this.countOnly && !this.completedResults.get().getQuery().isCancelled()) {
                if (this.schemaMapping == null) {
                    UIRegistry.displayInfoMsgDlgLocalized("QB_PARTIAL_RESULTS_DISPLAY", this.completedResults.get().getMaxTableRows(), results);
                } else {
                    UIRegistry.displayInfoMsgDlgLocalized("QB_PREVIEW_DISPLAY", this.completedResults.get().getMaxTableRows(), results);
                }
            } else if (this.schemaMapping != null) {
                UIRegistry.displayInfoMsgDlgLocalized("QB_PREVIEW_DISPLAY_TINY", new Object[0]);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String searchLbl = QueryBldrPane.this.schemaMapping == null ? UIRegistry.getResourceString("QB_SEARCH") : UIRegistry.getResourceString("QB_EXPORT_PREVIEW");
                QueryBldrPane.this.searchBtn.setText(searchLbl);
                if (QueryBldrPane.this.query != null) {
                    UIRegistry.getStatusBar().setProgressDone(QueryBldrPane.this.query.getName());
                }
                UIRegistry.displayStatusBarText("");
            }
        });
    }

    public boolean isCountOnly() {
        return this.countOnly;
    }

    protected void launchPartialResultDisplayMsg(final String hql) {
        new SwingWorker(){
            protected Integer count = null;

            @Override
            public Object construct() {
                String countHql = QueryBldrPane.getCountHql(hql);
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    DataProviderSessionIFace.QueryIFace q = session.createQuery(countHql, false);
                    this.count = (Integer)q.list().get(0);
                }
                finally {
                    session.close();
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.count != null && this.count > 20000) {
                    String msg = String.format(UIRegistry.getResourceString("QB_DISPLAYING_RETRIEVED_RESULTS_PARTIAL"), String.valueOf(this.count), String.format("%04.2f", (double)(QueryBldrPane.this.doneTime.get() - QueryBldrPane.this.startTime.get()) / 1.0E9), String.valueOf(20000));
                    UIRegistry.displayStatusBarText(msg);
                }
            }
        }.start();
    }

    public boolean queryTaskDone() {
        boolean result = true;
        this.doneTime.set(System.nanoTime());
        if (this.runningResults.get() != null && this.runningResults.get().getQuery() != null) {
            if (!(this.countOnly || this.runningResults.get().getQuery().isCancelled() || this.runningResults.get().getQuery().isInError())) {
                int results = this.runningResults.get().getQuery().getDataObjects().size();
                if (results == 20000) {
                    this.launchPartialResultDisplayMsg(this.runningResults.get().getHQL());
                }
                String msg = "";
                if (results <= this.runningResults.get().getMaxTableRows()) {
                    msg = String.format(UIRegistry.getResourceString("QB_DISPLAYING_RETRIEVED_RESULTS"), String.valueOf(results), String.format("%04.2f", (double)(this.doneTime.get() - this.startTime.get()) / 1.0E9));
                } else if (!this.runningResults.get().isPostSorted()) {
                    msg = String.format(UIRegistry.getResourceString("QB_DISPLAYING_RETRIEVED_RESULTS_PARTIAL"), String.valueOf(results), String.format("%04.2f", (double)(this.doneTime.get() - this.startTime.get()) / 1.0E9), String.valueOf(this.runningResults.get().getMaxTableRows()));
                } else {
                    result = false;
                }
                if (result) {
                    UIRegistry.displayStatusBarText(msg);
                    if (this.query != null && this.runningResults != null && this.runningResults.get() != null) {
                        final String qName = this.query.getName();
                        final int qResults = results;
                        final int qMaxRows = this.runningResults.get().getMaxTableRows();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.getStatusBar().setProgressRange(qName, 0, Math.min(qResults, qMaxRows));
                            }
                        });
                    }
                }
            }
            boolean isExtraOK = false;
            if (this.runningResults != null && this.runningResults.get() != null && this.runningResults.get().getQuery() != null) {
                boolean bl = isExtraOK = this.runningResults.get().getQuery().isCancelled() || this.runningResults.get().getQuery().isInError();
            }
            if (!result || this.countOnly || isExtraOK) {
                UIRegistry.displayStatusBarText("");
                final String qName = this.query.getName();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String searchLbl = QueryBldrPane.this.schemaMapping == null ? UIRegistry.getResourceString("QB_SEARCH") : UIRegistry.getResourceString("QB_EXPORT_PREVIEW");
                        QueryBldrPane.this.searchBtn.setText(searchLbl);
                        UIRegistry.getStatusBar().setProgressDone(qName);
                    }
                });
                result = false;
            }
            if (!result || this.countOnly && !this.runningResults.get().getQuery().isCancelled() && !this.runningResults.get().getQuery().isInError()) {
                if (this.countOnly) {
                    Object resultObj = this.runningResults.get().getQuery().getDataObjects().get(0);
                    int count = (Integer)resultObj;
                    UIRegistry.showLocalizedMsg("QB_COUNT_TITLE", "QB_COUNT_MSG", count);
                } else if (this.runningResults.get().isPostSorted()) {
                    PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, f:p:g, 2dlu, f:p:g, 2dlu, f:p:g, 5dlu"));
                    pb.add((Component)new JLabel(String.format(UIRegistry.getResourceString("QB_CANT_DISPLAY_MSG1"), this.runningResults.get().getQuery().getDataObjects().size())), new CellConstraints().xy(2, 2));
                    pb.add((Component)new JLabel(String.format(UIRegistry.getResourceString("QB_CANT_DISPLAY_MSG2"), this.runningResults.get().getMaxTableRows())), new CellConstraints().xy(2, 4));
                    pb.add((Component)new JLabel(UIRegistry.getResourceString("QB_CANT_DISPLAY_MSG3")), new CellConstraints().xy(2, 6));
                    CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("QB_CANT_DISPLAY_TITLE"), true, 5, (Component)pb.getPanel());
                    dlg.setHelpContext("QBTooManyRecordsForSort");
                    UIHelper.centerAndShow(dlg);
                    dlg.dispose();
                }
            }
        }
        return result;
    }

    protected void processSQL(Vector<QueryFieldPanel> queryFieldItemsArg, final HQLSpecs hqlSpecs, DBTableInfo rootTable, boolean distinct) {
        List<ERTICaptionInfo> captions = QueryBldrPane.getColumnInfo(queryFieldItemsArg, false, rootTable, false);
        String iconName = distinct ? "BlankIcon" : rootTable.getClassObj().getSimpleName();
        int tblId = distinct ? -1 : rootTable.getTableId();
        final QBQueryForIdResultsHQL qri = new QBQueryForIdResultsHQL(TITLEBAR_COLOR, UIRegistry.getResourceString("QB_SEARCH_RESULTS"), iconName, tblId, this);
        String hql = hqlSpecs.getHql();
        if (this.countOnly) {
            hql = QueryBldrPane.getCountHql(hql);
        }
        qri.setSQL(hql);
        qri.setParams(hqlSpecs.getArgs());
        qri.setSort(hqlSpecs.getSortElements());
        qri.setCaptions(captions);
        qri.setExpanded(true);
        qri.setHasIds(!distinct);
        boolean filterDups = false;
        if (distinct) {
            for (ERTICaptionInfo caption : captions) {
                DBRelationshipInfo.RelationshipType relType;
                if (caption instanceof ERTICaptionInfoTreeLevel) {
                    filterDups = true;
                    break;
                }
                if (!(caption instanceof ERTICaptionInfoRel) || !(relType = ((ERTICaptionInfoRel)caption).getRelationship().getType()).equals((Object)DBRelationshipInfo.RelationshipType.OneToMany) && !relType.equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany)) continue;
                filterDups = true;
                break;
            }
        }
        qri.setFilterDups(filterDups);
        if (this.schemaMapping != null) {
            qri.setMaxTableRows(120);
        } else {
            qri.setMaxTableRows(20000);
        }
        this.runningResults.set(qri);
        this.doneTime.set(-1L);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryBldrPane.this.runningResults.get() != null && !QueryBldrPane.this.runningResults.get().getCancelled()) {
                    UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("QB_SEARCHING"));
                    QueryBldrPane.this.searchBtn.setText(UIRegistry.getResourceString("QB_CANCEL"));
                    UIRegistry.getStatusBar().setIndeterminate(QueryBldrPane.this.query.getName(), true);
                }
            }
        });
        new SwingWorker(){

            @Override
            public Object construct() {
                if (QueryBldrPane.this.schemaMapping != null && !QueryBldrPane.this.countOnly && !QueryBldrPane.checkUniqueRecIds(hqlSpecs.getHql(), hqlSpecs.getArgs()).getFirst().booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("ExportPanel.DUPLICATE_KEYS_EXPORT"));
                        }
                    });
                    QueryBldrPane.this.runningResults.set(null);
                    QueryBldrPane.this.resultsComplete();
                    return null;
                }
                if (QueryBldrPane.this.esrp == null) {
                    CommandAction cmdAction = new CommandAction("Express_Search", "HQL", qri);
                    cmdAction.setProperty("reuse_panel", true);
                    CommandDispatcher.dispatch(cmdAction);
                } else {
                    QueryBldrPane.this.esrp.addSearchResults(qri);
                }
                return null;
            }
        }.start();
        this.startTime.set(System.nanoTime());
    }

    protected static void printTree(ProcessNode pn, int lvl) {
        int i = 0;
        while (i < lvl) {
            log.debug((Object)" ");
            System.out.print(" ");
            ++i;
        }
        log.debug((Object)pn);
        System.out.println(pn);
        for (ProcessNode kid : pn.getKids()) {
            QueryBldrPane.printTree(kid, lvl + 1);
        }
    }

    protected SpQuery cloneTheQuery() {
        SpQuery result = new SpQuery();
        result.initialize();
        result.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        result.setName(this.query.getName());
        result.setContextTableId(this.query.getContextTableId());
        result.setContextName(this.query.getContextName());
        for (QueryFieldPanel qfp : this.queryFieldItems) {
            SpQueryField qf = qfp.getQueryField();
            if (qf == null) continue;
            SpQueryField newQf = new SpQueryField();
            newQf.initialize();
            newQf.setFieldName(qf.getFieldName());
            newQf.setPosition(qf.getPosition());
            qfp.updateQueryField(newQf);
            result.addReference(newQf, "fields");
        }
        return result;
    }

    protected SpExportSchemaMapping cloneTheSchemaMapping(SpQuery clonedQuery) {
        SpExportSchemaMapping result = new SpExportSchemaMapping();
        result.initialize();
        result.setMappingName(this.schemaMapping.getMappingName());
        result.setDescription(this.schemaMapping.getDescription());
        result.setSpExportSchema(this.schemaMapping.getSpExportSchema());
        for (SpExportSchemaItemMapping item : this.schemaMapping.getMappings()) {
            SpExportSchemaItemMapping newItem = new SpExportSchemaItemMapping();
            newItem.initialize();
            newItem.setExportSchemaItem(item.getExportSchemaItem());
            SpQueryField qf = item.getQueryField();
            for (SpQueryField newQf : clonedQuery.getFields()) {
                if (!qf.getStringId().equalsIgnoreCase(newQf.getStringId())) continue;
                newItem.setQueryField(newQf);
                newQf.setMapping(newItem);
                break;
            }
            newItem.setExportSchemaMapping(result);
            result.getMappings().add(newItem);
        }
        return result;
    }

    protected boolean getExportMappingQueryName() {
        String baseName;
        String result = baseName = String.valueOf(this.exportSchema.getSchemaName()) + this.exportSchema.getSchemaVersion();
        int cnt = BasicSQLUtils.getCount("select count(*) from spquery where name = '" + result + "'");
        int suffix = 2;
        while (cnt > 0) {
            result = String.valueOf(baseName) + "_" + suffix;
            cnt = BasicSQLUtils.getCount("select count(*) from spquery where name = '" + result + "'");
            ++suffix;
        }
        this.query.setName(result);
        this.schemaMapping.setMappingName(result);
        return true;
    }

    protected boolean saveQuery(boolean saveAs) {
        TableQRI tableQRI;
        int origCount;
        boolean result = false;
        if (this.exportSchema == null ? (!this.query.isNamed() || saveAs) && !this.getQueryNameFromUser(saveAs) : (!this.query.isNamed() || saveAs) && !this.getExportMappingQueryName()) {
            return false;
        }
        UsageTracker.incrUsageCount("QB.SaveQuery." + this.query.getContextName());
        if (!saveAs && this.query.getId() != null && (origCount = BasicSQLUtils.getCountAsInt("select count(*) from spqueryfield where spqueryid=" + this.query.getId())) > this.query.getFields().size()) {
            this.query.setTimestampModified(new Timestamp(System.currentTimeMillis()));
        }
        if ((tableQRI = (TableQRI)this.tableList.getSelectedValue()) != null) {
            short position = 0;
            HashSet<Integer> queryFldsWithoutPanels = new HashSet<Integer>();
            for (SpQueryField qf : this.query.getFields()) {
                queryFldsWithoutPanels.add(qf.getId());
            }
            for (QueryFieldPanel qfp : this.queryFieldItems) {
                if (qfp.getQueryField() == null) continue;
                SpQueryField qf = qfp.getQueryField();
                queryFldsWithoutPanels.remove(qf.getId());
                qf.setPosition(position);
                qfp.updateQueryField();
                position = (short)(position + 1);
            }
            if (!this.checkCriteriaLengths(this.query)) {
                return false;
            }
            block5: for (Integer qfId : queryFldsWithoutPanels) {
                for (SpQueryField qf : this.query.getFields()) {
                    if (qfId == null || qf == null || qf.getId() == null || !qfId.equals(qf.getId())) continue;
                    this.query.getFields().remove(qf);
                    continue block5;
                }
            }
            if (this.query.getSpQueryId() == null || saveAs) {
                if (this.query.getSpQueryId() != null && saveAs) {
                    this.query = this.cloneTheQuery();
                    this.schemaMapping = this.cloneTheSchemaMapping(this.query);
                    this.queryNavBtn.setEnabled(true);
                }
                this.queryNavBtn = ((QueryTask)this.task).saveNewQuery(this.query, this.schemaMapping, false);
                this.query.setNamed(true);
                if (this.query.getSpQueryId() != null && saveAs) {
                    this.setupUI();
                }
                SubPaneMgr.getInstance().renamePane(this, this.query.getName());
                return true;
            }
            result = this.schemaMapping != null ? DataModelObjBase.save(true, new Object[]{this.query, this.schemaMapping}) : DataModelObjBase.save(true, new Object[]{this.query});
            if (result) {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    this.query = session.get(SpQuery.class, this.query.getId());
                    this.query.forceLoad(true);
                    this.schemaMapping = this.query.getMapping();
                    if (this.schemaMapping != null) {
                        this.schemaMapping.forceLoad();
                    }
                }
                finally {
                    session.close();
                }
            }
            return result;
        }
        log.error((Object)"No Context selected!");
        return false;
    }

    protected boolean checkCriteriaLengths(SpQuery query) {
        boolean result = true;
        Set<SpQueryField> flds = query.getFields();
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoByTableName("spqueryfield");
        int maxStartLen = tblInfo.getFieldByColumnName("StartValue").getLength();
        int maxEndLen = tblInfo.getFieldByColumnName("EndValue").getLength();
        Vector<String> badFields = new Vector<String>();
        if (flds != null) {
            for (SpQueryField fld : flds) {
                Integer startLen = fld.getStartValue() == null ? 0 : fld.getStartValue().length();
                Integer endLen = fld.getEndValue() == null ? 0 : fld.getEndValue().length();
                if (startLen <= maxStartLen && endLen <= maxEndLen) continue;
                badFields.add(fld.getColumnAliasTitle());
            }
            if (badFields.size() > 0) {
                String fldList = "";
                int f = 0;
                while (f < 5 && f < badFields.size()) {
                    if (f > 0) {
                        fldList = String.valueOf(fldList) + ", ";
                    }
                    fldList = String.valueOf(fldList) + (String)badFields.get(f);
                    ++f;
                }
                if (badFields.size() > 5) {
                    fldList = String.valueOf(fldList) + ", ... ";
                }
                if (result = UIRegistry.displayConfirm(UIRegistry.getResourceString("QueryTask.CRITERIA_TOO_LONG_TITLE"), String.format(UIRegistry.getResourceString("QueryTask.CRITERIA_TOO_LONG_MSG"), fldList), UIRegistry.getResourceString("Ok"), UIRegistry.getResourceString("Cancel"), 2)) {
                    for (SpQueryField fld : flds) {
                        Integer startLen = fld.getStartValue() == null ? 0 : fld.getStartValue().length();
                        Integer endLen = fld.getEndValue() == null ? 0 : fld.getEndValue().length();
                        if (startLen > maxStartLen) {
                            fld.setStartValue("");
                        }
                        if (endLen <= maxEndLen) continue;
                        fld.setEndValue("");
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getQueryNameFromUser(boolean saveAs) {
        block11: {
            session = DataProviderFactory.getInstance().createSession();
            try {
                newQueryName = this.query.getName();
                oldQueryName = this.query.getName();
                fndQuery = null;
                good = false;
                while (true) {
                    nameText = new JTextField(newQueryName);
                    nameLbl = UIHelper.createLabel(UIRegistry.getResourceString("QB_Q_NAME_PROMPT"));
                    pane = new PanelBuilder(new FormLayout("4dlu, p, 2dlu, fill:p:grow, 4dlu", "5dlu, p, 5dlu"));
                    cc = new CellConstraints();
                    pane.add((Component)nameLbl, cc.xy(2, 2));
                    pane.add((Component)nameText, cc.xy(4, 2));
                    cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), saveAs != false ? UIRegistry.getResourceString("QB_SAVE_Q_AS_TITLE") : UIRegistry.getResourceString("QB_SAVE_Q_TITLE"), true, 7, (Component)pane.getPanel());
                    cd.setHelpContext("QBSave");
                    UIHelper.centerAndShow(cd);
                    if (cd.isCancelled()) {
                        this.query.setName(oldQueryName);
                        session.close();
                        return false;
                    }
                    newQueryName = nameText.getText();
                    if (StringUtils.isNotEmpty((String)newQueryName) && newQueryName.length() > 64) {
                        UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("QB_NAME_TOO_LONG"));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)newQueryName)) {
                        UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("QB_ENTER_A_NAME"));
                        continue;
                    }
                    if (!UIHelper.isValidNameForDB(newQueryName)) {
                        UIRegistry.displayLocalizedStatusBarError("INVALID_CHARS_NAME", new Object[0]);
                        Toolkit.getDefaultToolkit().beep();
                        continue;
                    }
                    fndQuery = session.getData(SpQuery.class, "name", newQueryName, DataProviderSessionIFace.CompareType.Equals);
                    if (fndQuery != null) {
                        UIRegistry.getStatusBar().setErrorMessage(String.format(UIRegistry.getResourceString("QB_QUERY_EXISTS"), new Object[]{newQueryName}));
                        continue;
                    }
                    good = true;
                    this.query.setName(newQueryName);
                    continue;
                    break;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                QueryBldrPane.log.error((Object)ex);
                session.close();
                break block11;
            }
            catch (Throwable var12_13) {
                session.close();
                throw var12_13;
            }
            {
                if (!good) ** continue;
            }
            session.close();
        }
        UIRegistry.getStatusBar().setText("");
        return true;
    }

    protected static TableTree findTableTree(TableTree parentTT, String nameArg) {
        int k = 0;
        while (k < parentTT.getKids()) {
            TableTree tt = parentTT.getKid(k);
            if (tt.getName().equals(nameArg)) {
                return tt;
            }
            ++k;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void createNewList(TableQRI tblQRI, DefaultListModel model) {
        model.clear();
        if (tblQRI != null) {
            void var4_7;
            void var4_5;
            Vector<BaseQRI> sortList = new Vector<BaseQRI>();
            boolean bl = false;
            while (var4_5 < tblQRI.getFields()) {
                if (!tblQRI.getField((int)var4_5).isFieldHidden()) {
                    sortList.add(tblQRI.getField((int)var4_5));
                }
                ++var4_5;
            }
            boolean bl2 = false;
            while (var4_7 < tblQRI.getTableTree().getKids()) {
                boolean addIt;
                TableTree kidK = tblQRI.getTableTree().getKid((int)var4_7);
                if (kidK.isAlias()) {
                    addIt = QueryBldrPane.tblIsDisplayable(kidK, this.tableTreeHash.get(kidK.getName()).getTableInfo()) && QueryBldrPane.fixAliases(kidK, this.tableTreeHash);
                } else {
                    boolean bl3 = addIt = !kidK.getTableInfo().isHidden() && QueryBldrPane.tblIsDisplayable(kidK, kidK.getTableInfo());
                }
                if (addIt && (kidK.getTableQRI().getRelationship() == null || !kidK.getTableQRI().getRelationship().isHidden())) {
                    sortList.add(tblQRI.getTableTree().getKid((int)var4_7).getTableQRI());
                }
                ++var4_7;
            }
            Collections.sort(sortList);
            this.checkFldUsage(tblQRI.getTableTree(), sortList);
            for (QryListRendererIFace qryListRendererIFace : sortList) {
                model.addElement(qryListRendererIFace);
            }
        }
    }

    protected void checkFldUsage(TableTree tblTree, Vector<BaseQRI> flds) {
        String treeStr = String.valueOf(tblTree.getPathFromRootAsString()) + tblTree.getField();
        for (QueryFieldPanel qfp : this.queryFieldItems) {
            FieldQRI qri = qfp.getFieldQRI();
            if (qri instanceof RelQRI) {
                TableTree qriTT = qri.getTable().getTableTree().getParent();
                String qriTTStr = String.valueOf(qriTT.getPathFromRootAsString()) + qriTT.getField();
                if (!qriTTStr.equals(treeStr)) continue;
                for (BaseQRI fld : flds) {
                    if (!(fld instanceof TableQRI) || ((TableQRI)fld).getRelationship() != ((RelQRI)qri).getRelationshipInfo()) continue;
                    fld.setIsInUse(true);
                }
                continue;
            }
            if (qri == null || !(String.valueOf(qri.getTableTree().getPathFromRootAsString()) + qri.getTableTree().getField()).equals(treeStr)) continue;
            for (BaseQRI fld : flds) {
                FieldQRI qri2;
                if (!(fld instanceof FieldQRI) || !(qri2 = (FieldQRI)fld).getStringId().equals(qri.getStringId())) continue;
                qri2.setIsInUse(true);
            }
        }
    }

    protected static boolean tblIsDisplayable(TableTree aliasTbl, DBTableInfo tblInfo) {
        return !QueryBldrPane.isCyclic(aliasTbl, tblInfo.getTableId()) || QueryBldrPane.isCyclicable(aliasTbl, tblInfo);
    }

    protected static boolean isCyclic(TableTree alias, int tblId) {
        TableTree parent = alias.getParent();
        while (parent != null) {
            if (parent.getTableInfo() != null && parent.getTableInfo().getTableId() == tblId) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected static boolean isCyclicable(TableTree alias, DBTableInfo tblInfo) {
        if (Treeable.class.isAssignableFrom(tblInfo.getClassObj())) {
            if (alias.getField() != null && alias.getField().startsWith("accepted")) {
                TableTree parent = alias.getParent();
                int loop = 0;
                while (parent != null) {
                    if (parent.getTableInfo() == null || parent.getTableInfo().getTableId() != tblInfo.getTableId()) break;
                    if (parent.getField() != null && parent.getField().startsWith("accepted") && ++loop > 1) {
                        return false;
                    }
                    parent = parent.getParent();
                }
            }
            return true;
        }
        if (Container.class.isAssignableFrom(tblInfo.getClassObj())) {
            TableTree parent = alias.getParent();
            if (alias.getField().equals("parent")) {
                if (parent != null && parent.getTableInfo() != null && parent.getTableInfo().getTableId() == tblInfo.getTableId() && parent.getField() != null && parent.getField().equals("children")) {
                    return false;
                }
                int parentCount = 0;
                while (parent != null && parentCount < 7) {
                    ++parentCount;
                    TableTree grandParent = null;
                    if (parent.getTableInfo() != null && parent.getTableInfo().getTableId() == tblInfo.getTableId() && parent.getField() != null && parent.getField().equals("parent")) {
                        grandParent = parent.getParent();
                    }
                    parent = grandParent;
                }
                if (parentCount == 7) {
                    return false;
                }
            } else if (alias.getField().equals("children")) {
                if (parent != null && parent.getTableInfo() != null && parent.getTableInfo().getTableId() == tblInfo.getTableId() && parent.getField() != null && parent.getField().equals("parent")) {
                    return false;
                }
            } else if (alias.getField().equals("container")) {
                if (parent != null) {
                    if (parent.getTableInfo() != null && parent.getTableInfo().getTableId() == CollectionObject.getClassTableId() && parent.getField() != null && parent.getField().equals("collectionObjects")) {
                        return false;
                    }
                    if (parent.getTableInfo() != null && parent.getTableInfo().getTableId() == CollectionObject.getClassTableId() && parent.getField() != null && parent.getField().equals("collectionObjectKids")) {
                        return false;
                    }
                }
            } else if (alias.getField().equals("containerOwner")) {
                if (parent.getTableInfo() != null && parent.getTableInfo().getTableId() == CollectionObject.getClassTableId() && parent.getField() != null && parent.getField().equals("collectionObjects")) {
                    return false;
                }
                if (parent != null && parent.getTableInfo() != null && parent.getTableInfo().getTableId() == CollectionObject.getClassTableId() && parent.getField() != null && parent.getField().equals("collectionObjectKids")) {
                    return false;
                }
            }
            return true;
        }
        if (CollectionObject.class.isAssignableFrom(tblInfo.getClassObj())) {
            TableTree parent = alias.getParent();
            if (parent != null && parent.getTableInfo().getTableId() == CollectionRelationship.getClassTableId()) {
                if (alias.getField().equals("leftSide") && parent.getField() != null && parent.getField().equals("leftSideRels")) {
                    return false;
                }
                if (alias.getField().equals("rightSide") && parent.getField() != null && parent.getField().equals("rightSideRels")) {
                    return false;
                }
            }
            return true;
        }
        return CollectionRelationship.class.isAssignableFrom(tblInfo.getClassObj());
    }

    protected void fillNextList(JList parentList) {
        if (this.processingLists) {
            return;
        }
        this.processingLists = true;
        final int curInx = this.listBoxList.indexOf(parentList);
        if (curInx > -1) {
            int startSize = this.listBoxPanel.getComponentCount();
            int i = curInx + 1;
            while (i < this.listBoxList.size()) {
                this.listBoxPanel.remove(this.spList.get(i));
                ++i;
            }
            int removed = startSize - this.listBoxPanel.getComponentCount();
            int i2 = 0;
            while (i2 < removed) {
                this.tableTreeList.remove(this.tableTreeList.size() - 1);
                ++i2;
            }
        } else {
            this.listBoxPanel.removeAll();
            this.tableTreeList.clear();
        }
        QryListRendererIFace item = (QryListRendererIFace)parentList.getSelectedValue();
        if (item instanceof ExpandableQRI) {
            JScrollPane sp;
            DefaultListModel model;
            if (curInx == this.listBoxList.size() - 1) {
                model = new DefaultListModel();
                JList newList = new JList(model);
                newList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        block8: {
                            JList list;
                            QryListRendererIFace qriFace;
                            if (e.getClickCount() != 2 || QueryBldrPane.this.currentInx == -1 || !BaseQRI.class.isAssignableFrom((qriFace = (QryListRendererIFace)(list = (JList)e.getSource()).getSelectedValue()).getClass())) break block8;
                            BaseQRI qri = (BaseQRI)qriFace;
                            if (qri.isInUse()) {
                                for (QueryFieldPanel qfp : QueryBldrPane.this.queryFieldItems) {
                                    FieldQRI fqri = qfp.getFieldQRI();
                                    if (fqri != qri && (!(fqri instanceof RelQRI) || fqri.getTable() != qri)) continue;
                                    boolean clearIt = qfp.getSchemaItem() != null;
                                    QueryBldrPane.this.removeQueryFieldItem(qfp);
                                    if (!clearIt) break;
                                    qfp.setField(null, null);
                                    break;
                                }
                            } else {
                                if (QueryBldrPane.this.exportSchema != null && QueryBldrPane.this.selectedQFP == null) {
                                    System.out.println("Skipping");
                                    UIRegistry.displayInfoMsgDlgLocalized("QB_EXPORT_NO_CONCEPT_SELECTED", new Object[0]);
                                    return;
                                }
                                try {
                                    FieldQRI fieldQRI = QueryBldrPane.buildFieldQRI(qri);
                                    if (fieldQRI == null) {
                                        throw new Exception("null FieldQRI");
                                    }
                                    SpQueryField qf = new SpQueryField();
                                    qf.initialize();
                                    qf.setFieldName(fieldQRI.getFieldName());
                                    qf.setStringId(fieldQRI.getStringId());
                                    QueryBldrPane.this.query.addReference(qf, "fields");
                                    if (QueryBldrPane.this.exportSchema == null) {
                                        QueryBldrPane.this.addQueryFieldItem(fieldQRI, qf, false);
                                    }
                                    QueryBldrPane.this.addNewMapping(fieldQRI, qf, QueryBldrPane.this.selectedQFP);
                                }
                                catch (Exception ex) {
                                    log.error((Object)ex);
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                                    return;
                                }
                            }
                        }
                    }
                });
                newList.setCellRenderer(this.qryRenderer);
                this.listBoxList.add(newList);
                sp = new JScrollPane(newList, 22, 31);
                JLabel colHeader = UIHelper.createLabel(item.getTitle());
                colHeader.setHorizontalAlignment(0);
                colHeader.setBackground(this.listBoxPanel.getBackground());
                colHeader.setOpaque(true);
                sp.setColumnHeaderView(colHeader);
                this.spList.add(sp);
                newList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            QueryBldrPane.this.fillNextList(QueryBldrPane.this.listBoxList.get(curInx + 1));
                        }
                    }
                });
            } else {
                JList newList = this.listBoxList.get(curInx + 1);
                model = (DefaultListModel)newList.getModel();
                sp = this.spList.get(curInx + 1);
                JLabel colHeaderLbl = (JLabel)sp.getColumnHeader().getComponent(0);
                if (item instanceof TableQRI) {
                    colHeaderLbl.setText(((TableQRI)item).getTitle());
                } else {
                    colHeaderLbl.setText(UIRegistry.getResourceString("QueryBldrPane.QueryFields"));
                }
            }
            this.createNewList((TableQRI)item, model);
            this.listBoxPanel.remove(this.addBtn);
            this.listBoxPanel.add(sp);
            this.tableTreeList.add(((ExpandableQRI)item).getTableTree());
            this.listBoxPanel.add(this.addBtn);
            this.currentInx = -1;
        } else {
            this.listBoxPanel.add(this.addBtn);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBldrPane.this.updateAddBtnState();
                QueryBldrPane.this.listBoxPanel.validate();
                QueryBldrPane.this.listBoxPanel.repaint();
                QueryBldrPane.this.scrollPane.validate();
                QueryBldrPane.this.scrollPane.invalidate();
                QueryBldrPane.this.scrollPane.doLayout();
                QueryBldrPane.this.scrollPane.repaint();
                QueryBldrPane.this.validate();
                QueryBldrPane.this.invalidate();
                QueryBldrPane.this.doLayout();
                QueryBldrPane.this.repaint();
                UIRegistry.forceTopFrameRepaint();
            }
        });
        this.processingLists = false;
        this.currentInx = curInx;
    }

    protected static boolean isTablePickList(TableQRI qri) {
        return false;
    }

    protected static FieldQRI buildFieldQRIForTablePickList(TableQRI qri) {
        return null;
    }

    protected static FieldQRI buildFieldQRI(BaseQRI qri) {
        if (qri instanceof FieldQRI) {
            return (FieldQRI)qri;
        }
        if (qri instanceof TableQRI) {
            if (QueryBldrPane.isTablePickList((TableQRI)qri)) {
                return QueryBldrPane.buildFieldQRIForTablePickList((TableQRI)qri);
            }
            DBRelationshipInfo relInfo = ((TableQRI)qri).getRelationship();
            if (relInfo != null) {
                return new RelQRI((TableQRI)qri, relInfo);
            }
            throw new RuntimeException(String.valueOf(QueryBldrPane.class.getName()) + ": unable to determine relationship." + ((TableQRI)qri).getTableTree().getField() + " <-> " + ((TableQRI)qri).getTableTree().getParent().getField());
        }
        return null;
    }

    protected void updateAddBtnState() {
        if (this.currentInx != -1) {
            BaseQRI qri = (BaseQRI)this.listBoxList.get(this.currentInx).getSelectedValue();
            this.addBtn.setEnabled(qri != null && !qri.isInUse());
        }
    }

    @Override
    public void removeQueryFieldItem(final QueryFieldPanel qfp) {
        if (this.query.getReports().size() > 0) {
            CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_CONFIRM_DELETE_TITLE"), true, 7, (Component)new QBReportInfoPanel(this.query, UIRegistry.getResourceString("QB_USED_BY_REP_FLD_DELETE_CONFIRM")));
            cd.setHelpContext("QBFieldRemovedAndReports");
            UIHelper.centerAndShow(cd);
            cd.dispose();
            if (cd.isCancelled()) {
                return;
            }
        }
        if (qfp.getFieldQRI() != null) {
            qfp.getFieldQRI().setIsInUse(false);
        }
        if (qfp.getQueryField() != null) {
            this.removeFieldFromQuery(qfp.getQueryField());
            if (qfp.getItemMapping() != null) {
                this.removeSchemaItemMapping(qfp.getItemMapping());
            }
        }
        final FieldQRI qfpqri = qfp.getFieldQRI();
        if (this.exportSchema == null || qfp.isConditionForSchema()) {
            this.queryFieldItems.remove(qfp);
            this.qualifyFieldLabels();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryBldrPane.this.selectedQFP == qfp) {
                    QueryBldrPane.this.selectQFP(null);
                }
                if (QueryBldrPane.this.exportSchema == null || qfp.isConditionForSchema()) {
                    QueryBldrPane.this.queryFieldsPanel.getLayout().removeLayoutComponent(qfp);
                    QueryBldrPane.this.queryFieldsPanel.remove(qfp);
                }
                QueryBldrPane.this.queryFieldsPanel.validate();
                QueryBldrPane.this.updateAddBtnState();
                QueryBldrPane.this.tableList.setEnabled(QueryBldrPane.this.queryFieldItems.size() == 0);
                try {
                    BaseQRI qri = qfpqri instanceof RelQRI ? qfpqri.getTable() : qfpqri;
                    boolean done = false;
                    for (JList lb : QueryBldrPane.this.listBoxList) {
                        if (lb.isVisible()) {
                            int i = 0;
                            while (i < ((DefaultListModel)lb.getModel()).getSize()) {
                                BaseQRI qriI = (BaseQRI)((DefaultListModel)lb.getModel()).getElementAt(i);
                                if (qriI != null) {
                                    boolean match;
                                    boolean bl = match = qriI == qri;
                                    if (!match) {
                                        match = QueryBldrPane.buildFieldQRI(qri).getStringId().equals(QueryBldrPane.buildFieldQRI(qriI).getStringId());
                                    }
                                    if (match) {
                                        qriI.setIsInUse(false);
                                        lb.repaint();
                                        done = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!done) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                    log.error((Object)ex);
                }
                QueryBldrPane.this.queryFieldsPanel.repaint();
                QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.thereAreItems() && QueryBldrPane.this.canSave());
                QueryBldrPane.this.updateSearchBtn();
                UIRegistry.displayStatusBarText(null);
            }
        });
    }

    protected boolean thereAreItems() {
        if (this.exportSchema == null) {
            return this.queryFieldItems.size() > 0;
        }
        for (QueryFieldPanel qfp : this.queryFieldItems) {
            if (qfp.getFieldQRI() == null) continue;
            return true;
        }
        return false;
    }

    protected List<TableTreePathPoint> getCurrentDisplayPath() {
        if (this.tableTreeList.size() > 0) {
            return this.tableTreeList.get(this.tableTreeList.size() - 1).getPathFromRoot();
        }
        return new Vector<TableTreePathPoint>();
    }

    protected void displayField(FieldQRI field) {
        List<TableTreePathPoint> displayedPath = this.getCurrentDisplayPath();
        List<TableTreePathPoint> fieldPath = field.getTableTree().getPathFromRoot();
        if (this.tableTreeList.size() != this.listBoxPanel.getComponentCount() - 1) {
            log.error((Object)"tableTreeList and listBoxPanel are out of sync");
        }
        int p = 0;
        while (p < displayedPath.size() && p < fieldPath.size()) {
            if (!displayedPath.get(p).equals(fieldPath.get(p))) break;
            ++p;
        }
        if (p != fieldPath.size() || fieldPath.size() != displayedPath.size()) {
            if (p == fieldPath.size()) {
                if (p == 1) {
                    this.fillNextList(this.tableList);
                } else {
                    this.fillNextList(this.listBoxList.get(p - 2));
                }
            } else {
                --p;
                while (p < fieldPath.size() - 1) {
                    JList currList = p < 0 ? this.tableList : this.listBoxList.get(p);
                    ListModel model = currList.getModel();
                    int i = 0;
                    boolean foundPathItem = false;
                    while (i < model.getSize() && !foundPathItem) {
                        BaseQRI item = (BaseQRI)model.getElementAt(i);
                        if (item.hasChildren()) {
                            TableTree tt = item.getTableTree();
                            if (fieldPath.get(p + 1).equals(new TableTreePathPoint(tt))) {
                                currList.setSelectedIndex(i);
                                foundPathItem = true;
                            }
                        }
                        ++i;
                    }
                    if (foundPathItem) {
                        ++p;
                        continue;
                    }
                    log.error((Object)("unable to locate field: " + field.getFieldName()));
                    return;
                }
            }
        }
        ListModel model = this.listBoxList.get(fieldPath.size() - 1).getModel();
        int f = 0;
        while (f < model.getSize()) {
            BaseQRI item = (BaseQRI)model.getElementAt(f);
            if (item.getTitle().equals(field.getTitle())) {
                this.processingLists = true;
                this.listBoxList.get(fieldPath.size() - 1).setSelectedIndex(f);
                this.listBoxList.get(fieldPath.size() - 1).ensureIndexIsVisible(f);
                this.processingLists = false;
                break;
            }
            ++f;
        }
    }

    public FieldQRI getFieldQRI(SpQueryField field) {
        return QueryBldrPane.getFieldQRI(this.tableTree, field.getFieldName(), field.getIsRelFld() != null && field.getIsRelFld() != false, field.getStringId(), QueryBldrPane.getTableIds(field.getTableList()), 0, this.tableTreeHash);
    }

    protected static FieldQRI getFieldQRI(TableTree tbl, String fieldName, boolean isRelFld, String fldStringId, Vector<TableTreePathPoint> tableIds, int level, Hashtable<String, TableTree> ttHash) {
        TableTreePathPoint id = tableIds.get(level);
        int k = 0;
        while (k < tbl.getKids()) {
            boolean checkKid;
            TableTree kid = tbl.getKid(k);
            boolean bl = checkKid = kid.isAlias() ? QueryBldrPane.fixAliases(kid, ttHash) : true;
            if (checkKid && (kid.getTableQRI().getRelationship() == null || !kid.getTableQRI().getRelationship().isHidden()) && id.equals(new TableTreePathPoint(kid))) {
                if (level == tableIds.size() - 1) {
                    if (!isRelFld) {
                        int f = 0;
                        while (f < kid.getTableQRI().getFields()) {
                            if (kid.getTableQRI().getField(f).getStringId().equalsIgnoreCase(fldStringId)) {
                                return kid.getTableQRI().getField(f);
                            }
                            ++f;
                        }
                    } else if (kid.field.equalsIgnoreCase(fieldName)) {
                        return QueryBldrPane.buildFieldQRI(kid.getTableQRI());
                    }
                } else {
                    FieldQRI fi = QueryBldrPane.getFieldQRI(kid, fieldName, isRelFld, fldStringId, tableIds, level + 1, ttHash);
                    if (fi != null) {
                        return fi;
                    }
                }
            }
            ++k;
        }
        return null;
    }

    protected static Vector<TableTreePathPoint> getTableIds(String tableIdsList) {
        String[] points = StringUtils.split((String)tableIdsList, (String)",");
        Vector<TableTreePathPoint> result = new Vector<TableTreePathPoint>();
        String[] stringArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            String point = stringArray[n2];
            result.add(new TableTreePathPoint(point));
            ++n2;
        }
        return result;
    }

    protected static Vector<QueryFieldPanel> getQueryFieldPanels(QueryFieldPanelContainerIFace container, Set<SpQueryField> fields, TableTree tblTree, Hashtable<String, TableTree> ttHash, Component saveBtn, List<String> missingFlds) {
        Vector<QueryFieldPanel> result = new Vector<QueryFieldPanel>();
        ArrayList<SpQueryField> orderedFlds = new ArrayList<SpQueryField>(fields);
        Collections.sort(orderedFlds);
        result.add(QueryBldrPane.bldQueryFieldPanel(container, null, null, container.getColumnDefStr(), saveBtn));
        for (SpQueryField fld : orderedFlds) {
            FieldQRI fieldQRI = QueryBldrPane.getFieldQRI(tblTree, fld.getFieldName(), fld.getIsRelFld() != null && fld.getIsRelFld() != false, fld.getStringId(), QueryBldrPane.getTableIds(fld.getTableList()), 0, ttHash);
            if (fieldQRI != null) {
                result.add(QueryBldrPane.bldQueryFieldPanel(container, fieldQRI, fld, container.getColumnDefStr(), saveBtn));
                fieldQRI.setIsInUse(true);
                if (!fieldQRI.isFieldHidden() || container.isPromptMode()) continue;
                UIRegistry.showLocalizedMsg("QB_FIELD_HIDDEN_TITLE", "QB_FIELD_HIDDEN_SHOULD_REMOVE", fieldQRI.getTitle());
                continue;
            }
            String tableName = null;
            tableName = tblTree.getTableInfo() == null && fld.getContextTableIdent() != null ? DBTableIdMgr.getInstance().getTitleForId(fld.getContextTableIdent()) : (tblTree.getTableInfo() == null ? fld.getQuery().getContextName() : tblTree.getTableInfo().getTitle());
            log.error((Object)("Couldn't find [" + fld.getFieldName() + "] [" + fld.getTableList() + "]"));
            fields.remove(fld);
            fld.setQuery(null);
            if (missingFlds == null) continue;
            String fldText = fld.getColumnAlias() != null ? fld.getColumnAlias() : fld.getFieldName();
            missingFlds.add(String.format("%s -> %s", tableName, fldText));
        }
        return result;
    }

    protected static SpQueryField getQueryFieldMapping(SpExportSchemaMapping schemaMapping, SpExportSchemaItem schemaItem) {
        if (schemaMapping != null) {
            for (SpExportSchemaItemMapping mapping : schemaMapping.getMappings()) {
                if (!mapping.getExportSchemaItem().getId().equals(schemaItem.getId())) continue;
                return mapping.getQueryField();
            }
        }
        return null;
    }

    public static Vector<QueryFieldPanel> getQueryFieldPanelsForMapping(QueryFieldPanelContainerIFace container, Set<SpQueryField> fields, TableTree tblTree, Hashtable<String, TableTree> ttHash, Component saveBtn, SpExportSchemaMapping schemaMapping, List<String> missingFlds, Map<String, Vector<MappedFieldInfo>> autoMaps) {
        Vector<QueryFieldPanel> result = new Vector<QueryFieldPanel>();
        Vector<SpExportSchemaItem> sis = new Vector<SpExportSchemaItem>(schemaMapping.getSpExportSchema().getSpExportSchemaItems());
        Collections.sort(sis, new Comparator<SpExportSchemaItem>(){

            @Override
            public int compare(SpExportSchemaItem o1, SpExportSchemaItem o2) {
                return o1.getFieldName().compareTo(o2.getFieldName());
            }
        });
        for (SpExportSchemaItem schemaItem : sis) {
            SpQueryField fld = QueryBldrPane.getQueryFieldMapping(schemaMapping, schemaItem);
            if (fld == null) {
                result.add(new QueryFieldPanel(container, null, container.getColumnDefStr(), saveBtn, fld, schemaItem));
                continue;
            }
            FieldQRI fieldQRI = QueryBldrPane.getFieldQRI(tblTree, fld.getFieldName(), fld.getIsRelFld() != null && fld.getIsRelFld() != false, fld.getStringId(), QueryBldrPane.getTableIds(fld.getTableList()), 0, ttHash);
            if (fieldQRI != null) {
                result.add(new QueryFieldPanel(container, fieldQRI, container.getColumnDefStr(), saveBtn, fld, schemaItem));
                fieldQRI.setIsInUse(true);
                if (!fieldQRI.isFieldHidden() || container.isPromptMode()) continue;
                UIRegistry.showLocalizedMsg("QB_FIELD_HIDDEN_TITLE", "QB_FIELD_HIDDEN_SHOULD_REMOVE", fieldQRI.getTitle());
                continue;
            }
            log.error((Object)("Couldn't find [" + fld.getFieldName() + "] [" + fld.getTableList() + "]"));
            for (SpQueryField field : fields) {
                if (!field.getId().equals(fld.getId())) continue;
                fields.remove(field);
                field.setQuery(null);
                fld.setQuery(null);
                break;
            }
            if (missingFlds == null) continue;
            String fldText = fld.getColumnAlias() != null ? fld.getColumnAlias() : fld.getFieldName();
            missingFlds.add(fldText);
        }
        for (SpQueryField fld : fields) {
            if (fld.getMapping() != null) continue;
            FieldQRI fieldQRI = QueryBldrPane.getFieldQRI(tblTree, fld.getFieldName(), fld.getIsRelFld() != null && fld.getIsRelFld() != false, fld.getStringId(), QueryBldrPane.getTableIds(fld.getTableList()), 0, ttHash);
            if (fieldQRI != null) {
                result.add(new QueryFieldPanel(container, fieldQRI, container.getColumnDefStr(), saveBtn, fld, null, true));
                fieldQRI.setIsInUse(true);
                if (!fieldQRI.isFieldHidden() || container.isPromptMode()) continue;
                UIRegistry.showLocalizedMsg("QB_FIELD_HIDDEN_TITLE", "QB_FIELD_HIDDEN_SHOULD_REMOVE", fieldQRI.getTitle());
                continue;
            }
            log.error((Object)("Couldn't find [" + fld.getFieldName() + "] [" + fld.getTableList() + "]"));
            if (missingFlds == null) continue;
            missingFlds.add(fld.getColumnAlias());
        }
        result.add(new QueryFieldPanel(container, null, container.getColumnDefStr(), saveBtn, null, null, true));
        return result;
    }

    @Override
    public String getColumnDefStr() {
        return this.columnDefStr;
    }

    protected static QueryFieldPanel bldQueryFieldPanel(QueryFieldPanelContainerIFace container, FieldQRI fieldQRI, SpQueryField fld, String colDefStr, Component saveBtn) {
        if (colDefStr == null) {
            return new QueryFieldPanel(container, fieldQRI, colDefStr, saveBtn, null, null);
        }
        return new QueryFieldPanel(container, fieldQRI, colDefStr, saveBtn, fld, null);
    }

    protected void updateUIAfterAddOrMap(final FieldQRI fieldQRI, final QueryFieldPanel qfp, final boolean loading, final boolean isAdd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryBldrPane.this.currentInx > -1) {
                    if (isAdd) {
                        QueryBldrPane.this.queryFieldsPanel.add(qfp);
                        QueryBldrPane.this.queryFieldsPanel.validate();
                    }
                    if (fieldQRI instanceof RelQRI) {
                        TableQRI qri = fieldQRI.getTable();
                        for (JList lb : QueryBldrPane.this.listBoxList) {
                            if (!lb.isVisible() || !((DefaultListModel)lb.getModel()).contains(qri)) continue;
                            lb.repaint();
                        }
                    } else {
                        QueryBldrPane.this.listBoxList.get(QueryBldrPane.this.currentInx).repaint();
                    }
                    QueryBldrPane.this.updateAddBtnState();
                    QueryBldrPane.this.selectQFP(qfp);
                    QueryBldrPane.this.queryFieldsPanel.repaint();
                    if (!loading) {
                        QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.canSave());
                        QueryBldrPane.this.updateSearchBtn();
                    }
                    QueryBldrPane.this.tableList.setEnabled(QueryBldrPane.this.queryFieldItems.size() == 0);
                    if (fieldQRI instanceof TreeLevelQRI && QueryBldrPane.this.distinctChk.isSelected() && QueryBldrPane.this.countOnly) {
                        QueryBldrPane.this.countOnly = false;
                        QueryBldrPane.this.countOnlyChk.setSelected(false);
                        UIRegistry.displayLocalizedStatusBarText("QB_NO_COUNT_WITH_DISTINCT_WITH_TREELEVEL", new Object[0]);
                    } else {
                        UIRegistry.displayStatusBarText(null);
                    }
                }
            }
        });
    }

    protected void addQueryFieldItem(FieldQRI fieldQRI, SpQueryField queryField, boolean loading) {
        if (fieldQRI != null) {
            final QueryFieldPanel qfp = new QueryFieldPanel(this, fieldQRI, this.columnDefStr, this.saveBtn, queryField, null);
            qfp.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    QueryBldrPane.this.selectQFP(qfp);
                }
            });
            this.queryFieldItems.add(qfp);
            this.qualifyFieldLabels();
            fieldQRI.setIsInUse(true);
            this.updateUIAfterAddOrMap(fieldQRI, qfp, loading, true);
        }
    }

    @Override
    public void selectQFP(QueryFieldPanel qfp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.runSelectQFP(qfp);
        } else {
            FieldQRI fqri;
            if (this.selectedQFP != null) {
                this.selectedQFP.setSelected(false);
                this.selectedQFP.repaint();
            }
            this.selectedQFP = qfp;
            if (this.selectedQFP != null) {
                this.selectedQFP.setSelected(true);
                this.selectedQFP.repaint();
                this.scrollQueryFieldsToRect(this.selectedQFP.getBounds());
            }
            this.updateMoverBtns();
            if (qfp != null && (fqri = qfp.getFieldQRI()) != null) {
                this.displayField(fqri);
            }
        }
    }

    private void runSelectQFP(final QueryFieldPanel qfp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBldrPane.this.selectQFP(qfp);
            }
        });
    }

    protected void updateMoverBtns() {
        if (this.exportSchema == null) {
            int idx = this.queryFieldItems.indexOf(this.selectedQFP);
            this.orderUpBtn.setEnabled(idx > 0);
            this.orderDwnBtn.setEnabled(idx > -1 && idx < this.queryFieldItems.size() - 1);
        }
    }

    protected void qualifyFieldLabels() {
        ArrayList<String> labels = new ArrayList<String>(this.queryFieldItems.size());
        HashMap map = new HashMap();
        for (QueryFieldPanel queryFieldPanel : this.queryFieldItems) {
            if (queryFieldPanel.getFieldQRI() == null || queryFieldPanel.getFieldTitle() == null) continue;
            if (!map.containsKey(queryFieldPanel.getFieldTitle())) {
                map.put(queryFieldPanel.getFieldTitle(), new LinkedList());
            }
            ((List)map.get(queryFieldPanel.getFieldTitle())).add(queryFieldPanel);
            labels.add(queryFieldPanel.getFieldTitle());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1 && !((QueryFieldPanel)((List)entry.getValue()).get(0)).isLabelQualified()) continue;
            for (QueryFieldPanel q : (List)entry.getValue()) {
                labels.remove(entry.getKey());
                labels.add(q.qualifyLabel(labels, ((List)entry.getValue()).size() == 1));
            }
        }
    }

    protected static boolean fixAliases(TableTree tbl, Hashtable<String, TableTree> hash) {
        if (tbl.isAlias()) {
            TableTree tt = hash.get(tbl.getName());
            if (tt != null) {
                if (!tt.getTableInfo().isHidden() && QueryBldrPane.tblIsDisplayable(tbl, tt.getTableInfo())) {
                    tbl.clearKids();
                    try {
                        int k = 0;
                        while (k < tt.getKids()) {
                            tbl.addKid((TableTree)tt.getKid(k).clone());
                            ++k;
                        }
                        tbl.setTableInfo(tt.getTableInfo());
                        tbl.setTableQRIClone(tt.getTableQRI());
                        return true;
                    }
                    catch (CloneNotSupportedException ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                        throw new RuntimeException(ex);
                    }
                }
                return false;
            }
            log.error((Object)("Couldn't find [" + tbl.getName() + "] in the hash."));
            return false;
        }
        return true;
    }

    @Override
    public void setColumnDefStr(String columnDefStr) {
        this.columnDefStr = columnDefStr;
    }

    public RolloverCommand getQueryNavBtn() {
        return this.queryNavBtn;
    }

    public void setQueryNavBtn(RolloverCommand queryNavBtn) {
        this.queryNavBtn = queryNavBtn;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        CommandDispatcher.unregister("Reports", this);
        if (this.saveBtn != null && this.saveBtn.isEnabled()) {
            this.saveBtn.setEnabled(false);
        }
        if (this.runningResults.get() != null) {
            this.runningResults.get().cancel();
        }
        if (this.completedResults.get() != null) {
            this.completedResults.get().cancel();
        }
        QBResultsSubPane qbResultPane = null;
        for (SubPaneIFace subPane : SubPaneMgr.getInstance().getSubPanes()) {
            if (!(subPane instanceof QBResultsSubPane)) continue;
            qbResultPane = (QBResultsSubPane)subPane;
            break;
        }
        if (qbResultPane != null) {
            QBResultSetTableModel tblModel;
            QBResultsTablePanel tblPane = qbResultPane.getResultsTable();
            if (tblPane != null && (tblModel = tblPane.getTableModel()) != null) {
                tblModel.cancelBackgroundLoads();
            }
            SubPaneMgr.getInstance().removePane(qbResultPane);
        }
        this.query = null;
        if (this.queryNavBtn != null) {
            this.queryNavBtn.setEnabled(true);
        }
    }

    @Override
    public boolean aboutToShutdown() {
        boolean result = true;
        this.unlock();
        if (this.isChanged()) {
            String msg = String.format(UIRegistry.getResourceString("SaveChanges"), this.getTitle());
            JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
            int rv = JOptionPane.showConfirmDialog(topFrame, msg, UIRegistry.getResourceString("SaveChangesTitle"), 1);
            if (rv == 0) {
                this.saveQuery(false);
            } else if (rv == 2 || rv == -1) {
                return false;
            }
        }
        return result;
    }

    protected void unlock() {
        if (this.query != null && this.query.getMapping() != null) {
            ExportMappingTask.unlockMapping(this.query.getMapping());
        }
    }

    protected boolean isChanged() {
        return this.saveBtn.isEnabled();
    }

    protected void moveField(final QueryFieldPanel toMove, QueryFieldPanel moveTo) {
        int toIdx;
        int fromIdx = this.queryFieldItems.indexOf(toMove);
        if (fromIdx == (toIdx = this.queryFieldItems.indexOf(moveTo))) {
            return;
        }
        this.queryFieldItems.remove(fromIdx);
        this.queryFieldItems.insertElementAt(toMove, toIdx);
        ((NavBoxLayoutManager)this.queryFieldsPanel.getLayout()).moveLayoutComponent(toMove, moveTo);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBldrPane.this.queryFieldsPanel.doLayout();
                QueryBldrPane.this.queryFieldsPanel.validate();
                QueryBldrPane.this.scrollQueryFieldsToRect(toMove.getBounds());
                QueryBldrPane.this.queryFieldsPanel.repaint();
                QueryBldrPane.this.updateMoverBtns();
                QueryBldrPane.this.saveBtn.setEnabled(QueryBldrPane.this.canSave());
            }
        });
    }

    protected void scrollQueryFieldsToRect(Rectangle rect) {
        this.queryFieldsScroll.getViewport().scrollRectToVisible(rect);
        if (rect.y < this.queryFieldsScroll.getViewport().getViewPosition().y) {
            this.queryFieldsScroll.getViewport().setViewPosition(new Point(rect.x, rect.y));
        }
    }

    @Override
    public int getFields() {
        return this.queryFieldItems.size();
    }

    @Override
    public QueryFieldPanel getField(int index) {
        return this.queryFieldItems.get(index);
    }

    protected void updateSearchBtn() {
        this.searchBtn.setEnabled(this.thereAreItems());
    }

    @Override
    public boolean isPromptMode() {
        return false;
    }

    protected boolean canSearch() {
        return this.runningResults.get() == null;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Reports")) {
            this.refreshQuery();
            cmdAction.isAction("RPT.Refresh");
        }
    }

    protected void refreshQuery() {
        if (this.query != null && this.query.getId() != null && !this.isChanged()) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                session.refresh(this.query);
                this.query.forceLoad(true);
            }
            finally {
                session.close();
            }
        }
    }

    public Set<SpReport> getReportsForQuery() {
        return this.query.getReports();
    }

    @Override
    public void showingPane(boolean show) {
        if (show && ((QueryTask)this.task).needToRebuildTableTree() && !this.reloadMsgShown) {
            UIRegistry.showLocalizedMsg("QB_TREEDEF_LOCALIZ_CHANGES_TITLE", "QB_TREEDEF_LOCALIZ_CHANGES_WARN", new Object[0]);
            this.reloadMsgShown = true;
        }
    }

    public SpQuery getQuery() {
        return this.query;
    }

    @Override
    public JButton getAddBtn() {
        return this.addBtn;
    }

    protected boolean isQRIClassSelected(Class<?> qriClass) {
        for (QueryFieldPanel qfp : this.queryFieldItems) {
            if (qfp.getFieldQRI() == null || !qriClass.isAssignableFrom(qfp.getFieldQRI().getClass())) continue;
            return true;
        }
        return false;
    }

    protected boolean isTreeLevelSelected() {
        return this.isQRIClassSelected(TreeLevelQRI.class);
    }

    protected boolean isAggFieldSelected() {
        for (QueryFieldPanel qfp : this.queryFieldItems) {
            DBRelationshipInfo info;
            if (!(qfp.getFieldQRI() instanceof RelQRI) || (info = ((RelQRI)qfp.getFieldQRI()).getRelationshipInfo()) == null || !info.getType().equals((Object)DBRelationshipInfo.RelationshipType.ManyToMany) && !info.getType().equals((Object)DBRelationshipInfo.RelationshipType.OneToMany)) continue;
            return true;
        }
        return false;
    }
}

