/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.specify.tasks.subpane.qb.QryListRendererIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class QryListRenderer
implements ListCellRenderer {
    protected IconManager.IconSize iconSize;
    protected JPanel panel;
    protected ImageIcon kidIcon = null;
    protected ImageIcon blankIcon;
    protected JLabel iconLabel;
    protected JLabel label;
    protected JLabel kidLabel;
    protected boolean displayKidIndicator = true;

    public QryListRenderer(IconManager.IconSize iconSize) {
        this.iconSize = iconSize;
        this.blankIcon = IconManager.getIcon("BlankIcon", iconSize);
        this.iconLabel = new JLabel(this.blankIcon);
        this.label = UIHelper.createLabel("  ");
        this.kidLabel = new JLabel(this.blankIcon);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.iconLabel, "West");
        this.panel.add((Component)this.label, "Center");
        this.panel.add((Component)this.kidLabel, "East");
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.iconLabel.setOpaque(false);
        this.label.setOpaque(false);
        this.kidLabel.setOpaque(false);
    }

    public void setDisplayKidIndicator(boolean displayKidIndicator) {
        this.displayKidIndicator = displayKidIndicator;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
        QryListRendererIFace qri = (QryListRendererIFace)value;
        ImageIcon icon = qri == null ? this.blankIcon : (qri.getIsInUse() == null ? IconManager.getIcon(qri.getIconName(), this.iconSize) : (qri.getIsInUse() != false ? IconManager.getIcon("Checkmark", IconManager.IconSize.Std16) : this.blankIcon));
        this.iconLabel.setIcon(icon != null ? icon : this.blankIcon);
        ImageIcon childIcon = this.blankIcon;
        if (this.displayKidIndicator && qri != null && qri.hasChildren()) {
            childIcon = IconManager.getIcon(qri.hasMultiChildren() ? "MultiKid" : "SingleKid", this.iconSize);
        }
        this.kidLabel.setIcon(childIcon);
        if (iss) {
            this.panel.setBackground(list.getSelectionBackground());
            this.label.setForeground(list.getSelectionForeground());
            list.setSelectedIndex(index);
        } else {
            this.panel.setBackground(list.getBackground());
            this.label.setForeground(list.getForeground());
        }
        this.label.setText(" " + (qri != null ? this.removeSpecialCharacters(qri.getTitle()) : "?"));
        this.panel.doLayout();
        return this.panel;
    }

    protected String removeSpecialCharacters(String str) {
        String result = str.replaceAll("\\\\n", "");
        return result;
    }
}

