/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.dbsupport.QueryExecutor;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.TimeLogger;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoRel;
import edu.ku.brc.specify.tasks.subpane.qb.QBQueryForIdResultsHQL;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class QBResultSetTableModel
extends ResultSetTableModel {
    private static final Logger log = Logger.getLogger(QBResultSetTableModel.class);
    protected boolean debugging = false;
    protected final QueryExecutor queryExecutor = new QueryExecutor();
    protected final AtomicBoolean loadingCache = new AtomicBoolean(false);
    protected final AtomicBoolean isPostProcessed = new AtomicBoolean(false);
    protected final AtomicBoolean backgroundLoadsCancelled = new AtomicBoolean(false);
    protected boolean loadingCells = false;
    protected int bgTaskCount = 0;
    TimeLogger timeLogger = new TimeLogger();

    public QBResultSetTableModel(ESResultsTablePanelIFace parentERTP, QueryForIdResultsIFace results) {
        super(parentERTP, results, false, false);
    }

    @Override
    public synchronized boolean isLoadingCells() {
        return this.bgTaskCount != 0;
    }

    public void cancelBackgroundLoads() {
        this.backgroundLoadsCancelled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void exectionDone(CustomQueryIFace customQuery) {
        block44: {
            JPAQuery jpa;
            Object data;
            if (this.debugging) {
                log.debug((Object)"execution done");
            }
            if (customQuery instanceof JPAQuery && (data = (jpa = (JPAQuery)customQuery).getData()) != null && data instanceof Vector) {
                if (this.debugging) {
                    log.debug((Object)"aggregating list");
                }
                if (this.backgroundLoadsCancelled.get()) {
                    this.queryExecutor.shutdown();
                    return;
                }
                Vector info = (Vector)data;
                int row = (Integer)info.get(0);
                int col = (Integer)info.get(1);
                Class cls = (Class)info.get(2);
                Vector cols = (Vector)info.get(3);
                QBResultSetTableModel qBResultSetTableModel = this;
                synchronized (qBResultSetTableModel) {
                    cols.set(col, DataObjFieldFormatMgr.getInstance().aggregate(jpa.getDataObjects(), cls));
                    --this.bgTaskCount;
                    if (this.bgTaskCount < 10) {
                        this.timeLogger.end();
                    }
                }
                if (!this.isPostProcessed.get()) {
                    this.fireTableCellUpdated(row, col);
                } else if (!this.loadingCache.get()) {
                    this.fireTableDataChanged();
                }
                return;
            }
            try {
                this.timeLogger.start();
                this.results.queryTaskDone(customQuery);
                List<?> list = customQuery.getDataObjects();
                boolean hasIds = ((QBQueryForIdResultsHQL)this.results).isHasIds();
                List<ERTICaptionInfo> captions = this.results.getVisibleCaptionInfo();
                if (!customQuery.isInError() && !customQuery.isCancelled() && list != null && list.size() > 0) {
                    if (this.debugging) {
                        log.debug((Object)"loading cache");
                    }
                    this.loadingCache.set(true);
                    this.isPostProcessed.set(((QBQueryForIdResultsHQL)this.results).isPostSorted() || ((QBQueryForIdResultsHQL)this.results).isFilterDups());
                    boolean filterDups = ((QBQueryForIdResultsHQL)this.results).isFilterDups();
                    int maxTableRows = this.results.getMaxTableRows();
                    int rowNum = 0;
                    for (Object rowObj : list) {
                        if (rowNum == maxTableRows || customQuery.isCancelled()) break;
                        Vector<Object> row = null;
                        if (rowObj != null) {
                            row = new Vector(rowObj.getClass().isArray() ? ((Object[])rowObj).length : 1);
                        } else if (!hasIds) {
                            row = new Vector<Object>(1);
                        }
                        Integer id = null;
                        if (rowObj != null) {
                            int skipCols = 0;
                            Iterator<ERTICaptionInfo> cols = captions.iterator();
                            Object[] values = rowObj.getClass().isArray() ? (Object[])rowObj : new Object[]{rowObj};
                            int col = 0;
                            while (col < values.length) {
                                Object[] colObj = values[col];
                                if (skipCols != 0) {
                                    --skipCols;
                                    continue;
                                }
                                if (col == 0 && hasIds) {
                                    if (hasIds) {
                                        id = (Integer)colObj;
                                        if (this.debugging) {
                                            log.debug((Object)("*** 1 Adding id[" + colObj + "]"));
                                        }
                                    }
                                } else {
                                    ERTICaptionInfo erti = cols.next();
                                    if (colObj != null && !filterDups && erti instanceof ERTICaptionInfoRel && ((ERTICaptionInfoRel)erti).getRelationship().getType() == DBRelationshipInfo.RelationshipType.OneToMany) {
                                        ERTICaptionInfoRel ertiRel = (ERTICaptionInfoRel)erti;
                                        JPAQuery jpa2 = new JPAQuery(this.queryExecutor, ertiRel.getListHql(colObj), this);
                                        Vector<Object> info = new Vector<Object>();
                                        info.add(rowNum);
                                        info.add(row.size());
                                        info.add(ertiRel.getRelationship().getDataClass());
                                        info.add(row);
                                        jpa2.setData(info);
                                        if (this.debugging) {
                                            log.debug((Object)("*** 3 launching aggregator[" + erti.getColLabel() + "]"));
                                        }
                                        jpa2.start();
                                        QBResultSetTableModel qBResultSetTableModel = this;
                                        synchronized (qBResultSetTableModel) {
                                            ++this.bgTaskCount;
                                        }
                                        row.add(UIRegistry.getResourceString("QBResultSetTableModel.LOADING_CELL"));
                                    } else {
                                        if (erti.getColInfoList() != null) {
                                            Object[] modifiedColObj = new Object[erti.getColInfoList().size()];
                                            modifiedColObj[0] = colObj;
                                            int subCol = 1;
                                            while (subCol < modifiedColObj.length) {
                                                modifiedColObj[subCol] = values[++col];
                                                ++subCol;
                                            }
                                            colObj = modifiedColObj;
                                        }
                                        Object obj = erti.processValue(colObj);
                                        row.add(obj);
                                        if (this.debugging) {
                                            log.debug((Object)("*** 2 Adding field[" + obj + "]"));
                                        }
                                    }
                                }
                                ++col;
                            }
                        } else {
                            row.add(rowObj);
                        }
                        if (hasIds) {
                            row.add(id);
                        }
                        this.cache.add(row);
                        UIRegistry.getStatusBar().incrementValue(((QBQueryForIdResultsHQL)this.results).getQueryName());
                        ++rowNum;
                    }
                    if (customQuery.isCancelled()) {
                        this.queryExecutor.shutdown();
                    } else {
                        this.results.cacheFilled(this.cache);
                    }
                    this.loadingCache.set(false);
                    this.fireTableDataChanged();
                } else if (this.debugging) {
                    log.debug((Object)"cache load cancelled");
                }
                if (this.propertyListener != null) {
                    this.propertyListener.propertyChange(new PropertyChangeEvent(this, "rowCount", null, new Integer(this.cache.size())));
                }
                if (this.parentERTP != null) {
                    if (this.debugging) {
                        log.debug((Object)"search complete ");
                    }
                    CommandAction cmdAction = new CommandAction("Express_Search", "SearchComplete", customQuery);
                    cmdAction.setProperty("QueryForIdResultsIFace", this.results);
                    cmdAction.setProperty("ESResultsTablePanelIFace", this.parentERTP);
                    CommandDispatcher.dispatch(cmdAction);
                }
            }
            catch (Exception e) {
                if (((QBQueryForIdResultsHQL)this.results).getCancelled()) break block44;
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QBResultSetTableModel.class, e);
            }
        }
    }

    @Override
    public RecordSetIFace getRecordSet(int[] rows, boolean returnAll) {
        int idCol;
        RecordSet rs = new RecordSet();
        rs.setType(RecordSet.GLOBAL);
        rs.initialize();
        if (this.cache == null || !((QBQueryForIdResultsHQL)this.results).isHasIds() || !returnAll && (rows == null || rows.length == 0)) {
            return rs;
        }
        int n = idCol = this.cache.size() > 0 ? ((Vector)this.cache.get(0)).size() - 1 : -1;
        if (rows == null) {
            for (Vector row : this.cache) {
                rs.addItem((Integer)row.get(idCol));
            }
        } else {
            int[] nArray = rows;
            int n2 = rows.length;
            int n3 = 0;
            while (n3 < n2) {
                int inx = nArray[n3];
                rs.addItem((Integer)((Vector)this.cache.get(inx)).get(idCol));
                ++n3;
            }
        }
        return rs;
    }

    @Override
    public Integer getRowId(int index) {
        if (!((QBQueryForIdResultsHQL)this.results).isHasIds()) {
            return null;
        }
        Vector row = (Vector)this.cache.get(index);
        return (Integer)row.get(row.size() - 1);
    }

    @Override
    public void removeRow(int index) {
        this.cache.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public void cleanUp() {
        this.queryExecutor.shutdown();
        this.bgTaskCount = 0;
        super.cleanUp();
    }
}

