/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class QBReportInfoPanel
extends JPanel {
    protected JLabel msg;
    protected JList reps;
    protected final SpQuery query;
    protected final String msgTxt;

    public QBReportInfoPanel(SpQuery query, String msgTxt) {
        this.query = query;
        this.msgTxt = msgTxt;
        this.createUI();
    }

    protected void createUI() {
        PanelBuilder builder = new PanelBuilder(new FormLayout("2dlu, fill:p:grow, 2dlu", "5dlu, p, 5dlu, p, 5dlu"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        this.msg = UIHelper.createLabel(this.msgTxt);
        this.msg.setHorizontalAlignment(0);
        this.msg.setVerticalAlignment(0);
        builder.add((Component)this.msg, cc.xy(2, 2));
        Vector<SpReport> sortedReps = new Vector<SpReport>();
        for (SpReport spRep : this.query.getReports()) {
            sortedReps.add(spRep);
        }
        Collections.sort(sortedReps, new Comparator<SpReport>(){

            @Override
            public int compare(SpReport o1, SpReport o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.reps = UIHelper.createList(sortedReps);
        this.reps.setBorder(new BevelBorder(1));
        builder.add((Component)this.reps, cc.xy(2, 4));
    }
}

