/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryForIdResultsHQL;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.tasks.subpane.qb.ResultRowComparator;
import edu.ku.brc.specify.tasks.subpane.qb.SortElement;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class QBQueryForIdResultsHQL
extends QueryForIdResultsHQL {
    protected final QueryBldrPane queryBuilder;
    protected final AtomicReference<Future<CustomQueryIFace>> queryTask = new AtomicReference();
    protected final AtomicReference<CustomQueryIFace> query = new AtomicReference();
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected List<Pair<String, Object>> params = null;
    protected String title;
    protected String iconName;
    protected List<SortElement> sortElements = null;
    protected boolean filterDups = false;
    protected Vector<Vector<Object>> cache = null;
    protected boolean recIdsLoaded = false;
    protected boolean hasIds = true;
    protected int maxTableRows = 20000;

    public QBQueryForIdResultsHQL(Color bannerColor, String title, String iconName, int tableId, QueryBldrPane queryBuilder) {
        super(null, bannerColor, tableId);
        this.title = title;
        this.iconName = iconName;
        this.queryBuilder = queryBuilder;
    }

    public void setCaptions(List<ERTICaptionInfo> list) {
        this.captions = list;
    }

    @Override
    public Integer getDisplayOrder() {
        return 0;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    protected void buildCaptions() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    protected boolean repContextIsActive(AppResourceIFace repResource) {
        AppResourceIFace match = AppContextMgr.getInstance().getResource(repResource.getName());
        return match != null && match.getMimeType().equalsIgnoreCase(repResource.getMimeType());
    }

    @Override
    public List<Pair<String, Object>> getParams() {
        return this.params;
    }

    public void setParams(List<Pair<String, Object>> params) {
        this.params = params;
    }

    @Override
    public void complete() {
        if (this.queryBuilder != null) {
            this.queryBuilder.resultsComplete();
        }
        super.complete();
    }

    @Override
    public Future<?> getQueryTask() {
        return this.queryTask.get();
    }

    @Override
    public void setQueryTask(Future<?> queryTask) {
        this.queryTask.set(queryTask);
    }

    @Override
    public void queryTaskDone(Object results) {
        try {
            this.query.set((CustomQueryIFace)results);
            if (this.cancelled.get()) {
                this.query.get().cancel();
            }
            this.queryTask.set(null);
            if (!this.queryBuilder.queryTaskDone()) {
                this.query.get().cancel();
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QBQueryForIdResultsHQL.class, e);
            throw new RuntimeException(e);
        }
    }

    public CustomQueryIFace getQuery() {
        return this.query.get();
    }

    protected boolean isRetrieving() {
        return this.queryTask.get() != null && this.query.get() == null;
    }

    protected boolean isDisplaying() {
        return !this.isRetrieving() && this.query.get() != null;
    }

    public void cancel() {
        if (this.isRetrieving()) {
            this.cancelled.set(true);
            this.queryTask.get().cancel(true);
        } else if (this.isDisplaying()) {
            this.cancelled.set(true);
            this.query.get().cancel();
        }
    }

    public boolean getCancelled() {
        return this.cancelled.get();
    }

    @Override
    public Vector<Integer> getRecIds() {
        if (!this.recIdsLoaded) {
            this.recIds = new Vector(this.cache != null ? this.cache.size() : 0);
            if (this.cache != null) {
                for (Vector<Object> row : this.cache) {
                    this.recIds.add((Integer)row.get(row.size() - 1));
                }
            }
            this.recIdsLoaded = true;
        }
        return this.recIds;
    }

    @Override
    public int size() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public int getMaxTableRows() {
        return this.maxTableRows;
    }

    public void setMaxTableRows(int maxTableRows) {
        this.maxTableRows = maxTableRows;
    }

    public void setSort(List<SortElement> sortElements) {
        this.sortElements = sortElements;
    }

    public void setFilterDups(boolean filterDups) {
        this.filterDups = filterDups;
    }

    public String getHQL() {
        return this.overrideSQL;
    }

    @Override
    public void cacheFilled(Vector<Vector<Object>> cacheData) {
        if (this.filterDups && cacheData.size() > 1) {
            LinkedList<SortElement> dupSorts = new LinkedList<SortElement>();
            int c = 0;
            while (c < cacheData.get(0).size()) {
                dupSorts.add(new SortElement(c, 0));
                ++c;
            }
            ResultRowComparator comparator = new ResultRowComparator(dupSorts);
            Collections.sort(cacheData, comparator);
            int r = 0;
            LinkedList<Vector<Object>> rowsToDelete = new LinkedList<Vector<Object>>();
            while (r < cacheData.size()) {
                Vector<Object> vector = cacheData.get(r);
                ++r;
                boolean go = true;
                while (r < cacheData.size() && go) {
                    Vector<Object> nextRow = cacheData.get(r);
                    if (comparator.compare(vector, nextRow) == 0) {
                        rowsToDelete.add(nextRow);
                        ++r;
                        continue;
                    }
                    go = false;
                }
            }
            for (Vector vector : rowsToDelete) {
                cacheData.remove(vector);
            }
        }
        if (this.sortElements != null) {
            Collections.sort(cacheData, new ResultRowComparator(this.sortElements));
        }
        this.cache = cacheData;
    }

    public boolean isHasIds() {
        return this.hasIds;
    }

    public void setHasIds(boolean hasIds) {
        this.hasIds = hasIds;
    }

    public boolean isPostSorted() {
        return this.sortElements != null && this.sortElements.size() > 0;
    }

    public String getQueryName() {
        return this.queryBuilder.getQuery().getName();
    }

    public boolean isFilterDups() {
        return this.filterDups;
    }

    public QueryBldrPane getQueryBuilder() {
        return this.queryBuilder;
    }
}

