/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceBase;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.UIRegistry;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class QBLiveDataSource
extends QBDataSourceBase {
    protected static final Logger log = Logger.getLogger(QBLiveDataSource.class);
    protected final ResultSetTableModel data;
    protected int row = -1;
    protected int[] selectedRows = null;
    protected int selectedIdx = -1;

    public QBLiveDataSource(ResultSetTableModel data, List<ERTICaptionInfoQB> columnInfo) {
        super(columnInfo, true, null);
        this.data = data;
        if (data != null) {
            this.selectedRows = data.getParentERTP().getSelectedRows();
            if (this.selectedRows.length == 0) {
                this.selectedRows = null;
            }
        }
    }

    public QBLiveDataSource(ResultSetTableModel data, List<ERTICaptionInfoQB> columnInfo, Object repeats) {
        super(columnInfo, true, repeats);
        this.data = data;
        if (data != null) {
            this.selectedRows = data.getParentERTP().getSelectedRows();
            if (this.selectedRows.length == 0) {
                this.selectedRows = null;
            }
        }
    }

    protected int getRowCount() {
        return this.selectedRows == null ? this.data.getRowCount() : this.selectedRows.length;
    }

    @Override
    public Object getFieldValue(JRField arg0) throws JRException {
        if (arg0.getName().equalsIgnoreCase("resultsetsize")) {
            return String.valueOf(this.getRowCount());
        }
        if (arg0.getName().equalsIgnoreCase("ID")) {
            return this.getRecordId();
        }
        int fldIdx = this.getFldIdx(arg0.getName());
        if (fldIdx < 0) {
            if (arg0.getClass().equals(String.class)) {
                return String.format(UIRegistry.getResourceString("QBJRDS_UNKNOWN_FIELD"), arg0.getName());
            }
            log.error((Object)("field not found: " + arg0.getName()));
            return null;
        }
        int colInfoIdx = Collections.binarySearch(this.colNames, new QBDataSourceBase.SourceColumnInfo(arg0.getName(), null, null), this.srcColNameComparator);
        return this.processValue(((QBDataSourceBase.SourceColumnInfo)this.colNames.get(colInfoIdx)).getColInfoIdx(), this.data.getCacheValueAt(this.row, fldIdx));
    }

    @Override
    protected void setUpColNames() {
        this.setUpColNamesPostProcess();
    }

    @Override
    protected boolean getNext() {
        if (this.selectedRows == null) {
            return ++this.row < this.data.getRowCount();
        }
        if (++this.selectedIdx < this.selectedRows.length) {
            this.row = this.selectedRows[this.selectedIdx];
            return true;
        }
        return false;
    }

    @Override
    protected Object[] getRepeaterRowVals() {
        Object[] rowData = new Object[this.colNames.size()];
        int c = 0;
        while (c < this.colNames.size()) {
            rowData[c] = this.data.getCacheValueAt(this.row, c);
            ++c;
        }
        return rowData;
    }

    @Override
    public Object getRecordId() {
        if (!this.recordIdsIncluded) {
            return super.getRecordId();
        }
        return this.data.getRowId(this.row);
    }

    @Override
    public boolean hasResultSize() {
        return true;
    }

    @Override
    public int size() {
        return this.getRowCount();
    }
}

