/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.tasks.subpane.JRConnectionFieldDef;
import edu.ku.brc.specify.tasks.subpane.SpJRIReportConnection;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class QBJRIReportConnection
extends SpJRIReportConnection {
    protected final SpQuery query;

    public QBJRIReportConnection(SpQuery query) {
        super(query.getName());
        this.query = query;
    }

    public QBJRIReportConnection(String queryName) {
        super(queryName);
        this.query = null;
    }

    public void loadProperties(HashMap map) {
        if (this.objectName != null) {
            this.fields.clear();
            List<ERTICaptionInfo> cols = this.query == null ? QueryBldrPane.getColumnInfo(this.objectName, true) : QueryBldrPane.getColumnInfoSp(this.query.getFields(), true);
            for (ERTICaptionInfo col : cols) {
                this.fields.add(new JRConnectionFieldDef(((ERTICaptionInfoQB)col).getColStringId(), col.getColLabel(), this.getColClass(col)));
            }
            this.fields.add(new JRConnectionFieldDef("id", UIRegistry.getResourceString("QBJRIReportConnection.ID"), Integer.class));
            this.fields.add(new JRConnectionFieldDef("resultsetsize", UIRegistry.getResourceString("QBJRIReportConnection.ResultSetSize"), String.class));
        }
    }

    protected Class<?> getColClass(ERTICaptionInfo col) {
        Class<?> cls = col.getColClass();
        if (cls.equals(Calendar.class) || cls.equals(Timestamp.class) || cls.equals(java.sql.Date.class) || cls.equals(Date.class)) {
            return String.class;
        }
        UIFieldFormatterIFace formatter = col.getUiFieldFormatter();
        if (formatter != null && formatter.isInBoundFormatter()) {
            return Object.class;
        }
        return cls;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < this.fields.size()) {
            map.put("COLUMN_" + i, ((JRConnectionFieldDef)this.fields.get(i)).getFldTitle());
            ++i;
        }
        return map;
    }

    public String getDescription() {
        return UIRegistry.getResourceString("REP_SPECIFY_REPORT_CONNECTION");
    }

    public SpQuery getQuery() {
        return this.query;
    }

    @Override
    public DataModelObjBase getSpObject() {
        return this.query;
    }
}

