/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceListenerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.RowRepeater;
import edu.ku.brc.specify.tasks.subpane.qb.RowRepeaterColumn;
import edu.ku.brc.specify.tasks.subpane.qb.RowRepeaterConst;
import edu.ku.brc.ui.DateWrapper;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class QBDataSourceBase
implements JRDataSource {
    private static final Logger log = Logger.getLogger(QBDataSourceBase.class);
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected final List<ERTICaptionInfoQB> columnInfo;
    protected final boolean recordIdsIncluded;
    protected final ArrayList<SourceColumnInfo> colNames = new ArrayList();
    protected final List<QBDataSourceListenerIFace> listeners = new LinkedList<QBDataSourceListenerIFace>();
    protected final RowRepeater repeater;
    protected int currentRowRepeats = 0;
    protected final Comparator<SourceColumnInfo> srcColNameComparator = new Comparator<SourceColumnInfo>(){

        @Override
        public int compare(SourceColumnInfo o1, SourceColumnInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public Object getFieldValue(JRField arg0) throws JRException {
        return null;
    }

    public boolean next() throws JRException {
        if (this.currentRowRepeats > 0) {
            --this.currentRowRepeats;
            return true;
        }
        boolean result = this.getNext();
        if (result) {
            this.currentRowRepeats = this.repeater != null ? this.repeater.repeats(this.getRepeaterRowVals()) - 1 : 0;
        }
        return result;
    }

    protected boolean getNext() {
        return false;
    }

    protected Object[] getRepeaterRowVals() {
        return null;
    }

    public synchronized void addListener(QBDataSourceListenerIFace listener) {
        this.listeners.add(listener);
        this.updateNewListener(listener);
    }

    protected void updateNewListener(QBDataSourceListenerIFace listener) {
        listener.rowCount(this.size());
    }

    public QBDataSourceBase(List<ERTICaptionInfoQB> columnInfo, boolean recordIdsIncluded, Object repeats) {
        this.columnInfo = columnInfo;
        this.recordIdsIncluded = recordIdsIncluded;
        this.setUpColNames();
        if (repeats == null) {
            this.repeater = null;
        } else if (repeats instanceof String) {
            this.repeater = new RowRepeaterColumn(this.getFldIdx((String)repeats));
        } else if (repeats instanceof Integer) {
            this.repeater = new RowRepeaterConst((Integer)repeats);
        } else {
            this.repeater = null;
            log.error((Object)("invalid repeats parameter: " + repeats));
        }
    }

    protected void setUpColNames() {
        int c = 0;
        int e = 0;
        for (ERTICaptionInfoQB col : this.columnInfo) {
            this.colNames.add(new SourceColumnInfo(col.getColStringId(), new Integer(c++), new Integer(e++)));
            if (col.getColInfoList() == null) continue;
            c += col.getColInfoList().size() - 1;
        }
        Collections.sort(this.colNames, this.srcColNameComparator);
    }

    protected void setUpColNamesPostProcess() {
        this.colNames.clear();
        int c = 0;
        for (ERTICaptionInfoQB col : this.columnInfo) {
            this.colNames.add(new SourceColumnInfo(col.getColStringId(), new Integer(c), new Integer(c)));
            ++c;
        }
        Collections.sort(this.colNames, this.srcColNameComparator);
    }

    protected int getFldIdx(String fldName) {
        int fldIdx = Collections.binarySearch(this.colNames, new SourceColumnInfo(fldName, null, null), this.srcColNameComparator);
        if (fldIdx < 0) {
            return -1;
        }
        return this.colNames.get(fldIdx).getRowDataIdx();
    }

    protected Object processValue(int colIdx, Object obj) {
        if (obj instanceof Calendar) {
            return scrDateFormat.format((Calendar)obj);
        }
        if (obj instanceof Timestamp) {
            return scrDateFormat.format((java.util.Date)obj);
        }
        if (obj instanceof Date || obj instanceof java.util.Date) {
            return scrDateFormat.format((java.util.Date)obj);
        }
        UIFieldFormatterIFace formatter = this.columnInfo.get(colIdx).getUiFieldFormatter();
        if (formatter != null && formatter.isInBoundFormatter()) {
            return formatter.formatToUI(obj);
        }
        return obj;
    }

    public Object getRecordId() {
        return null;
    }

    public boolean hasResultSize() {
        return false;
    }

    public int size() {
        return -1;
    }

    public ERTICaptionInfoQB getColumnInfo(int idx) {
        return this.columnInfo.get(this.recordIdsIncluded ? idx - 1 : idx);
    }

    class SourceColumnInfo {
        protected final String name;
        protected final Integer rowDataIdx;
        protected final Integer colInfoIdx;

        public SourceColumnInfo(String name, Integer rowDataIdx, Integer colInfoIdx) {
            this.name = name;
            this.rowDataIdx = rowDataIdx;
            this.colInfoIdx = colInfoIdx;
        }

        public String getName() {
            return this.name;
        }

        public Integer getRowDataIdx() {
            return this.rowDataIdx;
        }

        public Integer getColInfoIdx() {
            return this.colInfoIdx;
        }
    }
}

