/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceBase;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceListenerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ResultRowComparator;
import edu.ku.brc.specify.tasks.subpane.qb.SortElement;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class QBDataSource
extends QBDataSourceBase
implements CustomQueryListener {
    protected static final Logger log = Logger.getLogger(QBDataSource.class);
    protected final AtomicBoolean loadCancelled = new AtomicBoolean(false);
    protected JPAQuery theQuery = null;
    protected boolean firstRow = true;
    protected int currentRow = 0;
    protected Long firstResult = 0L;
    protected Long maxResults = 0L;
    protected boolean removeReadRows = true;
    protected final String hql;
    protected final List<Pair<String, Object>> params;
    protected final List<SortElement> sort;
    protected boolean processed = false;
    protected AtomicBoolean processing = new AtomicBoolean(true);
    protected Vector<Vector<Object>> cache = null;
    protected final AtomicInteger resultSetSize = new AtomicInteger(-1);
    protected Object rowVals = null;
    protected final AtomicReference<Iterator<?>> rows = new AtomicReference<Object>(null);

    @Override
    public Object getFieldValue(JRField arg0) throws JRException {
        boolean logIt;
        if (arg0.getName().equalsIgnoreCase("resultsetsize")) {
            return String.valueOf(this.resultSetSize.get());
        }
        if (arg0.getName().equalsIgnoreCase("ID")) {
            return this.getRecordId();
        }
        boolean bl = logIt = this.rows.get() == null || this.processing.get();
        if (logIt) {
            log.debug((Object)(this + " waiting for rows..."));
        }
        while (this.processing.get() || this.rows.get() == null) {
        }
        if (logIt) {
            log.debug((Object)("... " + this + " got rows"));
        }
        int fldIdx = this.getFldIdx(arg0.getName());
        return this.getFieldValue(fldIdx, arg0.getName(), arg0.getClass());
    }

    public Object getFieldValue(int colIdx) {
        return this.getFieldValue(colIdx, null, null);
    }

    public int getFieldCount() {
        return this.columnInfo.size() + (this.recordIdsIncluded ? 1 : 0);
    }

    protected Object getFieldValue(int fldIdx, String fldName, Class<?> fldClass) {
        boolean skipProcessing;
        int colInfoIdx;
        boolean isRawCol;
        if (fldIdx < 0) {
            return null;
        }
        boolean bl = isRawCol = fldName == null;
        if (isRawCol) {
            colInfoIdx = fldIdx - 1;
        } else {
            colInfoIdx = Collections.binarySearch(this.colNames, new QBDataSourceBase.SourceColumnInfo(this, fldName, null, null), this.srcColNameComparator);
            if (colInfoIdx < 0) {
                if (fldClass.equals(String.class)) {
                    return String.format(UIRegistry.getResourceString("QBJRDS_UNKNOWN_FIELD"), fldName);
                }
                log.error((Object)("field not found: " + fldName + " (" + fldIdx + ")"));
                return null;
            }
        }
        boolean bl2 = skipProcessing = isRawCol && fldIdx == 0;
        if (!this.processed && !skipProcessing) {
            Object[] value;
            int processIdx = isRawCol ? colInfoIdx : ((QBDataSourceBase.SourceColumnInfo)this.colNames.get(colInfoIdx)).getColInfoIdx();
            ERTICaptionInfoQB col = (ERTICaptionInfoQB)this.columnInfo.get(processIdx);
            if (col.getColInfoList() != null && col.getColInfoList().size() > 1) {
                value = new Object[col.getColInfoList().size()];
                value[0] = ((Object[])this.rowVals)[fldIdx];
                int i = 1;
                while (i < col.getColInfoList().size()) {
                    value[i] = ((Object[])this.rowVals)[fldIdx + i];
                    ++i;
                }
            } else {
                value = ((Object[])this.rowVals)[fldIdx];
            }
            return this.processValue(processIdx, col.processValue(value));
        }
        if (!this.processed) {
            return ((Object[])this.rowVals)[fldIdx];
        }
        return ((Vector)this.rowVals).get(fldIdx);
    }

    @Override
    public boolean getNext() {
        boolean result;
        boolean logIt;
        boolean bl = logIt = this.rows.get() == null || this.processing.get();
        if (logIt) {
            log.debug((Object)(this + " waiting for rows..."));
        }
        while (this.rows.get() == null || this.processing.get()) {
        }
        if (logIt) {
            log.debug((Object)("... " + this + " got rows"));
        }
        if (result = this.doGetNext(false)) {
            for (QBDataSourceListenerIFace listener : this.listeners) {
                listener.currentRow(++this.currentRow);
            }
        } else {
            if (this.loadCancelled.get()) {
                return true;
            }
            for (QBDataSourceListenerIFace listener : this.listeners) {
                listener.done(this.currentRow);
            }
        }
        return result;
    }

    protected boolean doGetNext(boolean sorting) {
        if (this.rows.get().hasNext()) {
            Object nextRow;
            if (!this.firstRow && this.removeReadRows) {
                if (!sorting) {
                    try {
                        this.rows.get().remove();
                    }
                    catch (IllegalStateException isex) {
                        log.warn((Object)isex);
                    }
                    catch (UnsupportedOperationException onsex) {
                        log.warn((Object)onsex);
                    }
                }
            } else {
                this.firstRow = false;
            }
            if (Object[].class.isAssignableFrom((nextRow = this.rows.get().next()).getClass())) {
                this.rowVals = nextRow;
            } else if (Vector.class.isAssignableFrom(nextRow.getClass())) {
                this.rowVals = nextRow;
            } else {
                this.rowVals = new Object[1];
                ((Object[])this.rowVals)[0] = nextRow;
            }
            return true;
        }
        this.rowVals = null;
        this.rows.set(null);
        if (this.theQuery != null) {
            this.theQuery.getDataObjects().clear();
            if (this.theQuery.getDataObjects() instanceof ArrayList) {
                ((ArrayList)this.theQuery.getDataObjects()).trimToSize();
            }
            this.theQuery.clearCql();
        }
        return false;
    }

    @Override
    protected Object[] getRepeaterRowVals() {
        if (Vector.class.isAssignableFrom(this.rowVals.getClass())) {
            Object[] result = new Object[((Vector)this.rowVals).size()];
            int r = 0;
            while (r < ((Vector)this.rowVals).size()) {
                result[r] = ((Vector)this.rowVals).get(r);
                ++r;
            }
            return result;
        }
        return (Object[])this.rowVals;
    }

    protected boolean needToPreProcess() {
        return this.sort != null && this.sort.size() > 0;
    }

    @Override
    public void exectionDone(CustomQueryIFace customQuery) {
        this.resultSetSize.set(((JPAQuery)customQuery).getDataObjects().size());
        for (QBDataSourceListenerIFace listener : this.listeners) {
            listener.rowCount(this.resultSetSize.get());
        }
        this.rows.set(((JPAQuery)customQuery).getDataObjects().iterator());
        if (this.needToPreProcess()) {
            this.cache = new Vector(this.resultSetSize.get());
            for (QBDataSourceListenerIFace listener : this.listeners) {
                listener.loading();
            }
            while (this.doGetNext(true)) {
                for (QBDataSourceListenerIFace listener : this.listeners) {
                    listener.currentRow(++this.currentRow);
                }
                Vector<Object> row = new Vector<Object>(((Object[])this.rowVals).length);
                int fldIdx = 0;
                int colIdx = 0;
                while (fldIdx < ((Object[])this.rowVals).length) {
                    if (this.recordIdsIncluded && fldIdx == 0) {
                        row.add(((Object[])this.rowVals)[fldIdx]);
                        --colIdx;
                    } else {
                        Object[] value;
                        ERTICaptionInfoQB col = (ERTICaptionInfoQB)this.columnInfo.get(colIdx);
                        if (col.getColInfoList() != null && col.getColInfoList().size() > 1) {
                            value = new Object[col.getColInfoList().size()];
                            value[0] = ((Object[])this.rowVals)[fldIdx];
                            int i = 1;
                            while (i < col.getColInfoList().size()) {
                                value[i] = ((Object[])this.rowVals)[fldIdx + i];
                                ++i;
                            }
                            fldIdx += col.getColInfoList().size() - 1;
                        } else {
                            value = ((Object[])this.rowVals)[fldIdx];
                        }
                        row.add(this.processValue(colIdx, col.processValue(value)));
                    }
                    ++fldIdx;
                    ++colIdx;
                }
                this.cache.add(row);
            }
            this.setUpColNamesPostProcess();
            Collections.sort(this.cache, new ResultRowComparator(this.sort, true));
            this.processed = true;
            this.firstRow = true;
            this.currentRow = 0;
            this.rows.set(this.cache.iterator());
            for (QBDataSourceListenerIFace listener : this.listeners) {
                listener.loaded();
            }
        }
        this.processing.set(false);
        for (QBDataSourceListenerIFace listener : this.listeners) {
            listener.filling();
        }
    }

    @Override
    public void executionError(CustomQueryIFace customQuery) {
        this.rows.set(new ArrayList().iterator());
    }

    public QBDataSource(String hql, List<Pair<String, Object>> params, List<SortElement> sort, List<ERTICaptionInfoQB> columnInfo, boolean recordIdsIncluded) {
        super(columnInfo, recordIdsIncluded, null);
        this.hql = hql;
        this.params = params;
        this.sort = sort;
    }

    public QBDataSource(String hql, List<Pair<String, Object>> params, List<SortElement> sort, List<ERTICaptionInfoQB> columnInfo, boolean recordIdsIncluded, Object repeats) {
        super(columnInfo, recordIdsIncluded, repeats);
        this.hql = hql;
        this.params = params;
        this.sort = sort;
    }

    public void startDataAcquisition() {
        this.firstRow = true;
        this.currentRow = 0;
        this.theQuery = new JPAQuery(this.hql, (CustomQueryListener)this);
        if (this.firstResult > 0L) {
            this.theQuery.setFirstResult(this.firstResult.intValue());
        }
        if (this.maxResults > 0L) {
            this.theQuery.setMaxResults(this.maxResults.intValue());
        }
        this.theQuery.setParams(this.params);
        this.theQuery.start();
    }

    @Override
    public Object getRecordId() {
        if (!this.recordIdsIncluded || this.processed) {
            return super.getRecordId();
        }
        return ((Object[])this.rowVals)[0];
    }

    @Override
    protected int getFldIdx(String fldName) {
        int result = super.getFldIdx(fldName);
        return this.recordIdsIncluded ? result + 1 : result;
    }

    @Override
    public boolean hasResultSize() {
        return this.resultSetSize.get() != -1;
    }

    @Override
    public int size() {
        return this.resultSetSize.get();
    }

    public synchronized void cancelLoad() {
        this.loadCancelled.set(true);
        Iterator<?> r = this.rows.get();
        while (r.hasNext()) {
            r.next();
        }
    }

    @Override
    protected void updateNewListener(QBDataSourceListenerIFace listener) {
        super.updateNewListener(listener);
        if (this.processing.get()) {
            listener.loading();
        } else if (this.currentRow < this.size()) {
            listener.filling();
        }
    }

    public long getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(long firstRecord) {
        this.firstResult = firstRecord;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(long maxRecords) {
        this.maxResults = maxRecords;
    }

    public boolean isRemoveReadRows() {
        return this.removeReadRows;
    }

    public void setRemoveReadRows(boolean removeReadRows) {
        this.removeReadRows = removeReadRows;
    }
}

