/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanel;
import edu.ku.brc.specify.ui.db.PickListTableAdapter;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class PickListCriteriaCombo
extends JComboBox {
    protected static final Logger log = Logger.getLogger(QueryFieldPanel.class);
    protected final PickListDBAdapterIFace items;
    protected List<PickListItemIFace> sels = new ArrayList<PickListItemIFace>();
    protected static final int SELMODE_SINGLE = 0;
    protected static final int SELMODE_DOUBLE = 1;
    protected static final int SELMODE_MULTI = 2;
    protected int selMode = 2;
    protected SpQueryField.OperatorType currentOp;

    public PickListCriteriaCombo(PickListDBAdapterIFace items) {
        this.items = items;
        this.setupItems();
    }

    protected void setupItems() {
        this.setModel((ComboBoxModel)((Object)this.items));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged")) {
                    PickListItemIFace theSelection = (PickListItemIFace)PickListCriteriaCombo.this.getSelectedItem();
                    PickListCriteriaCombo.this.setSelectedItem(null);
                    if (PickListCriteriaCombo.this.selMode == 0) {
                        boolean addIt = !PickListCriteriaCombo.this.sels.contains(theSelection);
                        PickListCriteriaCombo.this.sels.clear();
                        if (addIt) {
                            PickListCriteriaCombo.this.sels.add(theSelection);
                        }
                    } else if (PickListCriteriaCombo.this.selMode == 2) {
                        if (PickListCriteriaCombo.this.sels.contains(theSelection)) {
                            PickListCriteriaCombo.this.sels.remove(theSelection);
                        } else {
                            PickListCriteriaCombo.this.sels.add(theSelection);
                        }
                    } else if (PickListCriteriaCombo.this.selMode == 1) {
                        if (PickListCriteriaCombo.this.sels.size() == 2) {
                            PickListCriteriaCombo.this.sels.clear();
                        }
                        PickListCriteriaCombo.this.sels.add(theSelection);
                    }
                }
            }
        });
    }

    public ListCellRenderer getRenderer() {
        return new PickListCellRenderer();
    }

    public String getText(boolean getValues) {
        if (this.selMode == 2) {
            Collections.sort(this.sels);
        }
        StringBuilder sb = new StringBuilder();
        for (PickListItemIFace sel : this.sels) {
            String s;
            String string = getValues ? (this.items instanceof PickListTableAdapter ? ((DataModelObjBase)sel.getValueObject()).getId().toString() : sel.getValue()) : (s = sel.getTitle());
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getSelectionsText() {
        return this.getText(false);
    }

    public String getCriteria() {
        return this.getText(true);
    }

    protected PickListItemIFace getItemForText(String itemText) {
        for (PickListItemIFace item : this.items.getList()) {
            if (!item.getTitle().equals(itemText)) continue;
            return item;
        }
        return null;
    }

    public void setSelections(String selections) {
        String[] selsToSet;
        this.sels.clear();
        String[] stringArray = selsToSet = selections.split(", ");
        int n = selsToSet.length;
        int n2 = 0;
        while (n2 < n) {
            String selToSet = stringArray[n2];
            PickListItemIFace match = this.getItemForText(selToSet);
            if (match != null) {
                this.sels.add(match);
            } else {
                log.info((Object)("no picklist item found for '" + selToSet + "'"));
            }
            ++n2;
        }
    }

    protected int getModeForOp(SpQueryField.OperatorType op) {
        if (op.getOrdinal() == SpQueryField.OperatorType.IN.getOrdinal()) {
            return 2;
        }
        if (op.getOrdinal() == SpQueryField.OperatorType.BETWEEN.getOrdinal()) {
            return 1;
        }
        return 0;
    }

    protected void setSelMode(int mode) {
        this.setSelectedItem(null);
        this.sels.clear();
        this.selMode = mode;
        this.repaint();
    }

    public SpQueryField.OperatorType getCurrentOp() {
        return this.currentOp;
    }

    public void setCurrentOp(SpQueryField.OperatorType newOp) {
        if (this.getModeForOp(newOp) != this.selMode) {
            this.setSelMode(this.getModeForOp(newOp));
        }
        this.currentOp = newOp;
    }

    protected class PickListCellRenderer
    extends DefaultListCellRenderer {
        protected PickListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                return UIHelper.createLabel(PickListCriteriaCombo.this.getSelectionsText());
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

